/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.comm.utils;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class SmsUtils {
    private SmsUtils() {
    }

    public static String getRandomString(int len) {
        return RandomUtil.randomString((String)(RandomUtil.BASE_CHAR_NUMBER + "abcdefghijklmnopqrstuvwxyz".toUpperCase()), (int)len);
    }

    public static String getRandomString() {
        return SmsUtils.getRandomString(6);
    }

    public static String getRandomInt(int len) {
        return RandomUtil.randomString((String)"0123456789", (int)len);
    }

    public static boolean isEmpty(Object str) {
        return ObjectUtil.isEmpty((Object)str);
    }

    public static boolean isNotEmpty(Object str) {
        return !SmsUtils.isEmpty(str);
    }

    public static <T> T jsonForObject(String json, Class<T> t) {
        return (T)JSONUtil.toBean((String)json, t);
    }

    public static <T, M> void copyBean(T t, M m) {
        BeanUtil.copyProperties(t, m, (String[])new String[0]);
    }

    public static LinkedHashMap<String, String> getNewMap() {
        return new LinkedHashMap<String, String>();
    }

    public static String joinComma(List<String> list) {
        return CollUtil.join(list, (CharSequence)",");
    }

    public static List<String> splitTrimComma(String str) {
        return StrUtil.splitTrim((CharSequence)str, (CharSequence)",");
    }

    public static String addCodePrefixIfNot(List<String> phones) {
        return CollUtil.join(phones, (CharSequence)",", SmsUtils::addCodePrefixIfNot);
    }

    public static String addCodePrefixIfNot(String phone) {
        return StrUtil.addPrefixIfNot((CharSequence)phone, (CharSequence)"+86");
    }

    public static String[] addCodePrefixIfNotToArray(List<String> list) {
        ArrayList<String> toStr = new ArrayList<String>();
        for (String s : list) {
            toStr.add(SmsUtils.addCodePrefixIfNot(s));
        }
        return toStr.toArray(new String[list.size()]);
    }

    public static void replaceKeysSeparator(Map<String, Object> map, String separator, String newSeparator) {
        if (CollUtil.isEmpty(map)) {
            return;
        }
        ArrayList<String> keySet = new ArrayList<String>(map.keySet());
        for (String key : keySet) {
            if (StrUtil.isEmpty((CharSequence)key) || !key.contains(separator)) continue;
            String value = String.valueOf(map.get(key));
            String newKey = key.replaceAll(separator, newSeparator);
            map.putIfAbsent(newKey, value);
            map.remove(key);
        }
    }

    public static boolean isClassExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static LinkedHashMap<String, String> buildMessageByAmpersand(String message) {
        if (SmsUtils.isEmpty(message)) {
            return new LinkedHashMap<String, String>();
        }
        String[] split = message.split("&");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(split.length);
        for (int i = 0; i < split.length; ++i) {
            map.put(String.valueOf(i), split[i]);
        }
        return map;
    }

    public static <E, T> E[] toArray(Collection<T> list, Predicate<T> predicate, Function<? super T, ? extends E> mapper, E[] array) {
        if (SmsUtils.isEmpty(list)) {
            return (Object[])array.clone();
        }
        return list.stream().filter(predicate).map(mapper).toArray(size -> (Object[])array.clone());
    }

    public static String[] toArray(Map<String, String> map) {
        if (SmsUtils.isEmpty(map)) {
            return new String[0];
        }
        return SmsUtils.toArray(map.values(), SmsUtils::isNotEmpty, s -> s, new String[map.size()]);
    }

    public static String sortedParamsAsc(Map<String, Object> params, String ... excludes) {
        if (MapUtil.isEmpty(params)) {
            return "";
        }
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        if (CollUtil.isEmpty(keys)) {
            return "";
        }
        if (ArrayUtil.isNotEmpty((Object[])excludes)) {
            ArrayList excludeKeys = CollUtil.toList((Object[])excludes);
            keys.removeIf(key -> excludeKeys.stream().anyMatch(exclude -> exclude.equals(key)));
            if (CollUtil.isEmpty(keys)) {
                return "";
            }
        }
        Collections.sort(keys);
        StringBuilder sb = new StringBuilder();
        for (String key2 : keys) {
            sb.append(key2).append("=").append(Convert.toStr((Object)params.get(key2))).append("&");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

