/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMissingBean(value={SpringFileStorageProperties.class})
@ConfigurationProperties(prefix="dromara.x-file-storage")
public class SpringFileStorageProperties {
    private String defaultPlatform = "local";
    private String thumbnailSuffix = ".min.jpg";
    private Boolean uploadNotSupportMetadataThrowException = true;
    private Boolean uploadNotSupportAclThrowException = true;
    private Boolean copyNotSupportMetadataThrowException = true;
    private Boolean copyNotSupportAclThrowException = true;
    private Boolean moveNotSupportMetadataThrowException = true;
    private Boolean moveNotSupportAclThrowException = true;
    private Boolean enableByteFileWrapper = true;
    private Boolean enableUriFileWrapper = true;
    private Boolean enableInputStreamFileWrapper = true;
    private Boolean enableLocalFileWrapper = true;
    private Boolean enableHttpServletRequestFileWrapper = true;
    private Boolean enableMultipartFileWrapper = true;
    @Deprecated
    private List<? extends SpringLocalConfig> local = new ArrayList<SpringLocalConfig>();
    private List<? extends SpringLocalPlusConfig> localPlus = new ArrayList<SpringLocalPlusConfig>();
    private List<? extends SpringHuaweiObsConfig> huaweiObs = new ArrayList<SpringHuaweiObsConfig>();
    private List<? extends SpringAliyunOssConfig> aliyunOss = new ArrayList<SpringAliyunOssConfig>();
    private List<? extends SpringQiniuKodoConfig> qiniuKodo = new ArrayList<SpringQiniuKodoConfig>();
    private List<? extends SpringTencentCosConfig> tencentCos = new ArrayList<SpringTencentCosConfig>();
    private List<? extends SpringBaiduBosConfig> baiduBos = new ArrayList<SpringBaiduBosConfig>();
    private List<? extends SpringUpyunUssConfig> upyunUss = new ArrayList<SpringUpyunUssConfig>();
    private List<? extends SpringMinioConfig> minio = new ArrayList<SpringMinioConfig>();
    private List<? extends SpringAmazonS3Config> amazonS3 = new ArrayList<SpringAmazonS3Config>();
    private List<? extends SpringFtpConfig> ftp = new ArrayList<SpringFtpConfig>();
    private List<? extends SpringSftpConfig> sftp = new ArrayList<SpringSftpConfig>();
    private List<? extends SpringWebDavConfig> webdav = new ArrayList<SpringWebDavConfig>();
    private List<? extends SpringGoogleCloudStorageConfig> googleCloudStorage = new ArrayList<SpringGoogleCloudStorageConfig>();
    private List<? extends SpringFastDfsConfig> fastdfs = new ArrayList<SpringFastDfsConfig>();
    private List<? extends SpringAzureBlobStorageConfig> azureBlob = new ArrayList<SpringAzureBlobStorageConfig>();

    public FileStorageProperties toFileStorageProperties() {
        FileStorageProperties properties = new FileStorageProperties();
        properties.setDefaultPlatform(this.defaultPlatform);
        properties.setThumbnailSuffix(this.thumbnailSuffix);
        properties.setUploadNotSupportMetadataThrowException(this.uploadNotSupportMetadataThrowException);
        properties.setUploadNotSupportAclThrowException(this.uploadNotSupportAclThrowException);
        properties.setCopyNotSupportMetadataThrowException(this.copyNotSupportMetadataThrowException);
        properties.setCopyNotSupportAclThrowException(this.copyNotSupportAclThrowException);
        properties.setMoveNotSupportMetadataThrowException(this.moveNotSupportMetadataThrowException);
        properties.setMoveNotSupportAclThrowException(this.moveNotSupportAclThrowException);
        properties.setLocal(this.local.stream().filter(SpringLocalConfig::getEnableStorage).collect(Collectors.toList()));
        properties.setLocalPlus(this.localPlus.stream().filter(SpringLocalPlusConfig::getEnableStorage).collect(Collectors.toList()));
        properties.setHuaweiObs(this.huaweiObs.stream().filter(SpringHuaweiObsConfig::getEnableStorage).collect(Collectors.toList()));
        properties.setAliyunOss(this.aliyunOss.stream().filter(SpringAliyunOssConfig::getEnableStorage).collect(Collectors.toList()));
        properties.setQiniuKodo(this.qiniuKodo.stream().filter(SpringQiniuKodoConfig::getEnableStorage).collect(Collectors.toList()));
        properties.setTencentCos(this.tencentCos.stream().filter(SpringTencentCosConfig::getEnableStorage).collect(Collectors.toList()));
        properties.setBaiduBos(this.baiduBos.stream().filter(SpringBaiduBosConfig::getEnableStorage).collect(Collectors.toList()));
        properties.setUpyunUss(this.upyunUss.stream().filter(SpringUpyunUssConfig::getEnableStorage).collect(Collectors.toList()));
        properties.setMinio(this.minio.stream().filter(SpringMinioConfig::getEnableStorage).collect(Collectors.toList()));
        properties.setAmazonS3(this.amazonS3.stream().filter(SpringAmazonS3Config::getEnableStorage).collect(Collectors.toList()));
        properties.setFtp(this.ftp.stream().filter(SpringFtpConfig::getEnableStorage).collect(Collectors.toList()));
        properties.setSftp(this.sftp.stream().filter(SpringSftpConfig::getEnableStorage).collect(Collectors.toList()));
        properties.setWebdav(this.webdav.stream().filter(SpringWebDavConfig::getEnableStorage).collect(Collectors.toList()));
        properties.setGoogleCloudStorage(this.googleCloudStorage.stream().filter(SpringGoogleCloudStorageConfig::getEnableStorage).collect(Collectors.toList()));
        properties.setFastdfs(this.fastdfs.stream().filter(SpringFastDfsConfig::getEnableStorage).collect(Collectors.toList()));
        properties.setAzureBlob(this.azureBlob.stream().filter(SpringAzureBlobStorageConfig::getEnableStorage).collect(Collectors.toList()));
        return properties;
    }

    public String getDefaultPlatform() {
        return this.defaultPlatform;
    }

    public String getThumbnailSuffix() {
        return this.thumbnailSuffix;
    }

    public Boolean getUploadNotSupportMetadataThrowException() {
        return this.uploadNotSupportMetadataThrowException;
    }

    public Boolean getUploadNotSupportAclThrowException() {
        return this.uploadNotSupportAclThrowException;
    }

    public Boolean getCopyNotSupportMetadataThrowException() {
        return this.copyNotSupportMetadataThrowException;
    }

    public Boolean getCopyNotSupportAclThrowException() {
        return this.copyNotSupportAclThrowException;
    }

    public Boolean getMoveNotSupportMetadataThrowException() {
        return this.moveNotSupportMetadataThrowException;
    }

    public Boolean getMoveNotSupportAclThrowException() {
        return this.moveNotSupportAclThrowException;
    }

    public Boolean getEnableByteFileWrapper() {
        return this.enableByteFileWrapper;
    }

    public Boolean getEnableUriFileWrapper() {
        return this.enableUriFileWrapper;
    }

    public Boolean getEnableInputStreamFileWrapper() {
        return this.enableInputStreamFileWrapper;
    }

    public Boolean getEnableLocalFileWrapper() {
        return this.enableLocalFileWrapper;
    }

    public Boolean getEnableHttpServletRequestFileWrapper() {
        return this.enableHttpServletRequestFileWrapper;
    }

    public Boolean getEnableMultipartFileWrapper() {
        return this.enableMultipartFileWrapper;
    }

    @Deprecated
    public List<? extends SpringLocalConfig> getLocal() {
        return this.local;
    }

    public List<? extends SpringLocalPlusConfig> getLocalPlus() {
        return this.localPlus;
    }

    public List<? extends SpringHuaweiObsConfig> getHuaweiObs() {
        return this.huaweiObs;
    }

    public List<? extends SpringAliyunOssConfig> getAliyunOss() {
        return this.aliyunOss;
    }

    public List<? extends SpringQiniuKodoConfig> getQiniuKodo() {
        return this.qiniuKodo;
    }

    public List<? extends SpringTencentCosConfig> getTencentCos() {
        return this.tencentCos;
    }

    public List<? extends SpringBaiduBosConfig> getBaiduBos() {
        return this.baiduBos;
    }

    public List<? extends SpringUpyunUssConfig> getUpyunUss() {
        return this.upyunUss;
    }

    public List<? extends SpringMinioConfig> getMinio() {
        return this.minio;
    }

    public List<? extends SpringAmazonS3Config> getAmazonS3() {
        return this.amazonS3;
    }

    public List<? extends SpringFtpConfig> getFtp() {
        return this.ftp;
    }

    public List<? extends SpringSftpConfig> getSftp() {
        return this.sftp;
    }

    public List<? extends SpringWebDavConfig> getWebdav() {
        return this.webdav;
    }

    public List<? extends SpringGoogleCloudStorageConfig> getGoogleCloudStorage() {
        return this.googleCloudStorage;
    }

    public List<? extends SpringFastDfsConfig> getFastdfs() {
        return this.fastdfs;
    }

    public List<? extends SpringAzureBlobStorageConfig> getAzureBlob() {
        return this.azureBlob;
    }

    public SpringFileStorageProperties setDefaultPlatform(String defaultPlatform) {
        this.defaultPlatform = defaultPlatform;
        return this;
    }

    public SpringFileStorageProperties setThumbnailSuffix(String thumbnailSuffix) {
        this.thumbnailSuffix = thumbnailSuffix;
        return this;
    }

    public SpringFileStorageProperties setUploadNotSupportMetadataThrowException(Boolean uploadNotSupportMetadataThrowException) {
        this.uploadNotSupportMetadataThrowException = uploadNotSupportMetadataThrowException;
        return this;
    }

    public SpringFileStorageProperties setUploadNotSupportAclThrowException(Boolean uploadNotSupportAclThrowException) {
        this.uploadNotSupportAclThrowException = uploadNotSupportAclThrowException;
        return this;
    }

    public SpringFileStorageProperties setCopyNotSupportMetadataThrowException(Boolean copyNotSupportMetadataThrowException) {
        this.copyNotSupportMetadataThrowException = copyNotSupportMetadataThrowException;
        return this;
    }

    public SpringFileStorageProperties setCopyNotSupportAclThrowException(Boolean copyNotSupportAclThrowException) {
        this.copyNotSupportAclThrowException = copyNotSupportAclThrowException;
        return this;
    }

    public SpringFileStorageProperties setMoveNotSupportMetadataThrowException(Boolean moveNotSupportMetadataThrowException) {
        this.moveNotSupportMetadataThrowException = moveNotSupportMetadataThrowException;
        return this;
    }

    public SpringFileStorageProperties setMoveNotSupportAclThrowException(Boolean moveNotSupportAclThrowException) {
        this.moveNotSupportAclThrowException = moveNotSupportAclThrowException;
        return this;
    }

    public SpringFileStorageProperties setEnableByteFileWrapper(Boolean enableByteFileWrapper) {
        this.enableByteFileWrapper = enableByteFileWrapper;
        return this;
    }

    public SpringFileStorageProperties setEnableUriFileWrapper(Boolean enableUriFileWrapper) {
        this.enableUriFileWrapper = enableUriFileWrapper;
        return this;
    }

    public SpringFileStorageProperties setEnableInputStreamFileWrapper(Boolean enableInputStreamFileWrapper) {
        this.enableInputStreamFileWrapper = enableInputStreamFileWrapper;
        return this;
    }

    public SpringFileStorageProperties setEnableLocalFileWrapper(Boolean enableLocalFileWrapper) {
        this.enableLocalFileWrapper = enableLocalFileWrapper;
        return this;
    }

    public SpringFileStorageProperties setEnableHttpServletRequestFileWrapper(Boolean enableHttpServletRequestFileWrapper) {
        this.enableHttpServletRequestFileWrapper = enableHttpServletRequestFileWrapper;
        return this;
    }

    public SpringFileStorageProperties setEnableMultipartFileWrapper(Boolean enableMultipartFileWrapper) {
        this.enableMultipartFileWrapper = enableMultipartFileWrapper;
        return this;
    }

    @Deprecated
    public SpringFileStorageProperties setLocal(List<? extends SpringLocalConfig> local) {
        this.local = local;
        return this;
    }

    public SpringFileStorageProperties setLocalPlus(List<? extends SpringLocalPlusConfig> localPlus) {
        this.localPlus = localPlus;
        return this;
    }

    public SpringFileStorageProperties setHuaweiObs(List<? extends SpringHuaweiObsConfig> huaweiObs) {
        this.huaweiObs = huaweiObs;
        return this;
    }

    public SpringFileStorageProperties setAliyunOss(List<? extends SpringAliyunOssConfig> aliyunOss) {
        this.aliyunOss = aliyunOss;
        return this;
    }

    public SpringFileStorageProperties setQiniuKodo(List<? extends SpringQiniuKodoConfig> qiniuKodo) {
        this.qiniuKodo = qiniuKodo;
        return this;
    }

    public SpringFileStorageProperties setTencentCos(List<? extends SpringTencentCosConfig> tencentCos) {
        this.tencentCos = tencentCos;
        return this;
    }

    public SpringFileStorageProperties setBaiduBos(List<? extends SpringBaiduBosConfig> baiduBos) {
        this.baiduBos = baiduBos;
        return this;
    }

    public SpringFileStorageProperties setUpyunUss(List<? extends SpringUpyunUssConfig> upyunUss) {
        this.upyunUss = upyunUss;
        return this;
    }

    public SpringFileStorageProperties setMinio(List<? extends SpringMinioConfig> minio) {
        this.minio = minio;
        return this;
    }

    public SpringFileStorageProperties setAmazonS3(List<? extends SpringAmazonS3Config> amazonS3) {
        this.amazonS3 = amazonS3;
        return this;
    }

    public SpringFileStorageProperties setFtp(List<? extends SpringFtpConfig> ftp) {
        this.ftp = ftp;
        return this;
    }

    public SpringFileStorageProperties setSftp(List<? extends SpringSftpConfig> sftp) {
        this.sftp = sftp;
        return this;
    }

    public SpringFileStorageProperties setWebdav(List<? extends SpringWebDavConfig> webdav) {
        this.webdav = webdav;
        return this;
    }

    public SpringFileStorageProperties setGoogleCloudStorage(List<? extends SpringGoogleCloudStorageConfig> googleCloudStorage) {
        this.googleCloudStorage = googleCloudStorage;
        return this;
    }

    public SpringFileStorageProperties setFastdfs(List<? extends SpringFastDfsConfig> fastdfs) {
        this.fastdfs = fastdfs;
        return this;
    }

    public SpringFileStorageProperties setAzureBlob(List<? extends SpringAzureBlobStorageConfig> azureBlob) {
        this.azureBlob = azureBlob;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringFileStorageProperties)) {
            return false;
        }
        SpringFileStorageProperties other = (SpringFileStorageProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$uploadNotSupportMetadataThrowException = this.getUploadNotSupportMetadataThrowException();
        Boolean other$uploadNotSupportMetadataThrowException = other.getUploadNotSupportMetadataThrowException();
        if (this$uploadNotSupportMetadataThrowException == null ? other$uploadNotSupportMetadataThrowException != null : !((Object)this$uploadNotSupportMetadataThrowException).equals(other$uploadNotSupportMetadataThrowException)) {
            return false;
        }
        Boolean this$uploadNotSupportAclThrowException = this.getUploadNotSupportAclThrowException();
        Boolean other$uploadNotSupportAclThrowException = other.getUploadNotSupportAclThrowException();
        if (this$uploadNotSupportAclThrowException == null ? other$uploadNotSupportAclThrowException != null : !((Object)this$uploadNotSupportAclThrowException).equals(other$uploadNotSupportAclThrowException)) {
            return false;
        }
        Boolean this$copyNotSupportMetadataThrowException = this.getCopyNotSupportMetadataThrowException();
        Boolean other$copyNotSupportMetadataThrowException = other.getCopyNotSupportMetadataThrowException();
        if (this$copyNotSupportMetadataThrowException == null ? other$copyNotSupportMetadataThrowException != null : !((Object)this$copyNotSupportMetadataThrowException).equals(other$copyNotSupportMetadataThrowException)) {
            return false;
        }
        Boolean this$copyNotSupportAclThrowException = this.getCopyNotSupportAclThrowException();
        Boolean other$copyNotSupportAclThrowException = other.getCopyNotSupportAclThrowException();
        if (this$copyNotSupportAclThrowException == null ? other$copyNotSupportAclThrowException != null : !((Object)this$copyNotSupportAclThrowException).equals(other$copyNotSupportAclThrowException)) {
            return false;
        }
        Boolean this$moveNotSupportMetadataThrowException = this.getMoveNotSupportMetadataThrowException();
        Boolean other$moveNotSupportMetadataThrowException = other.getMoveNotSupportMetadataThrowException();
        if (this$moveNotSupportMetadataThrowException == null ? other$moveNotSupportMetadataThrowException != null : !((Object)this$moveNotSupportMetadataThrowException).equals(other$moveNotSupportMetadataThrowException)) {
            return false;
        }
        Boolean this$moveNotSupportAclThrowException = this.getMoveNotSupportAclThrowException();
        Boolean other$moveNotSupportAclThrowException = other.getMoveNotSupportAclThrowException();
        if (this$moveNotSupportAclThrowException == null ? other$moveNotSupportAclThrowException != null : !((Object)this$moveNotSupportAclThrowException).equals(other$moveNotSupportAclThrowException)) {
            return false;
        }
        Boolean this$enableByteFileWrapper = this.getEnableByteFileWrapper();
        Boolean other$enableByteFileWrapper = other.getEnableByteFileWrapper();
        if (this$enableByteFileWrapper == null ? other$enableByteFileWrapper != null : !((Object)this$enableByteFileWrapper).equals(other$enableByteFileWrapper)) {
            return false;
        }
        Boolean this$enableUriFileWrapper = this.getEnableUriFileWrapper();
        Boolean other$enableUriFileWrapper = other.getEnableUriFileWrapper();
        if (this$enableUriFileWrapper == null ? other$enableUriFileWrapper != null : !((Object)this$enableUriFileWrapper).equals(other$enableUriFileWrapper)) {
            return false;
        }
        Boolean this$enableInputStreamFileWrapper = this.getEnableInputStreamFileWrapper();
        Boolean other$enableInputStreamFileWrapper = other.getEnableInputStreamFileWrapper();
        if (this$enableInputStreamFileWrapper == null ? other$enableInputStreamFileWrapper != null : !((Object)this$enableInputStreamFileWrapper).equals(other$enableInputStreamFileWrapper)) {
            return false;
        }
        Boolean this$enableLocalFileWrapper = this.getEnableLocalFileWrapper();
        Boolean other$enableLocalFileWrapper = other.getEnableLocalFileWrapper();
        if (this$enableLocalFileWrapper == null ? other$enableLocalFileWrapper != null : !((Object)this$enableLocalFileWrapper).equals(other$enableLocalFileWrapper)) {
            return false;
        }
        Boolean this$enableHttpServletRequestFileWrapper = this.getEnableHttpServletRequestFileWrapper();
        Boolean other$enableHttpServletRequestFileWrapper = other.getEnableHttpServletRequestFileWrapper();
        if (this$enableHttpServletRequestFileWrapper == null ? other$enableHttpServletRequestFileWrapper != null : !((Object)this$enableHttpServletRequestFileWrapper).equals(other$enableHttpServletRequestFileWrapper)) {
            return false;
        }
        Boolean this$enableMultipartFileWrapper = this.getEnableMultipartFileWrapper();
        Boolean other$enableMultipartFileWrapper = other.getEnableMultipartFileWrapper();
        if (this$enableMultipartFileWrapper == null ? other$enableMultipartFileWrapper != null : !((Object)this$enableMultipartFileWrapper).equals(other$enableMultipartFileWrapper)) {
            return false;
        }
        String this$defaultPlatform = this.getDefaultPlatform();
        String other$defaultPlatform = other.getDefaultPlatform();
        if (this$defaultPlatform == null ? other$defaultPlatform != null : !this$defaultPlatform.equals(other$defaultPlatform)) {
            return false;
        }
        String this$thumbnailSuffix = this.getThumbnailSuffix();
        String other$thumbnailSuffix = other.getThumbnailSuffix();
        if (this$thumbnailSuffix == null ? other$thumbnailSuffix != null : !this$thumbnailSuffix.equals(other$thumbnailSuffix)) {
            return false;
        }
        List<? extends SpringLocalConfig> this$local = this.getLocal();
        List<? extends SpringLocalConfig> other$local = other.getLocal();
        if (this$local == null ? other$local != null : !((Object)this$local).equals(other$local)) {
            return false;
        }
        List<? extends SpringLocalPlusConfig> this$localPlus = this.getLocalPlus();
        List<? extends SpringLocalPlusConfig> other$localPlus = other.getLocalPlus();
        if (this$localPlus == null ? other$localPlus != null : !((Object)this$localPlus).equals(other$localPlus)) {
            return false;
        }
        List<? extends SpringHuaweiObsConfig> this$huaweiObs = this.getHuaweiObs();
        List<? extends SpringHuaweiObsConfig> other$huaweiObs = other.getHuaweiObs();
        if (this$huaweiObs == null ? other$huaweiObs != null : !((Object)this$huaweiObs).equals(other$huaweiObs)) {
            return false;
        }
        List<? extends SpringAliyunOssConfig> this$aliyunOss = this.getAliyunOss();
        List<? extends SpringAliyunOssConfig> other$aliyunOss = other.getAliyunOss();
        if (this$aliyunOss == null ? other$aliyunOss != null : !((Object)this$aliyunOss).equals(other$aliyunOss)) {
            return false;
        }
        List<? extends SpringQiniuKodoConfig> this$qiniuKodo = this.getQiniuKodo();
        List<? extends SpringQiniuKodoConfig> other$qiniuKodo = other.getQiniuKodo();
        if (this$qiniuKodo == null ? other$qiniuKodo != null : !((Object)this$qiniuKodo).equals(other$qiniuKodo)) {
            return false;
        }
        List<? extends SpringTencentCosConfig> this$tencentCos = this.getTencentCos();
        List<? extends SpringTencentCosConfig> other$tencentCos = other.getTencentCos();
        if (this$tencentCos == null ? other$tencentCos != null : !((Object)this$tencentCos).equals(other$tencentCos)) {
            return false;
        }
        List<? extends SpringBaiduBosConfig> this$baiduBos = this.getBaiduBos();
        List<? extends SpringBaiduBosConfig> other$baiduBos = other.getBaiduBos();
        if (this$baiduBos == null ? other$baiduBos != null : !((Object)this$baiduBos).equals(other$baiduBos)) {
            return false;
        }
        List<? extends SpringUpyunUssConfig> this$upyunUss = this.getUpyunUss();
        List<? extends SpringUpyunUssConfig> other$upyunUss = other.getUpyunUss();
        if (this$upyunUss == null ? other$upyunUss != null : !((Object)this$upyunUss).equals(other$upyunUss)) {
            return false;
        }
        List<? extends SpringMinioConfig> this$minio = this.getMinio();
        List<? extends SpringMinioConfig> other$minio = other.getMinio();
        if (this$minio == null ? other$minio != null : !((Object)this$minio).equals(other$minio)) {
            return false;
        }
        List<? extends SpringAmazonS3Config> this$amazonS3 = this.getAmazonS3();
        List<? extends SpringAmazonS3Config> other$amazonS3 = other.getAmazonS3();
        if (this$amazonS3 == null ? other$amazonS3 != null : !((Object)this$amazonS3).equals(other$amazonS3)) {
            return false;
        }
        List<? extends SpringFtpConfig> this$ftp = this.getFtp();
        List<? extends SpringFtpConfig> other$ftp = other.getFtp();
        if (this$ftp == null ? other$ftp != null : !((Object)this$ftp).equals(other$ftp)) {
            return false;
        }
        List<? extends SpringSftpConfig> this$sftp = this.getSftp();
        List<? extends SpringSftpConfig> other$sftp = other.getSftp();
        if (this$sftp == null ? other$sftp != null : !((Object)this$sftp).equals(other$sftp)) {
            return false;
        }
        List<? extends SpringWebDavConfig> this$webdav = this.getWebdav();
        List<? extends SpringWebDavConfig> other$webdav = other.getWebdav();
        if (this$webdav == null ? other$webdav != null : !((Object)this$webdav).equals(other$webdav)) {
            return false;
        }
        List<? extends SpringGoogleCloudStorageConfig> this$googleCloudStorage = this.getGoogleCloudStorage();
        List<? extends SpringGoogleCloudStorageConfig> other$googleCloudStorage = other.getGoogleCloudStorage();
        if (this$googleCloudStorage == null ? other$googleCloudStorage != null : !((Object)this$googleCloudStorage).equals(other$googleCloudStorage)) {
            return false;
        }
        List<? extends SpringFastDfsConfig> this$fastdfs = this.getFastdfs();
        List<? extends SpringFastDfsConfig> other$fastdfs = other.getFastdfs();
        if (this$fastdfs == null ? other$fastdfs != null : !((Object)this$fastdfs).equals(other$fastdfs)) {
            return false;
        }
        List<? extends SpringAzureBlobStorageConfig> this$azureBlob = this.getAzureBlob();
        List<? extends SpringAzureBlobStorageConfig> other$azureBlob = other.getAzureBlob();
        return !(this$azureBlob == null ? other$azureBlob != null : !((Object)this$azureBlob).equals(other$azureBlob));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpringFileStorageProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $uploadNotSupportMetadataThrowException = this.getUploadNotSupportMetadataThrowException();
        result = result * 59 + ($uploadNotSupportMetadataThrowException == null ? 43 : ((Object)$uploadNotSupportMetadataThrowException).hashCode());
        Boolean $uploadNotSupportAclThrowException = this.getUploadNotSupportAclThrowException();
        result = result * 59 + ($uploadNotSupportAclThrowException == null ? 43 : ((Object)$uploadNotSupportAclThrowException).hashCode());
        Boolean $copyNotSupportMetadataThrowException = this.getCopyNotSupportMetadataThrowException();
        result = result * 59 + ($copyNotSupportMetadataThrowException == null ? 43 : ((Object)$copyNotSupportMetadataThrowException).hashCode());
        Boolean $copyNotSupportAclThrowException = this.getCopyNotSupportAclThrowException();
        result = result * 59 + ($copyNotSupportAclThrowException == null ? 43 : ((Object)$copyNotSupportAclThrowException).hashCode());
        Boolean $moveNotSupportMetadataThrowException = this.getMoveNotSupportMetadataThrowException();
        result = result * 59 + ($moveNotSupportMetadataThrowException == null ? 43 : ((Object)$moveNotSupportMetadataThrowException).hashCode());
        Boolean $moveNotSupportAclThrowException = this.getMoveNotSupportAclThrowException();
        result = result * 59 + ($moveNotSupportAclThrowException == null ? 43 : ((Object)$moveNotSupportAclThrowException).hashCode());
        Boolean $enableByteFileWrapper = this.getEnableByteFileWrapper();
        result = result * 59 + ($enableByteFileWrapper == null ? 43 : ((Object)$enableByteFileWrapper).hashCode());
        Boolean $enableUriFileWrapper = this.getEnableUriFileWrapper();
        result = result * 59 + ($enableUriFileWrapper == null ? 43 : ((Object)$enableUriFileWrapper).hashCode());
        Boolean $enableInputStreamFileWrapper = this.getEnableInputStreamFileWrapper();
        result = result * 59 + ($enableInputStreamFileWrapper == null ? 43 : ((Object)$enableInputStreamFileWrapper).hashCode());
        Boolean $enableLocalFileWrapper = this.getEnableLocalFileWrapper();
        result = result * 59 + ($enableLocalFileWrapper == null ? 43 : ((Object)$enableLocalFileWrapper).hashCode());
        Boolean $enableHttpServletRequestFileWrapper = this.getEnableHttpServletRequestFileWrapper();
        result = result * 59 + ($enableHttpServletRequestFileWrapper == null ? 43 : ((Object)$enableHttpServletRequestFileWrapper).hashCode());
        Boolean $enableMultipartFileWrapper = this.getEnableMultipartFileWrapper();
        result = result * 59 + ($enableMultipartFileWrapper == null ? 43 : ((Object)$enableMultipartFileWrapper).hashCode());
        String $defaultPlatform = this.getDefaultPlatform();
        result = result * 59 + ($defaultPlatform == null ? 43 : $defaultPlatform.hashCode());
        String $thumbnailSuffix = this.getThumbnailSuffix();
        result = result * 59 + ($thumbnailSuffix == null ? 43 : $thumbnailSuffix.hashCode());
        List<? extends SpringLocalConfig> $local = this.getLocal();
        result = result * 59 + ($local == null ? 43 : ((Object)$local).hashCode());
        List<? extends SpringLocalPlusConfig> $localPlus = this.getLocalPlus();
        result = result * 59 + ($localPlus == null ? 43 : ((Object)$localPlus).hashCode());
        List<? extends SpringHuaweiObsConfig> $huaweiObs = this.getHuaweiObs();
        result = result * 59 + ($huaweiObs == null ? 43 : ((Object)$huaweiObs).hashCode());
        List<? extends SpringAliyunOssConfig> $aliyunOss = this.getAliyunOss();
        result = result * 59 + ($aliyunOss == null ? 43 : ((Object)$aliyunOss).hashCode());
        List<? extends SpringQiniuKodoConfig> $qiniuKodo = this.getQiniuKodo();
        result = result * 59 + ($qiniuKodo == null ? 43 : ((Object)$qiniuKodo).hashCode());
        List<? extends SpringTencentCosConfig> $tencentCos = this.getTencentCos();
        result = result * 59 + ($tencentCos == null ? 43 : ((Object)$tencentCos).hashCode());
        List<? extends SpringBaiduBosConfig> $baiduBos = this.getBaiduBos();
        result = result * 59 + ($baiduBos == null ? 43 : ((Object)$baiduBos).hashCode());
        List<? extends SpringUpyunUssConfig> $upyunUss = this.getUpyunUss();
        result = result * 59 + ($upyunUss == null ? 43 : ((Object)$upyunUss).hashCode());
        List<? extends SpringMinioConfig> $minio = this.getMinio();
        result = result * 59 + ($minio == null ? 43 : ((Object)$minio).hashCode());
        List<? extends SpringAmazonS3Config> $amazonS3 = this.getAmazonS3();
        result = result * 59 + ($amazonS3 == null ? 43 : ((Object)$amazonS3).hashCode());
        List<? extends SpringFtpConfig> $ftp = this.getFtp();
        result = result * 59 + ($ftp == null ? 43 : ((Object)$ftp).hashCode());
        List<? extends SpringSftpConfig> $sftp = this.getSftp();
        result = result * 59 + ($sftp == null ? 43 : ((Object)$sftp).hashCode());
        List<? extends SpringWebDavConfig> $webdav = this.getWebdav();
        result = result * 59 + ($webdav == null ? 43 : ((Object)$webdav).hashCode());
        List<? extends SpringGoogleCloudStorageConfig> $googleCloudStorage = this.getGoogleCloudStorage();
        result = result * 59 + ($googleCloudStorage == null ? 43 : ((Object)$googleCloudStorage).hashCode());
        List<? extends SpringFastDfsConfig> $fastdfs = this.getFastdfs();
        result = result * 59 + ($fastdfs == null ? 43 : ((Object)$fastdfs).hashCode());
        List<? extends SpringAzureBlobStorageConfig> $azureBlob = this.getAzureBlob();
        result = result * 59 + ($azureBlob == null ? 43 : ((Object)$azureBlob).hashCode());
        return result;
    }

    public String toString() {
        return "SpringFileStorageProperties(defaultPlatform=" + this.defaultPlatform + ", thumbnailSuffix=" + this.thumbnailSuffix + ", uploadNotSupportMetadataThrowException=" + this.uploadNotSupportMetadataThrowException + ", uploadNotSupportAclThrowException=" + this.uploadNotSupportAclThrowException + ", copyNotSupportMetadataThrowException=" + this.copyNotSupportMetadataThrowException + ", copyNotSupportAclThrowException=" + this.copyNotSupportAclThrowException + ", moveNotSupportMetadataThrowException=" + this.moveNotSupportMetadataThrowException + ", moveNotSupportAclThrowException=" + this.moveNotSupportAclThrowException + ", enableByteFileWrapper=" + this.enableByteFileWrapper + ", enableUriFileWrapper=" + this.enableUriFileWrapper + ", enableInputStreamFileWrapper=" + this.enableInputStreamFileWrapper + ", enableLocalFileWrapper=" + this.enableLocalFileWrapper + ", enableHttpServletRequestFileWrapper=" + this.enableHttpServletRequestFileWrapper + ", enableMultipartFileWrapper=" + this.enableMultipartFileWrapper + ", local=" + this.local + ", localPlus=" + this.localPlus + ", huaweiObs=" + this.huaweiObs + ", aliyunOss=" + this.aliyunOss + ", qiniuKodo=" + this.qiniuKodo + ", tencentCos=" + this.tencentCos + ", baiduBos=" + this.baiduBos + ", upyunUss=" + this.upyunUss + ", minio=" + this.minio + ", amazonS3=" + this.amazonS3 + ", ftp=" + this.ftp + ", sftp=" + this.sftp + ", webdav=" + this.webdav + ", googleCloudStorage=" + this.googleCloudStorage + ", fastdfs=" + this.fastdfs + ", azureBlob=" + this.azureBlob + ")";
    }

    public static class SpringAzureBlobStorageConfig
    extends FileStorageProperties.AzureBlobStorageConfig {
        private Boolean enableStorage = false;

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public SpringAzureBlobStorageConfig setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
            return this;
        }

        public String toString() {
            return "SpringFileStorageProperties.SpringAzureBlobStorageConfig(super=" + super.toString() + ", enableStorage=" + this.enableStorage + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpringAzureBlobStorageConfig)) {
                return false;
            }
            SpringAzureBlobStorageConfig other = (SpringAzureBlobStorageConfig)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            return !(this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpringAzureBlobStorageConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            return result;
        }
    }

    public static class SpringFastDfsConfig
    extends FileStorageProperties.FastDfsConfig {
        private Boolean enableStorage = false;

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public SpringFastDfsConfig setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
            return this;
        }

        public String toString() {
            return "SpringFileStorageProperties.SpringFastDfsConfig(super=" + super.toString() + ", enableStorage=" + this.enableStorage + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpringFastDfsConfig)) {
                return false;
            }
            SpringFastDfsConfig other = (SpringFastDfsConfig)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            return !(this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpringFastDfsConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            return result;
        }
    }

    public static class SpringGoogleCloudStorageConfig
    extends FileStorageProperties.GoogleCloudStorageConfig {
        private Boolean enableStorage = false;

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public SpringGoogleCloudStorageConfig setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
            return this;
        }

        public String toString() {
            return "SpringFileStorageProperties.SpringGoogleCloudStorageConfig(super=" + super.toString() + ", enableStorage=" + this.enableStorage + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpringGoogleCloudStorageConfig)) {
                return false;
            }
            SpringGoogleCloudStorageConfig other = (SpringGoogleCloudStorageConfig)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            return !(this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpringGoogleCloudStorageConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            return result;
        }
    }

    public static class SpringWebDavConfig
    extends FileStorageProperties.WebDavConfig {
        private Boolean enableStorage = false;

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public SpringWebDavConfig setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
            return this;
        }

        public String toString() {
            return "SpringFileStorageProperties.SpringWebDavConfig(super=" + super.toString() + ", enableStorage=" + this.enableStorage + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpringWebDavConfig)) {
                return false;
            }
            SpringWebDavConfig other = (SpringWebDavConfig)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            return !(this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpringWebDavConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            return result;
        }
    }

    public static class SpringSftpConfig
    extends FileStorageProperties.SftpConfig {
        private Boolean enableStorage = false;

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public SpringSftpConfig setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
            return this;
        }

        public String toString() {
            return "SpringFileStorageProperties.SpringSftpConfig(super=" + super.toString() + ", enableStorage=" + this.enableStorage + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpringSftpConfig)) {
                return false;
            }
            SpringSftpConfig other = (SpringSftpConfig)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            return !(this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpringSftpConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            return result;
        }
    }

    public static class SpringFtpConfig
    extends FileStorageProperties.FtpConfig {
        private Boolean enableStorage = false;

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public SpringFtpConfig setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
            return this;
        }

        public String toString() {
            return "SpringFileStorageProperties.SpringFtpConfig(super=" + super.toString() + ", enableStorage=" + this.enableStorage + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpringFtpConfig)) {
                return false;
            }
            SpringFtpConfig other = (SpringFtpConfig)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            return !(this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpringFtpConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            return result;
        }
    }

    public static class SpringAmazonS3Config
    extends FileStorageProperties.AmazonS3Config {
        private Boolean enableStorage = false;

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public SpringAmazonS3Config setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
            return this;
        }

        public String toString() {
            return "SpringFileStorageProperties.SpringAmazonS3Config(super=" + super.toString() + ", enableStorage=" + this.enableStorage + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpringAmazonS3Config)) {
                return false;
            }
            SpringAmazonS3Config other = (SpringAmazonS3Config)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            return !(this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpringAmazonS3Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            return result;
        }
    }

    public static class SpringMinioConfig
    extends FileStorageProperties.MinioConfig {
        private Boolean enableStorage = false;

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public SpringMinioConfig setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
            return this;
        }

        public String toString() {
            return "SpringFileStorageProperties.SpringMinioConfig(super=" + super.toString() + ", enableStorage=" + this.enableStorage + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpringMinioConfig)) {
                return false;
            }
            SpringMinioConfig other = (SpringMinioConfig)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            return !(this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpringMinioConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            return result;
        }
    }

    public static class SpringUpyunUssConfig
    extends FileStorageProperties.UpyunUssConfig {
        private Boolean enableStorage = false;

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public SpringUpyunUssConfig setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
            return this;
        }

        public String toString() {
            return "SpringFileStorageProperties.SpringUpyunUssConfig(super=" + super.toString() + ", enableStorage=" + this.enableStorage + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpringUpyunUssConfig)) {
                return false;
            }
            SpringUpyunUssConfig other = (SpringUpyunUssConfig)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            return !(this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpringUpyunUssConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            return result;
        }
    }

    public static class SpringBaiduBosConfig
    extends FileStorageProperties.BaiduBosConfig {
        private Boolean enableStorage = false;

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public SpringBaiduBosConfig setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
            return this;
        }

        public String toString() {
            return "SpringFileStorageProperties.SpringBaiduBosConfig(super=" + super.toString() + ", enableStorage=" + this.enableStorage + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpringBaiduBosConfig)) {
                return false;
            }
            SpringBaiduBosConfig other = (SpringBaiduBosConfig)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            return !(this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpringBaiduBosConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            return result;
        }
    }

    public static class SpringTencentCosConfig
    extends FileStorageProperties.TencentCosConfig {
        private Boolean enableStorage = false;

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public SpringTencentCosConfig setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
            return this;
        }

        public String toString() {
            return "SpringFileStorageProperties.SpringTencentCosConfig(super=" + super.toString() + ", enableStorage=" + this.enableStorage + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpringTencentCosConfig)) {
                return false;
            }
            SpringTencentCosConfig other = (SpringTencentCosConfig)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            return !(this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpringTencentCosConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            return result;
        }
    }

    public static class SpringQiniuKodoConfig
    extends FileStorageProperties.QiniuKodoConfig {
        private Boolean enableStorage = false;

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public SpringQiniuKodoConfig setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
            return this;
        }

        public String toString() {
            return "SpringFileStorageProperties.SpringQiniuKodoConfig(super=" + super.toString() + ", enableStorage=" + this.enableStorage + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpringQiniuKodoConfig)) {
                return false;
            }
            SpringQiniuKodoConfig other = (SpringQiniuKodoConfig)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            return !(this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpringQiniuKodoConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            return result;
        }
    }

    public static class SpringAliyunOssConfig
    extends FileStorageProperties.AliyunOssConfig {
        private Boolean enableStorage = false;

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public SpringAliyunOssConfig setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
            return this;
        }

        public String toString() {
            return "SpringFileStorageProperties.SpringAliyunOssConfig(super=" + super.toString() + ", enableStorage=" + this.enableStorage + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpringAliyunOssConfig)) {
                return false;
            }
            SpringAliyunOssConfig other = (SpringAliyunOssConfig)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            return !(this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpringAliyunOssConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            return result;
        }
    }

    public static class SpringHuaweiObsConfig
    extends FileStorageProperties.HuaweiObsConfig {
        private Boolean enableStorage = false;

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public SpringHuaweiObsConfig setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
            return this;
        }

        public String toString() {
            return "SpringFileStorageProperties.SpringHuaweiObsConfig(super=" + super.toString() + ", enableStorage=" + this.enableStorage + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpringHuaweiObsConfig)) {
                return false;
            }
            SpringHuaweiObsConfig other = (SpringHuaweiObsConfig)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            return !(this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpringHuaweiObsConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            return result;
        }
    }

    public static class SpringLocalPlusConfig
    extends FileStorageProperties.LocalPlusConfig {
        private String[] pathPatterns = new String[0];
        private Boolean enableStorage = false;
        private Boolean enableAccess = false;

        public String[] getPathPatterns() {
            return this.pathPatterns;
        }

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public Boolean getEnableAccess() {
            return this.enableAccess;
        }

        public SpringLocalPlusConfig setPathPatterns(String[] pathPatterns) {
            this.pathPatterns = pathPatterns;
            return this;
        }

        public SpringLocalPlusConfig setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
            return this;
        }

        public SpringLocalPlusConfig setEnableAccess(Boolean enableAccess) {
            this.enableAccess = enableAccess;
            return this;
        }

        public String toString() {
            return "SpringFileStorageProperties.SpringLocalPlusConfig(super=" + super.toString() + ", pathPatterns=" + Arrays.deepToString(this.pathPatterns) + ", enableStorage=" + this.enableStorage + ", enableAccess=" + this.enableAccess + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpringLocalPlusConfig)) {
                return false;
            }
            SpringLocalPlusConfig other = (SpringLocalPlusConfig)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            if (this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage)) {
                return false;
            }
            Boolean this$enableAccess = this.getEnableAccess();
            Boolean other$enableAccess = other.getEnableAccess();
            if (this$enableAccess == null ? other$enableAccess != null : !((Object)this$enableAccess).equals(other$enableAccess)) {
                return false;
            }
            return Arrays.deepEquals(this.getPathPatterns(), other.getPathPatterns());
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpringLocalPlusConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            Boolean $enableAccess = this.getEnableAccess();
            result = result * 59 + ($enableAccess == null ? 43 : ((Object)$enableAccess).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getPathPatterns());
            return result;
        }
    }

    @Deprecated
    public static class SpringLocalConfig
    extends FileStorageProperties.LocalConfig {
        private String[] pathPatterns = new String[0];
        private Boolean enableStorage = false;
        private Boolean enableAccess = false;

        public String[] getPathPatterns() {
            return this.pathPatterns;
        }

        public Boolean getEnableStorage() {
            return this.enableStorage;
        }

        public Boolean getEnableAccess() {
            return this.enableAccess;
        }

        public SpringLocalConfig setPathPatterns(String[] pathPatterns) {
            this.pathPatterns = pathPatterns;
            return this;
        }

        public SpringLocalConfig setEnableStorage(Boolean enableStorage) {
            this.enableStorage = enableStorage;
            return this;
        }

        public SpringLocalConfig setEnableAccess(Boolean enableAccess) {
            this.enableAccess = enableAccess;
            return this;
        }

        public String toString() {
            return "SpringFileStorageProperties.SpringLocalConfig(super=" + super.toString() + ", pathPatterns=" + Arrays.deepToString(this.pathPatterns) + ", enableStorage=" + this.enableStorage + ", enableAccess=" + this.enableAccess + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpringLocalConfig)) {
                return false;
            }
            SpringLocalConfig other = (SpringLocalConfig)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$enableStorage = this.getEnableStorage();
            Boolean other$enableStorage = other.getEnableStorage();
            if (this$enableStorage == null ? other$enableStorage != null : !((Object)this$enableStorage).equals(other$enableStorage)) {
                return false;
            }
            Boolean this$enableAccess = this.getEnableAccess();
            Boolean other$enableAccess = other.getEnableAccess();
            if (this$enableAccess == null ? other$enableAccess != null : !((Object)this$enableAccess).equals(other$enableAccess)) {
                return false;
            }
            return Arrays.deepEquals(this.getPathPatterns(), other.getPathPatterns());
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpringLocalConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $enableStorage = this.getEnableStorage();
            result = result * 59 + ($enableStorage == null ? 43 : ((Object)$enableStorage).hashCode());
            Boolean $enableAccess = this.getEnableAccess();
            result = result * 59 + ($enableAccess == null ? 43 : ((Object)$enableAccess).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getPathPatterns());
            return result;
        }
    }
}

