/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.dataproviders;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.drools.core.WorkingMemory;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.spi.DataProvider;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.core.util.ArrayIterator;
import org.mvel2.MVEL;
import org.mvel2.integration.VariableResolverFactory;

public class MVELDataProvider
implements DataProvider,
MVELCompileable,
Externalizable {
    private static final long serialVersionUID = 510L;
    private MVELCompilationUnit unit;
    private String id;
    private Serializable expr;

    public MVELDataProvider() {
    }

    public MVELDataProvider(MVELCompilationUnit unit, String id) {
        this.unit = unit;
        this.id = id;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.unit = (MVELCompilationUnit)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeObject(this.unit);
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData) {
        this.expr = this.unit.getCompiledExpression(runtimeData);
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        return this.unit.getPreviousDeclarations();
    }

    @Override
    public void replaceDeclaration(Declaration declaration, Declaration resolved) {
        this.unit.replaceDeclaration(declaration, resolved);
    }

    @Override
    public Object createContext() {
        return null;
    }

    @Override
    public Iterator getResults(Tuple tuple, WorkingMemory wm, PropagationContext ctx, Object executionContext) {
        VariableResolverFactory factory = this.unit.getFactory(null, null, null, null, (LeftTuple)tuple, null, (InternalWorkingMemory)wm, wm.getGlobalResolver());
        Object result = MVEL.executeExpression((Object)this.expr, (VariableResolverFactory)factory);
        if (result == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (result instanceof Collection) {
            return ((Collection)result).iterator();
        }
        if (result instanceof Iterator) {
            return (Iterator)result;
        }
        if (result.getClass().isArray()) {
            return new ArrayIterator(result);
        }
        return Collections.singletonList(result).iterator();
    }

    @Override
    public DataProvider clone() {
        return this;
    }
}

