/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class UpgradableReentrantReadWriteLock {
    private final boolean shouldTryAtomicUpgrade;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ThreadLocal<LockRequestCounter> lockCounters = new ThreadLocal<LockRequestCounter>(){

        @Override
        protected LockRequestCounter initialValue() {
            return new LockRequestCounter();
        }
    };
    private AtomicBoolean tryingLockUpgrade = new AtomicBoolean(false);
    private final Integer lowPriotityMonitor = 42;
    private final Integer highPriorityMonitor = 43;

    public UpgradableReentrantReadWriteLock() {
        this(false);
    }

    public UpgradableReentrantReadWriteLock(boolean shouldTryAtomicUpgrade) {
        this.shouldTryAtomicUpgrade = shouldTryAtomicUpgrade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readLock() {
        LockRequestCounter lockCounter = this.lockCounters.get();
        if (this.increaseUpgradedReadCounter(lockCounter)) {
            return;
        }
        if (this.shouldTryAtomicUpgrade && this.tryingLockUpgrade.get() && lockCounter.readCounter == 0) {
            try {
                Integer n = this.lowPriotityMonitor;
                synchronized (n) {
                    this.lowPriotityMonitor.wait();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.lock.readLock().lock();
        this.increaseReadCounter(lockCounter);
    }

    public void readUnlock() {
        LockRequestCounter lockCounter = this.lockCounters.get();
        if (this.decreaseUpgradedReadCounter(lockCounter)) {
            return;
        }
        this.lock.readLock().unlock();
        this.decreaseReadCounters(lockCounter);
        this.notifyUpgradingThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyUpgradingThread() {
        if (this.shouldTryAtomicUpgrade && this.tryingLockUpgrade.get()) {
            Integer n = this.highPriorityMonitor;
            synchronized (n) {
                if (this.lock.getReadLockCount() < 2 && !this.lock.isWriteLocked()) {
                    this.highPriorityMonitor.notifyAll();
                }
            }
        }
    }

    public void writeLock() {
        if (this.lock.isWriteLockedByCurrentThread()) {
            this.lock.writeLock().lock();
            return;
        }
        LockRequestCounter lockCounter = this.lockCounters.get();
        if (lockCounter.readCounter > 0) {
            lockCounter.upgradedReadCounter = lockCounter.readCounter;
            if (this.shouldTryAtomicUpgrade && this.tryingLockUpgrade.compareAndSet(false, true)) {
                this.atomicLockUpgrade(lockCounter.readCounter);
            } else {
                for (int i = lockCounter.readCounter; i > 0; --i) {
                    this.lock.readLock().unlock();
                }
                this.notifyUpgradingThread();
                this.lowPriorityWriteLock();
            }
        } else {
            this.lowPriorityWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lowPriorityWriteLock() {
        if (this.shouldTryAtomicUpgrade && this.tryingLockUpgrade.get()) {
            Integer n = this.lowPriotityMonitor;
            synchronized (n) {
                try {
                    this.lowPriotityMonitor.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.lock.writeLock().lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atomicLockUpgrade(int readHoldCount) {
        for (int i = readHoldCount; i > 1; --i) {
            this.lock.readLock().unlock();
        }
        Integer n = this.highPriorityMonitor;
        synchronized (n) {
            if (this.lock.getReadLockCount() > readHoldCount || this.lock.isWriteLocked()) {
                try {
                    this.highPriorityMonitor.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.lock.readLock().unlock();
        this.lock.writeLock().lock();
        this.tryingLockUpgrade.set(false);
        n = this.lowPriotityMonitor;
        synchronized (n) {
            this.lowPriotityMonitor.notifyAll();
        }
    }

    public void writeUnlock() {
        LockRequestCounter lockCounter;
        if (this.lock.getWriteHoldCount() == 1 && (lockCounter = this.lockCounters.get()).upgradedReadCounter > 0) {
            for (int i = lockCounter.upgradedReadCounter; i > 0; --i) {
                this.lock.readLock().lock();
            }
            lockCounter.upgradedReadCounter = 0;
        }
        this.lock.writeLock().unlock();
        this.notifyUpgradingThread();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.lock.isWriteLockedByCurrentThread();
    }

    public int getWriteHoldCount() {
        return this.lock.getWriteHoldCount();
    }

    private void increaseReadCounter(LockRequestCounter lockCounter) {
        lockCounter.readCounter++;
    }

    private boolean increaseUpgradedReadCounter(LockRequestCounter lockCounter) {
        if (lockCounter.upgradedReadCounter == 0) {
            return false;
        }
        lockCounter.upgradedReadCounter++;
        return true;
    }

    private void decreaseReadCounters(LockRequestCounter lockCounter) {
        lockCounter.readCounter--;
    }

    private boolean decreaseUpgradedReadCounter(LockRequestCounter lockCounter) {
        if (lockCounter.upgradedReadCounter == 0) {
            return false;
        }
        lockCounter.upgradedReadCounter--;
        return true;
    }

    private static class LockRequestCounter {
        private int readCounter = 0;
        private int upgradedReadCounter = 0;

        private LockRequestCounter() {
        }
    }
}

