/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.RightTupleSets;
import org.drools.core.phreak.RightTupleEntry;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.NotNodeLeftTuple;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.spi.PropagationContext;

public class NotNode
extends BetaNode {
    private static final long serialVersionUID = 510L;
    static int notAssertObject = 0;
    static int notAssertTuple = 0;
    private boolean emptyBetaConstraints;

    public NotNode() {
    }

    public NotNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints joinNodeBinder, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), leftInput, rightInput, joinNodeBinder, context);
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
        this.emptyBetaConstraints = joinNodeBinder.getConstraints().length == 0 || context.isEmptyForAllBetaConstraints();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.emptyBetaConstraints = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.emptyBetaConstraints);
    }

    public boolean isEmptyBetaConstraints() {
        return this.emptyBetaConstraints;
    }

    public void setEmptyBetaConstraints(boolean emptyBetaConstraints) {
        this.emptyBetaConstraints = emptyBetaConstraints;
    }

    @Override
    public short getType() {
        return 191;
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        NotNodeLeftTuple peer = new NotNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new NotNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, LeftTupleSink sink) {
        return new NotNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new NotNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new NotNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new NotNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public String toString() {
        ObjectTypeNode source = this.getObjectTypeNode();
        return "[NotNode(" + this.getId() + ") - " + (source != null ? source.getObjectType() : "<source from a subnetwork>") + "]";
    }

    @Override
    public void assertRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext pctx, InternalWorkingMemory wm) {
        BetaMemory memory = (BetaMemory)NotNode.getBetaMemoryFromRightInput(this, wm);
        RightTuple rightTuple = this.createRightTuple(factHandle, this, pctx);
        rightTuple.setPropagationContext(pctx);
        boolean stagedInsertWasEmpty = false;
        if (this.streamMode) {
            stagedInsertWasEmpty = memory.getSegmentMemory().getTupleQueue().isEmpty();
            memory.getSegmentMemory().getTupleQueue().add(new RightTupleEntry(rightTuple, pctx, memory, pctx.getType()));
        } else {
            stagedInsertWasEmpty = memory.getStagedRightTuples().addInsert(rightTuple);
        }
        if (memory.getAndIncCounter() == 0 && this.isEmptyBetaConstraints()) {
            memory.linkNode(wm);
        } else if (stagedInsertWasEmpty) {
            memory.setNodeDirty(wm);
        }
    }

    @Override
    public void retractRightTuple(RightTuple rightTuple, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        rightTuple.setPropagationContext(pctx);
        RightTupleSets stagedRightTuples = memory.getStagedRightTuples();
        boolean stagedDeleteWasEmpty = false;
        if (this.streamMode) {
            stagedDeleteWasEmpty = memory.getSegmentMemory().getTupleQueue().isEmpty();
            memory.getSegmentMemory().getTupleQueue().add(new RightTupleEntry(rightTuple, pctx, memory, pctx.getType()));
        } else {
            stagedDeleteWasEmpty = stagedRightTuples.addDelete(rightTuple);
        }
        if (memory.getAndDecCounter() == 1 && this.isEmptyBetaConstraints()) {
            memory.linkNode(workingMemory);
        } else if (stagedDeleteWasEmpty) {
            memory.setNodeDirty(workingMemory);
        }
    }

    @Override
    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        if (!this.isInUse()) {
            this.getLeftTupleSource().removeTupleSink(this);
            this.getRightInput().removeObjectSink(this);
        }
    }

    public boolean isLeftUpdateOptimizationAllowed() {
        return this.getRawConstraints().isLeftUpdateOptimizationAllowed();
    }
}

