/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Externalizable;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.util.AbstractCodedHierarchyImpl;
import org.drools.core.util.HierNode;

public class CodedHierarchyImpl<T>
extends AbstractCodedHierarchyImpl<T>
implements Externalizable {
    protected transient Map<T, HierNode<T>> cache = new HashMap<T, HierNode<T>>();

    @Override
    protected HierNode<T> getNode(T name) {
        return this.cache.get(name);
    }

    @Override
    protected void add(HierNode<T> node) {
        super.add(node);
        this.cache.put(node.getValue(), node);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("*****************************************\n");
        int len = 0;
        for (HierNode node : this.getNodes()) {
            len = Math.max(len, this.numBit(node.getBitMask()));
        }
        for (HierNode node : this.getNodes()) {
            builder.append(node.toString(len)).append("\n");
        }
        builder.append("*****************************************\n");
        builder.append(this.getSortedMap()).append("\n");
        builder.append("*****************************************\n");
        return builder.toString();
    }
}

