/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.RightTupleRBTree;
import org.drools.core.util.index.IndexUtil;
import org.drools.core.util.index.RightTupleList;

public class RightTupleIndexRBTree
implements RightTupleMemory,
Externalizable {
    private RightTupleRBTree<Comparable<Comparable>> tree;
    private AbstractHashTable.FieldIndex index;
    private IndexUtil.ConstraintType constraintType;
    private int size;

    public RightTupleIndexRBTree() {
    }

    public RightTupleIndexRBTree(IndexUtil.ConstraintType constraintType, AbstractHashTable.FieldIndex index) {
        this.index = index;
        this.constraintType = constraintType;
        this.tree = new RightTupleRBTree();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.tree);
        out.writeObject(this.index);
        out.writeObject((Object)this.constraintType);
        out.writeInt(this.size);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tree = (RightTupleRBTree)in.readObject();
        this.index = (AbstractHashTable.FieldIndex)in.readObject();
        this.constraintType = (IndexUtil.ConstraintType)((Object)in.readObject());
        this.size = in.readInt();
    }

    @Override
    public void add(RightTuple tuple) {
        Comparable key = this.getIndexedValue(tuple);
        RightTupleRBTree.Node<Comparable<Comparable>> list = this.tree.insert(key);
        list.add(tuple);
        ++this.size;
    }

    @Override
    public void remove(RightTuple tuple) {
        RightTupleList list = tuple.getMemory();
        list.remove(tuple);
        if (list.getFirst() == null) {
            this.tree.delete((Comparable<Comparable>)((RightTupleRBTree.Node)list).key);
        }
        --this.size;
    }

    @Override
    public void removeAdd(RightTuple tuple) {
        this.remove(tuple);
        this.add(tuple);
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Entry[] toArray() {
        FastIterator it = this.tree.fastIterator();
        if (it == null) {
            return new Entry[0];
        }
        ArrayList toBeRemoved = new ArrayList();
        ArrayList<RightTuple> result = new ArrayList<RightTuple>();
        RightTupleList list = null;
        while ((list = (RightTupleList)it.next(list)) != null) {
            for (RightTuple entry = list.getFirst(); entry != null; entry = (RightTuple)entry.getNext()) {
                result.add(entry);
            }
        }
        return result.toArray(new LeftTuple[result.size()]);
    }

    @Override
    public RightTuple getFirst(LeftTuple tuple, InternalFactHandle factHandle, FastIterator rightTupleIterator) {
        Comparable key = this.getIndexedValue(tuple);
        return this.getNext(key, true);
    }

    @Override
    public Iterator iterator() {
        RightTupleRBTree.Node<Comparable<Comparable>> list = this.tree.first();
        RightTuple firstTuple = list != null ? list.first : null;
        return new FastIterator.IteratorAdapter(this.fastIterator(), firstTuple);
    }

    @Override
    public boolean contains(RightTuple tuple) {
        Comparable key = this.getIndexedValue(tuple);
        return this.tree.lookup(key) != null;
    }

    @Override
    public FastIterator fastIterator() {
        return new RightTupleFastIterator();
    }

    @Override
    public FastIterator fullFastIterator() {
        return new RightTupleFastIterator();
    }

    @Override
    public FastIterator fullFastIterator(RightTuple tuple) {
        FastIterator fastIterator = this.fullFastIterator();
        Comparable key = this.getIndexedValue(tuple);
        fastIterator.next(this.getNext(key, true));
        return fastIterator;
    }

    @Override
    public RightTupleMemory.IndexType getIndexType() {
        return RightTupleMemory.IndexType.COMPARISON;
    }

    private Comparable getIndexedValue(LeftTuple leftTuple) {
        return (Comparable)this.index.getDeclaration().getExtractor().getValue(leftTuple.get(this.index.getDeclaration()).getObject());
    }

    private Comparable getIndexedValue(RightTuple rightTuple) {
        return (Comparable)this.index.getExtractor().getValue(rightTuple.getFactHandle().getObject());
    }

    private RightTuple getNext(Comparable key, boolean first) {
        RightTupleRBTree.Node<Comparable<Comparable>> firstNode;
        switch (this.constraintType) {
            case LESS_THAN: {
                firstNode = this.tree.findNearestNode(key, false, RightTupleRBTree.Boundary.UPPER);
                break;
            }
            case LESS_OR_EQUAL: {
                firstNode = this.tree.findNearestNode(key, first, RightTupleRBTree.Boundary.UPPER);
                break;
            }
            case GREATER_THAN: {
                firstNode = this.tree.findNearestNode(key, false, RightTupleRBTree.Boundary.LOWER);
                break;
            }
            case GREATER_OR_EQUAL: {
                firstNode = this.tree.findNearestNode(key, first, RightTupleRBTree.Boundary.LOWER);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot call remove constraint of type: " + (Object)((Object)this.constraintType));
            }
        }
        return firstNode == null ? null : firstNode.getFirst();
    }

    public class RightTupleFastIterator
    implements FastIterator {
        @Override
        public Entry next(Entry object) {
            if (object == null) {
                RightTupleRBTree.Node firstNode = RightTupleIndexRBTree.this.tree.first();
                return firstNode == null ? null : firstNode.getFirst();
            }
            RightTuple rightTuple = (RightTuple)object;
            RightTuple next = (RightTuple)rightTuple.getNext();
            if (next != null) {
                return next;
            }
            Comparable key = RightTupleIndexRBTree.this.getIndexedValue(rightTuple);
            return RightTupleIndexRBTree.this.getNext(key, false);
        }

        @Override
        public boolean isFullIterator() {
            return false;
        }
    }
}

