/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.factmodel.traits;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.factmodel.traits.LatticeElement;
import org.drools.core.util.AbstractCodedHierarchyImpl;
import org.drools.core.util.HierNode;

public class IndexedTypeHierarchy<T>
extends AbstractCodedHierarchyImpl<T>
implements Externalizable {
    protected transient Map<T, HierNode<T>> cache;
    private BitSet bottom;
    private BitSet top;

    public IndexedTypeHierarchy() {
        this.top = new BitSet();
        this.cache = new HashMap<T, HierNode<T>>();
    }

    public IndexedTypeHierarchy(T topElement, BitSet topKey, T bottomElement, BitSet bottomKey) {
        this.setTopCode(topKey);
        this.setBottomCode(bottomKey);
        this.cache = new HashMap<T, HierNode<T>>();
        this.addMember(topElement, topKey);
        this.addMember(bottomElement, bottomKey);
    }

    public BitSet getTopCode() {
        return this.top;
    }

    public BitSet getBottomCode() {
        return this.bottom;
    }

    public void setBottomCode(BitSet bottom) {
        this.bottom = bottom;
    }

    public void setTopCode(BitSet top) {
        this.top = top;
    }

    @Override
    protected HierNode<T> getNode(T name) {
        return this.cache.get(name);
    }

    @Override
    protected void add(HierNode<T> node) {
        super.add(node);
        this.cache.put(node.getValue(), node);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("*****************************************\n");
        int len = 0;
        for (HierNode node : this.getNodes()) {
            len = Math.max(len, this.numBit(node.getBitMask()));
        }
        for (HierNode node : this.getNodes()) {
            builder.append(node.toString(len)).append("\n");
        }
        builder.append("*****************************************\n");
        builder.append(this.getSortedMap()).append("\n");
        builder.append("*****************************************\n");
        return builder.toString();
    }

    @Override
    protected HierNode<T> getNode(LatticeElement<T> name) {
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
    }
}

