/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import org.drools.core.rule.TypeDeclaration;
import org.kie.api.definition.type.Role;

public class TypeMetaInfo {
    private TypeDeclaration.Kind kind;
    private Role.Type role;
    private boolean isDeclaredType;

    public TypeMetaInfo() {
    }

    public TypeMetaInfo(TypeDeclaration typeDeclaration) {
        this.kind = typeDeclaration.getKind();
        this.role = typeDeclaration.getRole();
        this.isDeclaredType = !typeDeclaration.isJavaBased();
    }

    public TypeMetaInfo(Class<?> clazz) {
        this.kind = TypeDeclaration.Kind.CLASS;
        Role role = clazz.getAnnotation(Role.class);
        this.role = role == null ? Role.Type.FACT : role.value();
        this.isDeclaredType = false;
    }

    public boolean isEvent() {
        return this.role == Role.Type.EVENT;
    }

    public boolean isDeclaredType() {
        return this.isDeclaredType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("kind=").append(this.kind.toString().toLowerCase());
        sb.append(",");
        sb.append("role=").append(this.role.toString().toLowerCase());
        sb.append(",");
        sb.append("isDeclaredType=").append(this.isDeclaredType);
        return sb.toString();
    }
}

