/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.retry;

import org.duracloud.common.retry.ExceptionHandler;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.util.WaitUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retrier {
    public static final int DEFAULT_MAX_RETRIES = 3;
    public static final int DEFAULT_WAIT_BETWEEN_RETRIES = 1000;
    public static final int DEFAULT_WAIT_MULTIPLIER = 1;
    private int maxRetries;
    private long waitBetweenRetries;
    private int waitBetweenRetriesMultiplier;
    private static final Logger log = LoggerFactory.getLogger(Retrier.class);
    private static final ExceptionHandler DEFAULT_EXCEPTION_HANDLER = new ExceptionHandler(){

        @Override
        public void handle(Exception ex) {
            log.debug(ex.getMessage(), (Throwable)ex);
        }
    };

    public Retrier() {
        this(3, 1000, 1);
    }

    public Retrier(int maxRetries) {
        this(maxRetries, 1000, 1);
    }

    public Retrier(int maxRetries, int waitBetweenRetries, int waitBetweenRetriesMultiplier) {
        this.maxRetries = maxRetries;
        this.waitBetweenRetries = waitBetweenRetries;
        this.waitBetweenRetriesMultiplier = waitBetweenRetriesMultiplier;
    }

    public <T> T execute(Retriable retriable) throws Exception {
        return this.execute(retriable, DEFAULT_EXCEPTION_HANDLER);
    }

    public <T> T execute(Retriable retriable, ExceptionHandler exceptionHandler) throws Exception {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException("exceptionHandler must be non-null");
        }
        Exception lastException = null;
        for (int i = 0; i <= this.maxRetries; ++i) {
            try {
                return (T)retriable.retry();
            }
            catch (Exception e) {
                lastException = e;
                exceptionHandler.handle(e);
                if (i >= this.maxRetries) continue;
                WaitUtil.waitMs((long)Math.pow(i, this.waitBetweenRetriesMultiplier) * this.waitBetweenRetries);
                continue;
            }
        }
        throw lastException;
    }
}

