/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.nio.ByteBuffer;
import java.util.function.LongConsumer;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.eclipse.jetty.reactive.client.internal.AbstractEventPublisher;
import org.eclipse.jetty.util.Callback;

public class ResponseEventPublisher
extends AbstractEventPublisher<ReactiveResponse.Event>
implements Response.Listener {
    private final ReactiveRequest request;

    public ResponseEventPublisher(ReactiveRequest request) {
        this.request = request;
    }

    public void onBegin(Response response) {
        this.emit(new ReactiveResponse.Event(ReactiveResponse.Event.Type.BEGIN, this.request.getReactiveResponse()));
    }

    public boolean onHeader(Response response, HttpField field) {
        return true;
    }

    public void onHeaders(Response response) {
        this.emit(new ReactiveResponse.Event(ReactiveResponse.Event.Type.HEADERS, this.request.getReactiveResponse()));
    }

    public void onContent(Response response, ByteBuffer content) {
    }

    public void onContent(Response response, ByteBuffer content, Callback callback) {
    }

    public void onContent(Response response, LongConsumer demand, ByteBuffer content, Callback callback) {
        this.emit(new ReactiveResponse.Event(ReactiveResponse.Event.Type.CONTENT, this.request.getReactiveResponse(), content));
        callback.succeeded();
        demand.accept(1L);
    }

    public void onSuccess(Response response) {
        this.emit(new ReactiveResponse.Event(ReactiveResponse.Event.Type.SUCCESS, this.request.getReactiveResponse()));
    }

    public void onFailure(Response response, Throwable failure) {
        this.emit(new ReactiveResponse.Event(ReactiveResponse.Event.Type.FAILURE, this.request.getReactiveResponse(), failure));
    }

    public void onComplete(Result result) {
        this.emit(new ReactiveResponse.Event(ReactiveResponse.Event.Type.COMPLETE, this.request.getReactiveResponse()));
        if (result.isSucceeded()) {
            this.succeed();
        } else {
            this.fail(result.getFailure());
        }
    }
}

