/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.IndexDiffFilter;
import org.eclipse.jgit.treewalk.filter.SkipWorkTreeFilter;
import org.eclipse.jgit.util.FileUtils;

public class StashCreateCommand
extends GitCommand<RevCommit> {
    private static final String MSG_INDEX = "index on {0}: {1} {2}";
    private static final String MSG_UNTRACKED = "untracked files on {0}: {1} {2}";
    private static final String MSG_WORKING_DIR = "WIP on {0}: {1} {2}";
    private String indexMessage = "index on {0}: {1} {2}";
    private String workingDirectoryMessage = "WIP on {0}: {1} {2}";
    private String ref = "refs/stash";
    private PersonIdent person;
    private boolean includeUntracked;

    public StashCreateCommand(Repository repo) {
        super(repo);
        this.person = new PersonIdent(repo);
    }

    public StashCreateCommand setIndexMessage(String message) {
        this.indexMessage = message;
        return this;
    }

    public StashCreateCommand setWorkingDirectoryMessage(String message) {
        this.workingDirectoryMessage = message;
        return this;
    }

    public StashCreateCommand setPerson(PersonIdent person) {
        this.person = person;
        return this;
    }

    public StashCreateCommand setRef(String ref) {
        this.ref = ref;
        return this;
    }

    public StashCreateCommand setIncludeUntracked(boolean includeUntracked) {
        this.includeUntracked = includeUntracked;
        return this;
    }

    private RevCommit parseCommit(ObjectReader reader, ObjectId headId) throws IOException {
        try (RevWalk walk = new RevWalk(reader);){
            RevCommit revCommit = walk.parseCommit(headId);
            return revCommit;
        }
    }

    private CommitBuilder createBuilder() {
        CommitBuilder builder = new CommitBuilder();
        PersonIdent author = this.person;
        if (author == null) {
            author = new PersonIdent(this.repo);
        }
        builder.setAuthor(author);
        builder.setCommitter(author);
        return builder;
    }

    private void updateStashRef(ObjectId commitId, PersonIdent refLogIdent, String refLogMessage) throws IOException {
        if (this.ref == null) {
            return;
        }
        Ref currentRef = this.repo.findRef(this.ref);
        RefUpdate refUpdate = this.repo.updateRef(this.ref);
        refUpdate.setNewObjectId(commitId);
        refUpdate.setRefLogIdent(refLogIdent);
        refUpdate.setRefLogMessage(refLogMessage, false);
        if (currentRef != null) {
            refUpdate.setExpectedOldObjectId(currentRef.getObjectId());
        } else {
            refUpdate.setExpectedOldObjectId(ObjectId.zeroId());
        }
        refUpdate.forceUpdate();
    }

    private Ref getHead() throws GitAPIException {
        try {
            Ref head = this.repo.exactRef("HEAD");
            if (head == null || head.getObjectId() == null) {
                throw new NoHeadException(JGitText.get().headRequiredToStash);
            }
            return head;
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().stashFailed, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RevCommit call() throws GitAPIException {
        this.checkCallable();
        Ref head = this.getHead();
        try (ObjectReader reader = this.repo.newObjectReader();){
            ObjectId commitId;
            RevCommit headCommit = this.parseCommit(reader, head.getObjectId());
            DirCache cache = this.repo.lockDirCache();
            try (ObjectInserter inserter = this.repo.newObjectInserter();
                 TreeWalk treeWalk = new TreeWalk(this.repo, reader);){
                AbstractTreeIterator headIter;
                treeWalk.setRecursive(true);
                treeWalk.addTree(headCommit.getTree());
                treeWalk.addTree(new DirCacheIterator(cache));
                treeWalk.addTree(new FileTreeIterator(this.repo));
                treeWalk.getTree(2, FileTreeIterator.class).setDirCacheIterator(treeWalk, 1);
                treeWalk.setFilter(AndTreeFilter.create(new SkipWorkTreeFilter(1), new IndexDiffFilter(1, 2)));
                if (!treeWalk.next()) {
                    RevCommit revCommit = null;
                    return revCommit;
                }
                MutableObjectId id = new MutableObjectId();
                ArrayList<1> wtEdits = new ArrayList<1>();
                ArrayList<String> wtDeletes = new ArrayList<String>();
                ArrayList<DirCacheEntry> untracked = new ArrayList<DirCacheEntry>();
                boolean hasChanges = false;
                do {
                    headIter = treeWalk.getTree(0, AbstractTreeIterator.class);
                    DirCacheIterator indexIter = treeWalk.getTree(1, DirCacheIterator.class);
                    WorkingTreeIterator wtIter = treeWalk.getTree(2, WorkingTreeIterator.class);
                    if (indexIter != null && !indexIter.getDirCacheEntry().isMerged()) {
                        throw new UnmergedPathsException(new UnmergedPathException(indexIter.getDirCacheEntry()));
                    }
                    if (wtIter != null) {
                        if (indexIter == null && headIter == null && !this.includeUntracked) continue;
                        hasChanges = true;
                        if (indexIter != null && wtIter.idEqual(indexIter) || headIter != null && wtIter.idEqual(headIter)) continue;
                        treeWalk.getObjectId(id, 0);
                        final DirCacheEntry entry = new DirCacheEntry(treeWalk.getRawPath());
                        entry.setLength(wtIter.getEntryLength());
                        entry.setLastModified(wtIter.getEntryLastModified());
                        entry.setFileMode(wtIter.getEntryFileMode());
                        long contentLength = wtIter.getEntryContentLength();
                        try (InputStream inputStream = wtIter.openEntryStream();){
                            entry.setObjectId(inserter.insert(3, contentLength, inputStream));
                        }
                        if (indexIter == null && headIter == null) {
                            untracked.add(entry);
                        } else {
                            wtEdits.add(new DirCacheEditor.PathEdit(entry){

                                @Override
                                public void apply(DirCacheEntry ent) {
                                    ent.copyMetaData(entry);
                                }
                            });
                        }
                    }
                    hasChanges = true;
                    if (wtIter != null || headIter == null) continue;
                    wtDeletes.add(treeWalk.getPathString());
                } while (treeWalk.next());
                if (!hasChanges) {
                    headIter = null;
                    return headIter;
                }
                String branch = Repository.shortenRefName(head.getTarget().getName());
                CommitBuilder builder = this.createBuilder();
                builder.setParentId(headCommit);
                builder.setTreeId(cache.writeTree(inserter));
                builder.setMessage(MessageFormat.format(this.indexMessage, branch, headCommit.abbreviate(7).name(), headCommit.getShortMessage()));
                ObjectId indexCommit = inserter.insert(builder);
                ObjectId untrackedCommit = null;
                if (!untracked.isEmpty()) {
                    DirCache untrackedDirCache = DirCache.newInCore();
                    Iterator untrackedBuilder = untrackedDirCache.builder();
                    for (DirCacheEntry entry : untracked) {
                        ((DirCacheBuilder)((Object)untrackedBuilder)).add(entry);
                    }
                    ((DirCacheBuilder)((Object)untrackedBuilder)).finish();
                    builder.setParentIds(new ObjectId[0]);
                    builder.setTreeId(untrackedDirCache.writeTree(inserter));
                    builder.setMessage(MessageFormat.format(MSG_UNTRACKED, branch, headCommit.abbreviate(7).name(), headCommit.getShortMessage()));
                    untrackedCommit = inserter.insert(builder);
                }
                if (!wtEdits.isEmpty() || !wtDeletes.isEmpty()) {
                    DirCacheEditor editor = cache.editor();
                    for (DirCacheEditor.PathEdit pathEdit : wtEdits) {
                        editor.add(pathEdit);
                    }
                    for (String string : wtDeletes) {
                        editor.add(new DirCacheEditor.DeletePath(string));
                    }
                    editor.finish();
                }
                builder.setParentId(headCommit);
                builder.addParentId(indexCommit);
                if (untrackedCommit != null) {
                    builder.addParentId(untrackedCommit);
                }
                builder.setMessage(MessageFormat.format(this.workingDirectoryMessage, branch, headCommit.abbreviate(7).name(), headCommit.getShortMessage()));
                builder.setTreeId(cache.writeTree(inserter));
                commitId = inserter.insert(builder);
                inserter.flush();
                this.updateStashRef(commitId, builder.getAuthor(), builder.getMessage());
                if (this.includeUntracked) {
                    for (DirCacheEntry entry : untracked) {
                        File file = new File(this.repo.getWorkTree(), entry.getPathString());
                        FileUtils.delete(file);
                    }
                }
            }
            finally {
                cache.unlock();
            }
            new ResetCommand(this.repo).setMode(ResetCommand.ResetType.HARD).call();
            RevCommit revCommit = this.parseCommit(reader, commitId);
            return revCommit;
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().stashFailed, e);
        }
    }
}

