/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.DataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaBinaryDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaXmlDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.BuiltinDataTypeDictionary;
import org.eclipse.milo.opcua.stack.core.types.DataTypeDictionary;
import org.eclipse.milo.opcua.stack.core.types.DataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public class ClientDataTypeManager
implements DataTypeManager {
    private final ConcurrentMap<String, DataTypeDictionary<?>> dictionaries = Maps.newConcurrentMap();
    private final ConcurrentMap<NodeId, DataTypeCodec> codecs = Maps.newConcurrentMap();

    public ClientDataTypeManager() {
        this.registerTypeDictionary((DataTypeDictionary<?>)BuiltinDataTypeDictionary.getBinaryInstance());
        this.registerTypeDictionary((DataTypeDictionary<?>)BuiltinDataTypeDictionary.getXmlInstance());
    }

    public void registerTypeDictionary(DataTypeDictionary<?> dataTypeDictionary) {
        this.dictionaries.put(dataTypeDictionary.getNamespaceUri(), dataTypeDictionary);
        this.codecs.putAll(dataTypeDictionary.getCodecsByEncodingId());
    }

    @Nullable
    public DataTypeDictionary getTypeDictionary(String namespaceUri) {
        return (DataTypeDictionary)this.dictionaries.get(namespaceUri);
    }

    @Nullable
    public OpcUaBinaryDataTypeCodec<?> getBinaryCodec(NodeId encodingId) {
        DataTypeCodec codec = (DataTypeCodec)this.codecs.get(encodingId);
        if (codec instanceof OpcUaBinaryDataTypeCodec) {
            return (OpcUaBinaryDataTypeCodec)codec;
        }
        return null;
    }

    @Nullable
    public OpcUaXmlDataTypeCodec<?> getXmlCodec(NodeId encodingId) {
        DataTypeCodec codec = (DataTypeCodec)this.codecs.get(encodingId);
        if (codec instanceof OpcUaXmlDataTypeCodec) {
            return (OpcUaXmlDataTypeCodec)codec;
        }
        return null;
    }
}

