/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.AddressSpace;
import org.eclipse.milo.opcua.sdk.client.api.nodes.DataTypeNode;
import org.eclipse.milo.opcua.sdk.client.api.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.client.api.nodes.Node;
import org.eclipse.milo.opcua.sdk.client.api.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.client.api.nodes.ObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.api.nodes.ReferenceTypeNode;
import org.eclipse.milo.opcua.sdk.client.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.client.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.api.nodes.ViewNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaDataTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaObjectNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaReferenceTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaViewNode;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;

public class DefaultAddressSpace
implements AddressSpace {
    private final OpcUaClient client;

    public DefaultAddressSpace(OpcUaClient client) {
        this.client = client;
    }

    public CompletableFuture<UaNode> createNode(NodeId nodeId) {
        ReadValueId readValueId = new ReadValueId(nodeId, AttributeId.NodeClass.uid(), null, QualifiedName.NULL_VALUE);
        CompletableFuture<ReadResponse> future = this.client.read(0.0, TimestampsToReturn.Neither, Lists.newArrayList((Object[])new ReadValueId[]{readValueId}));
        return future.thenCompose(response -> {
            DataValue value = (DataValue)ConversionUtil.l((Object[])response.getResults()).get(0);
            NodeClass nodeClass = NodeClass.from((Integer)((Integer)value.getValue().getValue()));
            if (nodeClass != null) {
                this.client.getNodeCache().putAttribute(nodeId, AttributeId.NodeClass, value);
                return CompletableFuture.completedFuture(this.createNode(nodeId, nodeClass));
            }
            return DefaultAddressSpace.failedFuture(new UaException(value.getStatusCode(), "NodeClass was null"));
        });
    }

    @Override
    public CompletableFuture<UaNode> getNodeInstance(NodeId nodeId) {
        return this.createNode(nodeId).thenCompose(node -> {
            if (node instanceof UaVariableNode) {
                return this.getVariableNodeInstance(nodeId, (UaVariableNode)node);
            }
            if (node instanceof UaObjectNode) {
                return this.getObjectNodeInstance(nodeId, (UaObjectNode)node);
            }
            return CompletableFuture.completedFuture(node);
        });
    }

    private CompletableFuture<UaNode> getObjectNodeInstance(NodeId nodeId, UaObjectNode node) {
        return ((CompletableFuture)node.getTypeDefinition().thenCompose(Node::getNodeId)).thenCompose(typeDefinition -> this.client.getTypeRegistry().getNodeFactory((NodeId)typeDefinition).map(f -> CompletableFuture.completedFuture(f.apply(this.client, nodeId))).orElse(CompletableFuture.completedFuture(node)));
    }

    private CompletableFuture<UaNode> getVariableNodeInstance(NodeId nodeId, UaVariableNode node) {
        return ((CompletableFuture)node.getTypeDefinition().thenCompose(Node::getNodeId)).thenCompose(typeDefinition -> this.client.getTypeRegistry().getNodeFactory((NodeId)typeDefinition).map(f -> CompletableFuture.completedFuture(f.apply(this.client, nodeId))).orElse(CompletableFuture.completedFuture(node)));
    }

    @Override
    public CompletableFuture<ObjectNode> getObjectNode(NodeId nodeId) {
        return this.getNodeInstance(nodeId).thenCompose(node -> {
            if (ObjectNode.class.isAssignableFrom(node.getClass())) {
                return CompletableFuture.completedFuture(ObjectNode.class.cast(node));
            }
            return DefaultAddressSpace.failedFuture(new UaException(2158690304L, String.format("ObjectNode not assignable from %s", node.getClass())));
        });
    }

    @Override
    public <T extends ObjectNode> CompletableFuture<T> getObjectNode(NodeId nodeId, Class<T> nodeClazz) {
        return this.getNodeInstance(nodeId).thenCompose(node -> {
            if (nodeClazz.isAssignableFrom(node.getClass())) {
                return CompletableFuture.completedFuture(nodeClazz.cast(node));
            }
            return DefaultAddressSpace.failedFuture(new UaException(2158690304L, String.format("%s not assignable from %s", nodeClazz, node.getClass())));
        });
    }

    @Override
    public CompletableFuture<VariableNode> getVariableNode(NodeId nodeId) {
        return this.getNodeInstance(nodeId).thenCompose(node -> {
            if (VariableNode.class.isAssignableFrom(node.getClass())) {
                return CompletableFuture.completedFuture(VariableNode.class.cast(node));
            }
            return DefaultAddressSpace.failedFuture(new UaException(2158690304L, String.format("VariableNode not assignable from %s", node.getClass())));
        });
    }

    @Override
    public <T extends VariableNode> CompletableFuture<T> getVariableNode(NodeId nodeId, Class<T> nodeClazz) {
        return this.getNodeInstance(nodeId).thenCompose(node -> {
            if (nodeClazz.isAssignableFrom(node.getClass())) {
                return CompletableFuture.completedFuture(nodeClazz.cast(node));
            }
            return DefaultAddressSpace.failedFuture(new UaException(2158690304L, String.format("%s not assignable from %s", nodeClazz, node.getClass())));
        });
    }

    @Override
    public DataTypeNode createDataTypeNode(NodeId nodeId) {
        return new UaDataTypeNode(this.client, nodeId);
    }

    @Override
    public MethodNode createMethodNode(NodeId nodeId) {
        return new UaMethodNode(this.client, nodeId);
    }

    @Override
    public ObjectNode createObjectNode(NodeId nodeId) {
        return new UaObjectNode(this.client, nodeId);
    }

    @Override
    public ObjectTypeNode createObjectTypeNode(NodeId nodeId) {
        return new UaObjectTypeNode(this.client, nodeId);
    }

    @Override
    public ReferenceTypeNode createReferenceTypeNode(NodeId nodeId) {
        return new UaReferenceTypeNode(this.client, nodeId);
    }

    @Override
    public UaVariableNode createVariableNode(NodeId nodeId) {
        return new UaVariableNode(this.client, nodeId);
    }

    @Override
    public VariableTypeNode createVariableTypeNode(NodeId nodeId) {
        return new UaVariableTypeNode(this.client, nodeId);
    }

    @Override
    public ViewNode createViewNode(NodeId nodeId) {
        return new UaViewNode(this.client, nodeId);
    }

    @Override
    public CompletableFuture<List<Node>> browse(NodeId nodeId) {
        UInteger nodeClassMask = Unsigned.uint((int)(NodeClass.Method.getValue() | NodeClass.Object.getValue() | NodeClass.Variable.getValue()));
        UInteger resultMask = Unsigned.uint((int)BrowseResultMask.All.getValue());
        CompletableFuture<BrowseResult> future = this.client.browse(new BrowseDescription(nodeId, BrowseDirection.Forward, Identifiers.HierarchicalReferences, Boolean.valueOf(true), nodeClassMask, resultMask));
        return future.thenApply(result -> {
            List references = ConversionUtil.l((Object[])result.getReferences());
            return references.stream().flatMap(r -> StreamUtil.opt2stream(r.getNodeId().local().map(id -> this.createNode((NodeId)id, r.getNodeClass())))).collect(Collectors.toList());
        });
    }

    private UaNode createNode(NodeId nodeId, NodeClass nodeClass) {
        switch (nodeClass) {
            case DataType: {
                return new UaDataTypeNode(this.client, nodeId);
            }
            case Method: {
                return new UaMethodNode(this.client, nodeId);
            }
            case Object: {
                return new UaObjectNode(this.client, nodeId);
            }
            case ObjectType: {
                return new UaObjectTypeNode(this.client, nodeId);
            }
            case ReferenceType: {
                return new UaReferenceTypeNode(this.client, nodeId);
            }
            case Variable: {
                return new UaVariableNode(this.client, nodeId);
            }
            case VariableType: {
                return new UaVariableTypeNode(this.client, nodeId);
            }
            case View: {
                return new UaViewNode(this.client, nodeId);
            }
        }
        throw new IllegalStateException("unhandled NodeClass: " + nodeClass);
    }

    private static <T> CompletableFuture<T> failedFuture(UaException exception) {
        CompletableFuture f = new CompletableFuture();
        f.completeExceptionally(exception);
        return f;
    }
}

