/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.session.states;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaSession;
import org.eclipse.milo.opcua.sdk.client.session.Fsm;
import org.eclipse.milo.opcua.sdk.client.session.events.CloseSessionEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CreateSessionEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.Event;
import org.eclipse.milo.opcua.sdk.client.session.states.AbstractSessionState;
import org.eclipse.milo.opcua.sdk.client.session.states.Creating;
import org.eclipse.milo.opcua.sdk.client.session.states.SessionState;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public class Inactive
extends AbstractSessionState
implements SessionState {
    private final CompletableFuture<OpcUaSession> sessionFuture = FutureUtils.failedUaFuture((long)2149974016L);

    @Override
    public CompletableFuture<OpcUaSession> getSessionFuture() {
        return this.sessionFuture;
    }

    @Override
    public SessionState execute(Fsm fsm, Event event) {
        if (event instanceof CreateSessionEvent) {
            CompletableFuture<OpcUaSession> sessionFuture = ((CreateSessionEvent)event).getSessionFuture();
            Inactive.createSessionAsync(fsm, sessionFuture);
            return new Creating();
        }
        if (event instanceof CloseSessionEvent) {
            CompletableFuture<Unit> closeFuture = ((CloseSessionEvent)event).getCloseFuture();
            closeFuture.complete(Unit.VALUE);
            return this;
        }
        return this;
    }
}

