/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.session.states;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaSession;
import org.eclipse.milo.opcua.sdk.client.session.Fsm;
import org.eclipse.milo.opcua.sdk.client.session.events.CloseSessionEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CreateSessionEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CreateSessionFailureEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CreateSessionSuccessEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.Event;
import org.eclipse.milo.opcua.sdk.client.session.states.AbstractSessionState;
import org.eclipse.milo.opcua.sdk.client.session.states.Closing;
import org.eclipse.milo.opcua.sdk.client.session.states.Reactivating;
import org.eclipse.milo.opcua.sdk.client.session.states.SessionState;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;

public class Recreating
extends AbstractSessionState
implements SessionState {
    private final CompletableFuture<OpcUaSession> sessionFuture = new CompletableFuture();

    @Override
    public CompletableFuture<OpcUaSession> getSessionFuture() {
        return this.sessionFuture;
    }

    @Override
    public void onInternalTransition(Fsm fsm, Event event) {
        if (event instanceof CreateSessionEvent) {
            CreateSessionEvent e = (CreateSessionEvent)event;
            FutureUtils.complete(e.getSessionFuture()).with(this.sessionFuture);
        }
    }

    @Override
    public SessionState execute(Fsm fsm, Event event) {
        if (event instanceof CreateSessionSuccessEvent) {
            CreateSessionSuccessEvent e = (CreateSessionSuccessEvent)event;
            Recreating.activateSessionAsync(fsm, e.getResponse(), this.sessionFuture);
            return new Reactivating();
        }
        if (event instanceof CreateSessionFailureEvent) {
            Throwable failure = ((CreateSessionFailureEvent)event).getFailure();
            this.sessionFuture.completeExceptionally(failure);
            Recreating recreating = new Recreating();
            Recreating.createSessionAsync(fsm, recreating.getSessionFuture());
            return recreating;
        }
        if (event instanceof CloseSessionEvent) {
            return new Closing();
        }
        return this;
    }
}

