/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.session.states;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaSession;
import org.eclipse.milo.opcua.sdk.client.session.Fsm;
import org.eclipse.milo.opcua.sdk.client.session.events.CloseSessionEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CreateSessionEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.Event;
import org.eclipse.milo.opcua.sdk.client.session.events.TransferFailureEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.TransferSuccessEvent;
import org.eclipse.milo.opcua.sdk.client.session.states.AbstractSessionState;
import org.eclipse.milo.opcua.sdk.client.session.states.Closing;
import org.eclipse.milo.opcua.sdk.client.session.states.Recreating;
import org.eclipse.milo.opcua.sdk.client.session.states.Reinitializing;
import org.eclipse.milo.opcua.sdk.client.session.states.SessionState;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;

public class Retransferring
extends AbstractSessionState
implements SessionState {
    private CompletableFuture<OpcUaSession> sessionFuture;

    @Override
    public CompletableFuture<OpcUaSession> getSessionFuture() {
        return this.sessionFuture;
    }

    @Override
    public void onExternalTransition(Fsm fsm, SessionState from, Event event) {
        this.sessionFuture = from.getSessionFuture();
    }

    @Override
    public void onInternalTransition(Fsm fsm, Event event) {
        if (event instanceof CreateSessionEvent) {
            CreateSessionEvent e = (CreateSessionEvent)event;
            FutureUtils.complete(e.getSessionFuture()).with(this.sessionFuture);
        }
    }

    @Override
    public SessionState execute(Fsm fsm, Event event) {
        if (event instanceof TransferSuccessEvent) {
            OpcUaSession session = ((TransferSuccessEvent)event).getSession();
            Retransferring.initializeSessionAsync(fsm, session, this.sessionFuture);
            return new Reinitializing();
        }
        if (event instanceof TransferFailureEvent) {
            Throwable failure = ((TransferFailureEvent)event).getFailure();
            this.sessionFuture.completeExceptionally(failure);
            Recreating recreating = new Recreating();
            Retransferring.createSessionAsync(fsm, recreating.getSessionFuture());
            return recreating;
        }
        if (event instanceof CloseSessionEvent) {
            return new Closing();
        }
        return this;
    }
}

