/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaExceptionStatus;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.application.UaStackServer;
import org.eclipse.milo.opcua.stack.core.application.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.core.application.services.ServiceResponse;
import org.eclipse.milo.opcua.stack.core.channel.ChannelSecurity;
import org.eclipse.milo.opcua.stack.core.channel.ChunkDecoder;
import org.eclipse.milo.opcua.stack.core.channel.ChunkEncoder;
import org.eclipse.milo.opcua.stack.core.channel.ExceptionHandler;
import org.eclipse.milo.opcua.stack.core.channel.MessageAbortedException;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.SerializationQueue;
import org.eclipse.milo.opcua.stack.core.channel.ServerSecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.headers.HeaderDecoder;
import org.eclipse.milo.opcua.stack.core.channel.messages.ErrorMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.MessageType;
import org.eclipse.milo.opcua.stack.core.serialization.UaMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceFault;
import org.eclipse.milo.opcua.stack.core.util.BufferUtil;
import org.eclipse.milo.opcua.stack.server.tcp.UaTcpStackServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaTcpServerSymmetricHandler
extends ByteToMessageCodec<ServiceResponse>
implements HeaderDecoder {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private List<ByteBuf> chunkBuffers;
    private final int maxChunkCount;
    private final int maxChunkSize;
    private final UaTcpStackServer server;
    private final SerializationQueue serializationQueue;
    private final ServerSecureChannel secureChannel;

    public UaTcpServerSymmetricHandler(UaTcpStackServer server, SerializationQueue serializationQueue, ServerSecureChannel secureChannel) {
        this.server = server;
        this.serializationQueue = serializationQueue;
        this.secureChannel = secureChannel;
        this.maxChunkCount = serializationQueue.getParameters().getLocalMaxChunkCount();
        this.maxChunkSize = serializationQueue.getParameters().getLocalReceiveBufferSize();
        this.chunkBuffers = new ArrayList<ByteBuf>(this.maxChunkCount);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (this.secureChannel != null) {
            this.secureChannel.attr(UaTcpStackServer.BoundChannelKey).set((Object)ctx.channel());
        }
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.secureChannel != null) {
            this.secureChannel.attr(UaTcpStackServer.BoundChannelKey).remove();
        }
        super.channelInactive(ctx);
    }

    protected void encode(final ChannelHandlerContext ctx, final ServiceResponse serviceResponse, ByteBuf out) throws Exception {
        this.serializationQueue.encode((binaryEncoder, chunkEncoder) -> {
            ByteBuf messageBuffer = BufferUtil.buffer();
            try {
                binaryEncoder.setBuffer(messageBuffer);
                binaryEncoder.writeMessage(null, (UaMessage)serviceResponse.getResponse());
                this.checkMessageSize(messageBuffer);
                chunkEncoder.encodeSymmetric((SecureChannel)this.secureChannel, serviceResponse.getRequestId(), messageBuffer, MessageType.SecureMessage, new ChunkEncoder.Callback(){

                    public void onEncodingError(UaException ex) {
                        UaTcpServerSymmetricHandler.this.logger.error("Error encoding {}: {}", new Object[]{serviceResponse, ex.getMessage(), ex});
                        UaTcpServerSymmetricHandler.this.sendServiceFault(ex.getStatusCode(), ctx, serviceResponse);
                    }

                    public void onMessageEncoded(List<ByteBuf> messageChunks, long requestId) {
                        CompositeByteBuf chunkComposite = BufferUtil.compositeBuffer();
                        for (ByteBuf chunk : messageChunks) {
                            chunkComposite.addComponent(chunk);
                            chunkComposite.writerIndex(chunkComposite.writerIndex() + chunk.readableBytes());
                        }
                        ctx.writeAndFlush((Object)chunkComposite, ctx.voidPromise());
                    }
                });
            }
            catch (UaSerializationException ex) {
                this.logger.error("Error encoding response: {}", (Object)ex.getStatusCode(), (Object)ex);
                this.sendServiceFault(ex.getStatusCode(), ctx, serviceResponse);
            }
            finally {
                messageBuffer.release();
            }
        });
    }

    private void sendServiceFault(StatusCode statusCode, ChannelHandlerContext ctx, ServiceResponse serviceResponse) {
        if (serviceResponse.isServiceFault()) {
            ctx.fireExceptionCaught((Throwable)new UaException(statusCode));
        } else {
            UInteger requestHandle = serviceResponse.getRequest().getRequestHeader().getRequestHandle();
            ServiceFault serviceFault = new ServiceFault(new ResponseHeader(DateTime.now(), requestHandle, statusCode, null, null, null));
            ServiceResponse newServiceResponse = new ServiceResponse(serviceResponse.getRequest(), serviceResponse.getRequestId(), serviceFault);
            ctx.writeAndFlush((Object)newServiceResponse);
        }
    }

    private void checkMessageSize(ByteBuf messageBuffer) throws UaSerializationException {
        int messageSize = messageBuffer.readableBytes();
        int remoteMaxMessageSize = this.serializationQueue.getParameters().getRemoteMaxMessageSize();
        if (remoteMaxMessageSize > 0 && messageSize > remoteMaxMessageSize) {
            throw new UaSerializationException(2159607808L, "response exceeds remote max message size: " + messageSize + " > " + remoteMaxMessageSize);
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        buffer = buffer.order(ByteOrder.LITTLE_ENDIAN);
        block3: while (buffer.readableBytes() >= 8 && buffer.readableBytes() >= this.getMessageLength(buffer)) {
            int messageLength = this.getMessageLength(buffer);
            MessageType messageType = MessageType.fromMediumInt((int)buffer.getMedium(buffer.readerIndex()));
            switch (messageType) {
                case SecureMessage: {
                    this.onSecureMessage(ctx, buffer.readSlice(messageLength), out);
                    continue block3;
                }
            }
            out.add(buffer.readSlice(messageLength).retain());
        }
    }

    private void onSecureMessage(final ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws UaException {
        buffer.skipBytes(3);
        char chunkType = (char)buffer.readByte();
        if (chunkType == 'A') {
            this.chunkBuffers.forEach(ReferenceCounted::release);
            this.chunkBuffers.clear();
        } else {
            buffer.skipBytes(4);
            long secureChannelId = buffer.readUnsignedInt();
            if (secureChannelId != this.secureChannel.getChannelId()) {
                throw new UaException(0x80220000L, "invalid secure channel id: " + secureChannelId);
            }
            int chunkSize = buffer.readerIndex(0).readableBytes();
            if (chunkSize > this.maxChunkSize) {
                throw new UaException(0x80800000L, String.format("max chunk size exceeded (%s)", this.maxChunkSize));
            }
            this.chunkBuffers.add(buffer.retain());
            if (this.maxChunkCount > 0 && this.chunkBuffers.size() > this.maxChunkCount) {
                throw new UaException(0x80800000L, String.format("max chunk count exceeded (%s)", this.maxChunkCount));
            }
            if (chunkType == 'F') {
                final List<ByteBuf> buffersToDecode = this.chunkBuffers;
                this.chunkBuffers = new ArrayList<ByteBuf>();
                this.serializationQueue.decode((binaryDecoder, chunkDecoder) -> {
                    try {
                        this.validateChunkHeaders(buffersToDecode);
                    }
                    catch (UaException e) {
                        this.logger.error("Error validating chunk headers: {}", (Object)e.getMessage(), (Object)e);
                        buffersToDecode.forEach(ReferenceCountUtil::safeRelease);
                        ctx.fireExceptionCaught((Throwable)e);
                        return;
                    }
                    chunkDecoder.decodeSymmetric((SecureChannel)this.secureChannel, buffersToDecode, new ChunkDecoder.Callback(){

                        public void onDecodingError(UaException ex) {
                            UaTcpServerSymmetricHandler.this.logger.error("Error decoding symmetric message: {}", (Object)ex.getMessage(), (Object)ex);
                            ctx.close();
                        }

                        public void onMessageAborted(MessageAbortedException ex) {
                            UaTcpServerSymmetricHandler.this.logger.warn("Received message abort chunk; error={}, reason={}", (Object)ex.getStatusCode(), (Object)ex.getMessage());
                        }

                        public void onMessageDecoded(ByteBuf message, long requestId) {
                            UaTcpServerSymmetricHandler.this.server.getExecutorService().execute(() -> {
                                try {
                                    UaRequestMessage request = (UaRequestMessage)binaryDecoder.setBuffer(message).readMessage(null);
                                    UaTcpServerSymmetricHandler.this.server.receiveRequest((ServiceRequest<UaRequestMessage, UaResponseMessage>)new ServiceRequest(request, requestId, (UaStackServer)UaTcpServerSymmetricHandler.this.server, UaTcpServerSymmetricHandler.this.secureChannel));
                                }
                                catch (Throwable t) {
                                    UaTcpServerSymmetricHandler.this.logger.error("Error decoding UaRequestMessage", t);
                                    StatusCode statusCode = UaExceptionStatus.extract((Throwable)t).map(UaExceptionStatus::getStatusCode).orElse(StatusCode.BAD);
                                    ServiceFault serviceFault = new ServiceFault(new ResponseHeader(DateTime.now(), Unsigned.uint((int)0), statusCode, null, null, null));
                                    ctx.writeAndFlush((Object)new ServiceResponse(null, requestId, serviceFault));
                                }
                                finally {
                                    message.release();
                                    buffersToDecode.clear();
                                }
                            });
                        }
                    });
                });
            }
        }
    }

    private void validateChunkHeaders(List<ByteBuf> chunkBuffers) throws UaException {
        ChannelSecurity channelSecurity = this.secureChannel.getChannelSecurity();
        long currentTokenId = channelSecurity.getCurrentToken().getTokenId().longValue();
        long previousTokenId = channelSecurity.getPreviousToken().map(t -> t.getTokenId().longValue()).orElse(-1L);
        for (ByteBuf chunkBuffer : chunkBuffers) {
            long tokenId = chunkBuffer.getUnsignedInt(12);
            if (tokenId == currentTokenId || tokenId == previousTokenId) continue;
            String message = String.format("received unknown secure channel token: tokenId=%s currentTokenId=%s previousTokenId=%s", tokenId, currentTokenId, previousTokenId);
            throw new UaException(0x80870000L, message);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.chunkBuffers.forEach(ReferenceCountUtil::safeRelease);
        this.chunkBuffers.clear();
        if (cause instanceof IOException) {
            ctx.close();
            this.logger.debug("[remote={}] IOException caught; channel closed");
        } else {
            ErrorMessage errorMessage = ExceptionHandler.sendErrorMessage((ChannelHandlerContext)ctx, (Throwable)cause);
            if (cause instanceof UaException) {
                this.logger.debug("[remote={}] UaException caught; sent {}", new Object[]{ctx.channel().remoteAddress(), errorMessage, cause});
            } else {
                this.logger.error("[remote={}] Exception caught; sent {}", new Object[]{ctx.channel().remoteAddress(), errorMessage, cause});
            }
        }
    }
}

