/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;

public class IntersectIteration<E, X extends Exception>
extends FilterIteration<E, X> {
    protected final Iteration<? extends E, ? extends X> arg2;
    private final boolean distinct;
    private boolean initialized;
    private Set<E> includeSet;

    public IntersectIteration(Iteration<? extends E, ? extends X> arg1, Iteration<? extends E, ? extends X> arg2) {
        this(arg1, arg2, false);
    }

    public IntersectIteration(Iteration<? extends E, ? extends X> arg1, Iteration<? extends E, ? extends X> arg2, boolean distinct) {
        super(arg1);
        assert (arg2 != null);
        this.arg2 = arg2;
        this.distinct = distinct;
        this.initialized = false;
    }

    @Override
    protected boolean accept(E object) throws X {
        if (!this.initialized) {
            this.includeSet = this.addSecondSet(this.arg2, this.makeSet());
            this.initialized = true;
        }
        if (this.inIncludeSet(object)) {
            if (this.distinct) {
                this.removeFromIncludeSet(object);
            }
            return true;
        }
        return false;
    }

    public Set<E> addSecondSet(Iteration<? extends E, ? extends X> arg2, Set<E> set) throws X {
        return Iterations.addAll(arg2, this.makeSet());
    }

    protected boolean removeFromIncludeSet(E object) {
        return this.includeSet.remove(object);
    }

    protected boolean inIncludeSet(E object) {
        return this.includeSet.contains(object);
    }

    protected Set<E> makeSet() {
        return new HashSet();
    }

    @Override
    protected void handleClose() throws X {
        super.handleClose();
        Iterations.closeCloseable(this.arg2);
    }

    protected long clearIncludeSet() {
        long size = this.includeSet.size();
        this.includeSet.clear();
        return size;
    }
}

