/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.engine;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.pom.PomFile;
import org.eclipse.tycho.versions.pom.Profile;

@Component(role=ProjectMetadataReader.class, instantiationStrategy="per-lookup")
public class ProjectMetadataReader {
    private static final String PACKAGING_POM = "pom";
    @Requirement
    private Logger log;
    private Map<File, ProjectMetadata> projects = new LinkedHashMap<File, ProjectMetadata>();

    public void addBasedir(File basedir) throws IOException {
        if (!basedir.exists()) {
            this.log.info("Project does not exist at " + basedir);
            return;
        }
        if (basedir.isFile()) {
            if (!"pom.xml".equals(basedir.getName())) {
                this.log.info("Custom pom.xml file name is not supported at " + basedir);
                return;
            }
            basedir = basedir.getParentFile();
        }
        if (this.projects.containsKey(basedir)) {
            return;
        }
        ProjectMetadata project = new ProjectMetadata(basedir);
        this.projects.put(basedir, project);
        File pomFile = new File(basedir, "pom.xml");
        if (!pomFile.exists()) {
            pomFile = new File(basedir, ".polyglot.build.properties");
        }
        if (!pomFile.exists()) {
            this.log.info("No pom file found at " + basedir);
            return;
        }
        PomFile pom = PomFile.read(pomFile, "pom.xml".equals(pomFile.getName()));
        project.putMetadata(pom);
        String packaging = pom.getPackaging();
        if (PACKAGING_POM.equals(packaging)) {
            for (File child : this.getChildren(basedir, pom)) {
                this.addBasedir(child);
            }
        }
    }

    private Set<File> getChildren(File basedir, PomFile project) throws IOException {
        LinkedHashSet<File> children = new LinkedHashSet<File>();
        for (String module : project.getModules()) {
            children.add(this.canonify(new File(basedir, module)));
        }
        for (Profile profile : project.getProfiles()) {
            for (String module : profile.getModules()) {
                children.add(this.canonify(new File(basedir, module)));
            }
        }
        return children;
    }

    public Collection<ProjectMetadata> getProjects() {
        return this.projects.values();
    }

    private File canonify(File file) {
        return new File(file.toURI().normalize());
    }
}

