/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import org.ejml.UtilEjml;
import org.ejml.alg.dense.mult.VectorVectorMult;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.MatrixIterator64F;
import org.ejml.data.RealMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.SingularMatrixException;
import org.ejml.ops.CommonOps;
import org.ejml.ops.MatrixFeatures;
import org.ejml.ops.MatrixIO;
import org.ejml.ops.NormOps;
import org.ejml.ops.SpecializedOps;
import org.ejml.simple.SimpleEVD;
import org.ejml.simple.SimpleMatrix;
import org.ejml.simple.SimpleSVD;

public abstract class SimpleBase<T extends SimpleBase>
implements Serializable {
    protected DenseMatrix64F mat;

    public SimpleBase(int numRows, int numCols) {
        this.mat = new DenseMatrix64F(numRows, numCols);
    }

    protected SimpleBase() {
    }

    protected abstract T createMatrix(int var1, int var2);

    public DenseMatrix64F getMatrix() {
        return this.mat;
    }

    public T transpose() {
        T ret = this.createMatrix(this.mat.numCols, this.mat.numRows);
        CommonOps.transpose((DenseMatrix64F)this.mat, (DenseMatrix64F)((SimpleBase)ret).getMatrix());
        return ret;
    }

    public T mult(T b) {
        T ret = this.createMatrix(this.mat.numRows, ((SimpleBase)b).getMatrix().numCols);
        CommonOps.mult((RowD1Matrix64F)this.mat, (RowD1Matrix64F)((SimpleBase)b).getMatrix(), (RowD1Matrix64F)((SimpleBase)ret).getMatrix());
        return ret;
    }

    public T kron(T B) {
        T ret = this.createMatrix(this.mat.numRows * ((SimpleBase)B).numRows(), this.mat.numCols * ((SimpleBase)B).numCols());
        CommonOps.kron((DenseMatrix64F)this.mat, (DenseMatrix64F)((SimpleBase)B).getMatrix(), (DenseMatrix64F)((SimpleBase)ret).getMatrix());
        return ret;
    }

    public T plus(T b) {
        T ret = this.copy();
        CommonOps.addEquals((D1Matrix64F)((SimpleBase)ret).getMatrix(), (D1Matrix64F)((SimpleBase)b).getMatrix());
        return ret;
    }

    public T minus(T b) {
        T ret = this.copy();
        CommonOps.subtract((D1Matrix64F)this.getMatrix(), (D1Matrix64F)((SimpleBase)b).getMatrix(), (D1Matrix64F)((SimpleBase)ret).getMatrix());
        return ret;
    }

    public T minus(double b) {
        T ret = this.copy();
        CommonOps.subtract((D1Matrix64F)this.getMatrix(), (double)b, (D1Matrix64F)((SimpleBase)ret).getMatrix());
        return ret;
    }

    public T plus(double b) {
        T ret = this.createMatrix(this.numRows(), this.numCols());
        CommonOps.add((D1Matrix64F)this.getMatrix(), (double)b, (D1Matrix64F)((SimpleBase)ret).getMatrix());
        return ret;
    }

    public T plus(double beta, T b) {
        T ret = this.copy();
        CommonOps.addEquals((D1Matrix64F)((SimpleBase)ret).getMatrix(), (double)beta, (D1Matrix64F)((SimpleBase)b).getMatrix());
        return ret;
    }

    public double dot(T v) {
        if (!this.isVector()) {
            throw new IllegalArgumentException("'this' matrix is not a vector.");
        }
        if (!((SimpleBase)v).isVector()) {
            throw new IllegalArgumentException("'v' matrix is not a vector.");
        }
        return VectorVectorMult.innerProd((D1Matrix64F)this.mat, (D1Matrix64F)((SimpleBase)v).getMatrix());
    }

    public boolean isVector() {
        return this.mat.numRows == 1 || this.mat.numCols == 1;
    }

    public T scale(double val) {
        T ret = this.copy();
        CommonOps.scale((double)val, (D1Matrix64F)((SimpleBase)ret).getMatrix());
        return ret;
    }

    public T divide(double val) {
        T ret = this.copy();
        CommonOps.divide((D1Matrix64F)((SimpleBase)ret).getMatrix(), (double)val);
        return ret;
    }

    public T invert() {
        T ret = this.createMatrix(this.mat.numRows, this.mat.numCols);
        if (!CommonOps.invert((DenseMatrix64F)this.mat, (DenseMatrix64F)((SimpleBase)ret).getMatrix())) {
            throw new SingularMatrixException();
        }
        if (MatrixFeatures.hasUncountable((D1Matrix64F)((SimpleBase)ret).getMatrix())) {
            throw new SingularMatrixException("Solution has uncountable numbers");
        }
        return ret;
    }

    public T pseudoInverse() {
        T ret = this.createMatrix(this.mat.numCols, this.mat.numRows);
        CommonOps.pinv((DenseMatrix64F)this.mat, (DenseMatrix64F)((SimpleBase)ret).getMatrix());
        return ret;
    }

    public T solve(T b) {
        T x = this.createMatrix(this.mat.numCols, ((SimpleBase)b).getMatrix().numCols);
        if (!CommonOps.solve((DenseMatrix64F)this.mat, (DenseMatrix64F)((SimpleBase)b).getMatrix(), (DenseMatrix64F)((SimpleBase)x).getMatrix())) {
            throw new SingularMatrixException();
        }
        if (MatrixFeatures.hasUncountable((D1Matrix64F)((SimpleBase)x).getMatrix())) {
            throw new SingularMatrixException("Solution contains uncountable numbers");
        }
        return x;
    }

    public void set(T a) {
        this.mat.set((D1Matrix64F)((SimpleBase)a).getMatrix());
    }

    public void set(double val) {
        CommonOps.fill((D1Matrix64F)this.mat, (double)val);
    }

    public void zero() {
        this.mat.zero();
    }

    public double normF() {
        return NormOps.normF((D1Matrix64F)this.mat);
    }

    public double conditionP2() {
        return NormOps.conditionP2((DenseMatrix64F)this.mat);
    }

    public double determinant() {
        double ret = CommonOps.det((DenseMatrix64F)this.mat);
        if (UtilEjml.isUncountable((double)ret)) {
            return 0.0;
        }
        return ret;
    }

    public double trace() {
        return CommonOps.trace((RowD1Matrix64F)this.mat);
    }

    public void reshape(int numRows, int numCols) {
        this.mat.reshape(numRows, numCols, false);
    }

    public void set(int row, int col, double value) {
        this.mat.set(row, col, value);
    }

    public void set(int index, double value) {
        this.mat.set(index, value);
    }

    public void setRow(int row, int offset, double ... values) {
        for (int i = 0; i < values.length; ++i) {
            this.mat.set(row, offset + i, values[i]);
        }
    }

    public void setColumn(int column, int offset, double ... values) {
        for (int i = 0; i < values.length; ++i) {
            this.mat.set(offset + i, column, values[i]);
        }
    }

    public double get(int row, int col) {
        return this.mat.get(row, col);
    }

    public double get(int index) {
        return this.mat.data[index];
    }

    public int getIndex(int row, int col) {
        return row * this.mat.numCols + col;
    }

    public MatrixIterator64F iterator(boolean rowMajor, int minRow, int minCol, int maxRow, int maxCol) {
        return new MatrixIterator64F((D1Matrix64F)this.mat, rowMajor, minRow, minCol, maxRow, maxCol);
    }

    public T copy() {
        T ret = this.createMatrix(this.mat.numRows, this.mat.numCols);
        ((SimpleBase)ret).getMatrix().set((D1Matrix64F)this.getMatrix());
        return ret;
    }

    public int numRows() {
        return this.mat.numRows;
    }

    public int numCols() {
        return this.mat.numCols;
    }

    public int getNumElements() {
        return this.mat.getNumElements();
    }

    public void print() {
        MatrixIO.print((PrintStream)System.out, (RealMatrix64F)this.mat);
    }

    public void print(int numChar, int precision) {
        MatrixIO.print((PrintStream)System.out, (RealMatrix64F)this.mat, (int)numChar, (int)precision);
    }

    public void print(String format) {
        MatrixIO.print((PrintStream)System.out, (RealMatrix64F)this.mat, (String)format);
    }

    public String toString() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        MatrixIO.print((PrintStream)new PrintStream(stream), (RealMatrix64F)this.mat);
        return stream.toString();
    }

    public T extractMatrix(int y0, int y1, int x0, int x1) {
        if (y0 == Integer.MAX_VALUE) {
            y0 = this.mat.numRows;
        }
        if (y1 == Integer.MAX_VALUE) {
            y1 = this.mat.numRows;
        }
        if (x0 == Integer.MAX_VALUE) {
            x0 = this.mat.numCols;
        }
        if (x1 == Integer.MAX_VALUE) {
            x1 = this.mat.numCols;
        }
        T ret = this.createMatrix(y1 - y0, x1 - x0);
        CommonOps.extract((RealMatrix64F)this.mat, (int)y0, (int)y1, (int)x0, (int)x1, (RealMatrix64F)((SimpleBase)ret).getMatrix(), (int)0, (int)0);
        return ret;
    }

    public T extractVector(boolean extractRow, int element) {
        T ret;
        int length = extractRow ? this.mat.numCols : this.mat.numRows;
        T t = ret = extractRow ? this.createMatrix(1, length) : this.createMatrix(length, 1);
        if (extractRow) {
            SpecializedOps.subvector((RowD1Matrix64F)this.mat, (int)element, (int)0, (int)length, (boolean)true, (int)0, (RowD1Matrix64F)((SimpleBase)ret).getMatrix());
        } else {
            SpecializedOps.subvector((RowD1Matrix64F)this.mat, (int)0, (int)element, (int)length, (boolean)false, (int)0, (RowD1Matrix64F)((SimpleBase)ret).getMatrix());
        }
        return ret;
    }

    public T extractDiag() {
        int N = Math.min(this.mat.numCols, this.mat.numRows);
        T diag = this.createMatrix(N, 1);
        CommonOps.extractDiag((DenseMatrix64F)this.mat, (DenseMatrix64F)((SimpleBase)diag).getMatrix());
        return diag;
    }

    public boolean isIdentical(T a, double tol) {
        return MatrixFeatures.isIdentical((D1Matrix64F)this.mat, (D1Matrix64F)((SimpleBase)a).getMatrix(), (double)tol);
    }

    public boolean hasUncountable() {
        return MatrixFeatures.hasUncountable((D1Matrix64F)this.mat);
    }

    public SimpleSVD svd() {
        return new SimpleSVD(this.mat, false);
    }

    public SimpleSVD svd(boolean compact) {
        return new SimpleSVD(this.mat, compact);
    }

    public SimpleEVD eig() {
        return new SimpleEVD(this.mat);
    }

    public void insertIntoThis(int insertRow, int insertCol, T B) {
        CommonOps.insert((RealMatrix64F)((SimpleBase)B).getMatrix(), (RealMatrix64F)this.mat, (int)insertRow, (int)insertCol);
    }

    public T combine(int insertRow, int insertCol, T B) {
        SimpleBase<T> ret;
        if (insertRow == Integer.MAX_VALUE) {
            insertRow = this.mat.numRows;
        }
        if (insertCol == Integer.MAX_VALUE) {
            insertCol = this.mat.numCols;
        }
        int maxRow = insertRow + ((SimpleBase)B).numRows();
        int maxCol = insertCol + ((SimpleBase)B).numCols();
        if (maxRow > this.mat.numRows || maxCol > this.mat.numCols) {
            int M = Math.max(maxRow, this.mat.numRows);
            int N = Math.max(maxCol, this.mat.numCols);
            ret = this.createMatrix(M, N);
            ret.insertIntoThis(0, 0, (SimpleBase)this);
        } else {
            ret = this.copy();
        }
        ret.insertIntoThis(insertRow, insertCol, B);
        return (T)ret;
    }

    public double elementMaxAbs() {
        return CommonOps.elementMaxAbs((D1Matrix64F)this.mat);
    }

    public double elementSum() {
        return CommonOps.elementSum((D1Matrix64F)this.mat);
    }

    public T elementMult(T b) {
        T c = this.createMatrix(this.mat.numRows, this.mat.numCols);
        CommonOps.elementMult((D1Matrix64F)this.mat, (D1Matrix64F)((SimpleBase)b).getMatrix(), (D1Matrix64F)((SimpleBase)c).getMatrix());
        return c;
    }

    public T elementDiv(T b) {
        T c = this.createMatrix(this.mat.numRows, this.mat.numCols);
        CommonOps.elementDiv((D1Matrix64F)this.mat, (D1Matrix64F)((SimpleBase)b).getMatrix(), (D1Matrix64F)((SimpleBase)c).getMatrix());
        return c;
    }

    public T elementPower(T b) {
        T c = this.createMatrix(this.mat.numRows, this.mat.numCols);
        CommonOps.elementPower((D1Matrix64F)this.mat, (D1Matrix64F)((SimpleBase)b).getMatrix(), (D1Matrix64F)((SimpleBase)c).getMatrix());
        return c;
    }

    public T elementPower(double b) {
        T c = this.createMatrix(this.mat.numRows, this.mat.numCols);
        CommonOps.elementPower((D1Matrix64F)this.mat, (double)b, (D1Matrix64F)((SimpleBase)c).getMatrix());
        return c;
    }

    public T elementExp() {
        T c = this.createMatrix(this.mat.numRows, this.mat.numCols);
        CommonOps.elementExp((D1Matrix64F)this.mat, (D1Matrix64F)((SimpleBase)c).getMatrix());
        return c;
    }

    public T elementLog() {
        T c = this.createMatrix(this.mat.numRows, this.mat.numCols);
        CommonOps.elementLog((D1Matrix64F)this.mat, (D1Matrix64F)((SimpleBase)c).getMatrix());
        return c;
    }

    public T negative() {
        T A = this.copy();
        CommonOps.changeSign((D1Matrix64F)((SimpleBase)A).getMatrix());
        return A;
    }

    public void saveToFileBinary(String fileName) throws IOException {
        MatrixIO.saveBin((RealMatrix64F)this.mat, (String)fileName);
    }

    public static SimpleMatrix loadBinary(String fileName) throws IOException {
        RealMatrix64F mat = MatrixIO.loadBin((String)fileName);
        if (mat instanceof DenseMatrix64F) {
            return SimpleMatrix.wrap((DenseMatrix64F)mat);
        }
        return SimpleMatrix.wrap(new DenseMatrix64F(mat));
    }

    public void saveToFileCSV(String fileName) throws IOException {
        MatrixIO.saveCSV((RealMatrix64F)this.mat, (String)fileName);
    }

    public T loadCSV(String fileName) throws IOException {
        DenseMatrix64F mat = MatrixIO.loadCSV((String)fileName);
        T ret = this.createMatrix(1, 1);
        ((SimpleBase)ret).mat = mat instanceof DenseMatrix64F ? mat : new DenseMatrix64F((RealMatrix64F)mat);
        return ret;
    }

    public boolean isInBounds(int row, int col) {
        return row >= 0 && col >= 0 && row < this.mat.numRows && col < this.mat.numCols;
    }

    public void printDimensions() {
        System.out.println("[rows = " + this.numRows() + " , cols = " + this.numCols() + " ]");
    }
}

