/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.mapper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.join.mapper.ParentJoinFieldMapper;
import org.elasticsearch.join.mapper.Relations;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public final class Joiner {
    private final Map<String, Set<String>> parentsToChildren = new HashMap<String, Set<String>>();
    private final Map<String, String> childrenToParents = new HashMap<String, String>();
    private final String joinField;

    public static Joiner getJoiner(SearchExecutionContext context) {
        return Joiner.getJoiner(context.getMatchingFieldNames("*").stream().map(arg_0 -> ((SearchExecutionContext)context).getFieldType(arg_0)));
    }

    public static Joiner getJoiner(AggregationContext context) {
        return Joiner.getJoiner(context.getMatchingFieldNames("*").stream().map(arg_0 -> ((AggregationContext)context).getFieldType(arg_0)));
    }

    static Joiner getJoiner(Stream<MappedFieldType> fieldTypes) {
        Optional<ParentJoinFieldMapper.JoinFieldType> joinType = fieldTypes.filter((? super T ft) -> ft instanceof ParentJoinFieldMapper.JoinFieldType).map(ft -> (ParentJoinFieldMapper.JoinFieldType)((Object)ft)).findFirst();
        return joinType.map(ParentJoinFieldMapper.JoinFieldType::getJoiner).orElse(null);
    }

    Joiner(String joinField, List<Relations> relations) {
        this.joinField = joinField;
        for (Relations r : relations) {
            for (String child : r.children) {
                this.parentsToChildren.put(r.parent, r.children);
                if (this.childrenToParents.containsKey(child)) {
                    throw new IllegalArgumentException("[" + child + "] cannot have multiple parents");
                }
                this.childrenToParents.put(child, r.parent);
            }
        }
    }

    public String getJoinField() {
        return this.joinField;
    }

    public Query filter(String relationType) {
        return new TermQuery(new Term(this.joinField, relationType));
    }

    public Query parentFilter(String childType) {
        return new TermQuery(new Term(this.joinField, this.childrenToParents.get(childType)));
    }

    public Query childrenFilter(String parentType) {
        assert (this.parentTypeExists(parentType));
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (String child : this.parentsToChildren.get(parentType)) {
            builder.add(this.filter(child), BooleanClause.Occur.SHOULD);
        }
        return new ConstantScoreQuery((Query)builder.build());
    }

    public boolean childTypeExists(String type) {
        return this.childrenToParents.containsKey(type);
    }

    public boolean parentTypeExists(String type) {
        return this.parentsToChildren.containsKey(type);
    }

    public boolean knownRelation(String type) {
        return this.childTypeExists(type) || this.parentTypeExists(type);
    }

    public String parentJoinField(String childType) {
        return this.joinField + "#" + this.childrenToParents.get(childType);
    }

    public String childJoinField(String parentType) {
        return this.joinField + "#" + parentType;
    }

    boolean canMerge(Joiner other, Consumer<String> conflicts) {
        boolean conflicted = false;
        for (String parent : this.parentsToChildren.keySet()) {
            if (other.parentsToChildren.containsKey(parent)) continue;
            conflicts.accept("Cannot remove parent [" + parent + "]");
            conflicted = true;
        }
        for (String child : this.childrenToParents.keySet()) {
            if (other.childrenToParents.containsKey(child)) continue;
            conflicts.accept("Cannot remove child [" + child + "]");
            conflicted = true;
        }
        for (String newParent : other.parentsToChildren.keySet()) {
            if (!this.childrenToParents.containsKey(newParent) || this.parentsToChildren.containsKey(newParent)) continue;
            conflicts.accept("Cannot create parent [" + newParent + "] from an existing child");
            conflicted = true;
        }
        for (String newChild : other.childrenToParents.keySet()) {
            if (this.childrenToParents.containsKey(newChild) && !Objects.equals(other.childrenToParents.get(newChild), this.childrenToParents.get(newChild))) {
                conflicts.accept("Cannot change parent of [" + newChild + "]");
                conflicted = true;
            }
            if (!this.parentsToChildren.containsKey(newChild) || Objects.equals(this.childrenToParents.get(newChild), other.childrenToParents.get(newChild))) continue;
            conflicts.accept("Cannot create child [" + newChild + "] from an existing root");
            conflicted = true;
        }
        return !conflicted;
    }
}

