/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.ssl.PemReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.io.pem.PemObject;

final class SMPemTool {
    SMPemTool() {
    }

    public static X509Certificate[] toX509Certificates(File pem) throws CertificateException, IOException {
        try (FileInputStream in = new FileInputStream(pem);){
            X509Certificate[] x509CertificateArray = SMPemTool.toX509Certificates(in);
            return x509CertificateArray;
        }
    }

    public static X509Certificate[] toX509Certificates(InputStream in) throws CertificateException {
        ByteBuf[] byteBufs = PemReader.readCertificates((InputStream)in);
        ArrayList<X509Certificate> x509Certificates = new ArrayList<X509Certificate>();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", (Provider)new BouncyCastleProvider());
        for (ByteBuf byteBuf : byteBufs) {
            x509Certificates.add((X509Certificate)certificateFactory.generateCertificate((InputStream)new ByteBufInputStream(byteBuf)));
        }
        return x509Certificates.toArray(new X509Certificate[0]);
    }

    public static PrivateKey toPrivateKey(File pem) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        try (FileInputStream in = new FileInputStream(pem);){
            PrivateKey privateKey = SMPemTool.toPrivateKey(in);
            return privateKey;
        }
    }

    public static PrivateKey toPrivateKey(InputStream in) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        org.bouncycastle.util.io.pem.PemReader pemReader = new org.bouncycastle.util.io.pem.PemReader((Reader)new InputStreamReader(in));
        PemObject pem = pemReader.readPemObject();
        if (pem == null) {
            throw new IOException("The file does not represent a pem account.");
        }
        pemReader.close();
        PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(pem.getContent());
        KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
        return keyFactory.generatePrivate(encodedKeySpec);
    }

    static {
        Security.setProperty("crypto.policy", "unlimited");
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

