/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.SMPemTool;
import io.netty.handler.ssl.SMSslClientContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMSslClientContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(SMSslClientContextFactory.class);

    public static SMSslClientContext build(String caCert, String encryptNodeCert, String encryptNodeKey, String nodeCert, String nodeKey) throws IOException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        return SMSslClientContextFactory.build(new File(caCert), new File(encryptNodeCert), new File(encryptNodeKey), new File(nodeCert), new File(nodeKey));
    }

    public static SMSslClientContext build(File caCert, File encryptNodeCert, File encryptNodeKey, File nodeCert, File nodeKey) throws IOException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        logger.info("caCert: {}, encryptNodeCert: {}, encryptNodeKey: {}, nodeCert: {}, nodeKey: {}", new Object[]{caCert, encryptNodeCert, encryptNodeKey, nodeCert, nodeKey});
        X509Certificate[] caX509Certificates = SMPemTool.toX509Certificates(caCert);
        X509Certificate[] encryptNodeX509Certificates = SMPemTool.toX509Certificates(encryptNodeCert);
        PrivateKey encryptNodePrivateKey = SMPemTool.toPrivateKey(encryptNodeKey);
        X509Certificate[] nodeX509Certificates = SMPemTool.toX509Certificates(nodeCert);
        PrivateKey nodePrivateKey = SMPemTool.toPrivateKey(nodeKey);
        return new SMSslClientContext(caX509Certificates, encryptNodeX509Certificates, encryptNodePrivateKey, nodeX509Certificates, nodePrivateKey);
    }

    public static SMSslClientContext build(InputStream caCert, InputStream encryptNodeCert, InputStream encryptNodeKey, InputStream nodeCert, InputStream nodeKey) throws IOException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        logger.info("caCert: {}, encryptNodeCert: {}, encryptNodeKey: {}, nodeCert: {}, nodeKey: {}", new Object[]{caCert, encryptNodeCert, encryptNodeKey, nodeCert, nodeKey});
        X509Certificate[] caX509Certificates = SMPemTool.toX509Certificates(caCert);
        X509Certificate[] encryptNodeX509Certificates = SMPemTool.toX509Certificates(encryptNodeCert);
        PrivateKey encryptNodePrivateKey = SMPemTool.toPrivateKey(encryptNodeKey);
        X509Certificate[] nodeX509Certificates = SMPemTool.toX509Certificates(nodeCert);
        PrivateKey nodePrivateKey = SMPemTool.toPrivateKey(nodeKey);
        return new SMSslClientContext(caX509Certificates, encryptNodeX509Certificates, encryptNodePrivateKey, nodeX509Certificates, nodePrivateKey);
    }
}

