/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.db;

import org.flowable.app.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.db.EngineDatabaseConfiguration;
import org.flowable.common.engine.impl.db.LiquibaseBasedSchemaManager;
import org.flowable.common.engine.impl.db.LiquibaseDatabaseConfiguration;
import org.flowable.common.engine.impl.db.SchemaManager;

public class AppDbSchemaManager
extends LiquibaseBasedSchemaManager {
    public static final String LIQUIBASE_CHANGELOG = "org/flowable/app/db/liquibase/flowable-app-db-changelog.xml";

    public AppDbSchemaManager() {
        super("app", LIQUIBASE_CHANGELOG, "ACT_APP_");
    }

    protected LiquibaseDatabaseConfiguration getDatabaseConfiguration() {
        return new EngineDatabaseConfiguration((AbstractEngineConfiguration)CommandContextUtil.getAppEngineConfiguration());
    }

    public void initSchema() {
        this.initSchema(CommandContextUtil.getAppEngineConfiguration().getDatabaseSchemaUpdate());
    }

    public void schemaCreate() {
        try {
            this.getCommonSchemaManager().schemaCreate();
            this.getIdentityLinkSchemaManager().schemaCreate();
            this.getVariableSchemaManager().schemaCreate();
            super.schemaCreate();
        }
        catch (Exception e) {
            throw new FlowableException("Error creating App engine tables", (Throwable)e);
        }
    }

    public void schemaDrop() {
        try {
            super.schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping App engine tables", (Throwable)e);
        }
        try {
            this.getVariableSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping variable tables", (Throwable)e);
        }
        try {
            this.getIdentityLinkSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping identity link tables", (Throwable)e);
        }
        try {
            this.getCommonSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping common tables", (Throwable)e);
        }
    }

    public String schemaUpdate() {
        try {
            this.getCommonSchemaManager().schemaUpdate();
            if (CommandContextUtil.getAppEngineConfiguration().isExecuteServiceSchemaManagers()) {
                this.getIdentityLinkSchemaManager().schemaUpdate();
                this.getVariableSchemaManager().schemaUpdate();
            }
            super.schemaUpdate();
        }
        catch (Exception e) {
            throw new FlowableException("Error updating App engine tables", (Throwable)e);
        }
        return null;
    }

    public void schemaCheckEngine() {
    }

    protected SchemaManager getCommonSchemaManager() {
        return CommandContextUtil.getAppEngineConfiguration().getCommonSchemaManager();
    }

    protected SchemaManager getIdentityLinkSchemaManager() {
        return CommandContextUtil.getAppEngineConfiguration().getIdentityLinkSchemaManager();
    }

    protected SchemaManager getVariableSchemaManager() {
        return CommandContextUtil.getAppEngineConfiguration().getVariableSchemaManager();
    }
}

