/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.batch.service.impl.persistence.entity;

import org.flowable.batch.service.BatchServiceConfiguration;
import org.flowable.batch.service.event.impl.FlowableBatchEventBuilder;
import org.flowable.batch.service.impl.persistence.AbstractManager;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.persistence.entity.EntityManager;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;

public abstract class AbstractEntityManager<EntityImpl extends Entity>
extends AbstractManager
implements EntityManager<EntityImpl> {
    public AbstractEntityManager(BatchServiceConfiguration variableServiceConfiguration) {
        super(variableServiceConfiguration);
    }

    public EntityImpl findById(String entityId) {
        return (EntityImpl)this.getDataManager().findById(entityId);
    }

    public EntityImpl create() {
        return (EntityImpl)this.getDataManager().create();
    }

    public void insert(EntityImpl entity) {
        this.insert(entity, true);
    }

    public void insert(EntityImpl entity, boolean fireCreateEvent) {
        this.getDataManager().insert(entity);
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (fireCreateEvent && eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableBatchEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_CREATED, entity));
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableBatchEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_INITIALIZED, entity));
        }
    }

    public EntityImpl update(EntityImpl entity) {
        return this.update(entity, true);
    }

    public EntityImpl update(EntityImpl entity, boolean fireUpdateEvent) {
        Entity updatedEntity = this.getDataManager().update(entity);
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (fireUpdateEvent && eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableBatchEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_UPDATED, entity));
        }
        return (EntityImpl)updatedEntity;
    }

    public void delete(String id) {
        EntityImpl entity = this.findById(id);
        this.delete(entity);
    }

    public void delete(EntityImpl entity) {
        this.delete(entity, true);
    }

    public void delete(EntityImpl entity, boolean fireDeleteEvent) {
        this.getDataManager().delete(entity);
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (fireDeleteEvent && eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableBatchEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, entity));
        }
    }

    protected abstract DataManager<EntityImpl> getDataManager();
}

