/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.batch.service.impl.persistence.entity;

import java.util.List;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.service.BatchServiceConfiguration;
import org.flowable.batch.service.impl.persistence.entity.AbstractEntityManager;
import org.flowable.batch.service.impl.persistence.entity.BatchByteArrayRef;
import org.flowable.batch.service.impl.persistence.entity.BatchEntity;
import org.flowable.batch.service.impl.persistence.entity.BatchPartEntity;
import org.flowable.batch.service.impl.persistence.entity.BatchPartEntityManager;
import org.flowable.batch.service.impl.persistence.entity.data.BatchPartDataManager;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;

public class BatchPartEntityManagerImpl
extends AbstractEntityManager<BatchPartEntity>
implements BatchPartEntityManager {
    protected BatchPartDataManager batchPartDataManager;

    public BatchPartEntityManagerImpl(BatchServiceConfiguration batchServiceConfiguration, BatchPartDataManager batchPartDataManager) {
        super(batchServiceConfiguration);
        this.batchPartDataManager = batchPartDataManager;
    }

    @Override
    protected DataManager<BatchPartEntity> getDataManager() {
        return this.batchPartDataManager;
    }

    @Override
    public List<BatchPart> findBatchPartsByBatchId(String batchId) {
        return this.batchPartDataManager.findBatchPartsByBatchId(batchId);
    }

    @Override
    public List<BatchPart> findBatchPartsByBatchIdAndStatus(String batchId, String status) {
        return this.batchPartDataManager.findBatchPartsByBatchIdAndStatus(batchId, status);
    }

    @Override
    public List<BatchPart> findBatchPartsByScopeIdAndType(String scopeId, String scopeType) {
        return this.batchPartDataManager.findBatchPartsByScopeIdAndType(scopeId, scopeType);
    }

    @Override
    public BatchPartEntity createBatchPart(BatchEntity parentBatch, String status, String scopeId, String subScopeId, String scopeType) {
        BatchPartEntity batchPartEntity = (BatchPartEntity)this.batchPartDataManager.create();
        batchPartEntity.setBatchId(parentBatch.getId());
        batchPartEntity.setBatchType(parentBatch.getBatchType());
        batchPartEntity.setScopeId(scopeId);
        batchPartEntity.setSubScopeId(subScopeId);
        batchPartEntity.setScopeType(scopeType);
        batchPartEntity.setBatchSearchKey(parentBatch.getBatchSearchKey());
        batchPartEntity.setBatchSearchKey2(parentBatch.getBatchSearchKey2());
        batchPartEntity.setStatus(status);
        batchPartEntity.setCreateTime(this.getClock().getCurrentTime());
        this.insert(batchPartEntity);
        return batchPartEntity;
    }

    @Override
    public BatchPartEntity completeBatchPart(String batchPartId, String status, String resultJson) {
        BatchPartEntity batchPartEntity = (BatchPartEntity)this.getBatchPartEntityManager().findById(batchPartId);
        batchPartEntity.setCompleteTime(this.getClock().getCurrentTime());
        batchPartEntity.setStatus(status);
        batchPartEntity.setResultDocumentJson(resultJson);
        return batchPartEntity;
    }

    @Override
    public void deleteBatchPartEntityAndResources(BatchPartEntity batchPartEntity) {
        BatchByteArrayRef resultDocRefId = batchPartEntity.getResultDocRefId();
        if (resultDocRefId != null && resultDocRefId.getId() != null) {
            resultDocRefId.delete();
        }
        this.delete(batchPartEntity);
    }
}

