/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.batch.service.impl.persistence.entity;

import java.util.List;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchBuilder;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.service.BatchServiceConfiguration;
import org.flowable.batch.service.impl.BatchQueryImpl;
import org.flowable.batch.service.impl.persistence.entity.AbstractEntityManager;
import org.flowable.batch.service.impl.persistence.entity.BatchByteArrayRef;
import org.flowable.batch.service.impl.persistence.entity.BatchEntity;
import org.flowable.batch.service.impl.persistence.entity.BatchEntityImpl;
import org.flowable.batch.service.impl.persistence.entity.BatchEntityManager;
import org.flowable.batch.service.impl.persistence.entity.BatchPartEntity;
import org.flowable.batch.service.impl.persistence.entity.data.BatchDataManager;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;

public class BatchEntityManagerImpl
extends AbstractEntityManager<BatchEntity>
implements BatchEntityManager {
    protected BatchDataManager batchDataManager;

    public BatchEntityManagerImpl(BatchServiceConfiguration batchServiceConfiguration, BatchDataManager batchDataManager) {
        super(batchServiceConfiguration);
        this.batchDataManager = batchDataManager;
    }

    @Override
    protected DataManager<BatchEntity> getDataManager() {
        return this.batchDataManager;
    }

    @Override
    public List<Batch> findBatchesBySearchKey(String searchKey) {
        return this.batchDataManager.findBatchesBySearchKey(searchKey);
    }

    @Override
    public List<Batch> findAllBatches() {
        return this.batchDataManager.findAllBatches();
    }

    @Override
    public List<Batch> findBatchesByQueryCriteria(BatchQueryImpl batchQuery) {
        return this.batchDataManager.findBatchesByQueryCriteria(batchQuery);
    }

    @Override
    public long findBatchCountByQueryCriteria(BatchQueryImpl batchQuery) {
        return this.batchDataManager.findBatchCountByQueryCriteria(batchQuery);
    }

    @Override
    public BatchEntity createBatch(BatchBuilder batchBuilder) {
        BatchEntityImpl batchEntity = (BatchEntityImpl)this.batchDataManager.create();
        batchEntity.setBatchType(batchBuilder.getBatchType());
        batchEntity.setBatchSearchKey(batchBuilder.getSearchKey());
        batchEntity.setBatchSearchKey2(batchBuilder.getSearchKey2());
        batchEntity.setCreateTime(this.getClock().getCurrentTime());
        batchEntity.setStatus(batchBuilder.getStatus());
        batchEntity.setBatchDocumentJson(batchBuilder.getBatchDocumentJson());
        batchEntity.setTenantId(batchBuilder.getTenantId());
        this.batchDataManager.insert(batchEntity);
        return batchEntity;
    }

    @Override
    public void delete(String batchId) {
        BatchByteArrayRef batchDocRefId;
        BatchEntity batch = (BatchEntity)this.batchDataManager.findById(batchId);
        List<BatchPart> batchParts = this.getBatchPartEntityManager().findBatchPartsByBatchId(batch.getId());
        if (batchParts != null && batchParts.size() > 0) {
            for (BatchPart batchPart : batchParts) {
                this.getBatchPartEntityManager().deleteBatchPartEntityAndResources((BatchPartEntity)batchPart);
            }
        }
        if ((batchDocRefId = batch.getBatchDocRefId()) != null && batchDocRefId.getId() != null) {
            batchDocRefId.delete();
        }
        this.delete(batch);
    }
}

