


-- ----------------------------
-- Table structure for A1_APPROVAL
-- ----------------------------
DROP TABLE IF EXISTS `A1_APPROVAL`;
CREATE TABLE `A1_APPROVAL` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `approval_content` varchar(255)  COMMENT '常用语内容',
  `approval_type` int(11)  COMMENT '常用语类型:1:全局 2:流程分类 3:流程定义',
  `flow_type` int(11)  COMMENT '流程类型',
  `status` int(11)  COMMENT '状态 1可用、0不可用',
  `USER_ID` int(12)  COMMENT '用户id',
  PRIMARY KEY (`id`)
) ;

-- ----------------------------
-- Records of A1_APPROVAL
-- ----------------------------
BEGIN;



-- ----------------------------
-- Table structure for A1_APPROVAL_FLOW
-- ----------------------------
DROP TABLE IF EXISTS `A1_APPROVAL_FLOW`;
CREATE TABLE `A1_APPROVAL_FLOW` (
  `id` bigint(30) NOT NULL AUTO_INCREMENT,
  `flow_id` varchar(255) ,
  `flow_key` varchar(255) ,
  `approval_id` int(11) ,
  PRIMARY KEY (`id`) USING BTREE
) ;

DROP TABLE IF EXISTS `A1_DE_MODEL`;
CREATE TABLE `A1_DE_MODEL` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `NAME` varchar(64)  NOT NULL COMMENT '名称',
  `MODEL_KEY` varchar(400)   COMMENT '模型key',
  `DESCRIPTION` varchar(200)   COMMENT '模型描述',
  `MODEL_COMMENT` int(11)  COMMENT '模型评论',
  `LAST_UPDATED` datetime(3)   COMMENT '更新时间',
  `CREATED`      datetime(3)   COMMENT '创建时间',
  `CREATED_BY` varchar(255)   COMMENT '创建人',
  `LAST_UPDATED_BY` varchar(64)   COMMENT '更新人',
  `VERSION` int(11) DEFAULT '0' COMMENT '版本',
  `MODEL_EDITOR_XML` longblob COMMENT '模型内容',
  `TYPE_ID` varchar(64)   COMMENT '分类id',
  `STATUS` varchar(255)  DEFAULT '0' COMMENT '状态，部署或者保存',
  `MODEL_TYPE` int(11)  COMMENT 'BPMN/CMMN/DMN类型',
  `DESIGNER` varchar(64)  DEFAULT 'A1' COMMENT '设计器',
  `DEF_ID` varchar(64)   COMMENT '定义id',
  `DEF_KEY` varchar(64)   COMMENT '定义key',
  `DEPLOY_ID` varchar(64)   COMMENT '部署id',
  `MAIN_PROCESS` int(4)  COMMENT '是否是主版本',
  `REASON` varchar(255)   COMMENT '修改原因',
  `TENANT_ID` varchar(255)  DEFAULT '',
  `TYPE_KEY` varchar(255)  ,
  `THUMBNAIL` longblob,
  `form_Json` longblob COMMENT '表单数据',
  PRIMARY KEY (`ID`)
)  COMMENT='定义模型表';


DROP TABLE IF EXISTS `A1_FLOW_INSTANCE`;
CREATE TABLE `A1_FLOW_INSTANCE` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `PROC_DEF_NAME` varchar(64)   COMMENT '流程名称',
  `SUBJECT` varchar(255)   COMMENT '实例标题',
  `STATUS` varchar(64)   COMMENT '状态',
  `BIZ_KEY` varchar(64)   COMMENT '业务键',
  `CREATE_TIME` datetime(3)  COMMENT '开始时间',
  `END_TIME`  datetime(3)  COMMENT '结束时间',
  `PROC_DEF_id` varchar(64)   COMMENT '流程定义id',
  `PROC_ID` varchar(64)   COMMENT '流程实例id',
  `model_Id` bigint(20)  COMMENT '模型id',
  `title` varchar(255)   COMMENT '分类名称',
  PRIMARY KEY (`ID`) USING BTREE
)  COMMENT='实例记录表';



DROP TABLE IF EXISTS `A1_FLOW_TASK_MANUAL_PROCESSING`;
CREATE TABLE `A1_FLOW_TASK_MANUAL_PROCESSING` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `PROC_DEF_id` varchar(64)   COMMENT '流程定义id',
  `PROC_ID` varchar(64)   COMMENT '流程实例id',
  `task_ID` varchar(64)   COMMENT '任务id',
  `TASK_KEY` varchar(64)   COMMENT '运行任务id',
  `STATUS` varchar(64)  DEFAULT '0' COMMENT '状态',
  `CREATE_TIME` datetime(3)  ,
  PRIMARY KEY (`ID`) USING BTREE
)  COMMENT='异常任务清单';

DROP TABLE IF EXISTS `A1_FLOW_TASK_TRAJECTORY`;
CREATE TABLE `A1_FLOW_TASK_TRAJECTORY` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `PROC_DEF_id` varchar(64)   COMMENT '流程定义id',
  `PROC_ID` varchar(64)   COMMENT '流程实例id',
  `task_ID` varchar(64)   COMMENT '节点 xmlid',
  `FROM_NODE_ID` varchar(64)   COMMENT '源节点',
  `TO_NODE_ID` varchar(64)   COMMENT '目标节点',
  `STATUS` varchar(64)   COMMENT '状态',
  `OPINION` varchar(64)   COMMENT '意见',
  `STATUS_VAL` varchar(64)   COMMENT '状态值',
  `INNER_STATUS` varchar(64)   COMMENT '内部状态值',
  `ACTIVITY_INSTANCE_ID` varchar(64)   COMMENT '活动id',
  `NODE_TYPE` varchar(64)   COMMENT '节点类型',
  `END_STATUS` int(11)  COMMENT '结束状态',
  `USER_NAME` varchar(255)   COMMENT '用户名',
  `USER_ID` varchar(64)   COMMENT '用户id',
  `SUSPENSION_STATE` int(11)  COMMENT '任务状态 1 锁定 0正常运转 2 暂停流转',
  `TASK_USER_TYPE` varchar(64)   COMMENT '任务类型，user 个人任务 group 组任务',
  `NODE_RUN_ID` varchar(64)   COMMENT '运行任务id',
  `CREATE_TIME` datetime(3) COMMENT '创建时间',
  `title` varchar(255)   COMMENT '任务标题',
  `pre_node_id` varchar(255)   COMMENT '上一个完成节点',
  PRIMARY KEY (`ID`)
)  COMMENT='实例运转轨迹扩展表';

-- ----------------------------
-- Records of A1_FLOW_TASK_TRAJECTORY
-- ----------------------------
BEGIN;


DROP TABLE IF EXISTS `A1_RE_PROCDEF_INSTANCE_MODEL_LOG`;
CREATE TABLE `A1_RE_PROCDEF_INSTANCE_MODEL_LOG` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `PROC_INST_ID` varchar(64)  NOT NULL COMMENT '实例id',
  `PROC_DEF_ID` varchar(64)   COMMENT '定义ID',
  `NODE_ID` varchar(64)   COMMENT '节点id',
  `NODE_INFO` varchar(64)  NOT NULL COMMENT '节点信息',
  `NODE_TYPE` varchar(64)  NOT NULL COMMENT '节点类型',
  `PRE_NODE_ID` varchar(64)  NOT NULL COMMENT '上一个节点id',
  `NEXT_NODE_ID` varchar(64)  NOT NULL COMMENT '下一个节点id',
  `NAME` varchar(64)  NOT NULL COMMENT '节点名称',
  `CREATE_TIME` datetime(3) NOT NULL ,
  PRIMARY KEY (`ID`)
)  COMMENT='实例日志表';


DROP TABLE IF EXISTS `A1_RE_PROCDEF_INSTANCE_RESTART_LOG`;
CREATE TABLE `A1_RE_PROCDEF_INSTANCE_RESTART_LOG` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `DEAD_PROC_INST_ID` varchar(64)  NOT NULL COMMENT '原有的实例id',
  `PROC_DEF_ID` varchar(64)   COMMENT '定义ID',
  `PROC_INST_ID` varchar(64)   COMMENT '新的实例id',
  `ACTIVITY_ID` varchar(64)  NOT NULL COMMENT '节点ID',
  `OPERATE_TYPE` varchar(64)  NOT NULL COMMENT '操作',
  `STATUS` varchar(2)  DEFAULT '0' COMMENT '  0使用，1禁用 ',
  `CREATE_TIME` datetime(3) ,
  PRIMARY KEY (`ID`) USING BTREE
)  COMMENT='历史实例重启日志表';


DROP TABLE IF EXISTS `A1_SCRIPT_COMMON_MODEL`;
CREATE TABLE `A1_SCRIPT_COMMON_MODEL` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `NAME` varchar(64)  NOT NULL COMMENT '名称',
  `SCRIPT` varchar(255)  DEFAULT '0' COMMENT '  0使用，1禁用 ',
  `CATEGORY` varchar(255)   COMMENT ' 分类 ',
  `MEMO` varchar(255)   COMMENT ' 备注',
  `STATUS` varchar(255)  DEFAULT '0' COMMENT '  0使用，1禁用 ',
  `IS_DELETED` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  PRIMARY KEY (`ID`) USING BTREE
)  COMMENT='常用脚本表';


BEGIN;
INSERT INTO `A1_SCRIPT_COMMON_MODEL` VALUES (7, '获取当前日期（指定格式）', 'return commonScript.getCurrentDate();', '6', '获取当前日期，按指定格式输出', '6', 0);
INSERT INTO `A1_SCRIPT_COMMON_MODEL` VALUES (8, '登录人id', 'return commonScript.getCurrentUserId();', '7', '获取登录人id', '6', 0);
INSERT INTO `A1_SCRIPT_COMMON_MODEL` VALUES (9, '获取当前登录人信息', 'return commonScript.getUserInfo();', '6', '获取当前登录人信息', '6', 0);
INSERT INTO `A1_SCRIPT_COMMON_MODEL` VALUES (15, '2', '2', '9', '2', '9', 1);
COMMIT;


DROP TABLE IF EXISTS `A1_SCRIPT_TYPE`;
CREATE TABLE `A1_SCRIPT_TYPE` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `CATEGORY` varchar(64)  NOT NULL COMMENT '分类名称',
  `STATUS` varchar(255)  DEFAULT '0' COMMENT '  0使用，1禁用 ',
  `TYPE` varchar(255)   COMMENT '  0常用脚本 1流程脚本 ',
  PRIMARY KEY (`ID`) USING BTREE
)  COMMENT='脚本分类表';



DROP TABLE IF EXISTS `A1_USER_ORG_CODE`;
CREATE TABLE `A1_USER_ORG_CODE` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `NAME` varchar(64)  NOT NULL COMMENT '名称',
  `CODE` varchar(64)  NOT NULL COMMENT '编码',
  `TYPE` varchar(64)   COMMENT '类型',
  `DESCRIPTION` varchar(200)   COMMENT '模型描述',
  `ORDER_ID` int(11)  COMMENT '排序',
  `PARENT_ID` bigint(20)  COMMENT '父id',
  PRIMARY KEY (`ID`)
)  COMMENT='组织码表';


BEGIN;
INSERT INTO `A1_USER_ORG_CODE` VALUES (1, '用户', 'user', 'idm_user', '用户', 1, NULL);
INSERT INTO `A1_USER_ORG_CODE` VALUES (2, '组', 'group', 'idm_role', '组', 1, NULL);
INSERT INTO `A1_USER_ORG_CODE` VALUES (3, '用户', 'users', 'users', '用户', 1, NULL);
COMMIT;


DROP TABLE IF EXISTS `ACT_CMMN_DEPLOYMENT`;
CREATE TABLE `ACT_CMMN_DEPLOYMENT` (
  `ID_` varchar(255)  NOT NULL,
  `NAME_` varchar(255)  ,
  `CATEGORY_` varchar(255)  ,
  `KEY_` varchar(255)  ,
  `DEPLOY_TIME_` datetime(3) ,
  `PARENT_DEPLOYMENT_ID_` varchar(255)  ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
DROP TABLE IF EXISTS `ACT_CMMN_CASEDEF`;
CREATE TABLE `ACT_CMMN_CASEDEF` (
  `ID_` varchar(255)  NOT NULL,
  `REV_` int(11) NOT NULL,
  `NAME_` varchar(255)  ,
  `KEY_` varchar(255)  NOT NULL,
  `VERSION_` int(11) NOT NULL,
  `CATEGORY_` varchar(255)  ,
  `DEPLOYMENT_ID_` varchar(255)  ,
  `RESOURCE_NAME_` varchar(4000)  ,
  `DESCRIPTION_` varchar(4000)  ,
  `HAS_GRAPHICAL_NOTATION_` bit(1) ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  `DGRM_RESOURCE_NAME_` varchar(4000)  ,
  `HAS_START_FORM_KEY_` bit(1) ,
  PRIMARY KEY (`ID_`) USING BTREE,
  UNIQUE KEY `ACT_IDX_CASE_DEF_UNIQ` (`KEY_`,`VERSION_`,`TENANT_ID_`) USING BTREE,
  KEY `ACT_IDX_CASE_DEF_DPLY` (`DEPLOYMENT_ID_`) USING BTREE,
  CONSTRAINT `ACT_FK_CASE_DEF_DPLY` FOREIGN KEY (`DEPLOYMENT_ID_`) REFERENCES `ACT_CMMN_DEPLOYMENT` (`ID_`)
) ;



DROP TABLE IF EXISTS `ACT_CMMN_DATABASECHANGELOG`;
CREATE TABLE `ACT_CMMN_DATABASECHANGELOG` (
  `ID` varchar(255)  NOT NULL,
  `AUTHOR` varchar(255)  NOT NULL,
  `FILENAME` varchar(255)  NOT NULL,
  `DATEEXECUTED` datetime NOT NULL,
  `ORDEREXECUTED` int(11) NOT NULL,
  `EXECTYPE` varchar(10)  NOT NULL,
  `MD5SUM` varchar(35)  ,
  `DESCRIPTION` varchar(255)  ,
  `COMMENTS` varchar(255)  ,
  `TAG` varchar(255)  ,
  `LIQUIBASE` varchar(20)  ,
  `CONTEXTS` varchar(255)  ,
  `LABELS` varchar(255)  ,
  `DEPLOYMENT_ID` varchar(10)
) ;


BEGIN;
INSERT INTO `ACT_CMMN_DATABASECHANGELOG` VALUES ('1', 'flowable', 'org/flowable/cmmn/db/liquibase/flowable-cmmn-db-changelog.xml', '2020-03-04 16:38:49', 1, 'EXECUTED', '8:8b4b922d90b05ff27483abefc9597aa6', 'createTable tableName=ACT_CMMN_DEPLOYMENT; createTable tableName=ACT_CMMN_DEPLOYMENT_RESOURCE; addForeignKeyConstraint baseTableName=ACT_CMMN_DEPLOYMENT_RESOURCE, constraintName=ACT_FK_CMMN_RSRC_DPL, referencedTableName=ACT_CMMN_DEPLOYMENT; create...', '', NULL, '3.6.3', NULL, NULL, '3311126425');
INSERT INTO `ACT_CMMN_DATABASECHANGELOG` VALUES ('2', 'flowable', 'org/flowable/cmmn/db/liquibase/flowable-cmmn-db-changelog.xml', '2020-03-04 16:38:49', 2, 'EXECUTED', '8:65e39b3d385706bb261cbeffe7533cbe', 'addColumn tableName=ACT_CMMN_CASEDEF; addColumn tableName=ACT_CMMN_DEPLOYMENT_RESOURCE; addColumn tableName=ACT_CMMN_RU_CASE_INST; addColumn tableName=ACT_CMMN_RU_PLAN_ITEM_INST', '', NULL, '3.6.3', NULL, NULL, '3311126425');
INSERT INTO `ACT_CMMN_DATABASECHANGELOG` VALUES ('3', 'flowable', 'org/flowable/cmmn/db/liquibase/flowable-cmmn-db-changelog.xml', '2020-03-04 16:38:50', 3, 'EXECUTED', '8:c01f6e802b49436b4489040da3012359', 'addColumn tableName=ACT_CMMN_RU_PLAN_ITEM_INST; addColumn tableName=ACT_CMMN_RU_CASE_INST; createIndex indexName=ACT_IDX_PLAN_ITEM_STAGE_INST, tableName=ACT_CMMN_RU_PLAN_ITEM_INST; addColumn tableName=ACT_CMMN_RU_PLAN_ITEM_INST; addColumn tableNam...', '', NULL, '3.6.3', NULL, NULL, '3311126425');
INSERT INTO `ACT_CMMN_DATABASECHANGELOG` VALUES ('4', 'flowable', 'org/flowable/cmmn/db/liquibase/flowable-cmmn-db-changelog.xml', '2020-03-04 16:38:50', 4, 'EXECUTED', '8:e40d29cb79345b7fb5afd38a7f0ba8fc', 'createTable tableName=ACT_CMMN_HI_PLAN_ITEM_INST; addColumn tableName=ACT_CMMN_RU_MIL_INST; addColumn tableName=ACT_CMMN_HI_MIL_INST', '', NULL, '3.6.3', NULL, NULL, '3311126425');
INSERT INTO `ACT_CMMN_DATABASECHANGELOG` VALUES ('5', 'flowable', 'org/flowable/cmmn/db/liquibase/flowable-cmmn-db-changelog.xml', '2020-03-04 16:38:52', 5, 'EXECUTED', '8:70349de472f87368dcdec971a10311a0', 'modifyDataType columnName=DEPLOY_TIME_, tableName=ACT_CMMN_DEPLOYMENT; modifyDataType columnName=START_TIME_, tableName=ACT_CMMN_RU_CASE_INST; modifyDataType columnName=START_TIME_, tableName=ACT_CMMN_RU_PLAN_ITEM_INST; modifyDataType columnName=T...', '', NULL, '3.6.3', NULL, NULL, '3311126425');
INSERT INTO `ACT_CMMN_DATABASECHANGELOG` VALUES ('6', 'flowable', 'org/flowable/cmmn/db/liquibase/flowable-cmmn-db-changelog.xml', '2020-03-04 16:38:52', 6, 'EXECUTED', '8:10e82e26a7fee94c32a92099c059c18c', 'createIndex indexName=ACT_IDX_CASE_DEF_UNIQ, tableName=ACT_CMMN_CASEDEF', '', NULL, '3.6.3', NULL, NULL, '3311126425');
INSERT INTO `ACT_CMMN_DATABASECHANGELOG` VALUES ('7', 'flowable', 'org/flowable/cmmn/db/liquibase/flowable-cmmn-db-changelog.xml', '2020-03-04 16:38:53', 7, 'EXECUTED', '8:530bc81a1e30618ccf4a2da1f7c6c043', 'renameColumn newColumnName=CREATE_TIME_, oldColumnName=START_TIME_, tableName=ACT_CMMN_RU_PLAN_ITEM_INST; renameColumn newColumnName=CREATE_TIME_, oldColumnName=CREATED_TIME_, tableName=ACT_CMMN_HI_PLAN_ITEM_INST; addColumn tableName=ACT_CMMN_RU_P...', '', NULL, '3.6.3', NULL, NULL, '3311126425');
COMMIT;

DROP TABLE IF EXISTS `ACT_CMMN_DATABASECHANGELOGLOCK`;
CREATE TABLE `ACT_CMMN_DATABASECHANGELOGLOCK` (
  `ID` int(11) NOT NULL,
  `LOCKED` bit(1) NOT NULL,
  `LOCKGRANTED` datetime ,
  `LOCKEDBY` varchar(255)  ,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_CMMN_DATABASECHANGELOGLOCK
-- ----------------------------
BEGIN;
INSERT INTO `ACT_CMMN_DATABASECHANGELOGLOCK` VALUES (1, b'0', NULL, NULL);
COMMIT;





DROP TABLE IF EXISTS `ACT_CMMN_DEPLOYMENT_RESOURCE`;
CREATE TABLE `ACT_CMMN_DEPLOYMENT_RESOURCE` (
  `ID_` varchar(255)  NOT NULL,
  `NAME_` varchar(255)  ,
  `DEPLOYMENT_ID_` varchar(255)  ,
  `RESOURCE_BYTES_` longblob,
  `GENERATED_` bit(1) ,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_CMMN_RSRC_DPL` (`DEPLOYMENT_ID_`) USING BTREE,
  CONSTRAINT `ACT_FK_CMMN_RSRC_DPL` FOREIGN KEY (`DEPLOYMENT_ID_`) REFERENCES `ACT_CMMN_DEPLOYMENT` (`ID_`)
) ;


DROP TABLE IF EXISTS `ACT_CMMN_HI_CASE_INST`;
CREATE TABLE `ACT_CMMN_HI_CASE_INST` (
  `ID_` varchar(255)  NOT NULL,
  `REV_` int(11) NOT NULL,
  `BUSINESS_KEY_` varchar(255)  ,
  `NAME_` varchar(255)  ,
  `PARENT_ID_` varchar(255)  ,
  `CASE_DEF_ID_` varchar(255)  ,
  `STATE_` varchar(255)  ,
  `START_TIME_` datetime(3) ,
  `END_TIME_` datetime(3) ,
  `START_USER_ID_` varchar(255)  ,
  `CALLBACK_ID_` varchar(255)  ,
  `CALLBACK_TYPE_` varchar(255)  ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;




DROP TABLE IF EXISTS `ACT_CMMN_HI_MIL_INST`;
CREATE TABLE `ACT_CMMN_HI_MIL_INST` (
  `ID_` varchar(255)  NOT NULL,
  `REV_` int(11) NOT NULL,
  `NAME_` varchar(255)  NOT NULL,
  `TIME_STAMP_` datetime(3) ,
  `CASE_INST_ID_` varchar(255)  NOT NULL,
  `CASE_DEF_ID_` varchar(255)  NOT NULL,
  `ELEMENT_ID_` varchar(255)  NOT NULL,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;


DROP TABLE IF EXISTS `ACT_CMMN_HI_PLAN_ITEM_INST`;
CREATE TABLE `ACT_CMMN_HI_PLAN_ITEM_INST` (
  `ID_` varchar(255)  NOT NULL,
  `REV_` int(11) NOT NULL,
  `NAME_` varchar(255)  ,
  `STATE_` varchar(255)  ,
  `CASE_DEF_ID_` varchar(255)  ,
  `CASE_INST_ID_` varchar(255)  ,
  `STAGE_INST_ID_` varchar(255)  ,
  `IS_STAGE_` bit(1) ,
  `ELEMENT_ID_` varchar(255)  ,
  `ITEM_DEFINITION_ID_` varchar(255)  ,
  `ITEM_DEFINITION_TYPE_` varchar(255)  ,
  `CREATE_TIME_` datetime(3) ,
  `LAST_AVAILABLE_TIME_` datetime(3) ,
  `LAST_ENABLED_TIME_` datetime(3) ,
  `LAST_DISABLED_TIME_` datetime(3) ,
  `LAST_STARTED_TIME_` datetime(3) ,
  `LAST_SUSPENDED_TIME_` datetime(3) ,
  `COMPLETED_TIME_` datetime(3) ,
  `OCCURRED_TIME_` datetime(3) ,
  `TERMINATED_TIME_` datetime(3) ,
  `EXIT_TIME_` datetime(3) ,
  `ENDED_TIME_` datetime(3) ,
  `LAST_UPDATED_TIME_` datetime(3) ,
  `START_USER_ID_` varchar(255)  ,
  `REFERENCE_ID_` varchar(255)  ,
  `REFERENCE_TYPE_` varchar(255)  ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  `ENTRY_CRITERION_ID_` varchar(255)  ,
  `EXIT_CRITERION_ID_` varchar(255)  ,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;


DROP TABLE IF EXISTS `ACT_CMMN_RU_CASE_INST`;
CREATE TABLE `ACT_CMMN_RU_CASE_INST` (
  `ID_` varchar(255)  NOT NULL,
  `REV_` int(11) NOT NULL,
  `BUSINESS_KEY_` varchar(255)  ,
  `NAME_` varchar(255)  ,
  `PARENT_ID_` varchar(255)  ,
  `CASE_DEF_ID_` varchar(255)  ,
  `STATE_` varchar(255)  ,
  `START_TIME_` datetime(3) ,
  `START_USER_ID_` varchar(255)  ,
  `CALLBACK_ID_` varchar(255)  ,
  `CALLBACK_TYPE_` varchar(255)  ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  `LOCK_TIME_` datetime(3) ,
  `IS_COMPLETEABLE_` bit(1) ,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_CASE_INST_CASE_DEF` (`CASE_DEF_ID_`) USING BTREE,
  KEY `ACT_IDX_CASE_INST_PARENT` (`PARENT_ID_`) USING BTREE,
  CONSTRAINT `ACT_FK_CASE_INST_CASE_DEF` FOREIGN KEY (`CASE_DEF_ID_`) REFERENCES `ACT_CMMN_CASEDEF` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;


DROP TABLE IF EXISTS `ACT_CMMN_RU_MIL_INST`;
CREATE TABLE `ACT_CMMN_RU_MIL_INST` (
  `ID_` varchar(255)  NOT NULL,
  `NAME_` varchar(255)  NOT NULL,
  `TIME_STAMP_` datetime(3) ,
  `CASE_INST_ID_` varchar(255)  NOT NULL,
  `CASE_DEF_ID_` varchar(255)  NOT NULL,
  `ELEMENT_ID_` varchar(255)  NOT NULL,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_MIL_CASE_DEF` (`CASE_DEF_ID_`) USING BTREE,
  KEY `ACT_IDX_MIL_CASE_INST` (`CASE_INST_ID_`) USING BTREE,
  CONSTRAINT `ACT_FK_MIL_CASE_DEF` FOREIGN KEY (`CASE_DEF_ID_`) REFERENCES `ACT_CMMN_CASEDEF` (`ID_`),
  CONSTRAINT `ACT_FK_MIL_CASE_INST` FOREIGN KEY (`CASE_INST_ID_`) REFERENCES `ACT_CMMN_RU_CASE_INST` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;


DROP TABLE IF EXISTS `ACT_CMMN_RU_PLAN_ITEM_INST`;
CREATE TABLE `ACT_CMMN_RU_PLAN_ITEM_INST` (
  `ID_` varchar(255)  NOT NULL,
  `REV_` int(11) NOT NULL,
  `CASE_DEF_ID_` varchar(255)  ,
  `CASE_INST_ID_` varchar(255)  ,
  `STAGE_INST_ID_` varchar(255)  ,
  `IS_STAGE_` bit(1) ,
  `ELEMENT_ID_` varchar(255)  ,
  `NAME_` varchar(255)  ,
  `STATE_` varchar(255)  ,
  `CREATE_TIME_` datetime(3) ,
  `START_USER_ID_` varchar(255)  ,
  `REFERENCE_ID_` varchar(255)  ,
  `REFERENCE_TYPE_` varchar(255)  ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  `ITEM_DEFINITION_ID_` varchar(255)  ,
  `ITEM_DEFINITION_TYPE_` varchar(255)  ,
  `IS_COMPLETEABLE_` bit(1) ,
  `IS_COUNT_ENABLED_` bit(1) ,
  `VAR_COUNT_` int(11) ,
  `SENTRY_PART_INST_COUNT_` int(11) ,
  `LAST_AVAILABLE_TIME_` datetime(3) ,
  `LAST_ENABLED_TIME_` datetime(3) ,
  `LAST_DISABLED_TIME_` datetime(3) ,
  `LAST_STARTED_TIME_` datetime(3) ,
  `LAST_SUSPENDED_TIME_` datetime(3) ,
  `COMPLETED_TIME_` datetime(3) ,
  `OCCURRED_TIME_` datetime(3) ,
  `TERMINATED_TIME_` datetime(3) ,
  `EXIT_TIME_` datetime(3) ,
  `ENDED_TIME_` datetime(3) ,
  `ENTRY_CRITERION_ID_` varchar(255)  ,
  `EXIT_CRITERION_ID_` varchar(255)  ,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_PLAN_ITEM_CASE_DEF` (`CASE_DEF_ID_`) USING BTREE,
  KEY `ACT_IDX_PLAN_ITEM_CASE_INST` (`CASE_INST_ID_`) USING BTREE,
  KEY `ACT_IDX_PLAN_ITEM_STAGE_INST` (`STAGE_INST_ID_`) USING BTREE,
  CONSTRAINT `ACT_FK_PLAN_ITEM_CASE_DEF` FOREIGN KEY (`CASE_DEF_ID_`) REFERENCES `ACT_CMMN_CASEDEF` (`ID_`),
  CONSTRAINT `ACT_FK_PLAN_ITEM_CASE_INST` FOREIGN KEY (`CASE_INST_ID_`) REFERENCES `ACT_CMMN_RU_CASE_INST` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;




DROP TABLE IF EXISTS `ACT_CMMN_RU_SENTRY_PART_INST`;
CREATE TABLE `ACT_CMMN_RU_SENTRY_PART_INST` (
  `ID_` varchar(255)  NOT NULL,
  `REV_` int(11) NOT NULL,
  `CASE_DEF_ID_` varchar(255)  ,
  `CASE_INST_ID_` varchar(255)  ,
  `PLAN_ITEM_INST_ID_` varchar(255)  ,
  `ON_PART_ID_` varchar(255)  ,
  `IF_PART_ID_` varchar(255)  ,
  `TIME_STAMP_` datetime(3) ,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_SENTRY_CASE_DEF` (`CASE_DEF_ID_`) USING BTREE,
  KEY `ACT_IDX_SENTRY_CASE_INST` (`CASE_INST_ID_`) USING BTREE,
  KEY `ACT_IDX_SENTRY_PLAN_ITEM` (`PLAN_ITEM_INST_ID_`) USING BTREE,
  CONSTRAINT `ACT_FK_SENTRY_CASE_DEF` FOREIGN KEY (`CASE_DEF_ID_`) REFERENCES `ACT_CMMN_CASEDEF` (`ID_`),
  CONSTRAINT `ACT_FK_SENTRY_CASE_INST` FOREIGN KEY (`CASE_INST_ID_`) REFERENCES `ACT_CMMN_RU_CASE_INST` (`ID_`),
  CONSTRAINT `ACT_FK_SENTRY_PLAN_ITEM` FOREIGN KEY (`PLAN_ITEM_INST_ID_`) REFERENCES `ACT_CMMN_RU_PLAN_ITEM_INST` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for ACT_EVT_LOG
-- ----------------------------
DROP TABLE IF EXISTS `ACT_EVT_LOG`;
CREATE TABLE `ACT_EVT_LOG` (
  `LOG_NR_` bigint(20) NOT NULL AUTO_INCREMENT,
  `TYPE_` varchar(64)  ,
  `PROC_DEF_ID_` varchar(64)  ,
  `PROC_INST_ID_` varchar(64)  ,
  `EXECUTION_ID_` varchar(64)  ,
  `TASK_ID_` varchar(64)  ,
  `TIME_STAMP_` datetime(3),
  `USER_ID_` varchar(255)  ,
  `DATA_` longblob,
  `LOCK_OWNER_` varchar(255)  ,
  `LOCK_TIME_` datetime(3) NULL ,
  `IS_PROCESSED_` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`LOG_NR_`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for ACT_FO_DATABASECHANGELOG
-- ----------------------------
DROP TABLE IF EXISTS `ACT_FO_DATABASECHANGELOG`;
CREATE TABLE `ACT_FO_DATABASECHANGELOG` (
  `ID` varchar(255)  NOT NULL,
  `AUTHOR` varchar(255)  NOT NULL,
  `FILENAME` varchar(255)  NOT NULL,
  `DATEEXECUTED` datetime NOT NULL,
  `ORDEREXECUTED` int(11) NOT NULL,
  `EXECTYPE` varchar(10)  NOT NULL,
  `MD5SUM` varchar(35)  ,
  `DESCRIPTION` varchar(255)  ,
  `COMMENTS` varchar(255)  ,
  `TAG` varchar(255)  ,
  `LIQUIBASE` varchar(20)  ,
  `CONTEXTS` varchar(255)  ,
  `LABELS` varchar(255)  ,
  `DEPLOYMENT_ID` varchar(10)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for ACT_FO_DATABASECHANGELOGLOCK
-- ----------------------------
DROP TABLE IF EXISTS `ACT_FO_DATABASECHANGELOGLOCK`;
CREATE TABLE `ACT_FO_DATABASECHANGELOGLOCK` (
  `ID` int(11) NOT NULL,
  `LOCKED` bit(1) NOT NULL,
  `LOCKGRANTED` datetime ,
  `LOCKEDBY` varchar(255)  ,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_FO_DATABASECHANGELOGLOCK
-- ----------------------------
BEGIN;
INSERT INTO `ACT_FO_DATABASECHANGELOGLOCK` VALUES (1, b'0', NULL, NULL);
COMMIT;





DROP TABLE IF EXISTS `ACT_GE_BYTEARRAY`;
CREATE TABLE `ACT_GE_BYTEARRAY` (
  `ID_` varchar(64)  NOT NULL DEFAULT '',
  `REV_` int(11) ,
  `NAME_` varchar(255)  ,
  `DEPLOYMENT_ID_` varchar(64)  ,
  `BYTES_` longblob,
  `GENERATED_` tinyint(4) ,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_FK_BYTEARR_DEPL` (`DEPLOYMENT_ID_`) USING BTREE,
  CONSTRAINT `ACT_FK_BYTEARR_DEPL` FOREIGN KEY (`DEPLOYMENT_ID_`) REFERENCES `ACT_RE_DEPLOYMENT` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;



-- ----------------------------
-- Table structure for ACT_GE_PROPERTY
-- ----------------------------
DROP TABLE IF EXISTS `ACT_GE_PROPERTY`;
CREATE TABLE `ACT_GE_PROPERTY` (
  `NAME_` varchar(64)  NOT NULL DEFAULT '',
  `VALUE_` varchar(1000)  ,
  `REV_` int(11) ,
  PRIMARY KEY (`NAME_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_GE_PROPERTY
-- ----------------------------
BEGIN;
INSERT INTO `ACT_GE_PROPERTY` VALUES ('batch.schema.version', '6.5.0.2', 1);
INSERT INTO `ACT_GE_PROPERTY` VALUES ('cfg.execution-related-entities-count', 'true', 1);
INSERT INTO `ACT_GE_PROPERTY` VALUES ('cfg.task-related-entities-count', 'false', 2);
INSERT INTO `ACT_GE_PROPERTY` VALUES ('common.schema.version', '6.5.0.2', 1);
INSERT INTO `ACT_GE_PROPERTY` VALUES ('entitylink.schema.version', '6.5.0.2', 1);
INSERT INTO `ACT_GE_PROPERTY` VALUES ('eventsubscription.schema.version', '6.5.0.2', 1);
INSERT INTO `ACT_GE_PROPERTY` VALUES ('identitylink.schema.version', '6.5.0.2', 1);
INSERT INTO `ACT_GE_PROPERTY` VALUES ('job.schema.version', '6.5.0.2', 1);
INSERT INTO `ACT_GE_PROPERTY` VALUES ('next.dbid', '2630001', 1053);
INSERT INTO `ACT_GE_PROPERTY` VALUES ('pangu.custom.Id', '[{\"desc\":\"定时器模块\",\"muduleId\":\"JOB\",\"mudulePre\":\"PANGU-JOB-\",\"muduleStrategy\":\"1\"},{\"desc\":\"变量模块\",\"muduleId\":\"VAR\",\"mudulePre\":\"PANGU-VAR-\",\"muduleStrategy\":\"1\"},{\"desc\":\"任务模块模块\",\"muduleId\":\"TSK\",\"mudulePre\":\"PANGU-TSK-\",\"muduleStrategy\":\"1\"},{\"desc\":\"案例引擎模块\",\"muduleId\":\"CAS\",\"mudulePre\":\"PANGU-CAS-\",\"muduleStrategy\":\"1\"},{\"desc\":\"BPM引擎模块\",\"muduleId\":\"PRC\",\"mudulePre\":\"PANGU-PRC-\",\"muduleStrategy\":\"1\"},{\"desc\":\"事件订阅模块\",\"muduleId\":\"ESU\",\"mudulePre\":\"PANGU-ESU-\",\"muduleStrategy\":\"2\"}]', 8);
INSERT INTO `ACT_GE_PROPERTY` VALUES ('pangu.form.schema.version', 'pangu', 1);
INSERT INTO `ACT_GE_PROPERTY` VALUES ('schema.history', 'upgrade(6.5.0.1->6.5.0.2)', 2);
INSERT INTO `ACT_GE_PROPERTY` VALUES ('schema.version', '6.5.0.2', 2);
INSERT INTO `ACT_GE_PROPERTY` VALUES ('task.schema.version', '6.5.0.2', 1);
INSERT INTO `ACT_GE_PROPERTY` VALUES ('variable.schema.version', '6.5.0.2', 1);
COMMIT;

-- ----------------------------
-- Table structure for ACT_HI_ACTINST
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_ACTINST`;
CREATE TABLE `ACT_HI_ACTINST` (
  `ID_` varchar(64)  NOT NULL,
  `REV_` int(11) DEFAULT '1',
  `PROC_DEF_ID_` varchar(64)  NOT NULL,
  `PROC_INST_ID_` varchar(64)  NOT NULL,
  `EXECUTION_ID_` varchar(64)  NOT NULL,
  `ACT_ID_` varchar(255)  NOT NULL,
  `TASK_ID_` varchar(64)  ,
  `CALL_PROC_INST_ID_` varchar(64)  ,
  `ACT_NAME_` varchar(255)  ,
  `ACT_TYPE_` varchar(255)  NOT NULL,
  `ASSIGNEE_` varchar(255)  ,
  `START_TIME_` datetime NOT NULL,
  `END_TIME_` datetime ,
  `DURATION_` bigint(20) ,
  `DELETE_REASON_` varchar(4000)  ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_HI_ACT_INST_START` (`START_TIME_`) USING BTREE,
  KEY `ACT_IDX_HI_ACT_INST_END` (`END_TIME_`) USING BTREE,
  KEY `ACT_IDX_HI_ACT_INST_PROCINST` (`PROC_INST_ID_`,`ACT_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_ACT_INST_EXEC` (`EXECUTION_ID_`,`ACT_ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;



-- ----------------------------
-- Table structure for ACT_HI_ATTACHMENT
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_ATTACHMENT`;
CREATE TABLE `ACT_HI_ATTACHMENT` (
  `ID_` varchar(64)  NOT NULL,
  `REV_` int(11) ,
  `USER_ID_` varchar(255)  ,
  `NAME_` varchar(255)  ,
  `DESCRIPTION_` varchar(4000)  ,
  `TYPE_` varchar(255)  ,
  `TASK_ID_` varchar(64)  ,
  `PROC_INST_ID_` varchar(64)  ,
  `URL_` varchar(4000)  ,
  `CONTENT_ID_` varchar(64)  ,
  `TIME_` datetime ,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for ACT_HI_COMMENT
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_COMMENT`;
CREATE TABLE `ACT_HI_COMMENT` (
  `ID_` varchar(64)  NOT NULL,
  `TYPE_` varchar(255)  ,
  `TIME_` datetime NOT NULL,
  `USER_ID_` varchar(255)  ,
  `TASK_ID_` varchar(64)  ,
  `PROC_INST_ID_` varchar(64)  ,
  `ACTION_` varchar(255)  ,
  `MESSAGE_` varchar(4000)  ,
  `FULL_MSG_` longblob,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;



-- ----------------------------
-- Table structure for ACT_HI_DETAIL
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_DETAIL`;
CREATE TABLE `ACT_HI_DETAIL` (
  `ID_` varchar(64)  NOT NULL,
  `TYPE_` varchar(255)  NOT NULL,
  `PROC_INST_ID_` varchar(64)  ,
  `EXECUTION_ID_` varchar(64)  ,
  `TASK_ID_` varchar(64)  ,
  `ACT_INST_ID_` varchar(64)  ,
  `NAME_` varchar(255)  NOT NULL,
  `VAR_TYPE_` varchar(255)  ,
  `REV_` int(11) ,
  `TIME_` datetime NOT NULL,
  `BYTEARRAY_ID_` varchar(64)  ,
  `DOUBLE_` double ,
  `LONG_` bigint(20) ,
  `TEXT_` varchar(4000)  ,
  `TEXT2_` varchar(4000)  ,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_HI_DETAIL_PROC_INST` (`PROC_INST_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_DETAIL_ACT_INST` (`ACT_INST_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_DETAIL_TIME` (`TIME_`) USING BTREE,
  KEY `ACT_IDX_HI_DETAIL_NAME` (`NAME_`) USING BTREE,
  KEY `ACT_IDX_HI_DETAIL_TASK_ID` (`TASK_ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;


-- ----------------------------
-- Table structure for ACT_HI_ENTITYLINK
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_ENTITYLINK`;
CREATE TABLE `ACT_HI_ENTITYLINK` (
  `ID_` varchar(64)  NOT NULL DEFAULT '',
  `LINK_TYPE_` varchar(255)  ,
  `CREATE_TIME_` datetime ,
  `SCOPE_ID_` varchar(255)  ,
  `SCOPE_TYPE_` varchar(255)  ,
  `SCOPE_DEFINITION_ID_` varchar(255)  ,
  `REF_SCOPE_ID_` varchar(255)  ,
  `REF_SCOPE_TYPE_` varchar(255)  ,
  `REF_SCOPE_DEFINITION_ID_` varchar(255)  ,
  `HIERARCHY_TYPE_` varchar(255)  ,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_HI_ENT_LNK_SCOPE` (`SCOPE_ID_`,`SCOPE_TYPE_`,`LINK_TYPE_`) USING BTREE,
  KEY `ACT_IDX_HI_ENT_LNK_SCOPE_DEF` (`SCOPE_DEFINITION_ID_`,`SCOPE_TYPE_`,`LINK_TYPE_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;



-- ----------------------------
-- Table structure for ACT_HI_IDENTITYLINK
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_IDENTITYLINK`;
CREATE TABLE `ACT_HI_IDENTITYLINK` (
  `ID_` varchar(64)  NOT NULL DEFAULT '',
  `GROUP_ID_` varchar(255)  ,
  `TYPE_` varchar(255)  ,
  `USER_ID_` varchar(255)  ,
  `TASK_ID_` varchar(64)  ,
  `CREATE_TIME_` datetime ,
  `PROC_INST_ID_` varchar(64)  ,
  `SCOPE_ID_` varchar(255)  ,
  `SCOPE_TYPE_` varchar(255)  ,
  `SCOPE_DEFINITION_ID_` varchar(255)  ,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_HI_IDENT_LNK_USER` (`USER_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_IDENT_LNK_SCOPE` (`SCOPE_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_IDX_HI_IDENT_LNK_SCOPE_DEF` (`SCOPE_DEFINITION_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_IDX_HI_IDENT_LNK_TASK` (`TASK_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_IDENT_LNK_PROCINST` (`PROC_INST_ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;




-- ----------------------------
-- Table structure for ACT_HI_PROCINST
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_PROCINST`;
CREATE TABLE `ACT_HI_PROCINST` (
  `ID_` varchar(64)  NOT NULL,
  `REV_` int(11) DEFAULT '1',
  `PROC_INST_ID_` varchar(64)  NOT NULL,
  `BUSINESS_KEY_` varchar(255)  ,
  `PROC_DEF_ID_` varchar(64)  NOT NULL,
  `START_TIME_` datetime NOT NULL,
  `END_TIME_` datetime ,
  `DURATION_` bigint(20) ,
  `START_USER_ID_` varchar(255)  ,
  `START_ACT_ID_` varchar(255)  ,
  `END_ACT_ID_` varchar(255)  ,
  `SUPER_PROCESS_INSTANCE_ID_` varchar(64)  ,
  `DELETE_REASON_` varchar(4000)  ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  `NAME_` varchar(255)  ,
  `CALLBACK_ID_` varchar(255)  ,
  `CALLBACK_TYPE_` varchar(255)  ,
  PRIMARY KEY (`ID_`) USING BTREE,
  UNIQUE KEY `PROC_INST_ID_` (`PROC_INST_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_PRO_INST_END` (`END_TIME_`) USING BTREE,
  KEY `ACT_IDX_HI_PRO_I_BUSKEY` (`BUSINESS_KEY_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;



-- ----------------------------
-- Table structure for ACT_HI_TASKINST
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_TASKINST`;
CREATE TABLE `ACT_HI_TASKINST` (
  `ID_` varchar(64)  NOT NULL,
  `REV_` int(11) DEFAULT '1',
  `PROC_DEF_ID_` varchar(64)  ,
  `TASK_DEF_ID_` varchar(64)  ,
  `TASK_DEF_KEY_` varchar(255)  ,
  `PROC_INST_ID_` varchar(64)  ,
  `EXECUTION_ID_` varchar(64)  ,
  `SCOPE_ID_` varchar(255)  ,
  `SUB_SCOPE_ID_` varchar(255)  ,
  `SCOPE_TYPE_` varchar(255)  ,
  `SCOPE_DEFINITION_ID_` varchar(255)  ,
  `NAME_` varchar(255)  ,
  `PARENT_TASK_ID_` varchar(64)  ,
  `DESCRIPTION_` varchar(4000)  ,
  `OWNER_` varchar(255)  ,
  `ASSIGNEE_` varchar(255)  ,
  `START_TIME_` datetime NOT NULL,
  `CLAIM_TIME_` datetime ,
  `END_TIME_` datetime ,
  `DURATION_` bigint(20) ,
  `DELETE_REASON_` varchar(4000)  ,
  `PRIORITY_` int(11) ,
  `DUE_DATE_` datetime ,
  `FORM_KEY_` varchar(255)  ,
  `CATEGORY_` varchar(255)  ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  `LAST_UPDATED_TIME_` datetime ,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_HI_TASK_SCOPE` (`SCOPE_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_IDX_HI_TASK_SUB_SCOPE` (`SUB_SCOPE_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_IDX_HI_TASK_SCOPE_DEF` (`SCOPE_DEFINITION_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_IDX_HI_TASK_INST_PROCINST` (`PROC_INST_ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;


-- ----------------------------
-- Table structure for ACT_HI_TSK_LOG
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_TSK_LOG`;
CREATE TABLE `ACT_HI_TSK_LOG` (
  `ID_` bigint(20) NOT NULL AUTO_INCREMENT,
  `TYPE_` varchar(64)  ,
  `TASK_ID_` varchar(64)  NOT NULL,
  `TIME_STAMP_` datetime(3),
  `USER_ID_` varchar(255)  ,
  `DATA_` varchar(4000)  ,
  `EXECUTION_ID_` varchar(64)  ,
  `PROC_INST_ID_` varchar(64)  ,
  `PROC_DEF_ID_` varchar(64)  ,
  `SCOPE_ID_` varchar(255)  ,
  `SCOPE_DEFINITION_ID_` varchar(255)  ,
  `SUB_SCOPE_ID_` varchar(255)  ,
  `SCOPE_TYPE_` varchar(255)  ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for ACT_HI_VARINST
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_VARINST`;
CREATE TABLE `ACT_HI_VARINST` (
  `ID_` varchar(64)  NOT NULL,
  `REV_` int(11) DEFAULT '1',
  `PROC_INST_ID_` varchar(64)  ,
  `EXECUTION_ID_` varchar(64)  ,
  `TASK_ID_` varchar(64)  ,
  `NAME_` varchar(255)  NOT NULL,
  `VAR_TYPE_` varchar(100)  ,
  `SCOPE_ID_` varchar(255)  ,
  `SUB_SCOPE_ID_` varchar(255)  ,
  `SCOPE_TYPE_` varchar(255)  ,
  `BYTEARRAY_ID_` varchar(64)  ,
  `DOUBLE_` double ,
  `LONG_` bigint(20) ,
  `TEXT_` varchar(4000)  ,
  `TEXT2_` varchar(4000)  ,
  `CREATE_TIME_` datetime ,
  `LAST_UPDATED_TIME_` datetime ,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_HI_PROCVAR_NAME_TYPE` (`NAME_`,`VAR_TYPE_`) USING BTREE,
  KEY `ACT_IDX_HI_VAR_SCOPE_ID_TYPE` (`SCOPE_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_IDX_HI_VAR_SUB_ID_TYPE` (`SUB_SCOPE_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_IDX_HI_PROCVAR_PROC_INST` (`PROC_INST_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_PROCVAR_TASK_ID` (`TASK_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_PROCVAR_EXE` (`EXECUTION_ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;



-- ----------------------------
-- Table structure for ACT_ID_BYTEARRAY
-- ----------------------------
DROP TABLE IF EXISTS `ACT_ID_BYTEARRAY`;
CREATE TABLE `ACT_ID_BYTEARRAY` (
  `ID_` varchar(64)  NOT NULL DEFAULT '',
  `REV_` int(11) ,
  `NAME_` varchar(255)  ,
  `BYTES_` longblob,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for ACT_ID_GROUP
-- ----------------------------
DROP TABLE IF EXISTS `ACT_ID_GROUP`;
CREATE TABLE `ACT_ID_GROUP` (
  `ID_` varchar(64)  NOT NULL DEFAULT '',
  `REV_` int(11) ,
  `NAME_` varchar(255)  ,
  `TYPE_` varchar(255)  ,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;



-- ----------------------------
-- Table structure for ACT_ID_INFO
-- ----------------------------
DROP TABLE IF EXISTS `ACT_ID_INFO`;
CREATE TABLE `ACT_ID_INFO` (
  `ID_` varchar(64)  NOT NULL DEFAULT '',
  `REV_` int(11) ,
  `USER_ID_` varchar(64)  ,
  `TYPE_` varchar(64)  ,
  `KEY_` varchar(255)  ,
  `VALUE_` varchar(255)  ,
  `PASSWORD_` longblob,
  `PARENT_ID_` varchar(255)  ,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for ACT_ID_MEMBERSHIP
-- ----------------------------
DROP TABLE IF EXISTS `ACT_ID_MEMBERSHIP`;
CREATE TABLE `ACT_ID_MEMBERSHIP` (
  `USER_ID_` varchar(64)  NOT NULL DEFAULT '',
  `GROUP_ID_` varchar(64)  NOT NULL DEFAULT '',
  PRIMARY KEY (`USER_ID_`,`GROUP_ID_`) USING BTREE,
  KEY `ACT_FK_MEMB_GROUP` (`GROUP_ID_`) USING BTREE,
  CONSTRAINT `ACT_FK_MEMB_GROUP` FOREIGN KEY (`GROUP_ID_`) REFERENCES `ACT_ID_GROUP` (`ID_`),
  CONSTRAINT `ACT_FK_MEMB_USER` FOREIGN KEY (`USER_ID_`) REFERENCES `ACT_ID_USER` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_ID_MEMBERSHIP
-- ----------------------------
BEGIN;
INSERT INTO `ACT_ID_MEMBERSHIP` VALUES ('1', '1');
INSERT INTO `ACT_ID_MEMBERSHIP` VALUES ('2', '1');
COMMIT;

-- ----------------------------
-- Table structure for ACT_ID_PRIV
-- ----------------------------
DROP TABLE IF EXISTS `ACT_ID_PRIV`;
CREATE TABLE `ACT_ID_PRIV` (
  `ID_` varchar(64)  NOT NULL,
  `NAME_` varchar(255)  NOT NULL,
  PRIMARY KEY (`ID_`) USING BTREE,
  UNIQUE KEY `ACT_UNIQ_PRIV_NAME` (`NAME_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for ACT_ID_PRIV_MAPPING
-- ----------------------------
DROP TABLE IF EXISTS `ACT_ID_PRIV_MAPPING`;
CREATE TABLE `ACT_ID_PRIV_MAPPING` (
  `ID_` varchar(64)  NOT NULL,
  `PRIV_ID_` varchar(64)  NOT NULL,
  `USER_ID_` varchar(255)  ,
  `GROUP_ID_` varchar(255)  ,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_FK_PRIV_MAPPING` (`PRIV_ID_`) USING BTREE,
  KEY `ACT_IDX_PRIV_USER` (`USER_ID_`) USING BTREE,
  KEY `ACT_IDX_PRIV_GROUP` (`GROUP_ID_`) USING BTREE,
  CONSTRAINT `ACT_FK_PRIV_MAPPING` FOREIGN KEY (`PRIV_ID_`) REFERENCES `ACT_ID_PRIV` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for ACT_ID_PROPERTY
-- ----------------------------
DROP TABLE IF EXISTS `ACT_ID_PROPERTY`;
CREATE TABLE `ACT_ID_PROPERTY` (
  `NAME_` varchar(64)  NOT NULL DEFAULT '',
  `VALUE_` varchar(300)  ,
  `REV_` int(11) ,
  PRIMARY KEY (`NAME_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_ID_PROPERTY
-- ----------------------------
BEGIN;
INSERT INTO `ACT_ID_PROPERTY` VALUES ('schema.version', '6.5.0.2', 1);
COMMIT;

-- ----------------------------
-- Table structure for ACT_ID_TOKEN
-- ----------------------------
DROP TABLE IF EXISTS `ACT_ID_TOKEN`;
CREATE TABLE `ACT_ID_TOKEN` (
  `ID_` varchar(64)  NOT NULL,
  `REV_` int(11) ,
  `TOKEN_VALUE_` varchar(255)  ,
  `TOKEN_DATE_` datetime(3),
  `IP_ADDRESS_` varchar(255)  ,
  `USER_AGENT_` varchar(255)  ,
  `USER_ID_` varchar(255)  ,
  `TOKEN_DATA_` varchar(2000)  ,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for ACT_ID_USER
-- ----------------------------
DROP TABLE IF EXISTS `ACT_ID_USER`;
CREATE TABLE `ACT_ID_USER` (
  `ID_` varchar(64)  NOT NULL DEFAULT '',
  `REV_` int(11) ,
  `FIRST_` varchar(255)  ,
  `LAST_` varchar(255)  ,
  `DISPLAY_NAME_` varchar(255)  ,
  `EMAIL_` varchar(255)  ,
  `PWD_` varchar(255)  ,
  `PICTURE_ID_` varchar(64)  ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;


-- ----------------------------
-- Table structure for ACT_PROCDEF_INFO
-- ----------------------------
DROP TABLE IF EXISTS `ACT_PROCDEF_INFO`;
CREATE TABLE `ACT_PROCDEF_INFO` (
  `ID_` varchar(64)  NOT NULL,
  `PROC_DEF_ID_` varchar(64)  NOT NULL,
  `REV_` int(11) ,
  `INFO_JSON_ID_` varchar(64)  ,
  PRIMARY KEY (`ID_`) USING BTREE,
  UNIQUE KEY `ACT_UNIQ_INFO_PROCDEF` (`PROC_DEF_ID_`) USING BTREE,
  KEY `ACT_IDX_INFO_PROCDEF` (`PROC_DEF_ID_`) USING BTREE,
  KEY `ACT_FK_INFO_JSON_BA` (`INFO_JSON_ID_`) USING BTREE,
  CONSTRAINT `ACT_FK_INFO_JSON_BA` FOREIGN KEY (`INFO_JSON_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_FK_INFO_PROCDEF` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `ACT_RE_PROCDEF` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for ACT_RE_DEPLOYMENT
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RE_DEPLOYMENT`;
CREATE TABLE `ACT_RE_DEPLOYMENT` (
  `ID_` varchar(64)  NOT NULL DEFAULT '',
  `NAME_` varchar(255)  ,
  `CATEGORY_` varchar(255)  ,
  `KEY_` varchar(255)  ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  `DEPLOY_TIME_` datetime(3) NULL ,
  `DERIVED_FROM_` varchar(64)  ,
  `DERIVED_FROM_ROOT_` varchar(64)  ,
  `PARENT_DEPLOYMENT_ID_` varchar(255)  ,
  `ENGINE_VERSION_` varchar(255)  ,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;



-- ----------------------------
-- Table structure for ACT_RE_MODEL
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RE_MODEL`;
CREATE TABLE `ACT_RE_MODEL` (
  `ID_` varchar(64)  NOT NULL,
  `REV_` int(11) ,
  `NAME_` varchar(255)  ,
  `KEY_` varchar(255)  ,
  `CATEGORY_` varchar(255)  ,
  `CREATE_TIME_` datetime(3)  ,
  `LAST_UPDATE_TIME_` datetime(3)  ,
  `VERSION_` int(11) ,
  `META_INFO_` varchar(4000)  ,
  `DEPLOYMENT_ID_` varchar(64)  ,
  `EDITOR_SOURCE_VALUE_ID_` varchar(64)  ,
  `EDITOR_SOURCE_EXTRA_VALUE_ID_` varchar(64)  ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_FK_MODEL_SOURCE` (`EDITOR_SOURCE_VALUE_ID_`) USING BTREE,
  KEY `ACT_FK_MODEL_SOURCE_EXTRA` (`EDITOR_SOURCE_EXTRA_VALUE_ID_`) USING BTREE,
  KEY `ACT_FK_MODEL_DEPLOYMENT` (`DEPLOYMENT_ID_`) USING BTREE,
  CONSTRAINT `ACT_FK_MODEL_DEPLOYMENT` FOREIGN KEY (`DEPLOYMENT_ID_`) REFERENCES `ACT_RE_DEPLOYMENT` (`ID_`),
  CONSTRAINT `ACT_FK_MODEL_SOURCE` FOREIGN KEY (`EDITOR_SOURCE_VALUE_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_FK_MODEL_SOURCE_EXTRA` FOREIGN KEY (`EDITOR_SOURCE_EXTRA_VALUE_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for ACT_RE_PROCDEF
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RE_PROCDEF`;
CREATE TABLE `ACT_RE_PROCDEF` (
  `ID_` varchar(64)  NOT NULL,
  `REV_` int(11) ,
  `CATEGORY_` varchar(255)  ,
  `NAME_` varchar(255)  ,
  `KEY_` varchar(255)  NOT NULL,
  `VERSION_` int(11) NOT NULL,
  `DEPLOYMENT_ID_` varchar(64)  ,
  `RESOURCE_NAME_` varchar(4000)  ,
  `DGRM_RESOURCE_NAME_` varchar(4000)  ,
  `DESCRIPTION_` varchar(4000)  ,
  `HAS_START_FORM_KEY_` tinyint(4) ,
  `HAS_GRAPHICAL_NOTATION_` tinyint(4) ,
  `SUSPENSION_STATE_` int(11) ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  `ENGINE_VERSION_` varchar(255)  ,
  `DERIVED_FROM_` varchar(64)  ,
  `DERIVED_FROM_ROOT_` varchar(64)  ,
  `DERIVED_VERSION_` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID_`) USING BTREE,
  UNIQUE KEY `ACT_UNIQ_PROCDEF` (`KEY_`,`VERSION_`,`DERIVED_VERSION_`,`TENANT_ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;


-- ----------------------------
-- Table structure for ACT_RE_PROCDEF_INSTANCE
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RE_PROCDEF_INSTANCE`;
CREATE TABLE `ACT_RE_PROCDEF_INSTANCE` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `PROC_INST_ID` varchar(64)  NOT NULL COMMENT '实例id',
  `PROC_DEF_ID` varchar(400)   COMMENT '定义ID',
  `MI_COMPLETE` char(2) CHARACTER SET utf8  COMMENT '是否完成',
  `CREATE_TIME` datetime(3),
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='实例模型表';

-- ----------------------------
-- Table structure for ACT_RE_PROCDEF_INSTANCE_MODEL
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RE_PROCDEF_INSTANCE_MODEL`;
CREATE TABLE `ACT_RE_PROCDEF_INSTANCE_MODEL` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `PROC_INST_ID` varchar(64)  NOT NULL COMMENT '实例id',
  `PROC_DEF_ID` varchar(400)   COMMENT '定义ID',
  `MI_COMPLETE` char(2) CHARACTER SET utf8  COMMENT '是否完成',
  `CREATE_TIME` datetime(3),
  `MODEL_EDITOR_XML` longblob COMMENT '模型内容',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='实例模型表';



-- ----------------------------
-- Table structure for ACT_RU_ACTINST
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_ACTINST`;
CREATE TABLE `ACT_RU_ACTINST` (
  `ID_` varchar(64)  NOT NULL,
  `REV_` int(11) DEFAULT '1',
  `PROC_DEF_ID_` varchar(64)  NOT NULL,
  `PROC_INST_ID_` varchar(64)  NOT NULL,
  `EXECUTION_ID_` varchar(64)  NOT NULL,
  `ACT_ID_` varchar(255)  NOT NULL,
  `TASK_ID_` varchar(64)  ,
  `CALL_PROC_INST_ID_` varchar(64)  ,
  `ACT_NAME_` varchar(255)  ,
  `ACT_TYPE_` varchar(255)  NOT NULL,
  `ASSIGNEE_` varchar(255)  ,
  `START_TIME_` datetime NOT NULL,
  `END_TIME_` datetime ,
  `DURATION_` bigint(20) ,
  `DELETE_REASON_` varchar(4000)  ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_RU_ACTI_START` (`START_TIME_`) USING BTREE,
  KEY `ACT_IDX_RU_ACTI_END` (`END_TIME_`) USING BTREE,
  KEY `ACT_IDX_RU_ACTI_PROC` (`PROC_INST_ID_`) USING BTREE,
  KEY `ACT_IDX_RU_ACTI_PROC_ACT` (`PROC_INST_ID_`,`ACT_ID_`) USING BTREE,
  KEY `ACT_IDX_RU_ACTI_EXEC` (`EXECUTION_ID_`) USING BTREE,
  KEY `ACT_IDX_RU_ACTI_EXEC_ACT` (`EXECUTION_ID_`,`ACT_ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;



-- ----------------------------
-- Table structure for ACT_RU_DEADLETTER_JOB
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_DEADLETTER_JOB`;
CREATE TABLE `ACT_RU_DEADLETTER_JOB` (
  `ID_` varchar(64)  NOT NULL,
  `REV_` int(11) ,
  `TYPE_` varchar(255)  NOT NULL,
  `EXCLUSIVE_` tinyint(1) ,
  `EXECUTION_ID_` varchar(64)  ,
  `PROCESS_INSTANCE_ID_` varchar(64)  ,
  `PROC_DEF_ID_` varchar(64)  ,
  `ELEMENT_ID_` varchar(255)  ,
  `ELEMENT_NAME_` varchar(255)  ,
  `SCOPE_ID_` varchar(255)  ,
  `SUB_SCOPE_ID_` varchar(255)  ,
  `SCOPE_TYPE_` varchar(255)  ,
  `SCOPE_DEFINITION_ID_` varchar(255)  ,
  `EXCEPTION_STACK_ID_` varchar(64)  ,
  `EXCEPTION_MSG_` varchar(4000)  ,
  `DUEDATE_` datetime(3) NULL ,
  `REPEAT_` varchar(255)  ,
  `HANDLER_TYPE_` varchar(255)  ,
  `HANDLER_CFG_` varchar(4000)  ,
  `CUSTOM_VALUES_ID_` varchar(64)  ,
  `CREATE_TIME_` datetime(3) NULL ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_DEADLETTER_JOB_EXCEPTION_STACK_ID` (`EXCEPTION_STACK_ID_`) USING BTREE,
  KEY `ACT_IDX_DEADLETTER_JOB_CUSTOM_VALUES_ID` (`CUSTOM_VALUES_ID_`) USING BTREE,
  KEY `ACT_IDX_DJOB_SCOPE` (`SCOPE_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_IDX_DJOB_SUB_SCOPE` (`SUB_SCOPE_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_IDX_DJOB_SCOPE_DEF` (`SCOPE_DEFINITION_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_FK_DEADLETTER_JOB_EXECUTION` (`EXECUTION_ID_`) USING BTREE,
  KEY `ACT_FK_DEADLETTER_JOB_PROCESS_INSTANCE` (`PROCESS_INSTANCE_ID_`) USING BTREE,
  KEY `ACT_FK_DEADLETTER_JOB_PROC_DEF` (`PROC_DEF_ID_`) USING BTREE,
  CONSTRAINT `ACT_FK_DEADLETTER_JOB_CUSTOM_VALUES` FOREIGN KEY (`CUSTOM_VALUES_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_FK_DEADLETTER_JOB_EXCEPTION` FOREIGN KEY (`EXCEPTION_STACK_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_FK_DEADLETTER_JOB_EXECUTION` FOREIGN KEY (`EXECUTION_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_FK_DEADLETTER_JOB_PROCESS_INSTANCE` FOREIGN KEY (`PROCESS_INSTANCE_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_FK_DEADLETTER_JOB_PROC_DEF` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `ACT_RE_PROCDEF` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for ACT_RU_ENTITYLINK
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_ENTITYLINK`;
CREATE TABLE `ACT_RU_ENTITYLINK` (
  `ID_` varchar(64)  NOT NULL DEFAULT '',
  `REV_` int(11) ,
  `CREATE_TIME_` datetime ,
  `LINK_TYPE_` varchar(255)  ,
  `SCOPE_ID_` varchar(255)  ,
  `SCOPE_TYPE_` varchar(255)  ,
  `SCOPE_DEFINITION_ID_` varchar(255)  ,
  `REF_SCOPE_ID_` varchar(255)  ,
  `REF_SCOPE_TYPE_` varchar(255)  ,
  `REF_SCOPE_DEFINITION_ID_` varchar(255)  ,
  `HIERARCHY_TYPE_` varchar(255)  ,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_ENT_LNK_SCOPE` (`SCOPE_ID_`,`SCOPE_TYPE_`,`LINK_TYPE_`) USING BTREE,
  KEY `ACT_IDX_ENT_LNK_SCOPE_DEF` (`SCOPE_DEFINITION_ID_`,`SCOPE_TYPE_`,`LINK_TYPE_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;


-- ----------------------------
-- Table structure for ACT_RU_EVENT_SUBSCR
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_EVENT_SUBSCR`;
CREATE TABLE `ACT_RU_EVENT_SUBSCR` (
  `ID_` varchar(64)  NOT NULL,
  `REV_` int(11) ,
  `EVENT_TYPE_` varchar(255)  NOT NULL,
  `EVENT_NAME_` varchar(255)  ,
  `EXECUTION_ID_` varchar(64)  ,
  `PROC_INST_ID_` varchar(64)  ,
  `ACTIVITY_ID_` varchar(64)  ,
  `CONFIGURATION_` varchar(255)  ,
  `CREATED_` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `PROC_DEF_ID_` varchar(64)  ,
  `SUB_SCOPE_ID_` varchar(64)  ,
  `SCOPE_ID_` varchar(64)  ,
  `SCOPE_DEFINITION_ID_` varchar(64)  ,
  `SCOPE_TYPE_` varchar(64)  ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_EVENT_SUBSCR_CONFIG_` (`CONFIGURATION_`) USING BTREE,
  KEY `ACT_FK_EVENT_EXEC` (`EXECUTION_ID_`) USING BTREE,
  CONSTRAINT `ACT_FK_EVENT_EXEC` FOREIGN KEY (`EXECUTION_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for ACT_RU_EXECUTION
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_EXECUTION`;
CREATE TABLE `ACT_RU_EXECUTION` (
  `ID_` varchar(64)  NOT NULL DEFAULT '',
  `REV_` int(11) ,
  `PROC_INST_ID_` varchar(64)  ,
  `BUSINESS_KEY_` varchar(255)  ,
  `PARENT_ID_` varchar(64)  ,
  `PROC_DEF_ID_` varchar(64)  ,
  `SUPER_EXEC_` varchar(64)  ,
  `ROOT_PROC_INST_ID_` varchar(64)  ,
  `ACT_ID_` varchar(255)  ,
  `IS_ACTIVE_` tinyint(4) ,
  `IS_CONCURRENT_` tinyint(4) ,
  `IS_SCOPE_` tinyint(4) ,
  `IS_EVENT_SCOPE_` tinyint(4) ,
  `IS_MI_ROOT_` tinyint(4) ,
  `SUSPENSION_STATE_` int(11) ,
  `CACHED_ENT_STATE_` int(11) ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  `NAME_` varchar(255)  ,
  `START_ACT_ID_` varchar(255)  ,
  `START_TIME_` datetime ,
  `START_USER_ID_` varchar(255)  ,
  `LOCK_TIME_` timestamp NULL ,
  `IS_COUNT_ENABLED_` tinyint(4) ,
  `EVT_SUBSCR_COUNT_` int(11) ,
  `TASK_COUNT_` int(11) ,
  `JOB_COUNT_` int(11) ,
  `TIMER_JOB_COUNT_` int(11) ,
  `SUSP_JOB_COUNT_` int(11) ,
  `DEADLETTER_JOB_COUNT_` int(11) ,
  `VAR_COUNT_` int(11) ,
  `ID_LINK_COUNT_` int(11) ,
  `CALLBACK_ID_` varchar(255)  ,
  `CALLBACK_TYPE_` varchar(255)  ,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_EXEC_BUSKEY` (`BUSINESS_KEY_`) USING BTREE,
  KEY `ACT_IDC_EXEC_ROOT` (`ROOT_PROC_INST_ID_`) USING BTREE,
  KEY `ACT_FK_EXE_PROCINST` (`PROC_INST_ID_`) USING BTREE,
  KEY `ACT_FK_EXE_PARENT` (`PARENT_ID_`) USING BTREE,
  KEY `ACT_FK_EXE_SUPER` (`SUPER_EXEC_`) USING BTREE,
  KEY `ACT_FK_EXE_PROCDEF` (`PROC_DEF_ID_`) USING BTREE,
  CONSTRAINT `ACT_FK_EXE_PARENT` FOREIGN KEY (`PARENT_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`) ON DELETE CASCADE,
  CONSTRAINT `ACT_FK_EXE_PROCDEF` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `ACT_RE_PROCDEF` (`ID_`),
  CONSTRAINT `ACT_FK_EXE_PROCINST` FOREIGN KEY (`PROC_INST_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ACT_FK_EXE_SUPER` FOREIGN KEY (`SUPER_EXEC_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;



-- ----------------------------
-- Table structure for ACT_RU_HISTORY_JOB
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_HISTORY_JOB`;
CREATE TABLE `ACT_RU_HISTORY_JOB` (
  `ID_` varchar(64)  NOT NULL,
  `REV_` int(11) ,
  `LOCK_EXP_TIME_` timestamp NULL ,
  `LOCK_OWNER_` varchar(255)  ,
  `RETRIES_` int(11) ,
  `EXCEPTION_STACK_ID_` varchar(64)  ,
  `EXCEPTION_MSG_` varchar(4000)  ,
  `HANDLER_TYPE_` varchar(255)  ,
  `HANDLER_CFG_` varchar(4000)  ,
  `CUSTOM_VALUES_ID_` varchar(64)  ,
  `ADV_HANDLER_CFG_ID_` varchar(64)  ,
  `CREATE_TIME_` timestamp NULL ,
  `SCOPE_TYPE_` varchar(255)  ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for ACT_RU_IDENTITYLINK
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_IDENTITYLINK`;
CREATE TABLE `ACT_RU_IDENTITYLINK` (
  `ID_` varchar(64)  NOT NULL DEFAULT '',
  `REV_` int(11) ,
  `GROUP_ID_` varchar(255)  ,
  `TYPE_` varchar(255)  ,
  `USER_ID_` varchar(255)  ,
  `TASK_ID_` varchar(64)  ,
  `PROC_INST_ID_` varchar(64)  ,
  `PROC_DEF_ID_` varchar(64)  ,
  `SCOPE_ID_` varchar(255)  ,
  `SCOPE_TYPE_` varchar(255)  ,
  `SCOPE_DEFINITION_ID_` varchar(255)  ,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_IDENT_LNK_USER` (`USER_ID_`) USING BTREE,
  KEY `ACT_IDX_IDENT_LNK_GROUP` (`GROUP_ID_`) USING BTREE,
  KEY `ACT_IDX_IDENT_LNK_SCOPE` (`SCOPE_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_IDX_IDENT_LNK_SCOPE_DEF` (`SCOPE_DEFINITION_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_IDX_ATHRZ_PROCEDEF` (`PROC_DEF_ID_`) USING BTREE,
  KEY `ACT_FK_TSKASS_TASK` (`TASK_ID_`) USING BTREE,
  KEY `ACT_FK_IDL_PROCINST` (`PROC_INST_ID_`) USING BTREE,
  CONSTRAINT `ACT_FK_ATHRZ_PROCEDEF` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `ACT_RE_PROCDEF` (`ID_`),
  CONSTRAINT `ACT_FK_IDL_PROCINST` FOREIGN KEY (`PROC_INST_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_FK_TSKASS_TASK` FOREIGN KEY (`TASK_ID_`) REFERENCES `ACT_RU_TASK` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;



-- ----------------------------
-- Table structure for ACT_RU_JOB
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_JOB`;
CREATE TABLE `ACT_RU_JOB` (
  `ID_` varchar(64)  NOT NULL,
  `REV_` int(11) ,
  `TYPE_` varchar(255)  NOT NULL,
  `LOCK_EXP_TIME_` timestamp NULL ,
  `LOCK_OWNER_` varchar(255)  ,
  `EXCLUSIVE_` tinyint(1) ,
  `EXECUTION_ID_` varchar(64)  ,
  `PROCESS_INSTANCE_ID_` varchar(64)  ,
  `PROC_DEF_ID_` varchar(64)  ,
  `ELEMENT_ID_` varchar(255)  ,
  `ELEMENT_NAME_` varchar(255)  ,
  `SCOPE_ID_` varchar(255)  ,
  `SUB_SCOPE_ID_` varchar(255)  ,
  `SCOPE_TYPE_` varchar(255)  ,
  `SCOPE_DEFINITION_ID_` varchar(255)  ,
  `RETRIES_` int(11) ,
  `EXCEPTION_STACK_ID_` varchar(64)  ,
  `EXCEPTION_MSG_` varchar(4000)  ,
  `DUEDATE_` timestamp NULL ,
  `REPEAT_` varchar(255)  ,
  `HANDLER_TYPE_` varchar(255)  ,
  `HANDLER_CFG_` varchar(4000)  ,
  `CUSTOM_VALUES_ID_` varchar(64)  ,
  `CREATE_TIME_` timestamp NULL ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_JOB_EXCEPTION_STACK_ID` (`EXCEPTION_STACK_ID_`) USING BTREE,
  KEY `ACT_IDX_JOB_CUSTOM_VALUES_ID` (`CUSTOM_VALUES_ID_`) USING BTREE,
  KEY `ACT_IDX_JOB_SCOPE` (`SCOPE_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_IDX_JOB_SUB_SCOPE` (`SUB_SCOPE_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_IDX_JOB_SCOPE_DEF` (`SCOPE_DEFINITION_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_FK_JOB_EXECUTION` (`EXECUTION_ID_`) USING BTREE,
  KEY `ACT_FK_JOB_PROCESS_INSTANCE` (`PROCESS_INSTANCE_ID_`) USING BTREE,
  KEY `ACT_FK_JOB_PROC_DEF` (`PROC_DEF_ID_`) USING BTREE,
  CONSTRAINT `ACT_FK_JOB_CUSTOM_VALUES` FOREIGN KEY (`CUSTOM_VALUES_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_FK_JOB_EXCEPTION` FOREIGN KEY (`EXCEPTION_STACK_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_FK_JOB_EXECUTION` FOREIGN KEY (`EXECUTION_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_FK_JOB_PROCESS_INSTANCE` FOREIGN KEY (`PROCESS_INSTANCE_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_FK_JOB_PROC_DEF` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `ACT_RE_PROCDEF` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for ACT_RU_SUSPENDED_JOB
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_SUSPENDED_JOB`;
CREATE TABLE `ACT_RU_SUSPENDED_JOB` (
  `ID_` varchar(64)  NOT NULL,
  `REV_` int(11) ,
  `TYPE_` varchar(255)  NOT NULL,
  `EXCLUSIVE_` tinyint(1) ,
  `EXECUTION_ID_` varchar(64)  ,
  `PROCESS_INSTANCE_ID_` varchar(64)  ,
  `PROC_DEF_ID_` varchar(64)  ,
  `ELEMENT_ID_` varchar(255)  ,
  `ELEMENT_NAME_` varchar(255)  ,
  `SCOPE_ID_` varchar(255)  ,
  `SUB_SCOPE_ID_` varchar(255)  ,
  `SCOPE_TYPE_` varchar(255)  ,
  `SCOPE_DEFINITION_ID_` varchar(255)  ,
  `RETRIES_` int(11) ,
  `EXCEPTION_STACK_ID_` varchar(64)  ,
  `EXCEPTION_MSG_` varchar(4000)  ,
  `DUEDATE_` timestamp NULL ,
  `REPEAT_` varchar(255)  ,
  `HANDLER_TYPE_` varchar(255)  ,
  `HANDLER_CFG_` varchar(4000)  ,
  `CUSTOM_VALUES_ID_` varchar(64)  ,
  `CREATE_TIME_` timestamp NULL ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_SUSPENDED_JOB_EXCEPTION_STACK_ID` (`EXCEPTION_STACK_ID_`) USING BTREE,
  KEY `ACT_IDX_SUSPENDED_JOB_CUSTOM_VALUES_ID` (`CUSTOM_VALUES_ID_`) USING BTREE,
  KEY `ACT_IDX_SJOB_SCOPE` (`SCOPE_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_IDX_SJOB_SUB_SCOPE` (`SUB_SCOPE_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_IDX_SJOB_SCOPE_DEF` (`SCOPE_DEFINITION_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_FK_SUSPENDED_JOB_EXECUTION` (`EXECUTION_ID_`) USING BTREE,
  KEY `ACT_FK_SUSPENDED_JOB_PROCESS_INSTANCE` (`PROCESS_INSTANCE_ID_`) USING BTREE,
  KEY `ACT_FK_SUSPENDED_JOB_PROC_DEF` (`PROC_DEF_ID_`) USING BTREE,
  CONSTRAINT `ACT_FK_SUSPENDED_JOB_CUSTOM_VALUES` FOREIGN KEY (`CUSTOM_VALUES_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_FK_SUSPENDED_JOB_EXCEPTION` FOREIGN KEY (`EXCEPTION_STACK_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_FK_SUSPENDED_JOB_EXECUTION` FOREIGN KEY (`EXECUTION_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_FK_SUSPENDED_JOB_PROCESS_INSTANCE` FOREIGN KEY (`PROCESS_INSTANCE_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_FK_SUSPENDED_JOB_PROC_DEF` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `ACT_RE_PROCDEF` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for ACT_RU_TASK
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_TASK`;
CREATE TABLE `ACT_RU_TASK` (
  `ID_` varchar(64)  NOT NULL DEFAULT '',
  `REV_` int(11) ,
  `EXECUTION_ID_` varchar(64)  ,
  `PROC_INST_ID_` varchar(64)  ,
  `PROC_DEF_ID_` varchar(64)  ,
  `TASK_DEF_ID_` varchar(64)  ,
  `SCOPE_ID_` varchar(255)  ,
  `SUB_SCOPE_ID_` varchar(255)  ,
  `SCOPE_TYPE_` varchar(255)  ,
  `SCOPE_DEFINITION_ID_` varchar(255)  ,
  `NAME_` varchar(255)  ,
  `PARENT_TASK_ID_` varchar(64)  ,
  `DESCRIPTION_` varchar(4000)  ,
  `TASK_DEF_KEY_` varchar(255)  ,
  `OWNER_` varchar(255)  ,
  `ASSIGNEE_` varchar(255)  ,
  `DELEGATION_` varchar(64)  ,
  `PRIORITY_` int(11) ,
  `CREATE_TIME_` timestamp NULL ,
  `DUE_DATE_` datetime ,
  `CATEGORY_` varchar(255)  ,
  `SUSPENSION_STATE_` int(11) ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  `FORM_KEY_` varchar(255)  ,
  `CLAIM_TIME_` datetime ,
  `IS_COUNT_ENABLED_` tinyint(4) ,
  `VAR_COUNT_` int(11) ,
  `ID_LINK_COUNT_` int(11) ,
  `SUB_TASK_COUNT_` int(11) ,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_TASK_CREATE` (`CREATE_TIME_`) USING BTREE,
  KEY `ACT_IDX_TASK_SCOPE` (`SCOPE_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_IDX_TASK_SUB_SCOPE` (`SUB_SCOPE_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_IDX_TASK_SCOPE_DEF` (`SCOPE_DEFINITION_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_FK_TASK_EXE` (`EXECUTION_ID_`) USING BTREE,
  KEY `ACT_FK_TASK_PROCINST` (`PROC_INST_ID_`) USING BTREE,
  KEY `ACT_FK_TASK_PROCDEF` (`PROC_DEF_ID_`) USING BTREE,
  CONSTRAINT `ACT_FK_TASK_EXE` FOREIGN KEY (`EXECUTION_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_FK_TASK_PROCDEF` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `ACT_RE_PROCDEF` (`ID_`),
  CONSTRAINT `ACT_FK_TASK_PROCINST` FOREIGN KEY (`PROC_INST_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;



-- ----------------------------
-- Table structure for ACT_RU_TIMER_JOB
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_TIMER_JOB`;
CREATE TABLE `ACT_RU_TIMER_JOB` (
  `ID_` varchar(64)  NOT NULL,
  `REV_` int(11) ,
  `TYPE_` varchar(255)  NOT NULL,
  `LOCK_EXP_TIME_` timestamp NULL ,
  `LOCK_OWNER_` varchar(255)  ,
  `EXCLUSIVE_` tinyint(1) ,
  `EXECUTION_ID_` varchar(64)  ,
  `PROCESS_INSTANCE_ID_` varchar(64)  ,
  `PROC_DEF_ID_` varchar(64)  ,
  `ELEMENT_ID_` varchar(255)  ,
  `ELEMENT_NAME_` varchar(255)  ,
  `SCOPE_ID_` varchar(255)  ,
  `SUB_SCOPE_ID_` varchar(255)  ,
  `SCOPE_TYPE_` varchar(255)  ,
  `SCOPE_DEFINITION_ID_` varchar(255)  ,
  `RETRIES_` int(11) ,
  `EXCEPTION_STACK_ID_` varchar(64)  ,
  `EXCEPTION_MSG_` varchar(4000)  ,
  `DUEDATE_` timestamp NULL ,
  `REPEAT_` varchar(255)  ,
  `HANDLER_TYPE_` varchar(255)  ,
  `HANDLER_CFG_` varchar(4000)  ,
  `CUSTOM_VALUES_ID_` varchar(64)  ,
  `CREATE_TIME_` timestamp NULL ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_TIMER_JOB_EXCEPTION_STACK_ID` (`EXCEPTION_STACK_ID_`) USING BTREE,
  KEY `ACT_IDX_TIMER_JOB_CUSTOM_VALUES_ID` (`CUSTOM_VALUES_ID_`) USING BTREE,
  KEY `ACT_IDX_TJOB_SCOPE` (`SCOPE_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_IDX_TJOB_SUB_SCOPE` (`SUB_SCOPE_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_IDX_TJOB_SCOPE_DEF` (`SCOPE_DEFINITION_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_FK_TIMER_JOB_EXECUTION` (`EXECUTION_ID_`) USING BTREE,
  KEY `ACT_FK_TIMER_JOB_PROCESS_INSTANCE` (`PROCESS_INSTANCE_ID_`) USING BTREE,
  KEY `ACT_FK_TIMER_JOB_PROC_DEF` (`PROC_DEF_ID_`) USING BTREE,
  CONSTRAINT `ACT_FK_TIMER_JOB_CUSTOM_VALUES` FOREIGN KEY (`CUSTOM_VALUES_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_FK_TIMER_JOB_EXCEPTION` FOREIGN KEY (`EXCEPTION_STACK_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_FK_TIMER_JOB_EXECUTION` FOREIGN KEY (`EXECUTION_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_FK_TIMER_JOB_PROCESS_INSTANCE` FOREIGN KEY (`PROCESS_INSTANCE_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_FK_TIMER_JOB_PROC_DEF` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `ACT_RE_PROCDEF` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for ACT_RU_VARIABLE
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_VARIABLE`;
CREATE TABLE `ACT_RU_VARIABLE` (
  `ID_` varchar(64)  NOT NULL,
  `REV_` int(11) ,
  `TYPE_` varchar(255)  NOT NULL,
  `NAME_` varchar(255)  NOT NULL,
  `EXECUTION_ID_` varchar(64)  ,
  `PROC_INST_ID_` varchar(64)  ,
  `TASK_ID_` varchar(64)  ,
  `SCOPE_ID_` varchar(255)  ,
  `SUB_SCOPE_ID_` varchar(255)  ,
  `SCOPE_TYPE_` varchar(255)  ,
  `BYTEARRAY_ID_` varchar(64)  ,
  `DOUBLE_` double ,
  `LONG_` bigint(20) ,
  `TEXT_` varchar(4000)  ,
  `TEXT2_` varchar(4000)  ,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_RU_VAR_SCOPE_ID_TYPE` (`SCOPE_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_IDX_RU_VAR_SUB_ID_TYPE` (`SUB_SCOPE_ID_`,`SCOPE_TYPE_`) USING BTREE,
  KEY `ACT_FK_VAR_BYTEARRAY` (`BYTEARRAY_ID_`) USING BTREE,
  KEY `ACT_IDX_VARIABLE_TASK_ID` (`TASK_ID_`) USING BTREE,
  KEY `ACT_FK_VAR_EXE` (`EXECUTION_ID_`) USING BTREE,
  KEY `ACT_FK_VAR_PROCINST` (`PROC_INST_ID_`) USING BTREE,
  CONSTRAINT `ACT_FK_VAR_BYTEARRAY` FOREIGN KEY (`BYTEARRAY_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_FK_VAR_EXE` FOREIGN KEY (`EXECUTION_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_FK_VAR_PROCINST` FOREIGN KEY (`PROC_INST_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;



-- ----------------------------
-- Table structure for DATABASECHANGELOG
-- ----------------------------
DROP TABLE IF EXISTS `DATABASECHANGELOG`;
CREATE TABLE `DATABASECHANGELOG` (
  `ID` varchar(255)  NOT NULL,
  `AUTHOR` varchar(255)  NOT NULL,
  `FILENAME` varchar(255)  NOT NULL,
  `DATEEXECUTED` datetime NOT NULL,
  `ORDEREXECUTED` int(11) NOT NULL,
  `EXECTYPE` varchar(10)  NOT NULL,
  `MD5SUM` varchar(35)  ,
  `DESCRIPTION` varchar(255)  ,
  `COMMENTS` varchar(255)  ,
  `TAG` varchar(255)  ,
  `LIQUIBASE` varchar(20)  ,
  `CONTEXTS` varchar(255)  ,
  `LABELS` varchar(255)  ,
  `DEPLOYMENT_ID` varchar(10)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of DATABASECHANGELOG
-- ----------------------------
BEGIN;
INSERT INTO `DATABASECHANGELOG` VALUES ('1', 'activiti', 'classpath:flowable-form-db-changelog.xml', '2019-11-08 21:55:19', 1, 'EXECUTED', '8:033ebf9380889aed7c453927ecc3250d', 'createTable tableName=ACT_FO_FORM_DEPLOYMENT; createTable tableName=ACT_FO_FORM_RESOURCE; createTable tableName=ACT_FO_FORM_DEFINITION; createTable tableName=ACT_FO_FORM_INSTANCE', '', NULL, '3.6.3', NULL, NULL, '3221318872');
INSERT INTO `DATABASECHANGELOG` VALUES ('2', 'flowable', 'classpath:flowable-form-db-changelog.xml', '2019-11-08 21:55:19', 2, 'EXECUTED', '8:986365ceb40445ce3b27a8e6b40f159b', 'addColumn tableName=ACT_FO_FORM_INSTANCE', '', NULL, '3.6.3', NULL, NULL, '3221318872');
INSERT INTO `DATABASECHANGELOG` VALUES ('3', 'flowable', 'classpath:flowable-form-db-changelog.xml', '2019-11-08 21:55:19', 3, 'EXECUTED', '8:abf482518ceb09830ef674e52c06bf15', 'dropColumn columnName=PARENT_DEPLOYMENT_ID_, tableName=ACT_FO_FORM_DEFINITION', '', NULL, '3.6.3', NULL, NULL, '3221318872');
INSERT INTO `DATABASECHANGELOG` VALUES ('4', 'flowable', 'classpath:flowable-form-db-changelog.xml', '2019-11-08 21:55:19', 4, 'EXECUTED', '8:2087829f22a4b2298dbf530681c74854', 'modifyDataType columnName=DEPLOY_TIME_, tableName=ACT_FO_FORM_DEPLOYMENT; modifyDataType columnName=SUBMITTED_DATE_, tableName=ACT_FO_FORM_INSTANCE', '', NULL, '3.6.3', NULL, NULL, '3221318872');
INSERT INTO `DATABASECHANGELOG` VALUES ('5', 'flowable', 'classpath:flowable-form-db-changelog.xml', '2019-11-08 21:55:19', 5, 'EXECUTED', '8:b4be732b89e5ca028bdd520c6ad4d446', 'createIndex indexName=ACT_IDX_FORM_DEF_UNIQ, tableName=ACT_FO_FORM_DEFINITION', '', NULL, '3.6.3', NULL, NULL, '3221318872');
COMMIT;

-- ----------------------------
-- Table structure for DATABASECHANGELOGLOCK
-- ----------------------------
DROP TABLE IF EXISTS `DATABASECHANGELOGLOCK`;
CREATE TABLE `DATABASECHANGELOGLOCK` (
  `ID` int(11) NOT NULL,
  `LOCKED` bit(1) NOT NULL,
  `LOCKGRANTED` datetime ,
  `LOCKEDBY` varchar(255)  ,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of DATABASECHANGELOGLOCK
-- ----------------------------
BEGIN;
INSERT INTO `DATABASECHANGELOGLOCK` VALUES (1, b'0', NULL, NULL);
COMMIT;

-- ----------------------------
-- Table structure for FLW_RU_BATCH
-- ----------------------------
DROP TABLE IF EXISTS `FLW_RU_BATCH`;
CREATE TABLE `FLW_RU_BATCH` (
  `ID_` varchar(64)  NOT NULL,
  `REV_` int(11) ,
  `TYPE_` varchar(64)  NOT NULL,
  `SEARCH_KEY_` varchar(255)  ,
  `SEARCH_KEY2_` varchar(255)  ,
  `CREATE_TIME_` datetime NOT NULL,
  `COMPLETE_TIME_` datetime ,
  `STATUS_` varchar(255)  ,
  `BATCH_DOC_ID_` varchar(64)  ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for FLW_RU_BATCH_PART
-- ----------------------------
DROP TABLE IF EXISTS `FLW_RU_BATCH_PART`;
CREATE TABLE `FLW_RU_BATCH_PART` (
  `ID_` varchar(64)  NOT NULL,
  `REV_` int(11) ,
  `BATCH_ID_` varchar(64)  ,
  `TYPE_` varchar(64)  NOT NULL,
  `SCOPE_ID_` varchar(64)  ,
  `SUB_SCOPE_ID_` varchar(64)  ,
  `SCOPE_TYPE_` varchar(64)  ,
  `SEARCH_KEY_` varchar(255)  ,
  `SEARCH_KEY2_` varchar(255)  ,
  `CREATE_TIME_` datetime NOT NULL,
  `COMPLETE_TIME_` datetime ,
  `STATUS_` varchar(255)  ,
  `RESULT_DOC_ID_` varchar(64)  ,
  `TENANT_ID_` varchar(255)  DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `FLW_IDX_BATCH_PART` (`BATCH_ID_`) USING BTREE,
  CONSTRAINT `FLW_FK_BATCH_PART_PARENT` FOREIGN KEY (`BATCH_ID_`) REFERENCES `FLW_RU_BATCH` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for PANGU_BPM_AGENT_DEF
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_BPM_AGENT_DEF`;
CREATE TABLE `PANGU_BPM_AGENT_DEF` (
  `ID` varchar(255)  NOT NULL COMMENT '主键id',
  `SETTING_ID` varchar(64)   COMMENT '设定ID',
  `FLOW_KEY` varchar(64)   COMMENT '流程定义KEY',
  `FLOW_NAME` varchar(64)   COMMENT '流程定义名称',
  `NODE_ID` varchar(64)   COMMENT '节点定义ID(为空的情况,如果指定ID,那么代理只在这些ID的任务生效)',
  `NODE_NAME` varchar(128)   COMMENT '节点名称  ',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='代理指定的流程';

-- ----------------------------
-- Table structure for PANGU_BPM_AGENT_SETTING
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_BPM_AGENT_SETTING`;
CREATE TABLE `PANGU_BPM_AGENT_SETTING` (
  `ID` varchar(255)  NOT NULL COMMENT '主键id',
  `SUBJECT` varchar(64)   COMMENT '标题',
  `AUTH_ID` varchar(64)   COMMENT '授权人ID',
  `AUTH_NAME` varchar(64)   COMMENT '授权人姓名',
  `START_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '开始生效时间',
  `END_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '失效时间 ',
  `CREATE_BY` varchar(64)   COMMENT '创建人ID',
  `CREATE_TIME` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间    ',
  `IS_ENABLED` tinyint(4)  COMMENT '是否有效',
  `AGENT_ID` varchar(64)   COMMENT '代理人ID',
  `AGENT_NAME` varchar(64)   COMMENT '代理人',
  `TYPE` int(11)  COMMENT '代理范围 1,全部流程,2,部分流程,3.流程节点',
  `UPDATE_BY` varchar(64)   COMMENT '更新人ID',
  `UPDATE_TIME` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  `TENANT_ID` varchar(64)   COMMENT '租户id',
  `OPINION` varchar(64)   COMMENT '委托说明',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='流程代理设置';


-- ----------------------------
-- Table structure for PANGU_BPM_CMD_LOG
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_BPM_CMD_LOG`;
CREATE TABLE `PANGU_BPM_CMD_LOG` (
  `ID_` int(11) NOT NULL AUTO_INCREMENT,
  `name_` varchar(255)   COMMENT '名称',
  `start_Time_` datetime  COMMENT '开始时间',
  `end_Time_` datetime  COMMENT '结束时间',
  `total_Time_` bigint(20)  COMMENT '耗时',
  `batch_id_` varchar(255)   COMMENT '批次号',
  `class_name_` varchar(255)   COMMENT '类名',
  `command_Percent_age` varchar(64)   COMMENT '总时间',
  `profile_session_` varchar(255)   COMMENT '配置文件会话数百分比',
  `Average_database_time_` bigint(20) ,
  `Average_execution_time_` bigint(20) ,
  `Average_Database_Execution_Time_Percentage_` bigint(20) ,
  `select_json_` longblob,
  `inserts_json_` longblob,
  `updates_json_` longblob,
  `delete_json_` longblob,
  `Total_Command_Time_` bigint(20) ,
  `count_` bigint(20) ,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;



-- ----------------------------
-- Table structure for PANGU_BPM_COMMU_RECEIVER
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_BPM_COMMU_RECEIVER`;
CREATE TABLE `PANGU_BPM_COMMU_RECEIVER` (
  `ID` varchar(255)  NOT NULL COMMENT '主键id',
  `COMMU_ID` varchar(64)   COMMENT '通知ID',
  `COMMU` varchar(64)   COMMENT '通知人',
  `BATCH_ID` varchar(64)   COMMENT '批次号',
  `TITLE` varchar(255)   COMMENT '标题',
  `RECEIVER_ID` varchar(64)   COMMENT '接收人ID',
  `RECEIVER` varchar(64)   COMMENT '接收人',
  `IS_READ` tinyint(4)  COMMENT '已读',
  `OPINION` varchar(64)   COMMENT '反馈意见',
  `STATUS` varchar(64)  DEFAULT '0' COMMENT '状态',
  `RECEIVE_TIME`  datetime(3) COMMENT '接收时间 ',
  `READ_TIME`  datetime(3) COMMENT '读取时间',
  `COMMU_TIME`  datetime(3) COMMENT '通知时间 ',
  `PROC_DEF_id` varchar(64)   COMMENT '流程定义id',
  `PROC_ID` varchar(64)   COMMENT '流程实例id',
  `task_ID` varchar(64)   COMMENT '任务ID',
  `TYPE_KEY` varchar(64)   COMMENT '分类key',
  `TYPE_TITLE` varchar(64)   COMMENT '分类标题',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='送阅表';



-- ----------------------------
-- Table structure for PANGU_BPM_JMS_TASK_COMMU_LOG
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_BPM_JMS_TASK_COMMU_LOG`;
CREATE TABLE `PANGU_BPM_JMS_TASK_COMMU_LOG` (
  `ID` varchar(255) COLLATE utf8mb4_bin NOT NULL COMMENT '主键',
  `TASK_ID` varchar(255) COLLATE utf8mb4_bin DEFAULT '' COMMENT '任务id',
  `PROC_ID` varchar(255) COLLATE utf8mb4_bin  COMMENT '流程实例id',
  `EXECUTION_ID` varchar(255) COLLATE utf8mb4_bin  COMMENT '执行实例id',
  `CREATE_USER_ID` varchar(255) COLLATE utf8mb4_bin  COMMENT '创建人id',
  `CREATE_USER_NAME` varchar(255) COLLATE utf8mb4_bin  COMMENT '创建人名称',
  `RECEIVER_USER_ID` varchar(255) COLLATE utf8mb4_bin  COMMENT '接受人Id',
  `RECEIVER_USER_NAME` varchar(255) COLLATE utf8mb4_bin  COMMENT '接受人名称',
  `USER_TYPE` varchar(255) COLLATE utf8mb4_bin  COMMENT '用户类型',
  `TEMPLATE_TYPE` varchar(255) COLLATE utf8mb4_bin  COMMENT '任务流转：bpmntasktrans 审批模板默认 bpmnapproval 流程结束默认  processend',
  `CREATE_TIME` datetime ,
  `CONTENT` varchar(255) COLLATE utf8mb4_bin DEFAULT '' COMMENT '内容',
  `TYPE_KEY` varchar(255) COLLATE utf8mb4_bin  COMMENT '分类key',
  `CONTENT_HTML` varchar(255) COLLATE utf8mb4_bin DEFAULT '' COMMENT '内容',
  `NOTICE_TYPE` varchar(255) COLLATE utf8mb4_bin DEFAULT '' COMMENT '通知类型',
  `IS_READ` tinyint(2) DEFAULT '0' COMMENT '是否已读',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='通知表';



-- ----------------------------
-- Table structure for PANGU_BPM_MSG_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_BPM_MSG_TEMPLATE`;
CREATE TABLE `PANGU_BPM_MSG_TEMPLATE` (
  `ID` int(11) NOT NULL COMMENT '主键',
  `NAME` varchar(255) COLLATE utf8mb4_bin DEFAULT '' COMMENT '名称',
  `KEY_NAME` varchar(255) COLLATE utf8mb4_bin  COMMENT '分类前缀',
  `TYPE_KEY` varchar(255) COLLATE utf8mb4_bin  COMMENT '分类key',
  `IS_DEFAULT` varchar(255) COLLATE utf8mb4_bin  COMMENT '是否是默认的',
  `SUBJECT` varchar(255) COLLATE utf8mb4_bin  COMMENT '内容',
  `PLAIN` varchar(255) COLLATE utf8mb4_bin  COMMENT '明文',
  `HTML` varchar(255) COLLATE utf8mb4_bin  COMMENT 'html',
  `SUBJECT_TEMPLATE` varchar(255) COLLATE utf8mb4_bin  COMMENT '内容模板',
  `PLAIN_TEMPLATE` varchar(255) COLLATE utf8mb4_bin  COMMENT '明文模板',
  `HTML_TEMPLATE` varchar(255) COLLATE utf8mb4_bin  COMMENT 'html模板',
  `DISABLED` tinyint(2) DEFAULT '0' COMMENT '是否禁用',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='消息模板';

-- ----------------------------
-- Records of PANGU_BPM_MSG_TEMPLATE
-- ----------------------------
BEGIN;
INSERT INTO `PANGU_BPM_MSG_TEMPLATE` VALUES (1, '任务创建默认', 'taskcreate-default', 'taskcreate', '0', '任务创建通知', '任务创建：流程实例：${instSubject}，执行到${nodeName}', '任务创建：流程实例<a href=\\\"#\\\">${instSubject}</a>，执行到${nodeName}', '任务创建通知', '任务创建：流程实例：${instSubject}，执行到${nodeName}', '任务创建：流程实例<a href=\\\"#\\\">${instSubject}</a>，执行到${nodeName}', 0);
INSERT INTO `PANGU_BPM_MSG_TEMPLATE` VALUES (2, '任务沟通默认', 'bpmcommusend-default', 'bpmcommusend', '1', '任务沟通', '任务沟通提醒，${receiver}您好,任务：${taskSubject}需要与您交流，请给出意见。', '任务沟通提醒，${receiver}您好,任务：${taskSubject}需要与您交流，请给出意见。', '任务沟通', '任务沟通提醒，${receiver}您好,任务：${taskSubject}需要与您交流，请给出意见。', '任务沟通提醒，${receiver}您好,任务：${taskSubject}需要与您交流，请给出意见。', 1);
INSERT INTO `PANGU_BPM_MSG_TEMPLATE` VALUES (3, '通知被代理人', 'bpmndelegate-default', 'bpmndelegate', '1', '通知被代理人', '代理通知，您的任务：${taskSubject}，代理给${agent}', '代理通知：<br />您的任务<a href=\\\"#\\\">${taskSubject}</a>，代理给${agent}', '通知被代理人', '代理通知，您的任务：${taskSubject}，代理给${agent}', '代理通知：<br />您的任务<a href=\\\"#\\\">${taskSubject}</a>，代理给${agent}', 1);
INSERT INTO `PANGU_BPM_MSG_TEMPLATE` VALUES (4, '任务沟通反馈信息', 'bpmcommufeedback-default', 'bpmcommufeedback', '1', '通知沟通人', '流程任务沟通 已经给出意见', '流程任务沟通 已经给出意见', '通知沟通人', '流程任务沟通 已经给出意见', '流程任务沟通 已经给出意见', 1);
INSERT INTO `PANGU_BPM_MSG_TEMPLATE` VALUES (5, '任务流转默认', 'bpmntasktrans-default', 'bpmntasktrans', '1', '任务流转默认', '${cause}', '任务流转通知：${instSubject}的${nodeName}任务，已经流转给你。', '任务流转默认', '${cause}', '任务流转通知：${instSubject}的${nodeName}任务，已经流转给你。', 1);
INSERT INTO `PANGU_BPM_MSG_TEMPLATE` VALUES (6, '任务创建默认', 'bpmhandto-default', 'bpmhandto', '1', '任务转交通知', '任务转交：流程实例：${instSubject}的${nodeName}任务，已经转交给你办理。', '任务转交：流程实例<a href=\\\"#\\\">${instSubject}</a>，需要你办理。', '任务转交通知', '任务转交：流程实例：${instSubject}的${nodeName}任务，已经转交给你办理。', '任务转交：流程实例<a href=\\\"#\\\">${instSubject}</a>，需要你办理。', 1);
INSERT INTO `PANGU_BPM_MSG_TEMPLATE` VALUES (7, '加签', 'bpmaddsigntask-default', 'addsigntask', '1', '加签通知', '加签通知，${sender}将任务：${taskSubject}转交给您', '加签通知：<br />${sender}邀请你参与会签任务<a href=\\\"#\\\">${taskSubject}</a>,加签原因:${cause}', '加签通知', '加签通知，${sender}将任务：${taskSubject}转交给您', '加签通知：<br />${sender}邀请你参与会签任务<a href=\\\"#\\\">${taskSubject}</a>,加签原因:${cause}', 1);
INSERT INTO `PANGU_BPM_MSG_TEMPLATE` VALUES (8, '任务完成默认', 'taskcomplete-default', 'taskcomplete', '1', '任务完成通知', '${nodeName}完成：流程实例: ${instSubject}完成.', '${nodeName}完成：流程实例: ${instSubject}完成.', '任务完成通知', '${nodeName}完成：流程实例: ${instSubject}完成.', '${nodeName}完成：流程实例: ${instSubject}完成.', 1);
INSERT INTO `PANGU_BPM_MSG_TEMPLATE` VALUES (9, '任务驳回默认', 'taskback-default', 'taskback', '1', '任务驳回通知', '任务驳回：流程实例：${instSubject}，驳回原因:${cause}', '任务驳回：流程实例：${instSubject}，驳回原因:${cause}', '任务驳回通知', '任务驳回：流程实例：${instSubject}，驳回原因:${cause}', '任务驳回：流程实例：${instSubject}，驳回原因:${cause}', 1);
INSERT INTO `PANGU_BPM_MSG_TEMPLATE` VALUES (10, '流程实例抄送', 'copyto-default', 'copyto', '1', '流程实例抄送', '流程实例抄送：流程${taskSubject}的${instId}实例，已经抄送给您。', NULL, '流程实例抄送', '流程实例抄送：流程${taskSubject}的${procId}实例，已经抄送给您。', '流程实例抄送：流程${taskSubject}的${procId}实例，已经抄送给您。', 1);
INSERT INTO `PANGU_BPM_MSG_TEMPLATE` VALUES (11, '流程结束默认', 'processend-default', 'processend', '1', '流程结束通知', '流程实例结束：${instSubject}，意见:${cause}。', '流程实例结束<a href=\\\"#\\\">${instSubject}</a>，意见:${cause}。', '流程结束通知', '流程实例结束：${instSubject}，意见:${cause}。', '流程实例结束<a href=\\\"#\\\">${instSubject}</a>，意见:${cause}。', 1);
INSERT INTO `PANGU_BPM_MSG_TEMPLATE` VALUES (12, '撤销流转默认', 'bpmtranscancel-default', 'bpmtranscancel', '1', '流转撤销通知', '流转撤销：流程实例：${instSubject}的${nodeName}流转任务，已被撤销。', '流转撤销：流程实例：${instSubject}的${nodeName}流转任务，已被撤销。', '流转撤销通知', '流转撤销：流程实例：${instSubject}的${nodeName}流转任务，已被撤销。', '流转撤销：流程实例：${instSubject}的${nodeName}流转任务，已被撤销。', 0);
INSERT INTO `PANGU_BPM_MSG_TEMPLATE` VALUES (13, '审批模板默认', 'bpmnapproval-default', 'bpmnapproval', '1', '审批提醒', '审批提醒，您有新的工作流需要审批：${taskSubject}。', '审批提醒：<br />您有新的工作流需要审批<a href=\\\"#\\\">${taskSubject}</a>', '审批提醒', '审批提醒，您有新的工作流需要审批：${taskSubject}。', '审批提醒：<br />您有新的工作流需要审批<a href=\\\"#\\\">${taskSubject}</a>', 1);
INSERT INTO `PANGU_BPM_MSG_TEMPLATE` VALUES (14, '驳回模板默认', 'bpmnback-default', 'bpmnback', '1', '驳回提醒', '驳回提醒，您的：${taskSubject}，请求被驳回，请处理!', '驳回提醒：<br />您的<a href=\\\"#\\\">${taskSubject}</a>请求被驳回，请处理!', '驳回提醒', '驳回提醒，您的：${taskSubject}，请求被驳回，请处理!', '驳回提醒：<br />您的<a href=\\\"#\\\">${taskSubject}</a>请求被驳回，请处理!', 1);
INSERT INTO `PANGU_BPM_MSG_TEMPLATE` VALUES (15, '撤销提醒默认', 'bpmnrecover-default', 'bpmnrecover', '1', '撤销提醒', '撤销提醒，审批任务${taskSubject}被撤销，撤销原因${cause} 原因通过cmd获取。', '撤销提醒：<br />审批任务${taskSubject}被撤销，撤销原因${cause}。', '撤销提醒', '撤销提醒，审批任务${taskSubject}被撤销，撤销原因${cause} 原因通过cmd获取。', '撤销提醒：<br />审批任务${taskSubject}被撤销，撤销原因${cause}。', 1);
INSERT INTO `PANGU_BPM_MSG_TEMPLATE` VALUES (16, '通知代理人', 'bpmnagent-default', 'bpmnagent', '1', '代理任务审批', '代理任务审批，您有新的代理任务需要审批：${taskSubject}，委托人${delegate}.', '代理任务审批：<br />您有新的代理任务需要审批<a href=\\\"#\\\">${taskSubject}</a>，委托人${delegate}.', '代理任务审批', '代理任务审批，您有新的代理任务需要审批：${taskSubject}，委托人${delegate}.', '代理任务审批：<br />您有新的代理任务需要审批<a href=\\\"#\\\">${taskSubject}</a>，委托人${delegate}.', 1);
INSERT INTO `PANGU_BPM_MSG_TEMPLATE` VALUES (17, '实例作废默认', 'bpmendprocess-defaultbpmendprocess-default', 'bpmendprocess', '1', '实例作废通知', '实例作废通知：${instSubject}，意见:${cause}。', '实例作废<a href=\\\"#\\\">${instSubject}</a>，意见:${cause}。', '实例作废通知', '实例作废通知：${instSubject}，意见:${cause}。', '流程实例结束<a href=\\\"#\\\">${instSubject}</a>，意见:${cause}。', 1);
COMMIT;

-- ----------------------------
-- Table structure for PANGU_BPM_SIMULATION_LOG
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_BPM_SIMULATION_LOG`;
CREATE TABLE `PANGU_BPM_SIMULATION_LOG` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `BUSINESS_KEY` varchar(64)  NOT NULL COMMENT '业务键',
  `PROC_INST_ID` varchar(64)   COMMENT '实例id',
  `PROC_DEF_ID` varchar(64)   COMMENT '定义ID',
  `CREATE_TIME` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `END_TIME` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `RUN_LOG` longblob COMMENT '运行日志',
  `EXPECTION_INFO` longblob COMMENT '日志信息',
  `IS_COMPLETE` bit(1)  COMMENT '是否正常完成',
  `IS_DELETE` bit(1)  COMMENT '是否删除相关数据',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='仿真运行日志表';



-- ----------------------------
-- Table structure for PANGU_BPM_SQL_LOG
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_BPM_SQL_LOG`;
CREATE TABLE `PANGU_BPM_SQL_LOG` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `sql_content` varchar(2000) COLLATE utf8mb4_bin ,
  `sql_Id` varchar(255) COLLATE utf8mb4_bin ,
  `resource` varchar(255) COLLATE utf8mb4_bin ,
  `MY_Batis_Id` varchar(255) COLLATE utf8mb4_bin ,
  `cost_Time` varchar(255) COLLATE utf8mb4_bin ,
  `sql_command_type` varchar(255) COLLATE utf8mb4_bin ,
  `create_time` timestamp NULL ,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;


-- ----------------------------
-- Table structure for PANGU_BPM_TASK_DELAYED
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_BPM_TASK_DELAYED`;
CREATE TABLE `PANGU_BPM_TASK_DELAYED` (
  `ID` varchar(255) COLLATE utf8mb4_bin NOT NULL COMMENT '主键',
  `task_id` varchar(255) COLLATE utf8mb4_bin DEFAULT '' COMMENT '任务id',
  `proc_id` varchar(255) COLLATE utf8mb4_bin ,
  `execution_id` varchar(255) COLLATE utf8mb4_bin ,
  `create_user_id` varchar(255) COLLATE utf8mb4_bin ,
  `create_user_name` varchar(255) COLLATE utf8mb4_bin ,
  `type` varchar(255) COLLATE utf8mb4_bin  COMMENT '1延时 2 暂停',
  `create_time` datetime ,
  `is_complete` tinyint(2) DEFAULT '0' COMMENT '是否完成',
  `disabled` tinyint(2) DEFAULT '0' COMMENT '是否禁用',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='任务延期';

-- ----------------------------
-- Table structure for PANGU_BPM_TRANSFER_TASK_LOG
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_BPM_TRANSFER_TASK_LOG`;
CREATE TABLE `PANGU_BPM_TRANSFER_TASK_LOG` (
  `ID` varchar(255)  NOT NULL COMMENT '主键id',
  `PREVIOUS_ASSIGNEE_ID` varchar(64)   COMMENT '原有任务办理人id',
  `PREVIOUS_ASSIGNEE_NAME` varchar(64)   COMMENT '原有任务办理人',
  `NEW_ASSIGNEE_ID` varchar(64)   COMMENT '新的任务处理人id',
  `NEW_ASSIGNEE_NAME` varchar(64)   COMMENT '新的任务处理人',
  `OPINION` varchar(64)   COMMENT '反馈意见',
  `CREATE_TIME` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建事件  ',
  `PROC_ID` varchar(64)   COMMENT '流程实例id',
  `task_ID` varchar(64)   COMMENT '任务ID',
  `execution_ID` varchar(64)   COMMENT '实例ID',
  `PROC_DEF_id` varchar(64)   COMMENT '流程定义id',
  `TYPE` varchar(64)   COMMENT '操作类型(copyto抄送,trans转办)',
  `TYPE_ID` varchar(64)   COMMENT '分类',
  `end_TIME` timestamp NULL  COMMENT '结束时间',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='处理人改动日志表';


-- ----------------------------
-- Table structure for PANGU_CMMN_MODEL
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_CMMN_MODEL`;
CREATE TABLE `PANGU_CMMN_MODEL` (
  `ID` varchar(255)  NOT NULL COMMENT '主键id',
  `NAME` varchar(64)   COMMENT '名称',
  `MODEL_KEY` varchar(400)   COMMENT '模型key',
  `DESCRIPTION` varchar(200)   COMMENT '模型描述',
  `MODEL_COMMENT` int(11)  COMMENT '模型评论',
  `CREATED` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `CREATED_BY` varchar(255)   COMMENT '创建人',
  `LAST_UPDATED` timestamp NULL  ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `LAST_UPDATED_BY` varchar(64)   COMMENT '更新人',
  `VERSION` int(11) DEFAULT '0' COMMENT '版本',
  `MODEL_EDITOR_XML` longblob COMMENT '模型内容',
  `TYPE_CODE` varchar(64)   COMMENT '分类code',
  `STATUS` varchar(255)  DEFAULT '0' COMMENT '状态，部署或者保存',
  `DEF_ID` varchar(64)   COMMENT '定义id',
  `DEF_KEY` varchar(64)   COMMENT '定义key',
  `DEPLOY_ID` varchar(64)   COMMENT '部署id',
  `MAIN_PROCESS` int(4)  COMMENT '是否是主版本',
  `REASON` varchar(255)   COMMENT '修改原因',
  `TENANT_ID` varchar(255)  DEFAULT '' COMMENT '租户id',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='定义模型表';



-- ----------------------------
-- Table structure for PANGU_DMN_HI_DECISION_EXECUTION
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_DMN_HI_DECISION_EXECUTION`;
CREATE TABLE `PANGU_DMN_HI_DECISION_EXECUTION` (
  `ID` varchar(255)  NOT NULL COMMENT '主键',
  `DECISION_DEFINITION_ID` varchar(255)   COMMENT '决策定义id',
  `DEPLOYMENT_ID` varchar(255)   COMMENT '部署id',
  `START_TIME` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '开始时间',
  `END_TIME` datetime(3) COMMENT '结束时间',
  `INSTANCE_ID` varchar(255)   COMMENT '实例id',
  `EXECUTION_ID` varchar(255)   COMMENT '执行实例id',
  `ACTIVITY_ID` varchar(255)   COMMENT '活动id',
  `FAILED` tinyint(4)  COMMENT '是否成功',
  `TENANT_ID` varchar(64)   COMMENT '租户id',
  `EXECUTION_JSON` longblob COMMENT '执行结果',
  `SCOPE_TYPE` varchar(255)   COMMENT '执行引擎',
  `CATEGORY` varchar(255)   COMMENT '分类',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='DMN运行记录';


-- ----------------------------
-- Table structure for PANGU_DMN_MODEL
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_DMN_MODEL`;
CREATE TABLE `PANGU_DMN_MODEL` (
  `ID` varchar(255)  NOT NULL COMMENT '主键',
  `NAME` varchar(255)   COMMENT '名称',
  `Model_KEY` varchar(255)   COMMENT 'key',
  `DESCRIPTION` varchar(255)   COMMENT '描述',
  `CATEGORY` varchar(255)   COMMENT '分类',
  `DMN_XML` longblob COMMENT 'DMN内容',
  `STATUS` varchar(20)   COMMENT '状态 draft=草稿；deploy=发布',
  `IS_MAIN` tinyint(4)  COMMENT '是否主版本',
  `VERSION` int(11)  COMMENT '版本',
  `CREATE_TIME` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CREATE_BY` varchar(64)   COMMENT '创建人',
  `UPDATE_TIME` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  `UPDATE_BY` varchar(64)   COMMENT '更新人',
  `TENANT_ID` varchar(64)   COMMENT '租户id',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='DMN模型表';


-- ----------------------------
-- Table structure for PANGU_FORM_BUSINESS_MODEL
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_FORM_BUSINESS_MODEL`;
CREATE TABLE `PANGU_FORM_BUSINESS_MODEL` (
  `ID` varchar(64)  NOT NULL DEFAULT '' COMMENT '主键id',
  `DESCRIPTION` varchar(64)   COMMENT '描述',
  `MODEL_NAME` varchar(64)   COMMENT '实体名',
  `TABLE_NAME` varchar(64)   COMMENT '表名',
  `GROUP_ID` varchar(64)   COMMENT '分类id',
  `GROUP_NAME` varchar(64)   COMMENT '分类名称',
  `TYPE` varchar(64)   COMMENT '类型',
  `DS_KEY` varchar(64)   COMMENT '数据源Id',
  `DS_NAME` varchar(64)   COMMENT '数据源名称',
  `CREATE_BY` varchar(64)   COMMENT '创建人',
  `CREATE_TIME` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `UPDATE_BY` varchar(64)   COMMENT '更新人',
  `UPDATE_TIME` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  `IS_CREATED_TABLE` bit(1)  COMMENT '是否创建表',
  `IS_EXTERNAL` bit(1)  COMMENT '外部',
  `IS_DELETE` tinyint(255) ,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='业务对象表';



-- ----------------------------
-- Table structure for PANGU_FORM_BUSINESS_MODEL_COLUMN
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_FORM_BUSINESS_MODEL_COLUMN`;
CREATE TABLE `PANGU_FORM_BUSINESS_MODEL_COLUMN` (
  `ID` varchar(64)  NOT NULL DEFAULT '' COMMENT '主键id',
  `DESCRIPTION` varchar(64)   COMMENT '描述',
  `COLUMN_KEY` varchar(64)   COMMENT '属性名',
  `NAME` varchar(64)   COMMENT '数据库字段名',
  `FORMAT` varchar(64)   COMMENT '日期格式化',
  `TABLE_ID` varchar(64)   COMMENT '对应的表id',
  `DEFAULT_VALUE` varchar(255)   COMMENT '默认值',
  `DATA_TYPE` varchar(64)   COMMENT '字段类型',
  `ATTR_LENGTH` int(11)  COMMENT '属性长度',
  `DECIMAL_LENGTH` int(11)  COMMENT '小数长度',
  `IS_REQUIRED` bit(1)  COMMENT '必填',
  `IS_PRIMARY` bit(1)  COMMENT '是否主键',
  `IS_DELETE` bit(1)  COMMENT '是否删除',
  `CREATE_BY` varchar(64)   COMMENT '创建人',
  `CREATE_TIME` datetime(3) COMMENT '创建时间',
  `UPDATE_BY` varchar(64)   COMMENT '更新人',
  `UPDATE_TIME` datetime(3) COMMENT '更新时间',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='业务对象列明细表';



-- ----------------------------
-- Table structure for PANGU_FORM_BUS_DEFINITION
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_FORM_BUS_DEFINITION`;
CREATE TABLE `PANGU_FORM_BUS_DEFINITION` (
  `ID` varchar(255)  NOT NULL COMMENT '表单元数据定义ID',
  `NAME` varchar(255)   COMMENT '表单名称',
  `FORM_KEY` varchar(255)   COMMENT '表单key',
  `FORM_BUSINESS_ID` varchar(255)   COMMENT '表单key',
  `FORM_DESC` varchar(255)   COMMENT '描述',
  `FORM_HTML` longblob COMMENT '表单定义HTML',
  `STATUS` varchar(20)   COMMENT '状态 draft=草稿；deploy=发布',
  `FORM_TYPE` varchar(20)   COMMENT '表单类型 分为 pc,mobile',
  `GROUP_ID` varchar(255)   COMMENT '分类id',
  `GROUP_NAME` varchar(255)   COMMENT '分类名称',
  `IS_MAIN` tinyint(4)  COMMENT '是否主版本',
  `HIDE_MAIN` tinyint(4)  COMMENT '是否隐含主表（1：是，0：否）',
  `VERSION` int(11)  COMMENT '版本',
  `DEPLOYMENT_ID` int(11)  COMMENT '部署ID',
  `DEF_ID` int(11)  COMMENT '定义ID',
  `CREATE_TIME` datetime(3) COMMENT '创建时间',
  `CREATE_BY` varchar(64)   COMMENT '创建人',
  `UPDATE_TIME` datetime(3) COMMENT '更新时间',
  `UPDATE_BY` varchar(64)   COMMENT '更新人',
  `FORM_TAB_TITLE` varchar(200)   COMMENT '表单tab标题',
  `CLASSIFY` varchar(64)   COMMENT '表单类型（combine：组合,single：单表）',
  `PAGE_FORMS` varchar(2000)   COMMENT '页签表单keys',
  `PAGE_FORM_JSON` longblob COMMENT '页签表单json',
  `SCOPE_TYPE` varchar(255)  ,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='业务表单定义';

-- ----------------------------
-- Table structure for PANGU_FORM_BUS_OBJECT
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_FORM_BUS_OBJECT`;
CREATE TABLE `PANGU_FORM_BUS_OBJECT` (
  `ID` varchar(255)  NOT NULL COMMENT '主键id',
  `OBJ_KEY` varchar(255)   COMMENT '对象名',
  `OBJ_NAME` varchar(255)   COMMENT '名字',
  `OBJ_DESC` varchar(255)   COMMENT '描述',
  `RELATION_JSON` longblob COMMENT '结构体',
  `GROUP_ID` varchar(255)   COMMENT '分类id',
  `GROUP_NAME` varchar(255)   COMMENT '分类名称',
  `PERSISTENCE_TYPE` varchar(255)   COMMENT '持久化类型',
  `CREATE_TIME` datetime(3) COMMENT '创建时间',
  `CREATE_BY` varchar(64)   COMMENT '创建人',
  `UPDATE_TIME` datetime(3) COMMENT '更新时间',
  `UPDATE_BY` varchar(64)   COMMENT '更新人',
  `VERSION` int(11)  COMMENT '版本',
  `IS_SAVE_INDEX` tinyint(4)  COMMENT '是否保存索引',
  `IS_DELETE` tinyint(4)  COMMENT '是否删除',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;



-- ----------------------------
-- Table structure for PANGU_FORM_DEFINITION
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_FORM_DEFINITION`;
CREATE TABLE `PANGU_FORM_DEFINITION` (
  `ID_` varchar(255)  NOT NULL,
  `NAME_` varchar(255)  ,
  `VERSION_` int(11) ,
  `KEY_` varchar(255)  ,
  `CATEGORY_` varchar(255)  ,
  `DEPLOYMENT_ID_` varchar(255)  ,
  `TENANT_ID_` varchar(255)  ,
  `RESOURCE_NAME_` varchar(255)  ,
  `DESCRIPTION_` varchar(255)  ,
  `SCOPE_TYPE` varchar(255)  ,
  PRIMARY KEY (`ID_`) USING BTREE,
  UNIQUE KEY `ACT_IDX_FORM_DEF_UNIQ` (`KEY_`,`VERSION_`,`TENANT_ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;



-- ----------------------------
-- Table structure for PANGU_FORM_DEFINITION_HISTORY
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_FORM_DEFINITION_HISTORY`;
CREATE TABLE `PANGU_FORM_DEFINITION_HISTORY` (
  `ID` varchar(255)  NOT NULL COMMENT '主键',
  `FORM_ID` varchar(255)   COMMENT '对应表单ID',
  `NAME` varchar(255)   COMMENT '表单名称',
  `FORM_DESC` varchar(255)   COMMENT '描述',
  `FORM_HTML` longblob COMMENT '表单定义HTML',
  `CREATE_USER_ID` varchar(64)   COMMENT '创建人ID',
  `CREATE_USER_NAME` varchar(64)   COMMENT '创建人名称',
  `UPDATE_TIME` datetime(3) COMMENT '更新时间',
  `FORM_KEY` varchar(255)   COMMENT '表单key',
  `VERSION` int(11)  COMMENT '版本',
  `CLASSIFY` varchar(64)   COMMENT '表单类型（combine：组合,single：单表）',
  `PAGE_FORMS` varchar(2000)   COMMENT '页签表单keys',
  `PAGE_FORM_JSON` longblob COMMENT '页签表单json',
  `HIDE_MAIN` tinyint(4)  COMMENT '是否隐含主表（1：是，0：否）',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='流程表单设计历史明细';

-- ----------------------------
-- Table structure for PANGU_FORM_DEPLOYMENT
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_FORM_DEPLOYMENT`;
CREATE TABLE `PANGU_FORM_DEPLOYMENT` (
  `ID_` varchar(255)  NOT NULL,
  `NAME_` varchar(255)  ,
  `CATEGORY_` varchar(255)  ,
  `DEPLOY_TIME_` datetime(3) ,
  `TENANT_ID_` varchar(255)  ,
  `PARENT_DEPLOYMENT_ID_` varchar(255)  ,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;


-- ----------------------------
-- Table structure for PANGU_FORM_INSTANCE
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_FORM_INSTANCE`;
CREATE TABLE `PANGU_FORM_INSTANCE` (
  `ID_` varchar(255)  NOT NULL,
  `FORM_DEFINITION_ID_` varchar(255)  NOT NULL,
  `TASK_ID_` varchar(255)  ,
  `PROC_INST_ID_` varchar(255)  ,
  `PROC_DEF_ID_` varchar(255)  ,
  `SUBMITTED_DATE_` datetime(3) ,
  `SUBMITTED_BY_` varchar(255)  ,
  `FORM_VALUES_ID_` varchar(255)  ,
  `TENANT_ID_` varchar(255)  ,
  `SCOPE_ID_` varchar(255)  ,
  `SCOPE_TYPE_` varchar(255)  ,
  `SCOPE_DEFINITION_ID_` varchar(255)  ,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;



-- ----------------------------
-- Table structure for PANGU_FORM_RESOURCE
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_FORM_RESOURCE`;
CREATE TABLE `PANGU_FORM_RESOURCE` (
  `ID_` varchar(255)  NOT NULL,
  `NAME_` varchar(255)  ,
  `DEPLOYMENT_ID_` varchar(255)  ,
  `RESOURCE_BYTES_` longblob,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;



-- ----------------------------
-- Table structure for PANGU_WORKBENCH_HOME_PORTAL
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_WORKBENCH_HOME_PORTAL`;
CREATE TABLE `PANGU_WORKBENCH_HOME_PORTAL` (
  `id` varchar(255)  NOT NULL COMMENT '主键',
  `content` varchar(255)  DEFAULT '' COMMENT '内容',
  `disabled` tinyint(2) DEFAULT '1' COMMENT '是否禁用',
  `create_time` datetime ,
  `create_user_id` varchar(255)  ,
  `create_user_name` varchar(255)  ,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='门户冒泡';

-- ----------------------------
-- Records of PANGU_WORKBENCH_HOME_PORTAL
-- ----------------------------
BEGIN;
INSERT INTO `PANGU_WORKBENCH_HOME_PORTAL` VALUES ('662595157182382080', '华为宣布方舟编译器将于8月31日起开源', 1, '2020-01-02 19:56:35', '1', '小志');
INSERT INTO `PANGU_WORKBENCH_HOME_PORTAL` VALUES ('662595183610691584', '客户说好才是真的好！', 1, '2020-01-02 19:56:42', '1', '春宇');
INSERT INTO `PANGU_WORKBENCH_HOME_PORTAL` VALUES ('662617503033196544', '出来学习，武装自己为了企业早日步入正轨', 1, '2020-01-02 21:25:23', '1', '林子');
INSERT INTO `PANGU_WORKBENCH_HOME_PORTAL` VALUES ('662952475099136000', '做什么事首要考虑的是以客户为中心.否则最多就是短暂的繁荣.', 1, '2020-01-03 19:36:27', '1', '小明');
INSERT INTO `PANGU_WORKBENCH_HOME_PORTAL` VALUES ('663087535018213376', '盘古BPM确实很强大', 1, '2020-01-04 04:33:07', '1', '管理员');
COMMIT;

-- ----------------------------
-- Table structure for PANGU_WORKBENCH_TOPIC
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_WORKBENCH_TOPIC`;
CREATE TABLE `PANGU_WORKBENCH_TOPIC` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255)  ,
  `sub_title` varchar(255)  ,
  `content` varchar(20000)  ,
  `create_time` datetime ,
  `create_user_id` int(11) ,
  `parent_id` int(11) ,
  `view_count` int(11) ,
  `descr` varchar(255)  ,
  `is_del` tinyint(2)  COMMENT '普通，加热，精华',
  `cover_img_url` varchar(255)  ,
  `is_root` tinyint(2) ,
  `rec_ver` int(11) ,
  `type` int(11)  COMMENT '1、公告 2通知 3新闻 4 规章 5文化 6技术',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='公告表';

-- ----------------------------
-- Records of PANGU_WORKBENCH_TOPIC
-- ----------------------------
BEGIN;
INSERT INTO `PANGU_WORKBENCH_TOPIC` VALUES (1, '《福布斯》评2020十大科技趋势：5G、车联网、区块链', '管理员 于 2019-08-30 11:44:47 发布在公告', '<p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">在过去的几年中，大部分关于今后数字变革趋势的讨论都开始变得有一些重复，云、边缘运算、物联网、人工智能……似乎总是将同样的椅子在同一间旧房间里重新摆放了一样。2020年将会与之前的不一样。尽管主宰这些讨论的同样的核心技术将继续对我们的数字变革之旅产生基本性的作用，2020年将会被新的技术等级定义，从边缘化慢慢移动到中心舞台。在这其中有：5G、人工智能、先进的数据分析，也会有一些令你吃惊的东西。言归正传，我认为在这其中会有10项在2020年显得最为重要。 &nbsp;<br></p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">1。5G惠及你我：2020年将会是5G之年。电子通讯行业的知名公司，如高通、美国电话电报公司、威瑞森、诺基亚、爱立信和华为，全球的5G布局保持着速度，世界上最好的安卓手机制造商已经发布了5G手机，5G将会在2020年落地运行。除了带给我们更快的宽带速度和最可靠的移动网络，5G的扩散将会加速智能城市、智能车辆、智能制造、和大量渴望5G物联网集成技术方面的进展。换言之，5G的真正价值不会局限于手机。与我们日常生活相关的每一个行业都会被变革---变得更好，经由这个将定义2020年的技术演变。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">2。更快的无线网、更快的世界：虽然无线6和5G是完全不同的技术，二者都将在2020年带给我们更快的处理和无线连接速度。5G和无线6的协同工作将为家庭和办公室创造完美的终端对终端的超快连接组合。预计下载速度比使用无线5快3倍，但是这并不是新标准价值的最好测量方式。无线6的真正价值在于它拥有比无线5更强能力，可以以更快的数据速度延伸到更多的设备上。这有两点重要的原因：第一点是，在接下来的几年中，无线网络平均的连接设备数量将从现在的10增加到50，这一增长将需要更快、更高效和更智能的无线能力。第二点原因是，通过无线网络消耗的质量和数量同时在增长，无线5不能很好地处理这一荷载。无线6将在2020年消除这些痛点。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">3。分析学是竞争优势：在2020年时依然被没有在分析学上大量投资的公司在2021年可能将无法经营。将有很多有价值的消费者数据需要采集、处理，然后变成任何公司可以在不充分使用现代分析学工具的前提下可以保持竞争力的见解。当其他企业都在利用复杂的分析学工具发现问题、机会以及解决方案时，盲目飞行、跟随勇气再也不是有效选项。这就是为什么我们在科技界，从收购Tableau的Salesforce到创建自己PowerPlatform的Microsoft，我们都看到了分析学能力的整合。每一个重大的技术公司已经发现，未来将位于数据中---特别是，数据的实时处理。因此，无论你在哪一个行业，分析学将再次成为2020年数字变革最具决定性的焦点。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">额外见解：我发现了类似于Alteryx、Splunk、SAS和Qlik以及Tibco的公司有连续的收购、投资以及增长活动。这些大的平台玩家，就像Slaesforce对Tableau做的那样，他们也在寻求收购，合资企业和/或战略合作。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">4。人工智能和机器学习成为了数据分析学的力量倍增器：如果你打算投资分析学，你也要在人工智能和机器学习上做投资，这样你才能在信息和数据的广阔旋涡的海洋中航行，将数据投入更好的使用。人工智能和机器学习以及数据分析学的价值可以归结为三个不同的价值命题：速度、规模和便利。速度和规模指自动分析大量数据组的优势，而非将任务分配给人工数据分析师。由于人工智能和机器学习，复杂的数据组如今可以使用两年前的时间的一小部分来进行分析。这并不是因为计算机变得更快或更好了，而是因为人工智能和机器学习运算十分擅长数据分析，并且这些分析可以容易地在云中测量。就便利的一面而言，与以往的数据分析不同的是，将人工智能和机器学习添加到分析学工具中来使得他们更加直觉、容易使用、以及更可靠。2019年他们已经变得越来越好，2020年他们的速度和准确性也会大幅度提升。、 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">5。区块链超越加密货币：我去年称区块链被夸大了，它会在2019年变得萧条。进入2020年，我认为我们将最终开始看到区块链超越加密货币的使用案例。我们知道，亚马逊网络服务基于区块链服务平台将区块链技术民主化了，他们在这一努力上并不是单独的。很多其他的全球领导者也在这一空间里扮演者角色，包括三星、微软、IBM以及中国的阿里巴巴。除夕以外，我们开始看到超越支付和加密货币以外的技术实际使用案例。例如，看看区块链将如何在食品安全、知识产权和版权、以及房地产/资产管理中得到使用。2020年将会是区块链真正崛起的开始。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">6。机器人流程自动化焕发第二春：机器人流程自动化并不是新的，它被广泛认为是人工智能树上最低的果实。然而它绝非每次我在过去的8个月参加的技术和制造会议上的热门话题。参会的机器人流程自动化一路领先，但是随着利益和投资持续增长，机器人流程自动化证明是值得信任的，我认为2020年对于机器人流程自动化投资而言是一个大年，就像2019年钱涌入了像AutomationAnywhere、Uipath和BluePrism等公司。同样地，像Cisco这样的公司也在使用机器人流程自动化助于创建回旋空间来提升技能，增大现有员工的价值，并且这一模式一定会快速发展成为制胜之道。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">7。对话式人工智能成为了合法的接口：我知道，Siri依然糟透了（大部分情况下），依然几乎不可能使用语音转文字来创建合宜的聊天信息。但是，我始终认为我们会看到至少某种形式的对话式人工智能在2020年变得有用。在软件方面，类似于微软对话式人工智能的项目也在十分努力地建立平台，不仅能够听得正确，也能跟踪复杂的对话并且理解情绪的细微差别，与此同时随着时间继续提升。在硅元素方面，专门用于智能设备的芯片组和片上系统格外擅长将人声从嘈杂的背景中分离开来，并且可以准确地实时处理自然语言。我们在2020年会看到日常消费技术的根本性进步吗？可能不会。但是我认为下一代可靠的对话式人工智能基础将会在未来得到加强。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">8。ACPC永远地改变了手提电脑市场：我们一直处于连通状态，因此我们也需要计算机也始终保持连通。我们今年会看到带有嵌入式5G和LTE连通的ACPC的扩展，当然我们也会看到一些智能企业合作紧随其后（联想和高通首先印入脑海，但是我也期待更多的公司会涌现出来，基于ARM的技术会使这成为可能。） &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">额外见解：ACPC享有几乎全天的电池寿命，可能会在明年将多日的电池寿命带给手提电脑，使得计算机真正的成为手提式。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">9。联网汽车，自动无人机和智能城市成为了新的现实：听我说完。我知道我们已经谈论了很多年，我们还没有做到，但是我认为边缘计算和5G的结合可能将使我们在2020年更接近真正自动化的汽车、无人机和智能城市。特斯拉使第一个将这投入市场的公司，但是这并非是ElonMusk试图解决的。通过自动化制造商和技术制造商之间紧密的战略对接，这将成为可能。像Intel/Nvidia/Qualcomm以及BMW/Volvo/Ford在合作，而Uber在建立他们的自动化舰队，亚马逊通过自动化无人机将你的每一个需求送到你的家门口。最终将这些承诺已久的技术带入市场。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">10。Xaas，UX/CX以及隐私：技术相关的数字变革趋势将如何在2020年走入中心舞台。我已经关注了技术的很多方面，但是现在让我们面对它：数字变革不仅仅只是技术部分的汇总。变化本身是数字变革的核心驱动器，变革几乎总是超越使它成为可能的工具。正因为此，我需要强调与技术相近的趋势，我认为这些可以在2020年主宰数字变革讨论：我的榜单榜首有XaaS（一切皆服务），UX/CX（用户/消费者体验）以及数字隐私。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">Xaas：2020年，即使是对于最专注于硬件的的行业以及技术部门而言，“一切皆服务”的趋势也将比去年来得更加强劲。惠普公司宣布他们将在2022年前提供他们投资组合中的所有服务。这或许只是沧海一粟，但是所有的on-prem提供者都展露出了类似的趋势。随着在线、离线、以及云服务继续演变，行业巨头将会渐渐偏向“一切皆服务”的原则，以及大数据、分析、区块链等等。这些在过去也曾是企业服务的一部分，但是2020年将是它们完全成为主流的一年。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">用户体验：随着数字变革的趋势，用户和客户体验（UX/CX）可谓紧密相连，这种趋势将继续推动企业在数字转型方面的投资。一方面，随着企业的目标逐渐从建立内部能力、提高效率过渡到执行他们的未来愿景，这种情况尤其明显。另一方面，在连接性（5G，WiFi6），计算能力（云服务，Edge，机器学习），智能自动化（RPA，AI）和直观的用户界面（对话式人工智能，手势分析，AR）等方面的改进，将使2020年成为从零售、酒店到交通和医疗等广泛行业用户体验的分水岭。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">数字隐私：由于近年来科技公司在隐私问题上的屡屡失败，欧盟通用数据保护条例的建立，以及美国越来越多对科技公司实施控制的呼声，我们将看到更多的公司最终在2020年认真对待隐私和数据安全问题。我预计许多公司将采用隐私和透明度作为品牌区分标准，允许用户比过去更容易地选择加入或退出数据收集方案。真正的问题是，像亚马逊（通过Alexa）和Facebook这样的公司是否会加入该隐私保护计划，还是说会继续悄悄地从用户那里收集所有数据。除此之外，戴尔、思科、IBM和惠普等传统高科技公司围绕数据安全和隐私所付出的努力可能会为2020年开始的数字隐私复兴铺平道路。哪些公司将会采取措施来保护隐私，哪些公司将会保持现状，以及哪些公司继续像“丢失的方舟”一样对数据进行攻击——这些问题将会成为下一个热点。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">总结： &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">对于企业而言，大多数数字转换计划的中心仍然是基础技术的核心。我相信以上这十个趋势将主导数字变革的趋势，并对未来做出预测。如果你正在参阅2020年十大最重要的商业趋势，并为自己的投资做准备的话，本文将会是你最佳的参考对象。</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\"><br></p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255); text-align: right;\">（来源：福布斯中文网，文：Daniel Newman，译：Stephen/Chloe</p><p><br></p>', '2020-01-04 13:22:13', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO `PANGU_WORKBENCH_TOPIC` VALUES (2, '国家统计局：7月份商品住宅销售价格涨幅总体稳定', '管理员 于 2019-08-30 11:44:17 发布在公告', '<p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">国家统计局今日发布了2019年7月份70个大中城市商品住宅销售价格变动情况统计数据。对此，国家统计局城市司高级统计师刘建伟进行了解读。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-weight: bolder;\">一、一二线城市新建商品住宅和二手住宅销售价格环比涨幅略有升降；三线城市涨幅均与上月相同 &nbsp;</span></p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">7月份，各地继续贯彻落实党中央、国务院部署，始终坚持“房子是用来住的、不是用来炒的”定位，以稳地价、稳房价、稳预期为目标，进一步落实房地产调控长效机制，房地产市场总体延续平稳态势。初步测算，4个一线城市新建商品住宅销售价格环比上涨0.3%，涨幅比上月扩大0.1个百分点。其中：北京和广州分别上涨0.6%和0.3%，深圳持平，上海下降0.1%。二手住宅销售价格环比上涨0.3%，上月为持平。其中：上海、广州和深圳分别上涨0.4%、0.4%和0.7%，北京下降0.3%。31个二线城市新建商品住宅销售价格环比上涨0.7%，涨幅比上月回落0.1个百分点；二手住宅销售价格上涨0.4%，涨幅比上月扩大0.1个百分点。35个三线城市新建商品住宅和二手住宅销售价格环比均上涨0.7%，涨幅均与上月相同。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-weight: bolder;\">二、一二三线城市新建商品住宅和二手住宅销售价格同比涨幅不同程度地回落或相同&nbsp;</span>&nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">初步测算，7月份，一线城市新建商品住宅销售价格同比上涨4.3%，涨幅比上月回落0.1个百分点；二手住宅销售价格同比上涨0.2%，涨幅与上月相同。二线城市新建商品住宅和二手住宅销售价格同比分别上涨10.7%和6.7%，涨幅比上月分别回落0.7和0.9个百分点。三线城市新建商品住宅和二手住宅销售价格同比分别上涨10.2%和7.1%，涨幅比上月分别回落0.7和0.8个百分点。</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\"><br></p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255); text-align: right;\">（来源：国家统计局）</p><p><br></p>', '2020-01-04 13:42:20', NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO `PANGU_WORKBENCH_TOPIC` VALUES (3, '中国ETC服务平台正式上线运营', '管理员 于 2019-08-30 11:15:28 发布在公告', '<p style=\"margin-bottom: 1rem;\"><span style=\"font-size: 16px;\">记者18日从交通运输部了解到，中国ETC服务平台当日正式上线提供服务，车主可通过国务院客户端小程序ETC服务专区或交通运输部官方微信ETC服务平台免费在线申办ETC。 &nbsp;</span></p><p style=\"margin-bottom: 1rem;\"><span style=\"font-size: 16px;\">交通运输部有关负责人表示，为实现不停车快捷收费目标，今年底前，在籍汽车ETC安装率将力争达到80%，高速公路入口车辆使用比例达到90%，基本实现不停车快捷收费。截至目前，我国ETC发行量已达10696.74万。 &nbsp;</span></p><p style=\"margin-bottom: 1rem;\"><span style=\"font-size: 16px;\">这位负责人表示，为进一步推动ETC发行工作，交通运输部联合中国政府网共同推出中国ETC服务官方小程序平台，实现ETC线上免费办理、线下送货上门，并向车主提供在线安装教程，自动激活使用。目前，全国各地车主用户可通过关注交通运输部官方微信公众号或使用国务院客户端小程序，进入ETC服务专区进行办理、查询等相关业务。</span></p><p style=\"margin-bottom: 1rem;\"><span style=\"font-size: 16px;\"><br></span></p><p style=\"margin-bottom: 1rem; text-align: right;\"><span style=\"font-size: 16px;\">（来源：新华社，记者：魏玉坤）<br></span></p><p style=\"margin-bottom: 1rem;\"><br style=\"color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\"></p><p><br></p>', '2020-01-04 13:43:56', NULL, NULL, 5, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO `PANGU_WORKBENCH_TOPIC` VALUES (4, '35岁真的是互联网人的危机之年吗', '管理员 于 2019-08-30 10:54:17 发布在文化', '<p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">35岁，是很多人成长过程中逐步积累社会经验、渐渐走向成熟的年龄。然而，在偶尔曝出的互联网公司裁员新闻和部分舆论的渲染下，35岁近来成了互联网人的危机之年。35岁危机、35岁焦虑、35岁被优化等词汇出现在很多爆款文章中。 &nbsp;<br></p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">35岁，对于互联网人来说，到底意味着什么？35岁真的是危机之年吗？《工人日报》记者近日采访了多个年龄段的互联网人，一探究竟。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-weight: bolder;\">技术更新太快，没有人不可替代 &nbsp;</span></p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">从1999年国内BAT三大巨头诞生算起，仅仅过去20年。如果一个年轻人从学校踏入社会就进入互联网行业，35岁及以上的他们已经算是“老人”了。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">1978年出生的系统开发程序员陈月就是互联网行业的“老人”。他经历过从功能手机到智能手机变革、PC时代向移动互联时代的嬗变。他最深的感受就是，“行业发展节奏太快，知识更新越来越快，入门门槛变低，对于所有人来说每天都要接触新技术，大家起点被拉得越来越近，经验显得不那么重要了”。互联网变化很快，经验尤其是技术经验高速折旧。“你做的东西很可能半年后就被新的框架、新的需求替代掉了，所以更需要年轻人新的思想，加快企业新陈代谢的速度。” &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">根据国外知名调查机构的数据，互联网行业呈平均年龄偏低的趋势。2018年，苹果员工的平均年龄是31岁，Google是30岁，Facebook是29岁，腾讯、华为是28岁。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">在90后小楠的公司，部门同事甚至领导都以90后成员居多。互联网是一个偏爱高效的行业，节奏快、工作强度大、加班时间长，年轻人更有体力和精力上的优势。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">目前在某B2B企业负责产品线的叶伟在面试招人的时候虽然没有年龄的限制，但也会考虑到中年人上有老、下有小，用在工作上的精力难免有限。而且，互联网行业中每个人的不可替代性并没有那么强，与其投入高成本，不如分散“投资”，招聘有精力投入的人，会带来更大收益。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-weight: bolder;\">行业在淘汰能力不足的人 &nbsp;</span></p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">“去年10月，公司因资金链断裂无法继续经营而全体裁员，我是最后一批被裁掉的。”1992年出生的杨小帅在上海某物流企业从事产品经营，这是他从计算机专业毕业4年来的第3份工作。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">虽然很快就入职了新工作，但是杨小帅仍然感受到了焦虑，原公司协议的N+1赔偿金到现在都还没有拿到。有同事在家赋闲2个月，也没有找到合适的工作，能提供的薪酬和岗位与自己的需求总是不能匹配。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">“互联网行业已经进入下半场，会面临更加激烈的竞争，整个行业其实是在淘汰能力不足的人。”杨小帅表示，即使自己还未到中年，但也不敢有丝毫的放松。他必须不断提高自己的竞争力，为将来做准备。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">和杨小帅同龄的Java程序员苏运丰也在换了3家公司后才找到了自己合适的岗位。在他看来，现在越来越重视技术型人才，未来没有技术就没有竞争力。30岁之前是技术人员的黄金时段，精力也很充沛。“我的工作经常加班，但有时候是自愿加班学习新的技术，压力比较大，在这行要么不断学习，要么就会被淘汰。” &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">对于从事非技术岗位的95后王望来说，焦虑和危机感并没有更少一点。从事电商运营的他加班是家常便饭，尤其是赶上“双11”“618”的促销活动。销售任务的压力让他想过离开，但是觉得自己的能力还不足以通过跳槽来实现工资的翻倍增长。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">说起部分被裁掉的35岁以上的人，在北京做互联网产品运营的王彦表示这是一个行业重新洗牌、大浪淘沙的过程。在行业形势一片大好的时候，公司内部有很多35岁以上中层管理人员，队伍结构并不合理。“这两年公司裁掉了一批中层，同时开始放缓晋升速度。当效益不那么好的时候，就不需要那么多管理层，而是需要更多提供一线生产力的新鲜力量。” &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">此外，部分较早入行的中高层管理人员享受到了互联网的红利期，甚至在短时间内积累了大量财富后工作不再有拼劲，长期远离一线业务。“老油条太多了，工作推诿，拿着百万年薪不干正事。裁员的时候优先被动刀也并不奇怪。”王彦说。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-weight: bolder;\">35岁以上的人去向何方</span>&nbsp;&nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">那些35岁以上的互联网人，就真的没有职场竞争力了么？ &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">38岁的解乔依旧驰骋在职场，从传统媒体跨越到互联网初创公司，她还在不断挑战新的领域。“互联网行业发展到今天是其正常要经历的周期，不必过度唱衰。也不必过度渲染35岁人的焦虑，每个年龄段都有焦虑，只是焦虑的问题不同。所谓的35岁危机是中年将至的正常现象。” &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">即将跨入35岁行列的乔布去年离开律师事务所来到深圳一家互联网公司做法务。他认为“真正的年轻是心态上的，而不是年龄上的”，互联网还有一些领域对于中年人来说是有机会的。例如市场、客户关系维护等需要有经验的人。自身得有危机意识，永远准备好一个战斗心态，拥抱变化、不断提高自身价值，才不容易被淘汰。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">而对于技术人员来说，虽然互联网公司年轻人占比较大，陈月觉得35岁以上的人也不是没有出路，只是相对困难。要么走深度的技术研究，要么将技术和管理相结合，重点是要不停学习、适应行业节奏。他希望未来还在这个行业且能在某个领域成为专家，从而延长职业寿命。“实在不行，那就接受降薪、降职，互联网行业科技含量高，发展还是最快的，机会相对来说比较多。” &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">也有人选择转行或者创业，有媒体报道互联网行业缩招的同时，保险行业却迎来扩招，不少高素质高学历的中年人转行加入保险代理人队伍。解乔也发现，最近一些互联网行业的朋友开始销售保险业务。在她看来，尤其对于职场女性来说，这是一个很好的选择，时间相对自由，而且阅历、经验以及之前行业积累的人脉都能带来优势。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">另有一部分互联网中年人选择自主创业。他们想自己已经积累了一定的积蓄、人脉、社会经验，何不尝试拥有一份自己的事业？然而，解乔认为创业需要承担的风险更大一些，不能盲目。“你要想清楚自己要什么，热爱是第一位的，同时要有一颗强大的心脏，不能把创业当作被逼无奈的退路。” &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\"><br></p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255); text-align: right;\">（应采访人要求，文中人名皆为化名）</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255); text-align: right;\">（来源：来源 工人日报，记者：唐姝</p><p><br></p>', '2020-01-03 13:45:25', NULL, NULL, 11, NULL, NULL, NULL, NULL, NULL, 2);
INSERT INTO `PANGU_WORKBENCH_TOPIC` VALUES (5, '全球将迎来新一轮降息潮', '管理员 于 2019-08-30 10:53:10 发布在文化', '<p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">虽然刚过中国的立秋节气，全球宏观经济却已经明显感到了一丝“凉意”。日前，印度央行、新西兰央行、泰国央行和菲律宾央行都相继宣布降息。事实上，自年初以来，降息已经成为超过20个国家主要央行的货币政策基调。全球正在迎来新一轮降息潮。 &nbsp;<br></p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-weight: bolder;\">降息阵营愈加壮大 &nbsp;</span></p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">印度、新西兰等国在宣布降息时都强调了“外部贸易环境恶化和全球需求不振”将造成其国内经济增长低于预期，通胀不及预期。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">其中，泰国央行明确表示，泰国经济可能低于此前预计的经济增速，增长前景恶化和低于预期的通胀环境使其“出人意料”地降息；印度央行在最新的展望中下调了经济增长预期，并表示通胀在短期内无法达到4%的目标区间；新西兰央行也表示，全球经济活动持续疲弱，新西兰商品和服务出口市场需求下滑；菲律宾最新季度经济增速下降至4年多来最低水平的5.5%，远低于5.9%的预期。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">令各方担忧的是，多国央行降息正在掀起新一轮降息潮。市场预计，在本轮降息的国家中，如果泰国未来经济数据持续放缓，泰国央行有可能在9月25日继续降息，将基准利率下调至1.25%；印度央行有可能在10月份议息会议上进一步削减利率至5.15%，并通过系列调整在2020年一季度达到5%的10年低位；菲律宾央行行长迪奥诺也表示，最快还将于6周内或者在四季度初进一步降息，不排除进一步削减存款准备金率100个基点的可能性。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">在亚太地区，最新的日本央行议息会议纪要显示，虽然7月份日本央行按兵不动，但一旦宏观经济需要，日本央行必须“向市场明确表明毫不迟疑采取进一步宽松举措的决心”。澳大利亚央行已于6月份、7月份连续两次降息，但仍表示在8月份暂停降息后，考虑到通胀前景低迷且全球经济增长前景恶化，不排除进一步下调利率的可能性。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-weight: bolder;\">释放信号引人深思 &nbsp;</span></p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">分析认为，这些降息预期透露出三大引人深思的疑问和担忧。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">第一，一轮又一轮的降息究竟为何？这一轮降息潮背后不仅仅是全球经济下行压力，更凸显出不同经济体在全球经济周期调整中的竞争性货币政策。这一态势的根源无疑在美国。即使在7月份美联储降息之后，美国政府高层仍然在多个场合强调美联储应该“更大幅度、更快地降息”，以使美国在与其他国家的竞争中具有竞争力。显然，在贸易保护主义进一步加剧经济衰退担忧的同时，美国利用货币政策提振竞争力的做法引发了多国央行“抢跑”。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">新西兰央行助理行长克里斯蒂安·霍克斯比在解释此次降息幅度高于市场预期时明确表示，作为出口导向型经济体，新西兰经济对于汇率的高度敏感性迫使该国央行不得不超出市场预期降息。澳大利亚央行行长菲利普·洛直白地表示，“更高的汇率将会伤及澳大利亚很多经济部门”。日本央行最新纪要表示，贸易环境持续恶化和全球政治不确定性不断推升日元，进一步伤及日本央行刺激出口导向型经济复苏的计划。因此，像日本央行一样支持“先发制人”货币宽松政策的成员数量正在上升。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">第二，发达经济体所谓的央行“独立性”何在？日前，4位美联储前主席罕见地发表联合署名文章，呼吁美联储保持独立性。然而，在其政策目标和执行手段均提前设定的情况下，这一所谓的独立性只能是个悖论。美联储与美国政府关于货币政策的争论更多是一个“序贯决策博弈”进程。美国一些政客在此前通胀和就业形势不错的情况下认为，美国有资本打贸易战，但在经济受到贸易战影响后迫切需要美联储作出反应，后者迫于各种压力不得不从。政客作为首先作出策略选择的博弈方，占据了绝对有利地位。所谓独立的货币政策决策者只能紧随其后，美联储的所谓独立性在系列博弈中大打折扣。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">第三，发达经济体央行还有多少“弹药”应对下一次危机？目前，美国3月期和10年期债券的收益率曲线已经出现连续倒挂，表明市场预期未来美国经济下行压力和美联储将持续降息。按照历史惯例，如果倒挂持续3个月以上，未来12个月有较大可能性出现经济衰退。然而，自国际金融危机以来，主要发达经济体政策利率水平与历史水平相比均处于低位。未来一旦出现衰退或者危机，已经或者即将进一步实行货币宽松政策的发达经济体将面临窘境，不仅利率调整空间将非常有限，而且央行资产负债表扩张的边际效果也将受限。届时，拿什么拯救危机中的经济，将成为越来越多发达经济体央行头疼的问题。</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\"><br></p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255); text-align: right;\">（来源：经济日报-中国经济网，记者：蒋华栋）</p><p><br></p>', '2020-01-04 13:46:31', NULL, NULL, 8, NULL, NULL, NULL, NULL, NULL, 3);
INSERT INTO `PANGU_WORKBENCH_TOPIC` VALUES (6, 'Tumblr衰落启示：“眼球就是一切”时代终结\n', '管理员 于 2019-08-30 10:52:05 发布在新闻', '<p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">据外媒报道，在鼎盛时期，轻博客网站Tumblr的用户比Instagram和Pinterest都要多。从对母公司Facebook的价值角度估算，Instagram现在接近2000亿美元，而Pinterest的市值接近180亿美元。 &nbsp;<br></p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">2013年，Tumblr被以11亿美元的价格卖给了雅虎。不久前，全球知名出版集团WordPress.com的母公司以极低的价格买下了它。确切的价格尚未确定，但内部人士观察到，其价值可能与硅谷的普通住宅相当。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">雅虎前首席执行官玛丽莎·梅耶尔(MarissaMayer)曾将Tumblr描述为“令人难以置信的特殊资产”，它拥有“1.05亿个不同的博客，每月有3亿独立访问者，每天有12万注册用户”。她还曾公开宣称：“我们承诺不会搞砸它。” &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">Tumblr表面上是个博客网站，但它很快就成为了早期的主流社交网络之一，虽然很难导航。Tumblr吸引了那些创造和分享艺术、随意想法的用户，并最终形成了一种社区意识。对外人来说，Tumblr的机制是不透明的：多年来，它没有直接消息的功能，甚至没有传统的评论功能，迫使用户通过转发彼此的帖子等方式相互交流。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">由于外人很难或不可能插入到对话中，而且它过去和现在都允许用户使用假名账户，加州大学欧文分校博士后研究员亚历山大·赵(AlexanderCho)说，这个网站对边缘社区的成员来说很安全。欧文参与编辑了一本即将出版的、关于Tumblr历史的书。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">Tumblr的高级社区趋势分析师凯瑟琳·霍尔德尼斯(CatherineHolderness)说：“Tumblr可以提供你想要的那种匿名，这允许人们以一种他们可能无法在Facebook上体验的方式分享。” &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">然而，Tumblr的结构、文化，甚至代码库中有些固有的东西，从一开始，它们对于任何潜在的所有者来说都是问题。在商业方面，Tumblr的运营假设是，它可以像横幅广告发明以来那样从用户身上赚钱，即吸引足够多的受众，“货币化”会自行解决后续问题。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">爱沙尼亚塔林大学的社交媒体研究员卡特琳·泰登伯格（KatrinTidenberg）已经研究Tumblr多年，她说：“可惜的是，Tumblr天生就不适合做广告，它的不可穿透性对广告商来说是个巨大挑战。最重要的是，它的许多用户以各种各样的方式传播有关成人内容的帖子。很多广告客户，特别是在美国，对于自家产品被人看到在某人的胸部旁边会感到非常紧张。” &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">相反，广告商越来越多地转向表面上更安全的领域，如谷歌和Facebook。市场研究机构eMarketer的数据显示，这两家巨头合计吸收了57%的数字广告支出。除了拥有最大的广告网络，他们“皇冠上的珠宝”是令人难以置信的、极度复杂的广告引擎，为广告商带来可衡量的结果。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">随着这些巨头的成熟，他们可以吸引最好的工程人才、最多的广告商、最多的眼球以及最多的合作伙伴。他们能够乘坐由现金制成的“飞轮”，以更快的速度旋转。在整个2010年前后，雅虎的工程和执行层面人才都在大量流失，无法吸引和留住能够帮助其创收的引擎参与竞争的那种人才，这种引擎即境况不佳的广告网络。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">雅虎加入AOL（合并成为新公司Oath，现在被称为VerizonMedia）后发生了或多或少相同的事情，其母公司在2018年末基本上将其全部价值减记为零。这个合并后的网络拥有大量的“眼球”，但在广告商已经超越了其网站所运行的那种低价节目展示广告的环境下，仅有这些眼球已经远远不够。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">当然，同样的事情也发生在媒体上，比如你现在正在阅读的“报纸”，其反应是从展示广告转向订阅收入。但实际上，对Tumblr来说，向人们收取访问服务的费用从来都不是个真正的选择，因为它主要是建立在全世界青少年的希望、梦想和无数博客帖子之上的。孩子们通常没有信用卡，即使他们有，他们也是在免费游戏、免费视频和免费服务的稳定环境中长大的。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">资深媒体制作人和漫画博主克劳迪娅·阿曼巴（KlaudiaAmenábar）说：“这个网站从根本上崩溃了，而且它一直都在崩溃。”阿曼巴自称是Tumblr的超级用户，现年24岁的她在16岁时发现了这项服务，从那以后就一直在使用它，并利用她在那里学到的东西开始在时尚和社交媒体领域建立起自己的职业生涯。她补充道：“移动应用现在好多了，但以前，关于移动应用的笑话在Tumblr上层出不穷。” &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">在过去的一年中，Tumblr的流量下降了40%，从2018年7月的大约6.4亿次访问量下降到现在的3.8亿次左右。大部分下降发生在该服务实施了对成人内容禁令之后。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">在禁令出台之前，Tumblr之所以发展壮大，正是因为它和互联网一样，开放到偶尔会变得乌烟瘴气的地步。这里充斥着成人题材，这一事实可能会吸引些观众，但也会让另一些人感到厌烦。Tumblr母公司Verizon推出了一项基本上是自动化的努力，以清除所有成人内容的服务，同时这也消除了网站上的大部分用户策展和用户生成的内容。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">从这时开始，Tumblr网站崩溃了，因为它庞大的粉丝小说作家、外部艺术家以及由喜怒无常的青少年组成的社区大量涌向其他平台。阿曼巴指出：“这种趋势此前就已开始蔓延，很多人停止使用Tumblr还因为它正变得过时，而Twitter变得更受欢迎，Instagram变得更大。” &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">Tumblr仍然是互联网模因（meme）和其他昙花一现流行趋势的强大引擎，具有潜在的复古风格，但肯定不像其鼎盛时期那么酷。它就像一辆旧车，如果它的主人能坚持足够长的时间，它就可能会成为经典。这就是为何Tumblr和WordPress.com在同一个家族中能够完美契合的原因。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">WordPress.com致力于支持一项活动——博客，在一个如果某件事没有在社交媒体上分享就没有发生的时代，这项活动可能看起来很奇怪。正如我们在黑胶唱片、木制玩具和电子邮件中看到的那样，博客（进而延伸到Tumblr）完全有可能卷土重来，或者至少能继续作为一个有价值的地方，让人进行更多深思熟虑的创作和参与。 &nbsp;</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\">Tumblr真正的挑战不是它现在的价值大幅缩水，而是其曾经受到的高度评价。拥有一款非常受欢迎的产品，并且只有一个最模糊的赚钱想法，事实证明，这并不是一个改变世界的商业模式。</p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255);\"><br></p><p style=\"margin-bottom: 1rem; color: rgb(51, 51, 51); font-family: tahoma, 瀵邦喛钂嬮梿鍛寸拨; font-size: 16px; white-space: normal; background-color: rgb(255, 255, 255); text-align: right;\">（来源：腾讯科技）</p><p><br></p>', '2020-01-04 13:48:14', NULL, NULL, 34, NULL, NULL, NULL, NULL, NULL, 2);
COMMIT;

-- ----------------------------
-- Table structure for PANGU_WORKBENCH_WF_MODULE
-- ----------------------------
DROP TABLE IF EXISTS `PANGU_WORKBENCH_WF_MODULE`;
CREATE TABLE `PANGU_WORKBENCH_WF_MODULE` (
  `id` varchar(255)  NOT NULL COMMENT '主键',
  `name` varchar(255)  DEFAULT '' COMMENT '文本名称',
  `code` varchar(255)  DEFAULT '' COMMENT '唯一编码',
  `parent` varchar(255)  DEFAULT '' COMMENT '父级id',
  `icon` varchar(255)  DEFAULT '' COMMENT '图标',
  `icon_class` varchar(255)  DEFAULT '' COMMENT '图标class',
  `description` varchar(255)  DEFAULT '' COMMENT '描述信息',
  `node_Info_Type` varchar(255)  DEFAULT '' COMMENT '类型，MODULE为根节点，MENU为子节点',
  `node_Info` varchar(255)  DEFAULT '' COMMENT '节点编码 比如OA_LCSP_CGSQ代表采购申请',
  `href` varchar(255)  DEFAULT '' COMMENT '连接',
  `model_key` varchar(255)  DEFAULT '' COMMENT '模型key',
  `disabled` tinyint(2) DEFAULT '1' COMMENT '是否禁用',
  `create_time` datetime ,
  `create_user_id` varchar(255)  ,
  `create_user_name` varchar(255)  ,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='常用流程码表';



-- ----------------------------
-- Table structure for QRTZ_BLOB_TRIGGERS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_BLOB_TRIGGERS`;
CREATE TABLE `QRTZ_BLOB_TRIGGERS` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `TRIGGER_NAME` varchar(200) NOT NULL,
  `TRIGGER_GROUP` varchar(200) NOT NULL,
  `BLOB_DATA` blob,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  KEY `SCHED_NAME` (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_blob_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for QRTZ_CALENDARS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_CALENDARS`;
CREATE TABLE `QRTZ_CALENDARS` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `CALENDAR_NAME` varchar(200) NOT NULL,
  `CALENDAR` blob NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`CALENDAR_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for QRTZ_CRON_TRIGGERS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_CRON_TRIGGERS`;
CREATE TABLE `QRTZ_CRON_TRIGGERS` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `TRIGGER_NAME` varchar(200) NOT NULL,
  `TRIGGER_GROUP` varchar(200) NOT NULL,
  `CRON_EXPRESSION` varchar(120) NOT NULL,
  `TIME_ZONE_ID` varchar(80) ,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_cron_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for QRTZ_FIRED_TRIGGERS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_FIRED_TRIGGERS`;
CREATE TABLE `QRTZ_FIRED_TRIGGERS` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `ENTRY_ID` varchar(95) NOT NULL,
  `TRIGGER_NAME` varchar(200) NOT NULL,
  `TRIGGER_GROUP` varchar(200) NOT NULL,
  `INSTANCE_NAME` varchar(200) NOT NULL,
  `FIRED_TIME` bigint(13) NOT NULL,
  `SCHED_TIME` bigint(13) NOT NULL,
  `PRIORITY` int(11) NOT NULL,
  `STATE` varchar(16) NOT NULL,
  `JOB_NAME` varchar(200) ,
  `JOB_GROUP` varchar(200) ,
  `IS_NONCONCURRENT` varchar(1) ,
  `REQUESTS_RECOVERY` varchar(1) ,
  PRIMARY KEY (`SCHED_NAME`,`ENTRY_ID`) USING BTREE,
  KEY `IDX_QRTZ_FT_TRIG_INST_NAME` (`SCHED_NAME`,`INSTANCE_NAME`) USING BTREE,
  KEY `IDX_QRTZ_FT_INST_JOB_REQ_RCVRY` (`SCHED_NAME`,`INSTANCE_NAME`,`REQUESTS_RECOVERY`) USING BTREE,
  KEY `IDX_QRTZ_FT_J_G` (`SCHED_NAME`,`JOB_NAME`,`JOB_GROUP`) USING BTREE,
  KEY `IDX_QRTZ_FT_JG` (`SCHED_NAME`,`JOB_GROUP`) USING BTREE,
  KEY `IDX_QRTZ_FT_T_G` (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  KEY `IDX_QRTZ_FT_TG` (`SCHED_NAME`,`TRIGGER_GROUP`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for QRTZ_JOB_DETAILS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_JOB_DETAILS`;
CREATE TABLE `QRTZ_JOB_DETAILS` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `JOB_NAME` varchar(200) NOT NULL,
  `JOB_GROUP` varchar(200) NOT NULL,
  `DESCRIPTION` varchar(250) ,
  `JOB_CLASS_NAME` varchar(250) NOT NULL,
  `IS_DURABLE` varchar(1) NOT NULL,
  `IS_NONCONCURRENT` varchar(1) NOT NULL,
  `IS_UPDATE_DATA` varchar(1) NOT NULL,
  `REQUESTS_RECOVERY` varchar(1) NOT NULL,
  `JOB_DATA` blob,
  PRIMARY KEY (`SCHED_NAME`,`JOB_NAME`,`JOB_GROUP`) USING BTREE,
  KEY `IDX_QRTZ_J_REQ_RECOVERY` (`SCHED_NAME`,`REQUESTS_RECOVERY`) USING BTREE,
  KEY `IDX_QRTZ_J_GRP` (`SCHED_NAME`,`JOB_GROUP`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for QRTZ_LOCKS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_LOCKS`;
CREATE TABLE `QRTZ_LOCKS` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `LOCK_NAME` varchar(40) NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`LOCK_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of QRTZ_LOCKS
-- ----------------------------
BEGIN;
INSERT INTO `QRTZ_LOCKS` VALUES ('RenrenScheduler', 'STATE_ACCESS');
INSERT INTO `QRTZ_LOCKS` VALUES ('RenrenScheduler', 'TRIGGER_ACCESS');
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_PAUSED_TRIGGER_GRPS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_PAUSED_TRIGGER_GRPS`;
CREATE TABLE `QRTZ_PAUSED_TRIGGER_GRPS` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `TRIGGER_GROUP` varchar(200) NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_GROUP`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for QRTZ_SCHEDULER_STATE
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_SCHEDULER_STATE`;
CREATE TABLE `QRTZ_SCHEDULER_STATE` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `INSTANCE_NAME` varchar(200) NOT NULL,
  `LAST_CHECKIN_TIME` bigint(13) NOT NULL,
  `CHECKIN_INTERVAL` bigint(13) NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`INSTANCE_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



-- ----------------------------
-- Table structure for QRTZ_SIMPLE_TRIGGERS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_SIMPLE_TRIGGERS`;
CREATE TABLE `QRTZ_SIMPLE_TRIGGERS` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `TRIGGER_NAME` varchar(200) NOT NULL,
  `TRIGGER_GROUP` varchar(200) NOT NULL,
  `REPEAT_COUNT` bigint(7) NOT NULL,
  `REPEAT_INTERVAL` bigint(12) NOT NULL,
  `TIMES_TRIGGERED` bigint(10) NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_simple_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for QRTZ_SIMPROP_TRIGGERS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_SIMPROP_TRIGGERS`;
CREATE TABLE `QRTZ_SIMPROP_TRIGGERS` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `TRIGGER_NAME` varchar(200) NOT NULL,
  `TRIGGER_GROUP` varchar(200) NOT NULL,
  `STR_PROP_1` varchar(512) ,
  `STR_PROP_2` varchar(512) ,
  `STR_PROP_3` varchar(512) ,
  `INT_PROP_1` int(11) ,
  `INT_PROP_2` int(11) ,
  `LONG_PROP_1` bigint(20) ,
  `LONG_PROP_2` bigint(20) ,
  `DEC_PROP_1` decimal(13,4) ,
  `DEC_PROP_2` decimal(13,4) ,
  `BOOL_PROP_1` varchar(1) ,
  `BOOL_PROP_2` varchar(1) ,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_simprop_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for QRTZ_TRIGGERS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_TRIGGERS`;
CREATE TABLE `QRTZ_TRIGGERS` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `TRIGGER_NAME` varchar(200) NOT NULL,
  `TRIGGER_GROUP` varchar(200) NOT NULL,
  `JOB_NAME` varchar(200) NOT NULL,
  `JOB_GROUP` varchar(200) NOT NULL,
  `DESCRIPTION` varchar(250) ,
  `NEXT_FIRE_TIME` bigint(13) ,
  `PREV_FIRE_TIME` bigint(13) ,
  `PRIORITY` int(11) ,
  `TRIGGER_STATE` varchar(16) NOT NULL,
  `TRIGGER_TYPE` varchar(8) NOT NULL,
  `START_TIME` bigint(13) NOT NULL,
  `END_TIME` bigint(13) ,
  `CALENDAR_NAME` varchar(200) ,
  `MISFIRE_INSTR` smallint(2) ,
  `JOB_DATA` blob,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  KEY `IDX_QRTZ_T_J` (`SCHED_NAME`,`JOB_NAME`,`JOB_GROUP`) USING BTREE,
  KEY `IDX_QRTZ_T_JG` (`SCHED_NAME`,`JOB_GROUP`) USING BTREE,
  KEY `IDX_QRTZ_T_C` (`SCHED_NAME`,`CALENDAR_NAME`) USING BTREE,
  KEY `IDX_QRTZ_T_G` (`SCHED_NAME`,`TRIGGER_GROUP`) USING BTREE,
  KEY `IDX_QRTZ_T_STATE` (`SCHED_NAME`,`TRIGGER_STATE`) USING BTREE,
  KEY `IDX_QRTZ_T_N_STATE` (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`,`TRIGGER_STATE`) USING BTREE,
  KEY `IDX_QRTZ_T_N_G_STATE` (`SCHED_NAME`,`TRIGGER_GROUP`,`TRIGGER_STATE`) USING BTREE,
  KEY `IDX_QRTZ_T_NEXT_FIRE_TIME` (`SCHED_NAME`,`NEXT_FIRE_TIME`) USING BTREE,
  KEY `IDX_QRTZ_T_NFT_ST` (`SCHED_NAME`,`TRIGGER_STATE`,`NEXT_FIRE_TIME`) USING BTREE,
  KEY `IDX_QRTZ_T_NFT_MISFIRE` (`SCHED_NAME`,`MISFIRE_INSTR`,`NEXT_FIRE_TIME`) USING BTREE,
  KEY `IDX_QRTZ_T_NFT_ST_MISFIRE` (`SCHED_NAME`,`MISFIRE_INSTR`,`NEXT_FIRE_TIME`,`TRIGGER_STATE`) USING BTREE,
  KEY `IDX_QRTZ_T_NFT_ST_MISFIRE_GRP` (`SCHED_NAME`,`MISFIRE_INSTR`,`NEXT_FIRE_TIME`,`TRIGGER_GROUP`,`TRIGGER_STATE`) USING BTREE,
  CONSTRAINT `qrtz_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`) REFERENCES `qrtz_job_details` (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for approval
-- ----------------------------
DROP TABLE IF EXISTS `approval`;
CREATE TABLE `approval` (
  `id` int(11) NOT NULL,
  `approval_content` varchar(255)  COMMENT '常用语内容',
  `approval_type` int(11)  COMMENT '常用语类型:1:全局 2:流程分类 3:流程定义',
  `flow_type` int(11)  COMMENT '流程分类者',
  `flow_id` varchar(255)  COMMENT '流程定义id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for pangu_bpm_user_script
-- ----------------------------
DROP TABLE IF EXISTS `pangu_bpm_user_script`;
CREATE TABLE `pangu_bpm_user_script` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `class_Name` varchar(255) COLLATE utf8mb4_bin  COMMENT '类名',
  `class_Ins_Name` varchar(255) COLLATE utf8mb4_bin  COMMENT '实例名称',
  `method_Name` varchar(255) COLLATE utf8mb4_bin  COMMENT '方法名称',
  `method_Desc` varchar(255) COLLATE utf8mb4_bin  COMMENT '方法描述',
  `return_Type` varchar(255) COLLATE utf8mb4_bin  COMMENT '返回值',
  `argument` varchar(1000) COLLATE utf8mb4_bin  COMMENT '参数说明',
  `enable` tinyint(1)  COMMENT '使用使用',
  `type` int(255) DEFAULT '0' COMMENT '类型',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;

-- ----------------------------
-- Records of pangu_bpm_user_script
-- ----------------------------
BEGIN;
INSERT INTO `pangu_bpm_user_script` VALUES (2, 'com.fastflow.modules.uc.service.ConditionScriptService', 'conditionScriptService', 'getUcUserByPostCode', '根据岗位code获取人员', 'java.util.List', '[{\n \"paraName\": \"arg0\",\n \"paraType\": \"java.lang.String\",\n \"paraDesc\": \"组织Code\",\n \"paraCtBindName\": \"code\",\n \"paraCtBindKey\": \"code\",\n  \"multiSelect\": false\n}]', 1, 0);
COMMIT;

-- ----------------------------
-- Table structure for schedule_job
-- ----------------------------
DROP TABLE IF EXISTS `schedule_job`;
CREATE TABLE `schedule_job` (
  `job_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '任务id',
  `bean_name` varchar(200)  COMMENT 'spring bean名称',
  `params` varchar(2000)  COMMENT '参数',
  `cron_expression` varchar(100)  COMMENT 'cron表达式',
  `status` tinyint(4)  COMMENT '任务状态  0：正常  1：暂停',
  `remark` varchar(255)  COMMENT '备注',
  `create_time` datetime  COMMENT '创建时间',
  PRIMARY KEY (`job_id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='定时任务';

-- ----------------------------
-- Records of schedule_job
-- ----------------------------
BEGIN;
INSERT INTO `schedule_job` VALUES (1, '1', '1', '1', NULL, '1', NULL);
COMMIT;

-- ----------------------------
-- Table structure for schedule_job_log
-- ----------------------------
DROP TABLE IF EXISTS `schedule_job_log`;
CREATE TABLE `schedule_job_log` (
  `log_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '任务日志id',
  `job_id` bigint(20) NOT NULL COMMENT '任务id',
  `bean_name` varchar(200)  COMMENT 'spring bean名称',
  `params` varchar(2000)  COMMENT '参数',
  `status` tinyint(4) NOT NULL COMMENT '任务状态    0：成功    1：失败',
  `error` varchar(2000)  COMMENT '失败信息',
  `times` int(11) NOT NULL COMMENT '耗时(单位：毫秒)',
  `create_time` datetime  COMMENT '创建时间',
  PRIMARY KEY (`log_id`) USING BTREE,
  KEY `job_id` (`job_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='定时任务日志';

-- ----------------------------
-- Table structure for sys_config
-- ----------------------------
DROP TABLE IF EXISTS `sys_config`;
CREATE TABLE `sys_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `param_key` varchar(50)  COMMENT 'key',
  `param_value` varchar(2000)  COMMENT 'value',
  `status` tinyint(4) DEFAULT '1' COMMENT '状态   0：隐藏   1：显示',
  `remark` varchar(500)  COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `param_key` (`param_key`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='系统配置信息表';

-- ----------------------------
-- Records of sys_config
-- ----------------------------
BEGIN;
INSERT INTO `sys_config` VALUES (1, 'CLOUD_STORAGE_CONFIG_KEY', '{\"aliyunAccessKeyId\":\"\",\"aliyunAccessKeySecret\":\"\",\"aliyunBucketName\":\"\",\"aliyunDomain\":\"\",\"aliyunEndPoint\":\"\",\"aliyunPrefix\":\"\",\"qcloudBucketName\":\"\",\"qcloudDomain\":\"\",\"qcloudPrefix\":\"\",\"qcloudSecretId\":\"\",\"qcloudSecretKey\":\"\",\"qiniuAccessKey\":\"NrgMfABZxWLo5B-YYSjoE8-AZ1EISdi1Z3ubLOeZ\",\"qiniuBucketName\":\"ios-app\",\"qiniuDomain\":\"http://7xqbwh.dl1.z0.glb.clouddn.com\",\"qiniuPrefix\":\"upload\",\"qiniuSecretKey\":\"uIwJHevMRWU0VLxFvgy0tAcOdGqasdtVlJkdy6vV\",\"type\":1}', 0, '云存储配置信息');
INSERT INTO `sys_config` VALUES (2, 'a', 'a', 1, 'a');
INSERT INTO `sys_config` VALUES (3, '1', '1', 1, '1');
COMMIT;

-- ----------------------------
-- Table structure for sys_data_source
-- ----------------------------
DROP TABLE IF EXISTS `sys_data_source`;
CREATE TABLE `sys_data_source` (
  `id_` varchar(255)  NOT NULL COMMENT '主键',
  `key_` varchar(255)   COMMENT '别名',
  `name_` varchar(255)   COMMENT '名称',
  `desc_` varchar(255)   COMMENT '描述',
  `db_type_` varchar(64)   COMMENT '类型',
  `class_path_` varchar(64)   COMMENT '路径',
  `attributes_json_` longblob COMMENT '配置',
  `DELETED` tinyint(1) DEFAULT '0' COMMENT '是否是系统的',
  PRIMARY KEY (`id_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='连接池';

-- ----------------------------
-- Records of sys_data_source
-- ----------------------------
BEGIN;
INSERT INTO `sys_data_source` VALUES ('1', 'dataSourceDefault', '本地数据源  ', '本地数据源 ', 'MYSQL', NULL, 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, 0);
INSERT INTO `sys_data_source` VALUES ('683048477462102016', '22', '11', '33', 'ORACLE', NULL, 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, 1);
INSERT INTO `sys_data_source` VALUES ('683081265699618816', '2323', '232', '', 'MYSQL', NULL, 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, 1);
INSERT INTO `sys_data_source` VALUES ('683084205604732928', '1', '1', '', 'MYSQL', NULL, 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, 1);
COMMIT;

-- ----------------------------
-- Table structure for sys_data_source_def
-- ----------------------------
DROP TABLE IF EXISTS `sys_data_source_def`;
CREATE TABLE `sys_data_source_def` (
  `id_` varchar(255)  NOT NULL COMMENT '主键',
  `name_` varchar(255)   COMMENT '名称',
  `class_path_` varchar(255)   COMMENT '类路径',
  `attributes_json_` longblob COMMENT '属性',
  `DELETED` tinyint(1)  COMMENT '是否已删，1已删除，0未删除',
  `system` tinyint(1)  COMMENT '是否是系统的',
  PRIMARY KEY (`id_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='连接池';

-- ----------------------------
-- Records of sys_data_source_def
-- ----------------------------
BEGIN;
INSERT INTO `sys_data_source_def` VALUES ('1', 'DURID数据源  ', 'com.alibaba.druid.pool.DruidDataSource', 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, 0, 1);
COMMIT;

-- ----------------------------
-- Table structure for sys_dept
-- ----------------------------
DROP TABLE IF EXISTS `sys_dept`;
CREATE TABLE `sys_dept` (
  `dept_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) DEFAULT '0' COMMENT '上级部门ID，一级部门为0',
  `name` varchar(50)  COMMENT '部门名称',
  `order_num` int(11)  COMMENT '排序',
  `del_flag` tinyint(4) DEFAULT '0' COMMENT '是否删除  -1：已删除  0：正常',
  PRIMARY KEY (`dept_id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='部门管理';



-- ----------------------------
-- Table structure for sys_dict
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict`;
CREATE TABLE `sys_dict` (
  `id` varchar(64)  NOT NULL COMMENT '主键id',
  `name` varchar(64)  NOT NULL COMMENT '名称',
  `type_Key` varchar(64)   COMMENT '类型key',
  `parent_id` varchar(64)  DEFAULT '0' COMMENT '父ID，一级菜单为-1',
  `order_num` int(11)  COMMENT '排序id',
  `status` varchar(255)   COMMENT '状态 0 禁用，1正常使用',
  `deleted` tinyint(1)  COMMENT '是否删除',
  `type_group_Key` varchar(255)   COMMENT '分类',
  `level` int(11)  COMMENT '级别',
  `create_Time` datetime ,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='分类表';

-- ----------------------------
-- Records of sys_dict
-- ----------------------------
BEGIN;
INSERT INTO `sys_dict` VALUES ('2', '数据字典', 'dic', '0', 2, '0', 0, '1', 0, '2020-02-27 08:48:43');
INSERT INTO `sys_dict` VALUES ('3', '业务订单', 'yewudingdan', '0', 2, '0', 0, '2222', 0, '2020-02-27 08:48:46');
INSERT INTO `sys_dict` VALUES ('4', '请假类型 ', 'qjlx', '3', 1, '0', 1, '2222', 1, '2020-02-27 08:48:48');
INSERT INTO `sys_dict` VALUES ('5', '计量单位', 'jiliangdanwei', '3', 1, '0', 0, '2222', 1, '2020-02-27 08:48:51');
INSERT INTO `sys_dict` VALUES ('682583508534689792', '4', '4', '2', NULL, NULL, 1, '1', 1, '2020-02-26 23:43:10');
INSERT INTO `sys_dict` VALUES ('682600071522418688', 'c', 'c', '4', 1, NULL, 1, '2222', 2, '2020-02-27 00:48:59');
INSERT INTO `sys_dict` VALUES ('682603583593512960', 'ffffffyy', 'ffyyyy', '4', 10, NULL, 0, '2222', 2, '2020-02-27 01:02:55');
INSERT INTO `sys_dict` VALUES ('682604106212179968', 'k', 'k', '4', 1, NULL, 1, '2222', 2, '2020-02-27 01:05:01');
INSERT INTO `sys_dict` VALUES ('682604481019379712', '2', '2', '4', 1, NULL, 1, '2222', 2, '2020-02-27 01:06:30');
INSERT INTO `sys_dict` VALUES ('682604510572445696', '3', '3', '4', 1, NULL, 1, '2222', 2, '2020-02-27 01:06:37');
INSERT INTO `sys_dict` VALUES ('682619393976303616', '55', '66', '682583508534689792', 1, NULL, 0, '1', 2, '2020-02-27 02:05:45');
INSERT INTO `sys_dict` VALUES ('682623131315077120', 'cc', 'ccc', '682603583593512960', 1, NULL, 0, '2222', 3, '2020-02-27 02:20:36');
COMMIT;

-- ----------------------------
-- Table structure for sys_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_log`;
CREATE TABLE `sys_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `username` varchar(50)  COMMENT '用户名',
  `operation` varchar(50)  COMMENT '用户操作',
  `method` varchar(200)  COMMENT '请求方法',
  `params` varchar(5000)  COMMENT '请求参数',
  `time` bigint(20) NOT NULL COMMENT '执行时长(毫秒)',
  `ip` varchar(64)  COMMENT 'IP地址',
  `create_date` datetime  COMMENT '创建时间',
  `url` varchar(255) ,
  `user_agent` varchar(255) ,
  `type` varchar(255) ,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='系统日志';



-- ----------------------------
-- Table structure for sys_menu
-- ----------------------------
DROP TABLE IF EXISTS `sys_menu`;
CREATE TABLE `sys_menu` (
  `menu_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20)  COMMENT '父菜单ID，一级菜单为0',
  `name` varchar(50)  COMMENT '菜单名称',
  `url` varchar(200)  COMMENT '菜单URL',
  `perms` varchar(500)  COMMENT '授权(多个用逗号分隔，如：user:list,user:create)',
  `type` int(11)  COMMENT '类型   0：目录   1：菜单   2：按钮',
  `icon` varchar(50)  COMMENT '菜单图标',
  `order_num` int(11)  COMMENT '排序',
  `deleted` tinyint(1) DEFAULT '0',
  `menu_level` int(11) ,
  PRIMARY KEY (`menu_id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='菜单管理';

-- ----------------------------
-- Records of sys_menu
-- ----------------------------
BEGIN;
INSERT INTO `sys_menu` VALUES (14, 6, '日志列表', NULL, 'sys:schedule:log', 2, NULL, 0, 1, 3);
INSERT INTO `sys_menu` VALUES (27, 120, '参数管理', 'modules/sys/config.html', 'sys:config:list,sys:config:info,sys:config:save,sys:config:update,sys:config:delete', 1, 'fa fa-snowflake-o', 6, 0, 3);
INSERT INTO `sys_menu` VALUES (43, 46, '流程优化管理', 'a1bpmn/api/runtime/def/v1/def/cockpit', '', 1, 'fa fa-sitemap', 10, 0, 3);
INSERT INTO `sys_menu` VALUES (46, 158, '流程管理', '', '', 0, 'fa fa-rocket', 2, 0, 2);
INSERT INTO `sys_menu` VALUES (47, 46, '模型管理', 'modules/flowable/process.html', '', 1, 'fa fa-diamond', 0, 0, 3);
INSERT INTO `sys_menu` VALUES (48, 46, '实例管理', 'a1bpmn/api/runtime/instance/v1/getInstanceListVo', '', 1, 'fa fa-database', 6, 0, 3);
INSERT INTO `sys_menu` VALUES (100, 46, '待阅任务', 'a1bpmn/api/commu/listVo', '', 1, 'fa fa-toggle-off', 3, 0, 3);
INSERT INTO `sys_menu` VALUES (102, 46, '已阅任务', 'a1bpmn/api/commu/his/listVo', '', 1, 'fa fa-toggle-on', 4, 0, 3);
INSERT INTO `sys_menu` VALUES (103, 46, '委托设置', 'a1bpmn/api/agent/listVo', '', 1, 'fa fa-street-view', 5, 0, 3);
INSERT INTO `sys_menu` VALUES (107, 46, '我的任务', 'a1bpmn/api/runtime/task/v1/listVO', NULL, 1, 'fa fa-tasks', 1, 0, 3);
INSERT INTO `sys_menu` VALUES (108, 46, '已办任务', 'a1bpmn/api/history/task/v1/listVO', '', 1, 'fa fa-server', 2, 0, 3);
INSERT INTO `sys_menu` VALUES (110, 157, '业务表单', '', '', 0, 'fa fa-wpforms', 0, 0, 2);
INSERT INTO `sys_menu` VALUES (111, 110, '业务对象', 'form/bus/businessObject/list', '', 1, 'fa fa-moon-o', 1, 0, 3);
INSERT INTO `sys_menu` VALUES (112, 110, '业务实体', 'form/bus/businessTable/businessTableList', '', 1, 'fa fa-database', 0, 0, 3);
INSERT INTO `sys_menu` VALUES (113, 110, '表单管理', 'form/design/list', '', 0, 'fa fa-diamond', 0, 0, 3);
INSERT INTO `sys_menu` VALUES (120, 159, '开发', '', '', 0, 'fa fa-cog', 2, 0, 2);
INSERT INTO `sys_menu` VALUES (121, 46, '常用流程', 'a1bpmn/api/runtime/bpmOftenFlow/v1/listVo', NULL, 1, 'fa fa-share-alt', 7, 0, 3);
INSERT INTO `sys_menu` VALUES (122, 46, '常用脚本', 'a1bpmn/api/runtime/runtime/script/v1/listVO', NULL, 1, 'fa fa-random', 8, 0, 3);
INSERT INTO `sys_menu` VALUES (123, 46, '流程消息模板', 'a1bpmn/api/messageTemplate/listVO', '', 1, 'fa fa-envelope-o', 9, 0, 3);
INSERT INTO `sys_menu` VALUES (124, 120, '访问日志', 'modules/sys/log.html', 'sys:log:list', 1, 'fa fa-lastfm', 10, 0, 3);
INSERT INTO `sys_menu` VALUES (125, 46, '引擎SQL监控', 'modules/flowable/sqlLog.html', NULL, 1, 'fa fa-table', 11, 0, 3);
INSERT INTO `sys_menu` VALUES (126, 160, '用户中心', '', NULL, 0, 'fa fa-share-alt', 4, 0, 2);
INSERT INTO `sys_menu` VALUES (127, 126, '职务管理', 'modules/uc/ucOrgJob.html', '', 1, 'fa fa-book', 1, 0, 3);
INSERT INTO `sys_menu` VALUES (128, 126, '组织维度管理', 'modules/uc/ucDemension.html', NULL, 1, 'fa fa-heart', 2, 0, 3);
INSERT INTO `sys_menu` VALUES (129, 126, '组织管理', 'modules/uc/dept.html', '', 1, 'fa fa-truck', 3, 0, 3);
INSERT INTO `sys_menu` VALUES (130, 126, '岗位管理', 'modules/uc/ucOrgPost.html', NULL, 1, 'fa fa-location-arrow', 4, 0, 3);
INSERT INTO `sys_menu` VALUES (132, 126, '用户管理', 'modules/uc/user.html', '', 1, 'fa fa-asterisk', 1, 0, 3);
INSERT INTO `sys_menu` VALUES (133, 126, '角色管理', 'modules/uc/role.html', '', 1, 'fa fa-group', 1, 0, 3);
INSERT INTO `sys_menu` VALUES (134, 126, '用户组织参数管理', 'modules/uc/params.html', NULL, 1, 'fa fa-certificate', 1, 0, 3);
INSERT INTO `sys_menu` VALUES (135, 120, '菜单管理', 'modules/sys/menuList.html', NULL, 1, 'fa fa-navicon', 3, 0, 3);
INSERT INTO `sys_menu` VALUES (144, 46, '流程缓存监控', 'modules/flowable/cacheMonitor.html', NULL, 1, 'fa fa-bar-chart', 11, 0, 3);
INSERT INTO `sys_menu` VALUES (145, 161, '决策引擎', NULL, NULL, 0, 'fa fa-space-shuttle', 4, 0, 2);
INSERT INTO `sys_menu` VALUES (146, 145, '决策模型管理', 'modules/dmn/model.html', NULL, 1, 'fa fa-diamond', 2, 0, 3);
INSERT INTO `sys_menu` VALUES (147, 145, '决策引擎执行日志', 'modules/dmn/modelLog.html', NULL, 1, ' fa fa-snowflake-o', 2, 0, 3);
INSERT INTO `sys_menu` VALUES (149, 120, '分类标识', 'modules/data/category.html', NULL, 1, 'fa fa-sitemap', 1, 0, 3);
INSERT INTO `sys_menu` VALUES (150, 120, '分类管理', 'modules/data/categoryTree.html', NULL, 1, 'fa fa-sliders', 1, 0, 3);
INSERT INTO `sys_menu` VALUES (151, 120, '数据字典', 'modules/data/dict.html', NULL, 1, 'fa fa-database', 1, 0, 3);
INSERT INTO `sys_menu` VALUES (152, 120, '流水号', 'modules/data/serialNo.html', NULL, 1, 'fa fa-braille', 1, 0, 3);
INSERT INTO `sys_menu` VALUES (153, 120, '系统图标', 'modules/data/font.html', NULL, 1, 'fa fa-cogs', 1, 0, 3);
INSERT INTO `sys_menu` VALUES (155, 120, '连接池', 'modules/data/connectionPool.html', NULL, 1, 'fa fa-database', 1, 0, 3);
INSERT INTO `sys_menu` VALUES (156, 120, '数据源', 'modules/data/dataSource.html', NULL, 1, 'fa fa-database', 1, 0, 3);
INSERT INTO `sys_menu` VALUES (157, 0, '业务表单', NULL, NULL, 3, 'fa fa-wpforms', 3, 0, 1);
INSERT INTO `sys_menu` VALUES (158, 0, '流程', NULL, NULL, 3, 'fa fa-rocket', 1, 0, 1);
INSERT INTO `sys_menu` VALUES (159, 0, '开发', NULL, NULL, 3, 'fa fa-cog', 6, 0, 1);
INSERT INTO `sys_menu` VALUES (160, 0, '用户中心', NULL, NULL, 3, 'fa fa-street-view', 2, 0, 1);
INSERT INTO `sys_menu` VALUES (161, 0, 'DMN', NULL, NULL, 3, 'fa fa-tasks', 4, 0, 1);
INSERT INTO `sys_menu` VALUES (170, 0, '案例管理', NULL, NULL, 3, 'fa fa-plane', 5, 0, 1);
INSERT INTO `sys_menu` VALUES (171, 172, '案例模型管理', 'modules/cmmn/modeler.html', NULL, 1, 'fa fa-diamond', 1, 0, 3);
INSERT INTO `sys_menu` VALUES (172, 170, '案例管理', NULL, NULL, 2, NULL, 1, 0, 2);
INSERT INTO `sys_menu` VALUES (173, 172, '案例实例管理', 'modules/cmmn/instanceList.html', NULL, 1, 'fa fa-database', 2, 0, 3);
INSERT INTO `sys_menu` VALUES (174, 172, '历史案例实例管理', 'modules/cmmn/hisInstanceList.html', NULL, 1, 'fa fa-truck', 7, 0, 3);
INSERT INTO `sys_menu` VALUES (175, 172, '运行计划项管理', 'modules/cmmn/planItemList.html', NULL, 1, 'fa fa-server', 3, 0, 3);
INSERT INTO `sys_menu` VALUES (176, 172, '历史计划项管理', 'modules/cmmn/hisPlanItemList.html', NULL, 1, 'fa fa-wpforms', 8, 0, 3);
INSERT INTO `sys_menu` VALUES (177, 172, '历史里程碑管理', 'modules/cmmn/hiMilestoneList.html', NULL, 1, 'fa fa-th-list', 9, 0, 3);
INSERT INTO `sys_menu` VALUES (178, 172, '运行里程碑管理', 'modules/cmmn/runMilestoneList.html', NULL, 1, 'fa fa-laptop', 4, 0, 3);
INSERT INTO `sys_menu` VALUES (179, 172, '资源管理', 'modules/cmmn/deployment.html', NULL, 1, 'fa fa-home', 5, 0, 3);
INSERT INTO `sys_menu` VALUES (180, 172, '缓存监控', 'modules/cmmn/cacheMonitor.html', NULL, 1, 'fa fa-map-marker', 6, 0, 3);
INSERT INTO `sys_menu` VALUES (182, 46, '引擎内核监控', 'modules/flowable/cmdLog.html', NULL, 1, 'fa fa-bar-chart-o', 12, 0, 3);
INSERT INTO `sys_menu` VALUES (183, 46, '引擎数据链路', 'modules/flowable/dataLink.html', NULL, 1, 'fa fa-bars', 12, 0, 3);
INSERT INTO `sys_menu` VALUES (184, 46, '引擎主键生成策略', 'modules/flowable/idCustom.html', NULL, 1, 'fa fa-bolt', 12, 0, 3);
COMMIT;

-- ----------------------------
-- Table structure for sys_oss
-- ----------------------------
DROP TABLE IF EXISTS `sys_oss`;
CREATE TABLE `sys_oss` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url` varchar(200)  COMMENT 'URL地址',
  `create_date` datetime  COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='文件上传';

-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_role`;
CREATE TABLE `sys_role` (
  `role_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `role_name` varchar(100)  COMMENT '角色名称',
  `remark` varchar(100)  COMMENT '备注',
  `dept_id` bigint(20)  COMMENT '部门ID',
  `create_time` datetime  COMMENT '创建时间',
  PRIMARY KEY (`role_id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='角色';



-- ----------------------------
-- Table structure for sys_role_dept
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_dept`;
CREATE TABLE `sys_role_dept` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `role_id` bigint(20)  COMMENT '角色ID',
  `dept_id` bigint(20)  COMMENT '部门ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='角色与部门对应关系';

-- ----------------------------
-- Table structure for sys_role_menu
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_menu`;
CREATE TABLE `sys_role_menu` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `role_id` bigint(20)  COMMENT '角色ID',
  `menu_id` bigint(20)  COMMENT '菜单ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='角色与菜单对应关系';

-- ----------------------------
-- Records of sys_role_menu
-- ----------------------------
BEGIN;
INSERT INTO `sys_role_menu` VALUES (476, 9, 1);
INSERT INTO `sys_role_menu` VALUES (477, 9, 4);
INSERT INTO `sys_role_menu` VALUES (478, 9, 23);
INSERT INTO `sys_role_menu` VALUES (479, 9, 24);
INSERT INTO `sys_role_menu` VALUES (480, 9, 25);
INSERT INTO `sys_role_menu` VALUES (481, 9, 26);
INSERT INTO `sys_role_menu` VALUES (482, 9, 5);
INSERT INTO `sys_role_menu` VALUES (483, 9, 6);
INSERT INTO `sys_role_menu` VALUES (484, 9, 7);
INSERT INTO `sys_role_menu` VALUES (485, 9, 8);
INSERT INTO `sys_role_menu` VALUES (486, 9, 9);
INSERT INTO `sys_role_menu` VALUES (487, 9, 10);
INSERT INTO `sys_role_menu` VALUES (488, 9, 11);
INSERT INTO `sys_role_menu` VALUES (489, 9, 12);
INSERT INTO `sys_role_menu` VALUES (490, 9, 13);
INSERT INTO `sys_role_menu` VALUES (491, 9, 14);
INSERT INTO `sys_role_menu` VALUES (492, 9, 27);
INSERT INTO `sys_role_menu` VALUES (493, 9, 29);
INSERT INTO `sys_role_menu` VALUES (494, 9, 36);
INSERT INTO `sys_role_menu` VALUES (495, 9, 37);
INSERT INTO `sys_role_menu` VALUES (496, 9, 38);
INSERT INTO `sys_role_menu` VALUES (497, 9, 39);
INSERT INTO `sys_role_menu` VALUES (498, 9, 40);
INSERT INTO `sys_role_menu` VALUES (499, 9, 41);
INSERT INTO `sys_role_menu` VALUES (500, 9, 2);
INSERT INTO `sys_role_menu` VALUES (501, 9, 15);
INSERT INTO `sys_role_menu` VALUES (502, 9, 16);
INSERT INTO `sys_role_menu` VALUES (503, 9, 17);
INSERT INTO `sys_role_menu` VALUES (504, 9, 18);
INSERT INTO `sys_role_menu` VALUES (505, 9, 3);
INSERT INTO `sys_role_menu` VALUES (506, 9, 19);
INSERT INTO `sys_role_menu` VALUES (507, 9, 20);
INSERT INTO `sys_role_menu` VALUES (508, 9, 21);
INSERT INTO `sys_role_menu` VALUES (509, 9, 22);
INSERT INTO `sys_role_menu` VALUES (510, 9, 31);
INSERT INTO `sys_role_menu` VALUES (511, 9, 32);
INSERT INTO `sys_role_menu` VALUES (514, 9, 35);
INSERT INTO `sys_role_menu` VALUES (515, 9, 42);
INSERT INTO `sys_role_menu` VALUES (516, 9, 43);
INSERT INTO `sys_role_menu` VALUES (517, 9, 46);
INSERT INTO `sys_role_menu` VALUES (518, 9, 47);
INSERT INTO `sys_role_menu` VALUES (519, 9, 48);
INSERT INTO `sys_role_menu` VALUES (520, 9, 53);
INSERT INTO `sys_role_menu` VALUES (521, 9, 54);
INSERT INTO `sys_role_menu` VALUES (522, 9, 56);
INSERT INTO `sys_role_menu` VALUES (523, 9, 100);
INSERT INTO `sys_role_menu` VALUES (524, 9, 102);
INSERT INTO `sys_role_menu` VALUES (525, 9, 103);
INSERT INTO `sys_role_menu` VALUES (529, 11, 1);
INSERT INTO `sys_role_menu` VALUES (530, 11, 4);
INSERT INTO `sys_role_menu` VALUES (531, 11, 23);
INSERT INTO `sys_role_menu` VALUES (532, 11, 24);
INSERT INTO `sys_role_menu` VALUES (533, 11, 25);
INSERT INTO `sys_role_menu` VALUES (534, 11, 26);
INSERT INTO `sys_role_menu` VALUES (535, 11, 5);
INSERT INTO `sys_role_menu` VALUES (536, 11, 6);
INSERT INTO `sys_role_menu` VALUES (537, 11, 7);
INSERT INTO `sys_role_menu` VALUES (538, 11, 8);
INSERT INTO `sys_role_menu` VALUES (539, 11, 9);
INSERT INTO `sys_role_menu` VALUES (540, 11, 10);
INSERT INTO `sys_role_menu` VALUES (541, 11, 11);
INSERT INTO `sys_role_menu` VALUES (542, 11, 12);
INSERT INTO `sys_role_menu` VALUES (543, 11, 13);
INSERT INTO `sys_role_menu` VALUES (544, 11, 14);
INSERT INTO `sys_role_menu` VALUES (545, 11, 27);
INSERT INTO `sys_role_menu` VALUES (546, 11, 29);
INSERT INTO `sys_role_menu` VALUES (547, 11, 36);
INSERT INTO `sys_role_menu` VALUES (548, 11, 37);
INSERT INTO `sys_role_menu` VALUES (549, 11, 38);
INSERT INTO `sys_role_menu` VALUES (550, 11, 39);
INSERT INTO `sys_role_menu` VALUES (551, 11, 40);
INSERT INTO `sys_role_menu` VALUES (552, 11, 41);
INSERT INTO `sys_role_menu` VALUES (553, 11, 2);
INSERT INTO `sys_role_menu` VALUES (554, 11, 15);
INSERT INTO `sys_role_menu` VALUES (555, 11, 16);
INSERT INTO `sys_role_menu` VALUES (556, 11, 17);
INSERT INTO `sys_role_menu` VALUES (557, 11, 18);
INSERT INTO `sys_role_menu` VALUES (558, 11, 3);
INSERT INTO `sys_role_menu` VALUES (559, 11, 19);
INSERT INTO `sys_role_menu` VALUES (560, 11, 20);
INSERT INTO `sys_role_menu` VALUES (561, 11, 21);
INSERT INTO `sys_role_menu` VALUES (562, 11, 22);
INSERT INTO `sys_role_menu` VALUES (563, 11, 31);
INSERT INTO `sys_role_menu` VALUES (564, 11, 32);
INSERT INTO `sys_role_menu` VALUES (567, 11, 35);
INSERT INTO `sys_role_menu` VALUES (568, 11, 42);
INSERT INTO `sys_role_menu` VALUES (569, 11, 43);
INSERT INTO `sys_role_menu` VALUES (570, 11, 46);
INSERT INTO `sys_role_menu` VALUES (571, 11, 47);
INSERT INTO `sys_role_menu` VALUES (572, 11, 48);
INSERT INTO `sys_role_menu` VALUES (573, 11, 53);
INSERT INTO `sys_role_menu` VALUES (574, 11, 54);
INSERT INTO `sys_role_menu` VALUES (575, 11, 56);
INSERT INTO `sys_role_menu` VALUES (576, 11, 100);
INSERT INTO `sys_role_menu` VALUES (577, 11, 102);
INSERT INTO `sys_role_menu` VALUES (578, 11, 103);
INSERT INTO `sys_role_menu` VALUES (579, 12, 41);
INSERT INTO `sys_role_menu` VALUES (580, 12, 3);
INSERT INTO `sys_role_menu` VALUES (581, 12, 19);
INSERT INTO `sys_role_menu` VALUES (582, 12, 20);
INSERT INTO `sys_role_menu` VALUES (583, 12, 21);
INSERT INTO `sys_role_menu` VALUES (584, 12, 22);
INSERT INTO `sys_role_menu` VALUES (631, 13, 1);
INSERT INTO `sys_role_menu` VALUES (632, 13, 4);
INSERT INTO `sys_role_menu` VALUES (633, 13, 23);
INSERT INTO `sys_role_menu` VALUES (634, 13, 24);
INSERT INTO `sys_role_menu` VALUES (635, 13, 25);
INSERT INTO `sys_role_menu` VALUES (636, 13, 26);
INSERT INTO `sys_role_menu` VALUES (637, 13, 5);
INSERT INTO `sys_role_menu` VALUES (638, 13, 6);
INSERT INTO `sys_role_menu` VALUES (639, 13, 7);
INSERT INTO `sys_role_menu` VALUES (640, 13, 8);
INSERT INTO `sys_role_menu` VALUES (641, 13, 9);
INSERT INTO `sys_role_menu` VALUES (642, 13, 10);
INSERT INTO `sys_role_menu` VALUES (643, 13, 11);
INSERT INTO `sys_role_menu` VALUES (644, 13, 12);
INSERT INTO `sys_role_menu` VALUES (645, 13, 14);
INSERT INTO `sys_role_menu` VALUES (646, 13, 27);
INSERT INTO `sys_role_menu` VALUES (647, 13, 36);
INSERT INTO `sys_role_menu` VALUES (648, 13, 37);
INSERT INTO `sys_role_menu` VALUES (649, 13, 38);
INSERT INTO `sys_role_menu` VALUES (650, 13, 39);
INSERT INTO `sys_role_menu` VALUES (651, 13, 40);
INSERT INTO `sys_role_menu` VALUES (652, 13, 41);
INSERT INTO `sys_role_menu` VALUES (653, 13, 2);
INSERT INTO `sys_role_menu` VALUES (654, 13, 15);
INSERT INTO `sys_role_menu` VALUES (655, 13, 16);
INSERT INTO `sys_role_menu` VALUES (656, 13, 17);
INSERT INTO `sys_role_menu` VALUES (657, 13, 3);
INSERT INTO `sys_role_menu` VALUES (658, 13, 19);
INSERT INTO `sys_role_menu` VALUES (659, 13, 20);
INSERT INTO `sys_role_menu` VALUES (660, 13, 21);
INSERT INTO `sys_role_menu` VALUES (661, 13, 31);
INSERT INTO `sys_role_menu` VALUES (662, 13, 32);
INSERT INTO `sys_role_menu` VALUES (665, 13, 42);
INSERT INTO `sys_role_menu` VALUES (666, 13, 43);
INSERT INTO `sys_role_menu` VALUES (667, 13, 46);
INSERT INTO `sys_role_menu` VALUES (668, 13, 47);
INSERT INTO `sys_role_menu` VALUES (669, 13, 48);
INSERT INTO `sys_role_menu` VALUES (670, 13, 53);
INSERT INTO `sys_role_menu` VALUES (671, 13, 56);
INSERT INTO `sys_role_menu` VALUES (672, 13, 100);
INSERT INTO `sys_role_menu` VALUES (673, 13, 102);
INSERT INTO `sys_role_menu` VALUES (674, 13, 103);
INSERT INTO `sys_role_menu` VALUES (675, 13, 107);
INSERT INTO `sys_role_menu` VALUES (676, 13, 108);
INSERT INTO `sys_role_menu` VALUES (677, 8, 1);
INSERT INTO `sys_role_menu` VALUES (678, 8, 4);
INSERT INTO `sys_role_menu` VALUES (679, 8, 23);
INSERT INTO `sys_role_menu` VALUES (680, 8, 24);
INSERT INTO `sys_role_menu` VALUES (681, 8, 25);
INSERT INTO `sys_role_menu` VALUES (682, 8, 26);
INSERT INTO `sys_role_menu` VALUES (683, 8, 5);
INSERT INTO `sys_role_menu` VALUES (684, 8, 6);
INSERT INTO `sys_role_menu` VALUES (685, 8, 7);
INSERT INTO `sys_role_menu` VALUES (686, 8, 8);
INSERT INTO `sys_role_menu` VALUES (687, 8, 9);
INSERT INTO `sys_role_menu` VALUES (688, 8, 10);
INSERT INTO `sys_role_menu` VALUES (689, 8, 11);
INSERT INTO `sys_role_menu` VALUES (690, 8, 12);
INSERT INTO `sys_role_menu` VALUES (691, 8, 14);
INSERT INTO `sys_role_menu` VALUES (692, 8, 27);
INSERT INTO `sys_role_menu` VALUES (693, 8, 36);
INSERT INTO `sys_role_menu` VALUES (694, 8, 37);
INSERT INTO `sys_role_menu` VALUES (695, 8, 38);
INSERT INTO `sys_role_menu` VALUES (696, 8, 39);
INSERT INTO `sys_role_menu` VALUES (697, 8, 40);
INSERT INTO `sys_role_menu` VALUES (698, 8, 41);
INSERT INTO `sys_role_menu` VALUES (699, 8, 2);
INSERT INTO `sys_role_menu` VALUES (700, 8, 15);
INSERT INTO `sys_role_menu` VALUES (701, 8, 16);
INSERT INTO `sys_role_menu` VALUES (702, 8, 17);
INSERT INTO `sys_role_menu` VALUES (703, 8, 3);
INSERT INTO `sys_role_menu` VALUES (704, 8, 19);
INSERT INTO `sys_role_menu` VALUES (705, 8, 20);
INSERT INTO `sys_role_menu` VALUES (706, 8, 21);
INSERT INTO `sys_role_menu` VALUES (707, 8, 31);
INSERT INTO `sys_role_menu` VALUES (708, 8, 32);
INSERT INTO `sys_role_menu` VALUES (711, 8, 42);
INSERT INTO `sys_role_menu` VALUES (712, 8, 43);
INSERT INTO `sys_role_menu` VALUES (713, 8, 46);
INSERT INTO `sys_role_menu` VALUES (714, 8, 47);
INSERT INTO `sys_role_menu` VALUES (715, 8, 48);
INSERT INTO `sys_role_menu` VALUES (716, 8, 53);
INSERT INTO `sys_role_menu` VALUES (717, 8, 56);
INSERT INTO `sys_role_menu` VALUES (718, 8, 100);
INSERT INTO `sys_role_menu` VALUES (719, 8, 102);
INSERT INTO `sys_role_menu` VALUES (720, 8, 103);
INSERT INTO `sys_role_menu` VALUES (721, 8, 107);
INSERT INTO `sys_role_menu` VALUES (722, 8, 108);
INSERT INTO `sys_role_menu` VALUES (723, 6, 1);
INSERT INTO `sys_role_menu` VALUES (724, 6, 4);
INSERT INTO `sys_role_menu` VALUES (725, 6, 23);
INSERT INTO `sys_role_menu` VALUES (726, 6, 24);
INSERT INTO `sys_role_menu` VALUES (727, 6, 25);
INSERT INTO `sys_role_menu` VALUES (728, 6, 26);
INSERT INTO `sys_role_menu` VALUES (729, 6, 5);
INSERT INTO `sys_role_menu` VALUES (730, 6, 6);
INSERT INTO `sys_role_menu` VALUES (731, 6, 7);
INSERT INTO `sys_role_menu` VALUES (732, 6, 8);
INSERT INTO `sys_role_menu` VALUES (733, 6, 9);
INSERT INTO `sys_role_menu` VALUES (734, 6, 10);
INSERT INTO `sys_role_menu` VALUES (735, 6, 11);
INSERT INTO `sys_role_menu` VALUES (736, 6, 12);
INSERT INTO `sys_role_menu` VALUES (737, 6, 14);
INSERT INTO `sys_role_menu` VALUES (738, 6, 27);
INSERT INTO `sys_role_menu` VALUES (739, 6, 36);
INSERT INTO `sys_role_menu` VALUES (740, 6, 37);
INSERT INTO `sys_role_menu` VALUES (741, 6, 38);
INSERT INTO `sys_role_menu` VALUES (742, 6, 39);
INSERT INTO `sys_role_menu` VALUES (743, 6, 40);
INSERT INTO `sys_role_menu` VALUES (744, 6, 41);
INSERT INTO `sys_role_menu` VALUES (745, 6, 2);
INSERT INTO `sys_role_menu` VALUES (746, 6, 15);
INSERT INTO `sys_role_menu` VALUES (747, 6, 16);
INSERT INTO `sys_role_menu` VALUES (748, 6, 17);
INSERT INTO `sys_role_menu` VALUES (749, 6, 3);
INSERT INTO `sys_role_menu` VALUES (750, 6, 19);
INSERT INTO `sys_role_menu` VALUES (751, 6, 20);
INSERT INTO `sys_role_menu` VALUES (752, 6, 21);
INSERT INTO `sys_role_menu` VALUES (753, 6, 31);
INSERT INTO `sys_role_menu` VALUES (754, 6, 32);
INSERT INTO `sys_role_menu` VALUES (757, 6, 42);
INSERT INTO `sys_role_menu` VALUES (758, 6, 43);
INSERT INTO `sys_role_menu` VALUES (759, 6, 46);
INSERT INTO `sys_role_menu` VALUES (760, 6, 47);
INSERT INTO `sys_role_menu` VALUES (761, 6, 48);
INSERT INTO `sys_role_menu` VALUES (762, 6, 53);
INSERT INTO `sys_role_menu` VALUES (763, 6, 56);
INSERT INTO `sys_role_menu` VALUES (764, 6, 100);
INSERT INTO `sys_role_menu` VALUES (765, 6, 102);
INSERT INTO `sys_role_menu` VALUES (766, 6, 103);
INSERT INTO `sys_role_menu` VALUES (767, 6, 107);
INSERT INTO `sys_role_menu` VALUES (768, 6, 108);
INSERT INTO `sys_role_menu` VALUES (813, 7, 4);
INSERT INTO `sys_role_menu` VALUES (814, 7, 23);
INSERT INTO `sys_role_menu` VALUES (815, 7, 24);
INSERT INTO `sys_role_menu` VALUES (816, 7, 25);
INSERT INTO `sys_role_menu` VALUES (817, 7, 26);
INSERT INTO `sys_role_menu` VALUES (818, 7, 5);
INSERT INTO `sys_role_menu` VALUES (819, 7, 6);
INSERT INTO `sys_role_menu` VALUES (820, 7, 7);
INSERT INTO `sys_role_menu` VALUES (821, 7, 8);
INSERT INTO `sys_role_menu` VALUES (822, 7, 9);
INSERT INTO `sys_role_menu` VALUES (823, 7, 10);
INSERT INTO `sys_role_menu` VALUES (824, 7, 11);
INSERT INTO `sys_role_menu` VALUES (825, 7, 12);
INSERT INTO `sys_role_menu` VALUES (826, 7, 14);
INSERT INTO `sys_role_menu` VALUES (827, 7, 27);
INSERT INTO `sys_role_menu` VALUES (828, 7, 36);
INSERT INTO `sys_role_menu` VALUES (829, 7, 37);
INSERT INTO `sys_role_menu` VALUES (830, 7, 38);
INSERT INTO `sys_role_menu` VALUES (831, 7, 39);
INSERT INTO `sys_role_menu` VALUES (832, 7, 40);
INSERT INTO `sys_role_menu` VALUES (833, 7, 41);
INSERT INTO `sys_role_menu` VALUES (834, 7, 2);
INSERT INTO `sys_role_menu` VALUES (835, 7, 15);
INSERT INTO `sys_role_menu` VALUES (836, 7, 16);
INSERT INTO `sys_role_menu` VALUES (837, 7, 17);
INSERT INTO `sys_role_menu` VALUES (838, 7, 3);
INSERT INTO `sys_role_menu` VALUES (839, 7, 19);
INSERT INTO `sys_role_menu` VALUES (840, 7, 20);
INSERT INTO `sys_role_menu` VALUES (841, 7, 21);
INSERT INTO `sys_role_menu` VALUES (842, 7, 31);
INSERT INTO `sys_role_menu` VALUES (843, 7, 32);
INSERT INTO `sys_role_menu` VALUES (846, 7, 42);
INSERT INTO `sys_role_menu` VALUES (847, 7, 43);
INSERT INTO `sys_role_menu` VALUES (848, 7, 46);
INSERT INTO `sys_role_menu` VALUES (849, 7, 47);
INSERT INTO `sys_role_menu` VALUES (850, 7, 48);
INSERT INTO `sys_role_menu` VALUES (851, 7, 53);
INSERT INTO `sys_role_menu` VALUES (852, 7, 56);
INSERT INTO `sys_role_menu` VALUES (853, 7, 100);
INSERT INTO `sys_role_menu` VALUES (854, 7, 102);
INSERT INTO `sys_role_menu` VALUES (855, 7, 103);
INSERT INTO `sys_role_menu` VALUES (906, 14, 41);
INSERT INTO `sys_role_menu` VALUES (907, 14, 2);
INSERT INTO `sys_role_menu` VALUES (908, 14, 15);
INSERT INTO `sys_role_menu` VALUES (909, 14, 16);
INSERT INTO `sys_role_menu` VALUES (910, 14, 17);
INSERT INTO `sys_role_menu` VALUES (911, 14, 3);
INSERT INTO `sys_role_menu` VALUES (912, 14, 19);
INSERT INTO `sys_role_menu` VALUES (913, 14, 20);
INSERT INTO `sys_role_menu` VALUES (914, 14, 21);
INSERT INTO `sys_role_menu` VALUES (915, 14, 31);
INSERT INTO `sys_role_menu` VALUES (916, 14, 32);
INSERT INTO `sys_role_menu` VALUES (919, 14, 42);
INSERT INTO `sys_role_menu` VALUES (920, 14, 43);
INSERT INTO `sys_role_menu` VALUES (921, 14, 46);
INSERT INTO `sys_role_menu` VALUES (922, 14, 47);
INSERT INTO `sys_role_menu` VALUES (923, 14, 48);
INSERT INTO `sys_role_menu` VALUES (924, 14, 53);
INSERT INTO `sys_role_menu` VALUES (925, 14, 56);
INSERT INTO `sys_role_menu` VALUES (926, 14, 100);
INSERT INTO `sys_role_menu` VALUES (927, 14, 102);
INSERT INTO `sys_role_menu` VALUES (928, 14, 103);
INSERT INTO `sys_role_menu` VALUES (929, 14, 107);
INSERT INTO `sys_role_menu` VALUES (930, 14, 108);
INSERT INTO `sys_role_menu` VALUES (931, 14, 110);
INSERT INTO `sys_role_menu` VALUES (932, 14, 111);
INSERT INTO `sys_role_menu` VALUES (933, 14, 112);
INSERT INTO `sys_role_menu` VALUES (934, 14, 113);
INSERT INTO `sys_role_menu` VALUES (935, 14, 120);
INSERT INTO `sys_role_menu` VALUES (936, 14, 4);
INSERT INTO `sys_role_menu` VALUES (937, 14, 23);
INSERT INTO `sys_role_menu` VALUES (938, 14, 24);
INSERT INTO `sys_role_menu` VALUES (939, 14, 25);
INSERT INTO `sys_role_menu` VALUES (940, 14, 26);
INSERT INTO `sys_role_menu` VALUES (941, 14, 5);
INSERT INTO `sys_role_menu` VALUES (942, 14, 6);
INSERT INTO `sys_role_menu` VALUES (943, 14, 7);
INSERT INTO `sys_role_menu` VALUES (944, 14, 8);
INSERT INTO `sys_role_menu` VALUES (945, 14, 9);
INSERT INTO `sys_role_menu` VALUES (946, 14, 10);
INSERT INTO `sys_role_menu` VALUES (947, 14, 11);
INSERT INTO `sys_role_menu` VALUES (948, 14, 12);
INSERT INTO `sys_role_menu` VALUES (949, 14, 14);
INSERT INTO `sys_role_menu` VALUES (950, 14, 27);
INSERT INTO `sys_role_menu` VALUES (951, 14, 36);
INSERT INTO `sys_role_menu` VALUES (952, 14, 37);
INSERT INTO `sys_role_menu` VALUES (953, 14, 38);
INSERT INTO `sys_role_menu` VALUES (954, 14, 39);
INSERT INTO `sys_role_menu` VALUES (955, 14, 40);
COMMIT;

-- ----------------------------
-- Table structure for sys_serialno
-- ----------------------------
DROP TABLE IF EXISTS `sys_serialno`;
CREATE TABLE `sys_serialno` (
  `ID_` varchar(255)  NOT NULL COMMENT '主键',
  `NAME_` varchar(255)   COMMENT '名称',
  `ALIAS_` varchar(255)   COMMENT '别名',
  `regulation_` varchar(255)   COMMENT '流水号规则',
  `gen_type_` decimal(10,0)  COMMENT '生成类型',
  `no_length_` decimal(10,0)  COMMENT '流水号长度',
  `cur_date_` varchar(255)   COMMENT '执行实例id',
  `init_value_` decimal(10,0)  COMMENT '初始值',
  `cur_value_` decimal(10,0)  COMMENT '是否成功',
  `step_` decimal(10,0)  COMMENT '步长',
  `DELETED` tinyint(1)  COMMENT '是否直接删除',
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='流水号';

-- ----------------------------
-- Records of sys_serialno
-- ----------------------------
BEGIN;
INSERT INTO `sys_serialno` VALUES ('1', '每天使用一组流水号', 'dayNo', '{yyyy}{MM}{DD}{NO}', 1, 5, NULL, 1, 0, 2, 0);
INSERT INTO `sys_serialno` VALUES ('682692501894594560', 'ccc', 'c', 'c', 1, 1, NULL, 1, 0, 1, 1);
INSERT INTO `sys_serialno` VALUES ('682693608511373312', '1', '1', '1', 1, 111, NULL, 111, 0, 1, 1);
INSERT INTO `sys_serialno` VALUES ('682698470624067584', '12121', '12121', '12122', 1, 1, NULL, 1, 0, 1, 1);
INSERT INTO `sys_serialno` VALUES ('682701400144084992', '88888', '121212', '12122', 2, 1, NULL, 1, 0, 1, 1);
INSERT INTO `sys_serialno` VALUES ('682702240028295168', '77', '77', '777', 2, 777, NULL, 777, 0, 777, 1);
COMMIT;

-- ----------------------------
-- Table structure for sys_type
-- ----------------------------
DROP TABLE IF EXISTS `sys_type`;
CREATE TABLE `sys_type` (
  `id_` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `title_` varchar(64)  NOT NULL COMMENT '名称',
  `type_key_` varchar(64)   COMMENT '类型key',
  `parent_id_` bigint(20) DEFAULT '-1' COMMENT '父ID，一级菜单为-1',
  `order_id_` int(11)  COMMENT '排序id',
  `status_` varchar(255)   COMMENT '状态 0 禁用，1正常使用',
  `scope_id_` varchar(64)   COMMENT 'BPMN/CMMN/DMN类型',
  PRIMARY KEY (`id_`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='分类表';

-- ----------------------------
-- Records of sys_type
-- ----------------------------
BEGIN;
INSERT INTO `sys_type` VALUES (20039, '所有数据', 'all', -1, NULL, '1', 'FORM');
INSERT INTO `sys_type` VALUES (20040, '默认分类', 'default', 20039, NULL, '1', 'FORM');
INSERT INTO `sys_type` VALUES (20041, '请假流程', 'renshi', 20039, NULL, '1', 'FORM');
INSERT INTO `sys_type` VALUES (20072, '请假流程', 'leave', 20074, NULL, '1', 'BPMN');
INSERT INTO `sys_type` VALUES (20073, '客户招待流程', 'fybx', 20074, NULL, '1', 'BPMN');
INSERT INTO `sys_type` VALUES (20074, '默认流程', 'all', -1, NULL, '1', 'BPMN');
INSERT INTO `sys_type` VALUES (20075, '客户招待流程', 'fybx_form', 20039, NULL, '1', 'FORM');
INSERT INTO `sys_type` VALUES (20076, '借款申请', 'jksq', 20074, NULL, '1', 'BPMN');
INSERT INTO `sys_type` VALUES (20077, '借款申请', 'jksq', 20039, NULL, '1', 'FORM');
INSERT INTO `sys_type` VALUES (20078, '默认分类', 'all', -1, NULL, '1', 'DMN');
INSERT INTO `sys_type` VALUES (20079, '请假流程决策', 'leave_dmn', 20078, NULL, '1', 'DMN');
INSERT INTO `sys_type` VALUES (20085, '444', 'qw', -1, NULL, '1', 'qw');
INSERT INTO `sys_type` VALUES (20086, '666', '5', -1, NULL, '0', '5');
INSERT INTO `sys_type` VALUES (66666, '66688888', '1', 20039, NULL, '0', NULL);
INSERT INTO `sys_type` VALUES (66667, '3', '2', 20040, NULL, '0', 'BPMN');
INSERT INTO `sys_type` VALUES (66668, '7', '7', 66666, NULL, '0', 'BPMN');
INSERT INTO `sys_type` VALUES (66669, '22', '2222', 20039, NULL, '0', 'BPMN');
INSERT INTO `sys_type` VALUES (66670, '77', '777', 20039, NULL, '0', 'BPMN');
INSERT INTO `sys_type` VALUES (66671, '888', '88', 20039, NULL, '0', 'BPMN');
INSERT INTO `sys_type` VALUES (66672, '999', '99', 20039, NULL, '0', 'BPMN');
INSERT INTO `sys_type` VALUES (66673, '1', '', 20039, NULL, '0', 'BPMN');
INSERT INTO `sys_type` VALUES (66674, '1212121', '212121', 20039, NULL, '0', 'BPMN');
INSERT INTO `sys_type` VALUES (66675, '1', '333', 20039, NULL, '0', 'BPMN');
INSERT INTO `sys_type` VALUES (66676, '11', '444', 20039, NULL, '0', 'BPMN');
INSERT INTO `sys_type` VALUES (66677, '4', '4', 20039, NULL, '0', 'BPMN');
INSERT INTO `sys_type` VALUES (66678, '599', '9995', 66677, NULL, '0', 'BPMN');
INSERT INTO `sys_type` VALUES (66679, '所有数据', 'all', -1, 1, '1', 'CMMN');
INSERT INTO `sys_type` VALUES (66680, 'RPA流程', 'rpa', 66679, 1, '1', 'CMMN');
COMMIT;

-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
DROP TABLE IF EXISTS `sys_user`;
CREATE TABLE `sys_user` (
  `user_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL COMMENT '用户名',
  `password` varchar(100)  COMMENT '密码',
  `salt` varchar(20)  COMMENT '盐',
  `email` varchar(100)  COMMENT '邮箱',
  `mobile` varchar(100)  COMMENT '手机号',
  `status` tinyint(4)  COMMENT '状态  0：禁用   1：正常',
  `dept_id` bigint(20)  COMMENT '部门ID',
  `create_time` datetime  COMMENT '创建时间',
  `realname` varchar(255) ,
  PRIMARY KEY (`user_id`) USING BTREE,
  UNIQUE KEY `username` (`username`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='系统用户';

-- ----------------------------
-- Records of sys_user
-- ----------------------------
BEGIN;
INSERT INTO `sys_user` VALUES (1, 'admin', 'e1153123d7d180ceeb820d577ff119876678732a68eef4e6ffc0b1f06a01f91b', 'YzcmCZNvbXocrsz9dm8e', 'root@aa.io', '13612345678', 1, 0, '2016-11-11 11:11:11', '管理员');
INSERT INTO `sys_user` VALUES (2, 'zhangsan', '5f9c50b9d370e553b076ecf20870baab6dff1d061fb15868b62ca17f04b70a16', 'YzcmCZNvbXocrsz9dm8e', '1234@qq.com', '', 1, 6, '2019-07-12 09:54:35', '张三');
INSERT INTO `sys_user` VALUES (3, 'lisi', '63e89f967920e659c226441b21b3701f707c02d0b6ee7e1f52c24ded62cb0dbe', 'YzcmCZNvbXocrsz9dm8e', 'lisi@qq.com', '13612345678', 1, 15, '2019-10-14 07:25:10', '李四');
INSERT INTO `sys_user` VALUES (4, '鲁正豪', 'e1153123d7d180ceeb820d577ff119876678732a68eef4e6ffc0b1f06a01f91b', 'YzcmCZNvbXocrsz9dm8e', 'root@renren.io', '13612345678', 1, 1, '2016-11-11 11:11:11', '鲁正豪');
INSERT INTO `sys_user` VALUES (5, '郁艳', 'e1153123d7d180ceeb820d577ff119876678732a68eef4e6ffc0b1f06a01f91b', 'YzcmCZNvbXocrsz9dm8e', 'root@renren.io', '13612345678', 1, 1, '2016-11-11 11:11:11', '郁艳');
INSERT INTO `sys_user` VALUES (6, '沈瑾瑜', 'e1153123d7d180ceeb820d577ff119876678732a68eef4e6ffc0b1f06a01f91b', 'YzcmCZNvbXocrsz9dm8e', 'root@renren.io', '13612345678', 1, 1, '2016-11-11 11:11:11', '沈瑾瑜');
INSERT INTO `sys_user` VALUES (7, '公羊艳', 'e1153123d7d180ceeb820d577ff119876678732a68eef4e6ffc0b1f06a01f91b', 'YzcmCZNvbXocrsz9dm8e', 'root@renren.io', '13612345678', 1, 1, '2016-11-11 11:11:11', '公羊艳');
INSERT INTO `sys_user` VALUES (8, '刘备', 'e1153123d7d180ceeb820d577ff119876678732a68eef4e6ffc0b1f06a01f91b', 'YzcmCZNvbXocrsz9dm8e', 'root@renren.io', '13612345678', 1, 1, '2016-11-11 11:11:11', '刘备');
INSERT INTO `sys_user` VALUES (9, '司马昭', 'e1153123d7d180ceeb820d577ff119876678732a68eef4e6ffc0b1f06a01f91b', 'YzcmCZNvbXocrsz9dm8e', 'root@renren.io', '13612345678', 1, 1, '2016-11-11 11:11:11', '司马昭');
INSERT INTO `sys_user` VALUES (10, '任乾', 'e1153123d7d180ceeb820d577ff119876678732a68eef4e6ffc0b1f06a01f91b', 'YzcmCZNvbXocrsz9dm8e', 'root@renren.io', '13612345678', 1, 1, '2016-11-11 11:11:11', '任乾');
INSERT INTO `sys_user` VALUES (11, '吴家骥', 'e1153123d7d180ceeb820d577ff119876678732a68eef4e6ffc0b1f06a01f91b', 'YzcmCZNvbXocrsz9dm8e', 'root@renren.io', '13612345678', 1, 1, '2016-11-11 11:11:11', '吴家骥');
INSERT INTO `sys_user` VALUES (31, 'Athena', 'fedea25e626f37f307a9e7b8433242cfa25550f7f74bc77e83f80293bf21366f', 'YRZ2WvzCaaZvNySl8CtU', '1012150528@qq.com', '111', 1, 1, '2019-12-16 01:58:00', 'Athena');
INSERT INTO `sys_user` VALUES (32, 'wangfei', 'd44a99609711cf18c80a930dcca53ea43825f4bb4b284bd1aa4329860eb35d75', 'aLdhdDH54SZtdtReCYDc', '10@qq.com', '111', 1, 1, '2019-12-16 01:58:23', 'wangfei');
COMMIT;

-- ----------------------------
-- Table structure for sys_user_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_role`;
CREATE TABLE `sys_user_role` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20)  COMMENT '用户ID',
  `role_id` bigint(20)  COMMENT '角色ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='用户与角色对应关系';

-- ----------------------------
-- Records of sys_user_role
-- ----------------------------
BEGIN;
INSERT INTO `sys_user_role` VALUES (44, 12, 6);
INSERT INTO `sys_user_role` VALUES (48, 14, 7);
INSERT INTO `sys_user_role` VALUES (49, 15, 7);
INSERT INTO `sys_user_role` VALUES (50, 16, 7);
INSERT INTO `sys_user_role` VALUES (51, 17, 8);
INSERT INTO `sys_user_role` VALUES (52, 18, 9);
INSERT INTO `sys_user_role` VALUES (54, 19, 7);
INSERT INTO `sys_user_role` VALUES (55, 20, 7);
INSERT INTO `sys_user_role` VALUES (57, 21, 6);
INSERT INTO `sys_user_role` VALUES (58, 21, 8);
INSERT INTO `sys_user_role` VALUES (59, 22, 7);
INSERT INTO `sys_user_role` VALUES (60, 23, 12);
INSERT INTO `sys_user_role` VALUES (61, 13, 7);
INSERT INTO `sys_user_role` VALUES (62, 24, 8);
INSERT INTO `sys_user_role` VALUES (63, 25, 6);
INSERT INTO `sys_user_role` VALUES (64, 25, 7);
INSERT INTO `sys_user_role` VALUES (65, 25, 12);
INSERT INTO `sys_user_role` VALUES (74, 27, 8);
INSERT INTO `sys_user_role` VALUES (75, 29, 7);
INSERT INTO `sys_user_role` VALUES (76, 30, 6);
INSERT INTO `sys_user_role` VALUES (77, 30, 7);
INSERT INTO `sys_user_role` VALUES (78, 30, 8);
INSERT INTO `sys_user_role` VALUES (79, 30, 9);
INSERT INTO `sys_user_role` VALUES (80, 30, 11);
INSERT INTO `sys_user_role` VALUES (81, 30, 12);
INSERT INTO `sys_user_role` VALUES (82, 26, 8);
INSERT INTO `sys_user_role` VALUES (89, 6, 6);
INSERT INTO `sys_user_role` VALUES (90, 6, 7);
INSERT INTO `sys_user_role` VALUES (91, 6, 8);
INSERT INTO `sys_user_role` VALUES (92, 6, 9);
INSERT INTO `sys_user_role` VALUES (93, 6, 11);
INSERT INTO `sys_user_role` VALUES (94, 6, 12);
INSERT INTO `sys_user_role` VALUES (95, 6, 13);
INSERT INTO `sys_user_role` VALUES (96, 31, 8);
INSERT INTO `sys_user_role` VALUES (97, 32, 8);
INSERT INTO `sys_user_role` VALUES (103, 2, 7);
INSERT INTO `sys_user_role` VALUES (107, 3, 7);
INSERT INTO `sys_user_role` VALUES (108, 3, 8);
INSERT INTO `sys_user_role` VALUES (109, 3, 9);
INSERT INTO `sys_user_role` VALUES (110, 3, 11);
INSERT INTO `sys_user_role` VALUES (111, 3, 12);
INSERT INTO `sys_user_role` VALUES (112, 1, 6);
INSERT INTO `sys_user_role` VALUES (113, 1, 8);
INSERT INTO `sys_user_role` VALUES (114, 1, 12);
INSERT INTO `sys_user_role` VALUES (115, 1, 14);
COMMIT;

-- ----------------------------
-- Table structure for uc_demension
-- ----------------------------
DROP TABLE IF EXISTS `uc_demension`;
CREATE TABLE `uc_demension` (
  `id` varchar(64) COLLATE utf8mb4_bin NOT NULL,
  `DEM_NAME` varchar(64) COLLATE utf8mb4_bin  COMMENT '名称',
  `code` varchar(64) COLLATE utf8mb4_bin  COMMENT '维度代码',
  `IS_DEFAULT_val` tinyint(1)  COMMENT '是否默认(1:默认,0:非默认)',
  `DEM_DESC` varchar(512) COLLATE utf8mb4_bin  COMMENT '描述',
  `ORGAN_ID` varchar(64) COLLATE utf8mb4_bin  COMMENT '机构id',
  `UPDATE_TIME` datetime(3) COMMENT '更新时间',
  `IS_DELETED` tinyint(1)  COMMENT '是否已删，1已删除，0未删除',
  `VERSION` int(11)  COMMENT '版本号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='维度管理';

-- ----------------------------
-- Records of uc_demension
-- ----------------------------
BEGIN;
INSERT INTO `uc_demension` VALUES ('678912394608508928', '人事维度', 'renshiweidu', 1, '', NULL, '2020-02-17 10:46:59', 0, 8);
INSERT INTO `uc_demension` VALUES ('678915759061073920', '财务维度', 'caiwuweidu', 0, '财务维度', NULL, '2020-02-17 10:48:50', 0, 0);
INSERT INTO `uc_demension` VALUES ('683368151089414144', '1', '1', 0, '', NULL, '2020-02-29 17:41:05', 1, 0);
COMMIT;

-- ----------------------------
-- Table structure for uc_org
-- ----------------------------
DROP TABLE IF EXISTS `uc_org`;
CREATE TABLE `uc_org` (
  `id` varchar(64) COLLATE utf8mb4_bin NOT NULL COMMENT '主键',
  `DEPT_NAME` varchar(64) COLLATE utf8mb4_bin  COMMENT '部门名称',
  `EASY_NAME` varchar(64) COLLATE utf8mb4_bin  COMMENT '简称',
  `DEPT_CODE` varchar(64) COLLATE utf8mb4_bin  COMMENT '部门编码',
  `RANK_CODE` varchar(64) COLLATE utf8mb4_bin  COMMENT '级别Code',
  `RANK_NAME` varchar(64) COLLATE utf8mb4_bin  COMMENT '级别',
  `ZH_ID` varchar(64) COLLATE utf8mb4_bin  COMMENT '主管领导',
  `PHONE` varchar(64) COLLATE utf8mb4_bin  COMMENT '电话',
  `PARENT_ID` varchar(64) COLLATE utf8mb4_bin  COMMENT '父组织id',
  `ADDRESS` varchar(512) COLLATE utf8mb4_bin  COMMENT '地址',
  `ZN_MS` varchar(512) COLLATE utf8mb4_bin  COMMENT '职能描述',
  `BZ_HU` varchar(64) COLLATE utf8mb4_bin  COMMENT '备注',
  `PATH` varchar(512) COLLATE utf8mb4_bin  COMMENT '组织id路径，包含层级关系',
  `VERSION` int(11) DEFAULT '0' COMMENT '版本号',
  `LEVEL` varchar(64) COLLATE utf8mb4_bin  COMMENT '深度',
  `SORT` int(11)  COMMENT '排序号',
  `CREATE_BY` varchar(64) COLLATE utf8mb4_bin  COMMENT '创建人',
  `CREATE_TIME`datetime(3) COMMENT '创建时间',
  `UPDATE_BY` varchar(64) COLLATE utf8mb4_bin  COMMENT '更新人',
  `UPDATE_TIME` datetime(3) COMMENT '更新时间',
  `STATUS` tinyint(1)  COMMENT '状态',
  `IS_DELETED` tinyint(1)  COMMENT '是否已删，1已删除，0未删除',
  `DEM_ID` varchar(64) COLLATE utf8mb4_bin  COMMENT '维度id',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `code` (`DEPT_CODE`) USING BTREE COMMENT 'code必须唯一'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='组织管理';

-- ----------------------------
-- Records of uc_org
-- ----------------------------
BEGIN;
INSERT INTO `uc_org` VALUES ('678917977457819648', '盘古BPM', '盘古BPM', 'beijingfengongsi', NULL, NULL, NULL, '', 'renshiweidu', '', '', '', '.renshiweidu.beijingfengongsi', 0, '', NULL, NULL, '2020-02-17 10:57:39', NULL, '2020-02-17 10:57:39', 0, 0, 'renshiweidu');
INSERT INTO `uc_org` VALUES ('679436474327760896', '盘古软件', '盘古软件', 'shanghaifengongsi', NULL, NULL, NULL, '', 'renshiweidu', '', '盘古软件', '', '.renshiweidu.shanghaifengongsi', 0, '', NULL, NULL, '2020-02-18 21:17:58', NULL, '2020-02-18 21:17:58', 0, 0, 'renshiweidu');
INSERT INTO `uc_org` VALUES ('680896380327165952', '跟部门', '跟部门', 'caiwu_genbumen', NULL, NULL, NULL, NULL, 'caiwuweidu', '', '', '', '.caiwuweidu.caiwu_genbumen', 0, '2', NULL, NULL, '2020-02-22 21:59:07', NULL, '2020-02-22 21:59:07', 0, 0, 'caiwuweidu');
COMMIT;

-- ----------------------------
-- Table structure for uc_org_job
-- ----------------------------
DROP TABLE IF EXISTS `uc_org_job`;
CREATE TABLE `uc_org_job` (
  `id` varchar(64) COLLATE utf8mb4_bin NOT NULL COMMENT '主键',
  `name` varchar(64) COLLATE utf8mb4_bin NOT NULL COMMENT '名称',
  `code` varchar(64) COLLATE utf8mb4_bin NOT NULL COMMENT '编码',
  `JOB_LEVEL` varchar(64) COLLATE utf8mb4_bin  COMMENT '职务级别',
  `DESCRIPTION` varchar(512) COLLATE utf8mb4_bin  COMMENT '描述',
  `UPDATE_TIME` datetime(3) COMMENT '更新时间',
  `IS_DELETED` tinyint(1)  COMMENT '是否已删，1已删除，0未删除',
  `VERSION` int(11)  COMMENT '版本号',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `unique_code` (`code`) USING BTREE COMMENT '唯一索引'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='职务定义';

-- ----------------------------
-- Records of uc_org_job
-- ----------------------------
BEGIN;
INSERT INTO `uc_org_job` VALUES ('678555843632824320', '管理岗', 'glg', '2', '', '2020-02-29 03:23:06', 0, 1);
INSERT INTO `uc_org_job` VALUES ('678907718349619200', '1', '1', '', '', '2020-02-17 10:16:55', 1, 0);
INSERT INTO `uc_org_job` VALUES ('679448260544299008', '开发岗', 'kaifagang', '2', '', '2020-02-18 08:04:49', 0, 0);
INSERT INTO `uc_org_job` VALUES ('680895903774539776', '部门经理', 'bumenjingli', '3', '部门经理', '2020-02-22 07:57:13', 0, 0);
INSERT INTO `uc_org_job` VALUES ('680896732220882944', '项目经理', 'xiangmujingli', '1', '项目经理', '2020-02-22 08:00:31', 0, 0);
INSERT INTO `uc_org_job` VALUES ('683362369572700160', '1', '2', '', '', '2020-02-29 17:18:09', 1, 0);
COMMIT;

-- ----------------------------
-- Table structure for uc_org_post
-- ----------------------------
DROP TABLE IF EXISTS `uc_org_post`;
CREATE TABLE `uc_org_post` (
  `id` varchar(64) COLLATE utf8mb4_bin NOT NULL COMMENT '主键',
  `ORG_ID` varchar(64) COLLATE utf8mb4_bin NOT NULL COMMENT '组织id',
  `JOB_ID` varchar(64) COLLATE utf8mb4_bin NOT NULL COMMENT '职务id',
  `POS_NAME` varchar(64) COLLATE utf8mb4_bin NOT NULL COMMENT '岗位名称',
  `code` varchar(64) COLLATE utf8mb4_bin NOT NULL COMMENT '岗位编码',
  `IS_CHARGE` tinyint(1)  COMMENT '是否主岗位：1主岗位，0 非主岗位',
  `UPDATE_TIME` datetime  COMMENT '更新时间',
  `IS_DELETED` tinyint(1)  COMMENT '是否已删，1已删除，0未删除',
  `VERSION` int(11) DEFAULT '0' COMMENT '版本号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='部门岗位管理';

-- ----------------------------
-- Records of uc_org_post
-- ----------------------------
BEGIN;
INSERT INTO `uc_org_post` VALUES ('678555986151079936', 'root', 'kfg', 'java开发', 'javaen', 0, NULL, 0, 0);
INSERT INTO `uc_org_post` VALUES ('678556378154926080', 'shgs', 'kfg', 'php开发', 'phpen', 0, NULL, 0, 0);
INSERT INTO `uc_org_post` VALUES ('678964127175016448', 'beijingfengongsi', 'glg', '研发工程师222', '研发工程师', 0, NULL, 1, 1);
INSERT INTO `uc_org_post` VALUES ('678967235624042496', 'beijingfengongsi', 'glg', '市场营销', 'shichangyingxiao', 0, NULL, 0, 0);
INSERT INTO `uc_org_post` VALUES ('678969254216728576', 'beijingfengongsi', 'glg', '333', '333', 0, NULL, 1, 0);
INSERT INTO `uc_org_post` VALUES ('679012379261927424', 'beijingfengongsi', 'glg', '2', '2', 0, NULL, 1, 0);
INSERT INTO `uc_org_post` VALUES ('679016071356743680', 'beijingfengongsi', 'glg', '2222', '222', 0, NULL, 1, 0);
INSERT INTO `uc_org_post` VALUES ('679016416099172352', 'beijingfengongsi', 'glg', '44', '444', 0, NULL, 1, 0);
INSERT INTO `uc_org_post` VALUES ('679075299295494144', 'beijingfengongsi', 'glg', '开发2部', 'kaifang2', 0, NULL, 0, 0);
INSERT INTO `uc_org_post` VALUES ('679075609049038848', 'beijingfengongsi', 'glg', '开发3部', 'kaifa3bu', 0, NULL, 0, 0);
INSERT INTO `uc_org_post` VALUES ('680896539463254016', 'caiwu_genbumen', 'glg', '出纳', 'chuna', 0, NULL, 0, 0);
INSERT INTO `uc_org_post` VALUES ('680896978984370176', 'shanghaifengongsi', 'glg', '盘古BPM-销售部', 'pangubpm_xiaoshoubu', 0, NULL, 0, 0);
INSERT INTO `uc_org_post` VALUES ('683371606843588608', 'beijingfengongsi', 'kaifagang', 'ccc', 'cccc', 0, NULL, 1, 0);
INSERT INTO `uc_org_post` VALUES ('683371657196208128', 'beijingfengongsi', 'kaifagang', 'ffff', 'ffffffff', 0, NULL, 1, 0);
COMMIT;

-- ----------------------------
-- Table structure for uc_params
-- ----------------------------
DROP TABLE IF EXISTS `uc_params`;
CREATE TABLE `uc_params` (
  `id` varchar(64) COLLATE utf8mb4_bin NOT NULL COMMENT '主键',
  `NAME` varchar(64) COLLATE utf8mb4_bin  COMMENT '机构名称',
  `code` varchar(64) COLLATE utf8mb4_bin  COMMENT '机构代码',
  `TYPE` varchar(64) COLLATE utf8mb4_bin  COMMENT '类型',
  `CTL_TYPE` varchar(64) COLLATE utf8mb4_bin  COMMENT '控件类型',
  `JSON` varchar(512) COLLATE utf8mb4_bin  COMMENT 'json值',
  `UPDATE_TIME` datetime(3) COMMENT '更新时间',
  `IS_DELETED` tinyint(1)  COMMENT '是否已删，1已删除，0未删除',
  `VERSION` int(11)  COMMENT '版本号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='用户组织参数';

-- ----------------------------
-- Table structure for uc_role
-- ----------------------------
DROP TABLE IF EXISTS `uc_role`;
CREATE TABLE `uc_role` (
  `id` varchar(64) COLLATE utf8mb4_bin NOT NULL COMMENT '主键',
  `NAME` varchar(64) COLLATE utf8mb4_bin  COMMENT '角色名称',
  `code` varchar(64) COLLATE utf8mb4_bin  COMMENT '英文别名',
  `CREATE_BY` varchar(64) COLLATE utf8mb4_bin  COMMENT '创建用户id',
  `UPDATE_BY` varchar(64) COLLATE utf8mb4_bin  COMMENT '更新用户id',
  `CREATE_ORG_ID` varchar(64) COLLATE utf8mb4_bin  COMMENT '创建组织id',
  `ENABLED` tinyint(1)  COMMENT '可用 0：禁用，1：启用',
  `DESCRIPTION` varchar(512) COLLATE utf8mb4_bin  COMMENT '描述',
  `UPDATE_TIME` datetime  COMMENT '更新时间',
  `IS_DELETED` tinyint(1)  COMMENT '是否已删，1已删除，0未删除',
  `VERSION` int(11) DEFAULT '0' COMMENT '版本号',
  `create_Time` datetime  COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='角色管理';

-- ----------------------------
-- Records of uc_role
-- ----------------------------
BEGIN;
INSERT INTO `uc_role` VALUES ('1', '111', '111', NULL, NULL, NULL, 1, '1111', '2020-02-06 16:58:16', 1, 5, '2020-02-06 17:23:21');
INSERT INTO `uc_role` VALUES ('678198539897012224', '666', '2', NULL, NULL, NULL, 1, '2', NULL, 1, 5, NULL);
INSERT INTO `uc_role` VALUES ('678571609396609024', '市场部', 'shichangbu', NULL, NULL, NULL, 1, '', NULL, 0, 1, NULL);
INSERT INTO `uc_role` VALUES ('678571648034537472', '人事部', 'renshibu', NULL, NULL, NULL, 1, '', NULL, 0, 0, NULL);
INSERT INTO `uc_role` VALUES ('678900086754770944', 'ccc', 'cc', NULL, NULL, NULL, 1, '', NULL, 1, 0, NULL);
INSERT INTO `uc_role` VALUES ('680792205136232448', '技术部', 'jsb', NULL, NULL, NULL, 1, '', NULL, 0, 0, NULL);
INSERT INTO `uc_role` VALUES ('682529352457388032', 'cc', NULL, NULL, NULL, NULL, 1, NULL, NULL, 1, 0, NULL);
INSERT INTO `uc_role` VALUES ('683364228228186112', '1', '222', NULL, NULL, NULL, 1, '', NULL, 1, 1, NULL);
INSERT INTO `uc_role` VALUES ('683762809342787584', '销售人员', 'XSRY', NULL, NULL, NULL, 1, '', NULL, 0, 0, NULL);
INSERT INTO `uc_role` VALUES ('683762880507543552', '销售经理', 'XSJL', NULL, NULL, NULL, 1, '', NULL, 0, 0, NULL);
INSERT INTO `uc_role` VALUES ('683762925415956480', '销售总监', 'XSZJ', NULL, NULL, NULL, 1, '', NULL, 0, 0, NULL);
COMMIT;

-- ----------------------------
-- Table structure for uc_role_menu
-- ----------------------------
DROP TABLE IF EXISTS `uc_role_menu`;
CREATE TABLE `uc_role_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_code` varchar(255) COLLATE utf8mb4_bin ,
  `menu_id` int(11) ,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;

-- ----------------------------
-- Records of uc_role_menu
-- ----------------------------
BEGIN;
INSERT INTO `uc_role_menu` VALUES (1, '2', 41);
INSERT INTO `uc_role_menu` VALUES (2, '2', 2);
INSERT INTO `uc_role_menu` VALUES (3, '2', 15);
INSERT INTO `uc_role_menu` VALUES (4, '2', 16);
INSERT INTO `uc_role_menu` VALUES (5, '2', 17);
INSERT INTO `uc_role_menu` VALUES (6, '2', 3);
INSERT INTO `uc_role_menu` VALUES (7, '2', 19);
INSERT INTO `uc_role_menu` VALUES (8, '2', 20);
INSERT INTO `uc_role_menu` VALUES (9, '2', 21);
INSERT INTO `uc_role_menu` VALUES (10, '2', 31);
INSERT INTO `uc_role_menu` VALUES (11, '2', 32);
INSERT INTO `uc_role_menu` VALUES (12, '2', 46);
INSERT INTO `uc_role_menu` VALUES (13, '2', 43);
INSERT INTO `uc_role_menu` VALUES (14, '2', 47);
INSERT INTO `uc_role_menu` VALUES (15, '2', 48);
INSERT INTO `uc_role_menu` VALUES (16, '2', 53);
INSERT INTO `uc_role_menu` VALUES (17, '2', 56);
INSERT INTO `uc_role_menu` VALUES (18, '2', 100);
INSERT INTO `uc_role_menu` VALUES (19, '2', 102);
INSERT INTO `uc_role_menu` VALUES (20, '2', 103);
INSERT INTO `uc_role_menu` VALUES (21, '2', 107);
INSERT INTO `uc_role_menu` VALUES (22, '2', 108);
INSERT INTO `uc_role_menu` VALUES (23, '2', 121);
INSERT INTO `uc_role_menu` VALUES (24, '2', 122);
INSERT INTO `uc_role_menu` VALUES (25, '2', 123);
INSERT INTO `uc_role_menu` VALUES (26, '2', 125);
INSERT INTO `uc_role_menu` VALUES (27, '2', 120);
INSERT INTO `uc_role_menu` VALUES (28, '2', 4);
INSERT INTO `uc_role_menu` VALUES (29, '2', 23);
INSERT INTO `uc_role_menu` VALUES (30, '2', 24);
INSERT INTO `uc_role_menu` VALUES (31, '2', 25);
INSERT INTO `uc_role_menu` VALUES (32, '2', 26);
INSERT INTO `uc_role_menu` VALUES (33, '2', 5);
INSERT INTO `uc_role_menu` VALUES (34, '2', 6);
INSERT INTO `uc_role_menu` VALUES (35, '2', 7);
INSERT INTO `uc_role_menu` VALUES (36, '2', 8);
INSERT INTO `uc_role_menu` VALUES (37, '2', 9);
INSERT INTO `uc_role_menu` VALUES (38, '2', 10);
INSERT INTO `uc_role_menu` VALUES (39, '2', 11);
INSERT INTO `uc_role_menu` VALUES (40, '2', 12);
INSERT INTO `uc_role_menu` VALUES (41, '2', 14);
INSERT INTO `uc_role_menu` VALUES (42, '2', 27);
INSERT INTO `uc_role_menu` VALUES (43, '2', 36);
INSERT INTO `uc_role_menu` VALUES (44, '2', 37);
INSERT INTO `uc_role_menu` VALUES (45, '2', 38);
INSERT INTO `uc_role_menu` VALUES (46, '2', 39);
INSERT INTO `uc_role_menu` VALUES (47, '2', 40);
INSERT INTO `uc_role_menu` VALUES (48, '2', 124);
INSERT INTO `uc_role_menu` VALUES (49, '2', 135);
INSERT INTO `uc_role_menu` VALUES (50, '2', 126);
INSERT INTO `uc_role_menu` VALUES (51, '2', 127);
INSERT INTO `uc_role_menu` VALUES (52, '2', 128);
INSERT INTO `uc_role_menu` VALUES (53, '2', 129);
INSERT INTO `uc_role_menu` VALUES (54, '2', 130);
INSERT INTO `uc_role_menu` VALUES (55, '2', 132);
INSERT INTO `uc_role_menu` VALUES (56, '2', 133);
INSERT INTO `uc_role_menu` VALUES (57, '2', 134);
INSERT INTO `uc_role_menu` VALUES (58, 'renshibu', 41);
INSERT INTO `uc_role_menu` VALUES (59, 'renshibu', 2);
INSERT INTO `uc_role_menu` VALUES (60, 'renshibu', 15);
INSERT INTO `uc_role_menu` VALUES (61, 'renshibu', 16);
INSERT INTO `uc_role_menu` VALUES (62, 'renshibu', 17);
INSERT INTO `uc_role_menu` VALUES (63, 'renshibu', 3);
INSERT INTO `uc_role_menu` VALUES (64, 'renshibu', 19);
INSERT INTO `uc_role_menu` VALUES (65, 'renshibu', 20);
INSERT INTO `uc_role_menu` VALUES (66, 'renshibu', 21);
INSERT INTO `uc_role_menu` VALUES (67, 'renshibu', 31);
INSERT INTO `uc_role_menu` VALUES (68, 'renshibu', 32);
INSERT INTO `uc_role_menu` VALUES (69, 'renshibu', 46);
INSERT INTO `uc_role_menu` VALUES (70, 'renshibu', 43);
INSERT INTO `uc_role_menu` VALUES (71, 'renshibu', 47);
INSERT INTO `uc_role_menu` VALUES (72, 'renshibu', 48);
INSERT INTO `uc_role_menu` VALUES (73, 'renshibu', 53);
INSERT INTO `uc_role_menu` VALUES (74, 'renshibu', 56);
INSERT INTO `uc_role_menu` VALUES (75, 'renshibu', 100);
INSERT INTO `uc_role_menu` VALUES (76, 'renshibu', 102);
INSERT INTO `uc_role_menu` VALUES (77, 'renshibu', 103);
INSERT INTO `uc_role_menu` VALUES (78, 'renshibu', 107);
INSERT INTO `uc_role_menu` VALUES (79, 'renshibu', 108);
INSERT INTO `uc_role_menu` VALUES (80, 'renshibu', 121);
INSERT INTO `uc_role_menu` VALUES (81, 'renshibu', 122);
INSERT INTO `uc_role_menu` VALUES (82, 'renshibu', 123);
INSERT INTO `uc_role_menu` VALUES (83, 'renshibu', 125);
INSERT INTO `uc_role_menu` VALUES (84, 'renshibu', 110);
INSERT INTO `uc_role_menu` VALUES (85, 'renshibu', 111);
INSERT INTO `uc_role_menu` VALUES (86, 'renshibu', 112);
INSERT INTO `uc_role_menu` VALUES (87, 'renshibu', 113);
INSERT INTO `uc_role_menu` VALUES (88, 'renshibu', 126);
INSERT INTO `uc_role_menu` VALUES (89, 'renshibu', 127);
INSERT INTO `uc_role_menu` VALUES (90, 'renshibu', 128);
INSERT INTO `uc_role_menu` VALUES (91, 'renshibu', 129);
INSERT INTO `uc_role_menu` VALUES (92, 'renshibu', 130);
INSERT INTO `uc_role_menu` VALUES (93, 'renshibu', 132);
INSERT INTO `uc_role_menu` VALUES (94, 'renshibu', 133);
INSERT INTO `uc_role_menu` VALUES (95, 'renshibu', 134);
INSERT INTO `uc_role_menu` VALUES (123, 'shichangbu', 46);
INSERT INTO `uc_role_menu` VALUES (124, 'shichangbu', 43);
INSERT INTO `uc_role_menu` VALUES (125, 'shichangbu', 47);
INSERT INTO `uc_role_menu` VALUES (126, 'shichangbu', 48);
INSERT INTO `uc_role_menu` VALUES (127, 'shichangbu', 56);
INSERT INTO `uc_role_menu` VALUES (128, 'shichangbu', 100);
INSERT INTO `uc_role_menu` VALUES (129, 'shichangbu', 102);
INSERT INTO `uc_role_menu` VALUES (130, 'shichangbu', 103);
INSERT INTO `uc_role_menu` VALUES (131, 'shichangbu', 107);
INSERT INTO `uc_role_menu` VALUES (132, 'shichangbu', 108);
INSERT INTO `uc_role_menu` VALUES (133, 'shichangbu', 121);
INSERT INTO `uc_role_menu` VALUES (134, 'shichangbu', 122);
INSERT INTO `uc_role_menu` VALUES (135, 'shichangbu', 123);
INSERT INTO `uc_role_menu` VALUES (136, 'shichangbu', 125);
INSERT INTO `uc_role_menu` VALUES (137, 'shichangbu', 110);
INSERT INTO `uc_role_menu` VALUES (138, 'shichangbu', 111);
INSERT INTO `uc_role_menu` VALUES (139, 'shichangbu', 112);
INSERT INTO `uc_role_menu` VALUES (140, 'shichangbu', 113);
INSERT INTO `uc_role_menu` VALUES (141, 'shichangbu', 5);
INSERT INTO `uc_role_menu` VALUES (142, 'shichangbu', 6);
INSERT INTO `uc_role_menu` VALUES (143, 'shichangbu', 14);
INSERT INTO `uc_role_menu` VALUES (144, 'shichangbu', 27);
INSERT INTO `uc_role_menu` VALUES (145, 'shichangbu', 126);
INSERT INTO `uc_role_menu` VALUES (146, 'shichangbu', 127);
INSERT INTO `uc_role_menu` VALUES (147, 'shichangbu', 128);
INSERT INTO `uc_role_menu` VALUES (148, 'shichangbu', 129);
INSERT INTO `uc_role_menu` VALUES (149, 'shichangbu', 130);
INSERT INTO `uc_role_menu` VALUES (150, 'shichangbu', 132);
INSERT INTO `uc_role_menu` VALUES (151, 'shichangbu', 133);
INSERT INTO `uc_role_menu` VALUES (152, 'shichangbu', 134);
INSERT INTO `uc_role_menu` VALUES (226, 'XSRY', 158);
INSERT INTO `uc_role_menu` VALUES (227, 'XSRY', 46);
INSERT INTO `uc_role_menu` VALUES (228, 'XSRY', 43);
INSERT INTO `uc_role_menu` VALUES (229, 'XSRY', 47);
INSERT INTO `uc_role_menu` VALUES (230, 'XSRY', 48);
INSERT INTO `uc_role_menu` VALUES (231, 'XSRY', 100);
INSERT INTO `uc_role_menu` VALUES (232, 'XSRY', 102);
INSERT INTO `uc_role_menu` VALUES (233, 'XSRY', 103);
INSERT INTO `uc_role_menu` VALUES (234, 'XSRY', 107);
INSERT INTO `uc_role_menu` VALUES (235, 'XSRY', 108);
INSERT INTO `uc_role_menu` VALUES (236, 'XSRY', 121);
INSERT INTO `uc_role_menu` VALUES (237, 'XSRY', 122);
INSERT INTO `uc_role_menu` VALUES (238, 'XSRY', 123);
INSERT INTO `uc_role_menu` VALUES (239, 'XSRY', 125);
INSERT INTO `uc_role_menu` VALUES (240, 'XSRY', 144);
INSERT INTO `uc_role_menu` VALUES (241, 'XSJL', 157);
INSERT INTO `uc_role_menu` VALUES (242, 'XSJL', 110);
INSERT INTO `uc_role_menu` VALUES (243, 'XSJL', 111);
INSERT INTO `uc_role_menu` VALUES (244, 'XSJL', 112);
INSERT INTO `uc_role_menu` VALUES (245, 'XSJL', 113);
INSERT INTO `uc_role_menu` VALUES (246, 'XSJL', 158);
INSERT INTO `uc_role_menu` VALUES (247, 'XSJL', 46);
INSERT INTO `uc_role_menu` VALUES (248, 'XSJL', 43);
INSERT INTO `uc_role_menu` VALUES (249, 'XSJL', 47);
INSERT INTO `uc_role_menu` VALUES (250, 'XSJL', 48);
INSERT INTO `uc_role_menu` VALUES (251, 'XSJL', 100);
INSERT INTO `uc_role_menu` VALUES (252, 'XSJL', 102);
INSERT INTO `uc_role_menu` VALUES (253, 'XSJL', 103);
INSERT INTO `uc_role_menu` VALUES (254, 'XSJL', 107);
INSERT INTO `uc_role_menu` VALUES (255, 'XSJL', 108);
INSERT INTO `uc_role_menu` VALUES (256, 'XSJL', 121);
INSERT INTO `uc_role_menu` VALUES (257, 'XSJL', 122);
INSERT INTO `uc_role_menu` VALUES (258, 'XSJL', 123);
INSERT INTO `uc_role_menu` VALUES (259, 'XSJL', 125);
INSERT INTO `uc_role_menu` VALUES (260, 'XSJL', 144);
INSERT INTO `uc_role_menu` VALUES (261, 'XSJL', 160);
INSERT INTO `uc_role_menu` VALUES (262, 'XSJL', 126);
INSERT INTO `uc_role_menu` VALUES (263, 'XSJL', 127);
INSERT INTO `uc_role_menu` VALUES (264, 'XSJL', 128);
INSERT INTO `uc_role_menu` VALUES (265, 'XSJL', 129);
INSERT INTO `uc_role_menu` VALUES (266, 'XSJL', 130);
INSERT INTO `uc_role_menu` VALUES (267, 'XSJL', 132);
INSERT INTO `uc_role_menu` VALUES (268, 'XSJL', 133);
INSERT INTO `uc_role_menu` VALUES (269, 'XSJL', 134);
INSERT INTO `uc_role_menu` VALUES (270, 'XSZJ', 14);
INSERT INTO `uc_role_menu` VALUES (271, 'XSZJ', 157);
INSERT INTO `uc_role_menu` VALUES (272, 'XSZJ', 110);
INSERT INTO `uc_role_menu` VALUES (273, 'XSZJ', 111);
INSERT INTO `uc_role_menu` VALUES (274, 'XSZJ', 112);
INSERT INTO `uc_role_menu` VALUES (275, 'XSZJ', 113);
INSERT INTO `uc_role_menu` VALUES (276, 'XSZJ', 158);
INSERT INTO `uc_role_menu` VALUES (277, 'XSZJ', 46);
INSERT INTO `uc_role_menu` VALUES (278, 'XSZJ', 43);
INSERT INTO `uc_role_menu` VALUES (279, 'XSZJ', 47);
INSERT INTO `uc_role_menu` VALUES (280, 'XSZJ', 48);
INSERT INTO `uc_role_menu` VALUES (281, 'XSZJ', 100);
INSERT INTO `uc_role_menu` VALUES (282, 'XSZJ', 102);
INSERT INTO `uc_role_menu` VALUES (283, 'XSZJ', 103);
INSERT INTO `uc_role_menu` VALUES (284, 'XSZJ', 107);
INSERT INTO `uc_role_menu` VALUES (285, 'XSZJ', 108);
INSERT INTO `uc_role_menu` VALUES (286, 'XSZJ', 121);
INSERT INTO `uc_role_menu` VALUES (287, 'XSZJ', 122);
INSERT INTO `uc_role_menu` VALUES (288, 'XSZJ', 123);
INSERT INTO `uc_role_menu` VALUES (289, 'XSZJ', 125);
INSERT INTO `uc_role_menu` VALUES (290, 'XSZJ', 144);
INSERT INTO `uc_role_menu` VALUES (291, 'XSZJ', 159);
INSERT INTO `uc_role_menu` VALUES (292, 'XSZJ', 120);
INSERT INTO `uc_role_menu` VALUES (293, 'XSZJ', 27);
INSERT INTO `uc_role_menu` VALUES (294, 'XSZJ', 124);
INSERT INTO `uc_role_menu` VALUES (295, 'XSZJ', 135);
INSERT INTO `uc_role_menu` VALUES (296, 'XSZJ', 149);
INSERT INTO `uc_role_menu` VALUES (297, 'XSZJ', 150);
INSERT INTO `uc_role_menu` VALUES (298, 'XSZJ', 151);
INSERT INTO `uc_role_menu` VALUES (299, 'XSZJ', 152);
INSERT INTO `uc_role_menu` VALUES (300, 'XSZJ', 153);
INSERT INTO `uc_role_menu` VALUES (301, 'XSZJ', 155);
INSERT INTO `uc_role_menu` VALUES (302, 'XSZJ', 156);
INSERT INTO `uc_role_menu` VALUES (303, 'XSZJ', 160);
INSERT INTO `uc_role_menu` VALUES (304, 'XSZJ', 126);
INSERT INTO `uc_role_menu` VALUES (305, 'XSZJ', 127);
INSERT INTO `uc_role_menu` VALUES (306, 'XSZJ', 128);
INSERT INTO `uc_role_menu` VALUES (307, 'XSZJ', 129);
INSERT INTO `uc_role_menu` VALUES (308, 'XSZJ', 130);
INSERT INTO `uc_role_menu` VALUES (309, 'XSZJ', 132);
INSERT INTO `uc_role_menu` VALUES (310, 'XSZJ', 133);
INSERT INTO `uc_role_menu` VALUES (311, 'XSZJ', 134);
INSERT INTO `uc_role_menu` VALUES (312, 'XSZJ', 161);
INSERT INTO `uc_role_menu` VALUES (313, 'XSZJ', 145);
INSERT INTO `uc_role_menu` VALUES (314, 'XSZJ', 146);
INSERT INTO `uc_role_menu` VALUES (315, 'XSZJ', 147);
COMMIT;

-- ----------------------------
-- Table structure for uc_user
-- ----------------------------
DROP TABLE IF EXISTS `uc_user`;
CREATE TABLE `uc_user` (
  `id` varchar(64) COLLATE utf8mb4_bin NOT NULL COMMENT '主键',
  `FULLNAME` varchar(255) COLLATE utf8mb4_bin  COMMENT '姓名',
  `MOBILE` varchar(64) COLLATE utf8mb4_bin  COMMENT '手机号码',
  `ACCOUNT` varchar(255) COLLATE utf8mb4_bin  COMMENT '帐号',
  `PASSWORD` varchar(64) COLLATE utf8mb4_bin  COMMENT '密码',
  `USER_NO` varchar(64) COLLATE utf8mb4_bin  COMMENT '工号',
  `salt` varchar(64) COLLATE utf8mb4_bin  COMMENT '盐',
  `JOB_NO` varchar(11) COLLATE utf8mb4_bin  COMMENT '职位编码',
  `JOB_LEVEL` int(255)  COMMENT '职位级别',
  `POST_LEVEL` int(255)  COMMENT '岗位级别',
  `EMAIL` varchar(64) COLLATE utf8mb4_bin  COMMENT '公司邮箱',
  `ENTRY_DATE` datetime  COMMENT '入职日期',
  `LEAVE_DATE` datetime  COMMENT '离职日期',
  `PHOTO` varchar(255) COLLATE utf8mb4_bin  COMMENT '头像',
  `ADDRESS` varchar(255) COLLATE utf8mb4_bin  COMMENT '住地址',
  `SEX` int(2)  COMMENT '性别：男，女，未知',
  `ID_CARD` varchar(64) COLLATE utf8mb4_bin  COMMENT '身份证号',
  `PHONE` varchar(64) COLLATE utf8mb4_bin  COMMENT '办公电话',
  `NATION` int(11)  COMMENT '民族',
  `EDUCATION` int(11)  COMMENT '学历',
  `BIRTHDAY` datetime  COMMENT '出生日期',
  `NOTIFY_TYPE` varchar(64) COLLATE utf8mb4_bin  COMMENT '自定义接收消息类型',
  `CREATE_TIME` datetime  COMMENT '创建时间',
  `CREATE_USER_NO` varchar(64) COLLATE utf8mb4_bin  COMMENT '创建用户id',
  `UPDATE_TIME` datetime  COMMENT '更新时间',
  `UPDATE_USER_NO` varchar(64) COLLATE utf8mb4_bin  COMMENT '更新用户id',
  `CREATE_ORG_ID` varchar(64) COLLATE utf8mb4_bin  COMMENT '创建组织id',
  `STATUS` tinyint(1)  COMMENT '可用 0：禁用，1：启用',
  `DESCRIPTION` varchar(512) COLLATE utf8mb4_bin  COMMENT '描述',
  `IS_DEL` tinyint(1)  COMMENT '是否已删，1已删除，0未删除',
  `VERSION` int(11)  COMMENT '版本号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='用户管理';

-- ----------------------------
-- Records of uc_user
-- ----------------------------
BEGIN;
INSERT INTO `uc_user` VALUES ('1', '王文', '13678293920', 'wangwen', '06ab098b1fd5fc5e02af489cee292721e1cf2549df5132001807a8e421189361', '010', 'LYdnupNJZm7Qh0n2uSDU', NULL, NULL, 1, '4.qq.com', '2020-02-21 10:00:00', NULL, NULL, 'wea', 0, 'aewe4', '', 0, 0, NULL, NULL, NULL, '1', '2020-02-21 21:20:08', 'super', NULL, 1, NULL, 0, 0);
INSERT INTO `uc_user` VALUES ('10', '王胖子', '13789230120', 'wangpangzi', '80af243c46aef1409a466f3b15a8ff94a8ff7ec38fcf1fae8bb4c75382a911b0', '009', 'QJeNHisBSj0mpqb8uAnD', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, 0, 0);
INSERT INTO `uc_user` VALUES ('2', '赵六', '12323122334', 'zhaoliu', 'fea1a4eb39bbf9cd22bcdc8883cb6493605eb40d57b4bc97da3f074a5e62a425', '001', 'ddYfoInZXsI2DSlyfeeI', NULL, NULL, 1, '5.qq.com', '2020-02-21 10:00:00', NULL, NULL, '', 0, '', '', 0, 0, NULL, NULL, NULL, '1', '2020-02-21 21:37:48', 'super', NULL, 1, NULL, 0, 0);
INSERT INTO `uc_user` VALUES ('3', '赵云', '14323233445', 'zhaoyun', '08ff1e681e17751049b7787a64a96aa0d9cf9d7fa0395d7ab7374cdbe239f8d6', '002', 'BFG4dlXpS20brg6HcrL2', NULL, NULL, 1, '6.qq.com', NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, '1', NULL, NULL, NULL, 1, NULL, 0, 0);
INSERT INTO `uc_user` VALUES ('4', '李白', '123231321223', 'libai', 'becb622122c19d68ecc7f319dc59c50120c435f863773d25bb6f9d665b101964', '003', 'oKILbaPTO2gWwsku3fKJ', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, 0, 0);
INSERT INTO `uc_user` VALUES ('5', '貂蝉', '12342332343', 'diaocan', '6d59cfe38087a61b4a1826e4155788729ac66bd28d644da826630229acd232a3', '004', 'uYkGssxYyO7gGL2rQO2Z', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, 0, 0);
INSERT INTO `uc_user` VALUES ('6', '王飞', '14523234354', 'wangfei', '4cb1fb5316383ebd28ea3348cfa7fc3d3e199efb32097dcc699a970f8fc0baa7', '005', 'QqyMvjgMplNXJEpjz3NA', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, 0, 0);
INSERT INTO `uc_user` VALUES ('7', '马化腾', '13223435465', 'mahuateng', '7192aa5223f71f4cd00ff4cf8d6b01935d60b13f34fea03f0ec870ada6f0d2f1', '006', 'MQJh0M4TivOyONAyUrbB', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, 0, 0);
INSERT INTO `uc_user` VALUES ('8', '马云', '12343231212', 'mayun', '557e61c64a4e1805fb79ec6dc57e54808c66c4b0a146ab6d71862238ebfb08ab', '007', 'UejqbnneXr6bqcfyi9bG', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, 0, 0);
INSERT INTO `uc_user` VALUES ('8c2ae91e-5cda-46f2-b887-31df24912aa4', '张三', '13569121232', 'awe', '51946acfc288c384093019996f789a6be0a31947c5543707fa4f9b156d84d1ba', '011', '4TSzgZmRTQKzSeTAowrs', NULL, NULL, 1, '1.qq.com', '2020-02-21 10:00:00', '2020-02-21 10:00:00', NULL, 'awef', 0, 'awef1', '1312231223', NULL, 0, '2020-02-21 10:00:00', NULL, '2020-02-07 07:19:48', '1', '2020-02-21 21:36:56', 'super', NULL, 1, NULL, 0, 0);
INSERT INTO `uc_user` VALUES ('9', '马塔分', '18912231232', 'matafen', 'd83a2308677dcfe0b5605ec5092520759302b2508b4c00c5a47fc04b1f469c88', '008', 'MkIJOwUJ0I8s7UoIDEh3', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, 0, 0);
INSERT INTO `uc_user` VALUES ('988a04ad-c19a-4e91-bd35-3a63ba481002', '朱晓明', '12319200303', 'PG03', 'd13d2478a949baa1e55efd1751c83ede0f203488519a908bd850a4a696c6d003', 'PG-03', 'nRiHsLX6nQXbSzbEBHqq', NULL, NULL, 1, '12350@qq.com', NULL, NULL, NULL, '', 0, '', '', 0, 0, '2020-02-29 10:00:00', NULL, '2020-03-01 05:39:52', 'super', '2020-03-01 05:52:45', 'super', NULL, 1, NULL, 0, 0);
INSERT INTO `uc_user` VALUES ('9a32395a-aa87-4b97-8ece-33e324fe226d', '王五', '13121212323', 'aaa', 'fcd0c2e5229f5e9e7d1373e668590ce63c67964df56bb2e07a06111e0badbc2b', '012', 'HuNdP1Sr1eKaDZe6gwEO', NULL, NULL, 1, '2.qq.com', '2020-02-13 10:00:00', '2020-02-13 10:00:00', NULL, 'awef', 0, 'aewf2', '1232344334', 0, 0, '2020-02-13 10:00:00', NULL, '2020-02-11 08:51:30', 'super', '2020-02-14 07:36:03', 'super', NULL, 1, NULL, 0, 0);
INSERT INTO `uc_user` VALUES ('9ef0df47-39bf-4252-bd82-ca6bcf555ba5', '刘小军', '13490190000', 'PG01', '15f5c5ba918fcb58434d086185253fd43870ef9c59a38dc2cb302592a7c29562', 'PG-01', 'ya8sAJ5mp1HeYYpQohEl', NULL, NULL, 1, '12312@pangubpm.com', '2020-02-29 10:00:00', NULL, NULL, '', 0, '', '', 0, 0, '2020-02-29 10:00:00', NULL, '2020-03-01 05:36:12', 'super', '2020-03-01 05:52:22', 'super', NULL, 1, NULL, 0, 0);
INSERT INTO `uc_user` VALUES ('fae6ba0b-7350-4c9b-ba11-bd7083ce7398', '张文文', '', 'PG02', '25b39302fd55a5c96f00060d259e064ea46b8706a8b643442e0fff1d173998c6', 'PG-02', 'VGXERgzaAUSCGtUHPe6E', NULL, NULL, 1, '233443@qq.com', '2020-02-29 10:00:00', NULL, NULL, '', 0, '', '', 0, 0, '2020-02-29 10:00:00', NULL, '2020-03-01 05:41:01', 'super', '2020-03-01 05:53:03', 'super', NULL, 1, NULL, 0, 0);
INSERT INTO `uc_user` VALUES ('super', '管理员', '13454542312', 'admin', '968c2699bb7d4a48ea3b679289543734d45fafefe95861537d1cb6196ed336a9', 'super', 'wnVuvcXmP3jPt5w0g74S', NULL, NULL, 1, '3.qq.com', '2020-02-13 10:00:00', NULL, NULL, 'erga', 0, 'awef3', '', 0, 0, '2020-02-13 10:00:00', NULL, NULL, NULL, '2020-02-14 07:39:57', 'super', NULL, 1, NULL, 0, 0);
COMMIT;

-- ----------------------------
-- Table structure for uc_user_bak
-- ----------------------------
DROP TABLE IF EXISTS `uc_user_bak`;
CREATE TABLE `uc_user_bak` (
  `id` varchar(64) COLLATE utf8mb4_bin NOT NULL COMMENT '主键',
  `FULLNAME` varchar(255) COLLATE utf8mb4_bin  COMMENT '姓名',
  `ACCOUNT` varchar(255) COLLATE utf8mb4_bin  COMMENT '帐号',
  `PASSWORD` varchar(64) COLLATE utf8mb4_bin  COMMENT '密码',
  `salt` varchar(64) COLLATE utf8mb4_bin  COMMENT '盐',
  `EMAIL` varchar(64) COLLATE utf8mb4_bin  COMMENT '邮箱',
  `MOBILE` varchar(64) COLLATE utf8mb4_bin  COMMENT '手机号码',
  `WEIXIN` varchar(64) COLLATE utf8mb4_bin  COMMENT '微信号',
  `ADDRESS` varchar(64) COLLATE utf8mb4_bin  COMMENT '地址',
  `PHOTO` varchar(64) COLLATE utf8mb4_bin  COMMENT '头像',
  `SEX` varchar(64) COLLATE utf8mb4_bin  COMMENT '性别：男，女，未知',
  `FROM_source` varchar(64) COLLATE utf8mb4_bin  COMMENT '来源',
  `NOTIFY_TYPE` varchar(64) COLLATE utf8mb4_bin  COMMENT '自定义接收消息类型',
  `USER_NUMBER` varchar(64) COLLATE utf8mb4_bin  COMMENT '工号',
  `ID_CARD` varchar(64) COLLATE utf8mb4_bin  COMMENT '身份证号',
  `PHONE` varchar(64) COLLATE utf8mb4_bin  COMMENT '办公电话',
  `EDUCATION` varchar(64) COLLATE utf8mb4_bin  COMMENT '学历',
  `BIRTHDAY` datetime  COMMENT '出生日期',
  `ENTRY_DATE` datetime  COMMENT '入职日期',
  `LEAVE_DATE` datetime  COMMENT '离职日期',
  `STATUS` tinyint(1)  COMMENT '0:禁用，1正常',
  `HAS_SYNC_TO_WX` int(11)  COMMENT '微信同步关注状态: 0：未同步 1：已同步，尚未关注 2：已同步且已关注',
  `CREATE_TIME` datetime  COMMENT '创建时间',
  `CREATE_BY` varchar(64) COLLATE utf8mb4_bin  COMMENT '创建用户id',
  `UPDATE_BY` varchar(64) COLLATE utf8mb4_bin  COMMENT '更新用户id',
  `CREATE_ORG_ID` varchar(64) COLLATE utf8mb4_bin  COMMENT '创建组织id',
  `ENABLED` tinyint(1)  COMMENT '可用 0：禁用，1：启用',
  `DESCRIPTION` varchar(512) COLLATE utf8mb4_bin  COMMENT '描述',
  `UPDATE_TIME` datetime  COMMENT '更新时间',
  `IS_DELE` tinyint(1)  COMMENT '是否已删，1已删除，0未删除',
  `VERSION` int(11)  COMMENT '版本号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='用户管理';

-- ----------------------------
-- Table structure for uc_user_org_post
-- ----------------------------
DROP TABLE IF EXISTS `uc_user_org_post`;
CREATE TABLE `uc_user_org_post` (
  `ID` varchar(255) COLLATE utf8mb4_bin NOT NULL COMMENT '主键ID',
  `USER_CODE` varchar(255) COLLATE utf8mb4_bin  COMMENT '人员编码',
  `ORG_CODE` varchar(255) COLLATE utf8mb4_bin  COMMENT '组织编码',
  `POST_CODE` varchar(255) COLLATE utf8mb4_bin  COMMENT '岗位编码',
  `IS_DEFAULT` tinyint(1)  COMMENT '是否默认组织',
  `IS_LEADER` int(11) DEFAULT '0' COMMENT '2组织主负责人，1组织负责人，0 不是负责人',
  `CREATE_TIME` datetime  COMMENT '创建时间',
  `UPDATE_TIME` datetime  COMMENT '更新时间',
  `CREATE_USER_NO` varchar(255) COLLATE utf8mb4_bin  COMMENT '创建人',
  `UPDATE_USER_NO` varchar(255) COLLATE utf8mb4_bin  COMMENT '修改人',
  `IS_REL_ACTIVE` tinyint(1) DEFAULT '1' COMMENT '是否有效，0:无效，1：有效',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;

-- ----------------------------
-- Records of uc_user_org_post
-- ----------------------------
BEGIN;
INSERT INTO `uc_user_org_post` VALUES ('171cb20d-6d4f-4765-8dbf-a7a6fc3c174a', 'PG-03', 'beijingfengongsi', 'shichangyingxiao', 1, 0, '2020-03-01 05:52:46', '2020-03-01 05:52:46', 'super', 'super', 1);
INSERT INTO `uc_user_org_post` VALUES ('2096b8c1-f2ef-4c3f-83e9-99887775f323', 'PG-02', 'beijingfengongsi', 'shichangyingxiao', 1, 0, '2020-03-01 05:53:04', '2020-03-01 05:53:04', 'super', 'super', 1);
INSERT INTO `uc_user_org_post` VALUES ('2c3bd557-8cd5-48d9-9eec-3fcca185d000', 'PG-01', 'beijingfengongsi', 'shichangyingxiao', 1, 0, '2020-03-01 05:52:22', '2020-03-01 05:52:22', 'super', 'super', 1);
INSERT INTO `uc_user_org_post` VALUES ('680896076600836096', '010', 'beijingfengongsi', 'shichangyingxiao', 0, 0, '2020-02-22 07:57:55', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896076605030400', '010', 'beijingfengongsi', 'kaifang2', 1, 0, '2020-02-22 07:57:55', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896076605030401', '009', 'beijingfengongsi', 'shichangyingxiao', 0, 0, '2020-02-22 07:57:55', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896076605030402', '009', 'beijingfengongsi', 'kaifang2', 0, 0, '2020-02-22 07:57:55', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896076605030403', '001', 'beijingfengongsi', 'shichangyingxiao', 0, 0, '2020-02-22 07:57:55', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896076605030404', '001', 'beijingfengongsi', 'kaifang2', 0, 0, '2020-02-22 07:57:55', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896076605030405', '002', 'beijingfengongsi', 'shichangyingxiao', 0, 0, '2020-02-22 07:57:55', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896076605030406', '002', 'beijingfengongsi', 'kaifang2', 0, 0, '2020-02-22 07:57:55', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896076605030407', '003', 'beijingfengongsi', 'shichangyingxiao', 0, 0, '2020-02-22 07:57:55', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896076605030408', '003', 'beijingfengongsi', 'kaifang2', 0, 0, '2020-02-22 07:57:55', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896076605030409', '004', 'beijingfengongsi', 'shichangyingxiao', 0, 0, '2020-02-22 07:57:55', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896076605030410', '004', 'beijingfengongsi', 'kaifang2', 0, 0, '2020-02-22 07:57:55', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896076605030411', '005', 'beijingfengongsi', 'shichangyingxiao', 0, 0, '2020-02-22 07:57:55', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896076609224704', '005', 'beijingfengongsi', 'kaifang2', 0, 0, '2020-02-22 07:57:55', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896076609224705', '006', 'beijingfengongsi', 'shichangyingxiao', 0, 0, '2020-02-22 07:57:55', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896076609224706', '006', 'beijingfengongsi', 'kaifang2', 0, 0, '2020-02-22 07:57:55', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896076609224707', '007', 'beijingfengongsi', 'shichangyingxiao', 0, 0, '2020-02-22 07:57:55', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896076609224708', '007', 'beijingfengongsi', 'kaifang2', 0, 0, '2020-02-22 07:57:55', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896076609224709', '011', 'beijingfengongsi', 'shichangyingxiao', 0, 0, '2020-02-22 07:57:55', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896076609224710', '011', 'beijingfengongsi', 'kaifang2', 0, 0, '2020-02-22 07:57:55', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896590587625472', '010', 'caiwu_genbumen', 'chuna', 1, 0, '2020-02-22 07:59:57', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680896590587625473', '009', 'caiwu_genbumen', 'chuna', 0, 0, '2020-02-22 07:59:57', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680897028661706752', '010', 'shanghaifengongsi', 'pangubpm_xiaoshoubu', 1, 0, '2020-02-22 08:01:42', NULL, NULL, NULL, 1);
INSERT INTO `uc_user_org_post` VALUES ('680897028665901056', '009', 'shanghaifengongsi', 'pangubpm_xiaoshoubu', 0, 0, '2020-02-22 08:01:42', NULL, NULL, NULL, 1);
COMMIT;

-- ----------------------------
-- Table structure for uc_user_role
-- ----------------------------
DROP TABLE IF EXISTS `uc_user_role`;
CREATE TABLE `uc_user_role` (
  `id` varchar(255) NOT NULL,
  `USER_CODE` varchar(255)  COMMENT '用户ID',
  `ROLE_CODE` varchar(255)  COMMENT '角色ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户与角色对应关系';

-- ----------------------------
-- Records of uc_user_role
-- ----------------------------
BEGIN;
INSERT INTO `uc_user_role` VALUES ('303db2f1-6978-4bb9-a083-8c8307e6a7a2', 'PG-03', 'XSJL');
INSERT INTO `uc_user_role` VALUES ('37e461a1-a0cc-4749-af57-f216f8393cc4', 'PG-02', 'XSZJ');
INSERT INTO `uc_user_role` VALUES ('44bb245d-9486-46e8-9078-49d3c557a75d', 'PG-01', 'XSRY');
INSERT INTO `uc_user_role` VALUES ('5c1ecbc1-1dae-46f4-97c1-71075b0dfe07', '010', 'shichangbu');
INSERT INTO `uc_user_role` VALUES ('678296162570076161', '012', '111');
INSERT INTO `uc_user_role` VALUES ('678296162570076162', 'super', '111');
INSERT INTO `uc_user_role` VALUES ('679792135653818368', '012', 'shichangbu');
INSERT INTO `uc_user_role` VALUES ('679792169153724417', '012', 'renshibu');
INSERT INTO `uc_user_role` VALUES ('679792169153724418', 'super', 'renshibu');
INSERT INTO `uc_user_role` VALUES ('9d93e93c-5720-4b25-b6e0-1f1f44c4540d', '001', 'shichangbu');
INSERT INTO `uc_user_role` VALUES ('aa5f8255-191d-462b-a93a-b9dc869ed777', '011', 'renshibu');
COMMIT;

-- ----------------------------
-- Table structure for uc_user_under
-- ----------------------------
DROP TABLE IF EXISTS `uc_user_under`;
CREATE TABLE `uc_user_under` (
  `id` varchar(64) COLLATE utf8mb4_bin NOT NULL COMMENT '主键',
  `USER_CODE` varchar(64) COLLATE utf8mb4_bin  COMMENT '用户id',
  `UNDER_USER_CODE` varchar(64) COLLATE utf8mb4_bin  COMMENT '下属用户id',
  `ORG_CODE` varchar(64) COLLATE utf8mb4_bin  COMMENT '组织id',
  `UPDATE_TIME` datetime  COMMENT '更新时间',
  `IS_DELETED` tinyint(1) DEFAULT '0' COMMENT '是否已删，1已删除，0未删除',
  `VERSION` int(11) DEFAULT '0' COMMENT '版本号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='下属管理';

-- ----------------------------
-- Records of uc_user_under
-- ----------------------------
BEGIN;
INSERT INTO `uc_user_under` VALUES ('677961485644726272', 'super', 'awef', 'bjgs', NULL, 0, 0);
INSERT INTO `uc_user_under` VALUES ('677961485644726273', 'super', 'awe', 'bjgs', NULL, 0, 0);
INSERT INTO `uc_user_under` VALUES ('677963619551412226', 'awef', 'super', 'bjgs', NULL, 0, 0);
INSERT INTO `uc_user_under` VALUES ('679040777522774016', 'awef', 'awef', 'beijingfengongsi', NULL, 0, 0);
INSERT INTO `uc_user_under` VALUES ('679040777522774017', 'awef', 'awe', 'beijingfengongsi', NULL, 0, 0);
INSERT INTO `uc_user_under` VALUES ('679040777522774018', 'awef', 'super', 'beijingfengongsi', NULL, 0, 0);
COMMIT;

SET FOREIGN_KEY_CHECKS = 1;
