/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter;

import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BaseBpmnXMLConverter;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseCallableElement;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.BusinessRuleTask;

public class BusinessRuleTaskXMLConverter
extends BaseBpmnXMLConverter {
    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return BusinessRuleTask.class;
    }

    @Override
    protected String getXMLElementName() {
        return "businessRuleTask";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        BusinessRuleTask businessRuleTask = new BusinessRuleTask();
        BpmnXMLUtil.addXMLLocation((BaseElement)businessRuleTask, xtr);
        BaseCallableElement baseCallableElement = new BaseCallableElement();
        String decisionRef = BpmnXMLUtil.getAttributeValue("decisionRef", xtr);
        String decisionRefName = BpmnXMLUtil.getAttributeValue("decisionRefName", xtr);
        String type = BpmnXMLUtil.getAttributeValue("type", xtr);
        String tenantId = BpmnXMLUtil.getAttributeValue("tenantId", xtr);
        String binding = BpmnXMLUtil.getAttributeValue("decisionRefBinding", xtr);
        String decisionRefVersion = BpmnXMLUtil.getAttributeValue("decisionRefVersion", xtr);
        baseCallableElement.setDecisionRef(decisionRef);
        baseCallableElement.setDecisionRefName(decisionRefName);
        baseCallableElement.setTenantId(tenantId);
        baseCallableElement.setDecisionRefVersion(decisionRefVersion);
        baseCallableElement.setType(type);
        baseCallableElement.setBinding(BaseCallableElement.CallableElementBinding.getValue((String)binding));
        businessRuleTask.setBaseCallableElement(baseCallableElement);
        businessRuleTask.setInputVariables(this.parseDelimitedList(BpmnXMLUtil.getAttributeValue("ruleVariablesInput", xtr)));
        businessRuleTask.setRuleNames(this.parseDelimitedList(BpmnXMLUtil.getAttributeValue("rules", xtr)));
        businessRuleTask.setResultVariableName(BpmnXMLUtil.getAttributeValue("resultVariable", xtr));
        businessRuleTask.setClassName(BpmnXMLUtil.getAttributeValue("class", xtr));
        String exclude = BpmnXMLUtil.getAttributeValue("exclude", xtr);
        if ("true".equalsIgnoreCase(exclude)) {
            businessRuleTask.setExclude(true);
        }
        this.parseChildElements(this.getXMLElementName(), (BaseElement)businessRuleTask, model, xtr);
        return businessRuleTask;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        String ruleNames;
        BusinessRuleTask businessRuleTask = (BusinessRuleTask)element;
        String inputVariables = this.convertToDelimitedString(businessRuleTask.getInputVariables());
        if (StringUtils.isNotEmpty((CharSequence)inputVariables)) {
            this.writeQualifiedAttribute("ruleVariablesInput", inputVariables, xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)(ruleNames = this.convertToDelimitedString(businessRuleTask.getRuleNames())))) {
            this.writeQualifiedAttribute("rules", ruleNames, xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)businessRuleTask.getResultVariableName())) {
            this.writeQualifiedAttribute("resultVariable", businessRuleTask.getResultVariableName(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)businessRuleTask.getClassName())) {
            this.writeQualifiedAttribute("class", businessRuleTask.getClassName(), xtw);
        }
        if (businessRuleTask.isExclude()) {
            this.writeQualifiedAttribute("exclude", "true", xtw);
        }
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
    }
}

