/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter;

import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BaseBpmnXMLConverter;
import org.flowable.bpmn.converter.export.FieldExtensionExport;
import org.flowable.bpmn.converter.export.MapExceptionExport;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.AbstractFlowableHttpHandler;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CaseServiceTask;
import org.flowable.bpmn.model.CustomProperty;
import org.flowable.bpmn.model.HttpServiceTask;
import org.flowable.bpmn.model.ImplementationType;
import org.flowable.bpmn.model.ServiceTask;

public class ServiceTaskXMLConverter
extends BaseBpmnXMLConverter {
    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return ServiceTask.class;
    }

    @Override
    protected String getXMLElementName() {
        return "serviceTask";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        String serviceTaskType = BpmnXMLUtil.getAttributeValue("type", xtr);
        Object serviceTask = null;
        serviceTask = "http".equals(serviceTaskType) ? new HttpServiceTask() : ("case".equals(serviceTaskType) ? new CaseServiceTask() : new ServiceTask());
        BpmnXMLUtil.addXMLLocation((BaseElement)serviceTask, xtr);
        if (StringUtils.isNotEmpty((CharSequence)BpmnXMLUtil.getAttributeValue("class", xtr))) {
            serviceTask.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_CLASS);
            serviceTask.setImplementation(BpmnXMLUtil.getAttributeValue("class", xtr));
        } else if (StringUtils.isNotEmpty((CharSequence)BpmnXMLUtil.getAttributeValue("expression", xtr))) {
            serviceTask.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION);
            serviceTask.setImplementation(BpmnXMLUtil.getAttributeValue("expression", xtr));
        } else if (StringUtils.isNotEmpty((CharSequence)BpmnXMLUtil.getAttributeValue("delegateExpression", xtr))) {
            serviceTask.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
            serviceTask.setImplementation(BpmnXMLUtil.getAttributeValue("delegateExpression", xtr));
        } else if ("##WebService".equals(xtr.getAttributeValue(null, "implementation"))) {
            serviceTask.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_WEBSERVICE);
            serviceTask.setOperationRef(this.parseOperationRef(xtr.getAttributeValue(null, "operationRef"), model));
        }
        serviceTask.setResultVariableName(BpmnXMLUtil.getAttributeValue("resultVariableName", xtr));
        if (StringUtils.isEmpty((CharSequence)serviceTask.getResultVariableName())) {
            serviceTask.setResultVariableName(BpmnXMLUtil.getAttributeValue("resultVariable", xtr));
        }
        serviceTask.setUseLocalScopeForResultVariable(Boolean.valueOf(BpmnXMLUtil.getAttributeValue("useLocalScopeForResultVariable", xtr)).booleanValue());
        serviceTask.setType(serviceTaskType);
        serviceTask.setExtensionId(BpmnXMLUtil.getAttributeValue("extensionId", xtr));
        if (StringUtils.isNotEmpty((CharSequence)BpmnXMLUtil.getAttributeValue("skipExpression", xtr))) {
            serviceTask.setSkipExpression(BpmnXMLUtil.getAttributeValue("skipExpression", xtr));
        }
        if (serviceTask instanceof CaseServiceTask) {
            this.convertCaseServiceTaskXMLProperties((CaseServiceTask)serviceTask, model, xtr);
        } else {
            this.parseChildElements(this.getXMLElementName(), (BaseElement)serviceTask, model, xtr);
        }
        return serviceTask;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        ServiceTask serviceTask = (ServiceTask)element;
        if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(serviceTask.getImplementationType())) {
            this.writeQualifiedAttribute("class", serviceTask.getImplementation(), xtw);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equals(serviceTask.getImplementationType())) {
            this.writeQualifiedAttribute("expression", serviceTask.getImplementation(), xtw);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(serviceTask.getImplementationType())) {
            this.writeQualifiedAttribute("delegateExpression", serviceTask.getImplementation(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getResultVariableName())) {
            this.writeQualifiedAttribute("resultVariableName", serviceTask.getResultVariableName(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getType())) {
            this.writeQualifiedAttribute("type", serviceTask.getType(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getExtensionId())) {
            this.writeQualifiedAttribute("extensionId", serviceTask.getExtensionId(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getSkipExpression())) {
            this.writeQualifiedAttribute("skipExpression", serviceTask.getSkipExpression(), xtw);
        }
        if (serviceTask.isTriggerable()) {
            this.writeQualifiedAttribute("triggerable", "true", xtw);
        }
        if (serviceTask.isUseLocalScopeForResultVariable()) {
            this.writeQualifiedAttribute("useLocalScopeForResultVariable", "true", xtw);
        }
    }

    @Override
    protected boolean writeExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        ServiceTask serviceTask = (ServiceTask)element;
        if (!serviceTask.getCustomProperties().isEmpty()) {
            this.writeCustomProperties(serviceTask, didWriteExtensionStartElement, xtw);
        } else {
            if (serviceTask instanceof HttpServiceTask) {
                didWriteExtensionStartElement = this.writeHttpTaskExtensionElements((HttpServiceTask)serviceTask, didWriteExtensionStartElement, xtw);
            }
            didWriteExtensionStartElement = FieldExtensionExport.writeFieldExtensions(serviceTask.getFieldExtensions(), didWriteExtensionStartElement, xtw);
            didWriteExtensionStartElement = MapExceptionExport.writeMapExceptionExtensions(serviceTask.getMapExceptions(), didWriteExtensionStartElement, xtw);
        }
        return didWriteExtensionStartElement;
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
    }

    protected void convertCaseServiceTaskXMLProperties(CaseServiceTask caseServiceTask, BpmnModel bpmnModel, XMLStreamReader xtr) throws Exception {
    }

    protected boolean writeCustomProperties(ServiceTask serviceTask, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        for (CustomProperty customProperty : serviceTask.getCustomProperties()) {
            if (StringUtils.isEmpty((CharSequence)customProperty.getSimpleValue())) continue;
            if (!didWriteExtensionStartElement) {
                xtw.writeStartElement("extensionElements");
                didWriteExtensionStartElement = true;
            }
            xtw.writeStartElement("flowable", "field", "http://flowable.org/bpmn");
            xtw.writeAttribute("name", customProperty.getName());
            if ((customProperty.getSimpleValue().contains("${") || customProperty.getSimpleValue().contains("#{")) && customProperty.getSimpleValue().contains("}")) {
                xtw.writeStartElement("flowable", "expression", "http://flowable.org/bpmn");
            } else {
                xtw.writeStartElement("flowable", "string", "http://flowable.org/bpmn");
            }
            xtw.writeCharacters(customProperty.getSimpleValue());
            xtw.writeEndElement();
            xtw.writeEndElement();
        }
        return didWriteExtensionStartElement;
    }

    protected boolean writeHttpTaskExtensionElements(HttpServiceTask httpServiceTask, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        if (httpServiceTask.getHttpRequestHandler() != null) {
            if (!didWriteExtensionStartElement) {
                xtw.writeStartElement("extensionElements");
                didWriteExtensionStartElement = true;
            }
            xtw.writeStartElement("flowable", "httpRequestHandler", "http://flowable.org/bpmn");
            this.writeHttpHandlerAttributes((AbstractFlowableHttpHandler)httpServiceTask.getHttpRequestHandler(), xtw);
            xtw.writeEndElement();
        }
        if (httpServiceTask.getHttpResponseHandler() != null) {
            if (!didWriteExtensionStartElement) {
                xtw.writeStartElement("extensionElements");
                didWriteExtensionStartElement = true;
            }
            xtw.writeStartElement("flowable", "httpResponseHandler", "http://flowable.org/bpmn");
            this.writeHttpHandlerAttributes((AbstractFlowableHttpHandler)httpServiceTask.getHttpResponseHandler(), xtw);
            xtw.writeEndElement();
        }
        return didWriteExtensionStartElement;
    }

    protected String parseOperationRef(String operationRef, BpmnModel model) {
        String result = null;
        if (StringUtils.isNotEmpty((CharSequence)operationRef)) {
            int indexOfP = operationRef.indexOf(58);
            if (indexOfP != -1) {
                String prefix = operationRef.substring(0, indexOfP);
                String resolvedNamespace = model.getNamespace(prefix);
                result = resolvedNamespace + ":" + operationRef.substring(indexOfP + 1);
            } else {
                result = model.getTargetNamespace() + ":" + operationRef;
            }
        }
        return result;
    }

    protected void writeHttpHandlerAttributes(AbstractFlowableHttpHandler httpHandler, XMLStreamWriter xtw) throws Exception {
        if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(httpHandler.getImplementationType())) {
            xtw.writeAttribute("class", httpHandler.getImplementation());
        } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(httpHandler.getImplementationType())) {
            xtw.writeAttribute("delegateExpression", httpHandler.getImplementation());
        }
    }
}

