/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.export;

import com.a1bpm.model.ExtA1Attribute;
import com.a1bpm.model.ExtA1CommonScript;
import com.a1bpm.model.ExtA1GlobalForm;
import com.a1bpm.model.ExtA1UserProperty;
import com.a1bpm.model.ExtA1UserRule;
import java.util.List;
import java.util.UUID;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtA1Button;
import org.flowable.bpmn.model.ExtA1Properties;

public class ExtPropertiesExport
implements BpmnXMLConstants {
    public static void writeExtProperties(BpmnModel model, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("extA1:ExtProperties");
        writer.writeAttribute("id", "ExtProperties_" + UUID.randomUUID().toString());
        ExtA1Properties extA1Properties = model.getExtA1Properties();
        if (extA1Properties == null) {
            writer.writeEndElement();
            return;
        }
        writer.writeStartElement("extA1:PropertiesDef");
        writer.writeAttribute("id", ExtPropertiesExport.emptyDefault(extA1Properties.getId()));
        writer.writeAttribute("subjectRule", ExtPropertiesExport.emptyDefault(extA1Properties.getSubjectRule()));
        writer.writeAttribute("description", ExtPropertiesExport.emptyDefault(extA1Properties.getDescription()));
        writer.writeAttribute("propNotifyType", ExtPropertiesExport.emptyDefault(extA1Properties.getPropNotifyType()));
        writer.writeAttribute("parameterUserAssign", ExtPropertiesExport.emptyDefault(extA1Properties.getParameterUserAssign()));
        writer.writeAttribute("propSkipRules", ExtPropertiesExport.emptyDefault(extA1Properties.getPropSkipRules()));
        writer.writeAttribute("propDateType", ExtPropertiesExport.emptyDefault(extA1Properties.getPropDateType()));
        writer.writeAttribute("dateTypeDay", ExtPropertiesExport.emptyDefault(extA1Properties.getDateTypeDay()));
        writer.writeAttribute("startMethod", ExtPropertiesExport.emptyDefault(extA1Properties.getStartMethod()));
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public static void writeButtons(BpmnModel model, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("extA1:Buttons");
        writer.writeAttribute("id", "Buttons_" + UUID.randomUUID().toString());
        for (ExtA1Button button : model.getExtA1Buttons()) {
            writer.writeStartElement("extA1:Button");
            writer.writeAttribute("id", ExtPropertiesExport.emptyDefault(button.getId()));
            writer.writeAttribute("alias", ExtPropertiesExport.emptyDefault(button.getAlias()));
            writer.writeAttribute("btnName", ExtPropertiesExport.emptyDefault(button.getBtnName()));
            writer.writeAttribute("nodeId", ExtPropertiesExport.emptyDefault(button.getNodeId()));
            writer.writeAttribute("cssName", ExtPropertiesExport.emptyDefault(button.getCssName()));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public static String emptyDefault(String val) {
        if (StringUtils.isEmpty((CharSequence)val)) {
            val = "";
        }
        return val;
    }

    public static void writeUserRules(BpmnModel model, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("extA1:UserRules");
        writer.writeAttribute("id", "UserRule_" + UUID.randomUUID().toString().replace("-", ""));
        for (ExtA1UserRule extA1UserRule : model.getExtA1UserRule()) {
            writer.writeStartElement("extA1:UserRule");
            writer.writeAttribute("id", ExtPropertiesExport.emptyDefault(extA1UserRule.getId()));
            writer.writeAttribute("nodeId", ExtPropertiesExport.emptyDefault(extA1UserRule.getNodeId()));
            writer.writeAttribute("pluginType", ExtPropertiesExport.emptyDefault(extA1UserRule.getPluginType()));
            writer.writeAttribute("pluginVal", ExtPropertiesExport.emptyDefault(extA1UserRule.getPluginVal()));
            writer.writeAttribute("logicCal", ExtPropertiesExport.emptyDefault(extA1UserRule.getLogicCal()));
            writer.writeAttribute("ruleId", ExtPropertiesExport.emptyDefault(extA1UserRule.getRuleId()));
            writer.writeAttribute("ruleVal", ExtPropertiesExport.emptyDefault(extA1UserRule.getRuleVal()));
            writer.writeAttribute("ruleDisplayName", ExtPropertiesExport.emptyDefault(extA1UserRule.getRuleDisplayName()));
            writer.writeAttribute("specId", ExtPropertiesExport.emptyDefault(extA1UserRule.getSpecId()));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public static void writeUserPropertyes(BpmnModel model, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("extA1:UserPropertyes");
        writer.writeAttribute("id", "ExtProperties_" + UUID.randomUUID().toString().replace("-", ""));
        List extA1UserPropertyList = model.getExtA1UserProperty();
        for (ExtA1UserProperty extA1UserProperty : extA1UserPropertyList) {
            writer.writeStartElement("extA1:UserProperty");
            writer.writeAttribute("id", ExtPropertiesExport.emptyDefault(UUID.randomUUID().toString().replace("-", "")));
            writer.writeAttribute("nodeId", ExtPropertiesExport.emptyDefault(extA1UserProperty.getNodeId()));
            writer.writeAttribute("backNode", ExtPropertiesExport.emptyDefault(extA1UserProperty.getBackNode()));
            writer.writeAttribute("backUserMode", ExtPropertiesExport.emptyDefault(extA1UserProperty.getBackUserMode()));
            writer.writeAttribute("dateType", ExtPropertiesExport.emptyDefault(extA1UserProperty.getDateType()));
            writer.writeAttribute("jumpType", ExtPropertiesExport.emptyDefault(extA1UserProperty.getJumpType()));
            writer.writeAttribute("nodePropertiesDay", ExtPropertiesExport.emptyDefault(extA1UserProperty.getNodePropertiesDay()));
            writer.writeAttribute("notifyType", ExtPropertiesExport.emptyDefault(extA1UserProperty.getNotifyType()));
            writer.writeAttribute("postHandler", ExtPropertiesExport.emptyDefault(extA1UserProperty.getPostHandler()));
            writer.writeAttribute("prevHand", ExtPropertiesExport.emptyDefault(extA1UserProperty.getPrevHand()));
            writer.writeAttribute("nodePropertiesHour", ExtPropertiesExport.emptyDefault(extA1UserProperty.getNodePropertiesHour()));
            writer.writeAttribute("nodePropertiesMinute", ExtPropertiesExport.emptyDefault(extA1UserProperty.getNodePropertiesMinute()));
            writer.writeAttribute("window", ExtPropertiesExport.emptyDefault(extA1UserProperty.getWindow()));
            writer.writeAttribute("executor", ExtPropertiesExport.emptyDefault(extA1UserProperty.getExecutor()));
            writer.writeAttribute("choose", ExtPropertiesExport.emptyDefault(extA1UserProperty.getChoose()));
            writer.writeAttribute("parallelFlag", ExtPropertiesExport.emptyDefault(extA1UserProperty.getParallelFlag()));
            writer.writeAttribute("openExpireFlag", ExtPropertiesExport.emptyDefault(extA1UserProperty.getOpenExpireFlag()));
            writer.writeAttribute("expireHandlerModel", ExtPropertiesExport.emptyDefault(extA1UserProperty.getExpireHandlerModel()));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public static void writeGlobals(BpmnModel model, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("extA1:Globals");
        writer.writeAttribute("id", "ExtProperties_" + UUID.randomUUID().toString().replace("-", ""));
        writer.writeEndElement();
    }

    public static void writeVariableDefs(BpmnModel model, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("extA1:VariableDefs");
        writer.writeAttribute("id", "ExtProperties_" + UUID.randomUUID().toString().replace("-", ""));
        writer.writeEndElement();
    }

    public static void writeConditions(BpmnModel model, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("extA1:Conditions");
        writer.writeAttribute("id", "ExtProperties_" + UUID.randomUUID().toString().replace("-", ""));
        writer.writeEndElement();
    }

    public static void writeCommonScripts(BpmnModel model, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("extA1:CommonScripts");
        writer.writeAttribute("id", "ExtProperties_" + UUID.randomUUID().toString().replace("-", ""));
        for (ExtA1CommonScript extA1CommonScript : model.getExtA1CommonScripts()) {
            writer.writeStartElement("extA1:CommonScript");
            writer.writeAttribute("id", ExtPropertiesExport.emptyDefault(UUID.randomUUID().toString().replace("-", "")));
            writer.writeAttribute("nodeId", ExtPropertiesExport.emptyDefault(extA1CommonScript.getNodeId()));
            writer.writeAttribute("previous", ExtPropertiesExport.emptyDefault(extA1CommonScript.getPrevious()));
            writer.writeAttribute("complete", ExtPropertiesExport.emptyDefault(extA1CommonScript.getComplete()));
            writer.writeAttribute("invalid", ExtPropertiesExport.emptyDefault(extA1CommonScript.getInvalid()));
            writer.writeAttribute("revoke", ExtPropertiesExport.emptyDefault(extA1CommonScript.getRevoke()));
            writer.writeAttribute("backToNode", ExtPropertiesExport.emptyDefault(extA1CommonScript.getBackToNode()));
            writer.writeAttribute("transactionUrge", ExtPropertiesExport.emptyDefault(extA1CommonScript.getTransactionUrge()));
            writer.writeAttribute("deleted", ExtPropertiesExport.emptyDefault(extA1CommonScript.getDeleted()));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public static void writeSGlobalForms(BpmnModel model, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("extA1:GlobalForms");
        writer.writeAttribute("id", "ExtProperties_" + UUID.randomUUID().toString().replace("-", ""));
        for (ExtA1GlobalForm globalForm : model.getExtA1GlobalForms()) {
            writer.writeStartElement("extA1:GlobalForm");
            writer.writeAttribute("id", ExtPropertiesExport.emptyDefault(globalForm.getId()));
            writer.writeAttribute("formValue", ExtPropertiesExport.emptyDefault(globalForm.getFormValue()));
            writer.writeAttribute("name", ExtPropertiesExport.emptyDefault(globalForm.getName()));
            writer.writeAttribute("parentFlowKey", ExtPropertiesExport.emptyDefault(globalForm.getParentFlowKey()));
            writer.writeAttribute("type", ExtPropertiesExport.emptyDefault(globalForm.getType()));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public static void writeSExtAttributes(BpmnModel model, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("extA1:ExtAttributes");
        writer.writeAttribute("id", "ExtProperties_" + UUID.randomUUID().toString().replace("-", ""));
        for (ExtA1Attribute extA1Attribute : model.getExtA1Attributes()) {
            writer.writeStartElement("extA1:ExtAttribute");
            writer.writeAttribute("id", ExtPropertiesExport.emptyDefault(extA1Attribute.getId()));
            writer.writeAttribute("name", ExtPropertiesExport.emptyDefault(extA1Attribute.getName()));
            writer.writeAttribute("nodeId", ExtPropertiesExport.emptyDefault(extA1Attribute.getNodeId()));
            writer.writeAttribute("val", ExtPropertiesExport.emptyDefault(extA1Attribute.getVal()));
            writer.writeAttribute("flag", ExtPropertiesExport.emptyDefault(extA1Attribute.getFlag()));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public static void writeSPropertiesDef(BpmnModel model, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("extA1:PropertiesDef");
        writer.writeAttribute("id", "PropertiesDef_" + UUID.randomUUID().toString().replace("-", ""));
        ExtA1Properties extA1Properties = model.getExtA1Properties();
        if (extA1Properties != null) {
            writer.writeAttribute("description", extA1Properties.getDescription());
        }
        writer.writeEndElement();
    }
}

