/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.FlowableListener;
import org.flowable.bpmn.model.HasExecutionListeners;
import org.flowable.bpmn.model.SubProcess;

public abstract class FlowElement
extends BaseElement
implements HasExecutionListeners {
    protected String name;
    protected String documentation;
    protected List<FlowableListener> executionListeners = new ArrayList<FlowableListener>();
    protected FlowElementsContainer parentContainer;
    private String nextId;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    @Override
    public List<FlowableListener> getExecutionListeners() {
        return this.executionListeners;
    }

    @Override
    public void setExecutionListeners(List<FlowableListener> executionListeners) {
        this.executionListeners = executionListeners;
    }

    @JsonIgnore
    public FlowElementsContainer getParentContainer() {
        return this.parentContainer;
    }

    @JsonIgnore
    public SubProcess getSubProcess() {
        SubProcess subProcess = null;
        if (this.parentContainer instanceof SubProcess) {
            subProcess = (SubProcess)this.parentContainer;
        }
        return subProcess;
    }

    public void setParentContainer(FlowElementsContainer parentContainer) {
        this.parentContainer = parentContainer;
    }

    @Override
    public abstract FlowElement clone();

    public void setValues(FlowElement otherElement) {
        super.setValues(otherElement);
        this.setName(otherElement.getName());
        this.setDocumentation(otherElement.getDocumentation());
        this.executionListeners = new ArrayList<FlowableListener>();
        if (otherElement.getExecutionListeners() != null && !otherElement.getExecutionListeners().isEmpty()) {
            for (FlowableListener listener : otherElement.getExecutionListeners()) {
                this.executionListeners.add(listener.clone());
            }
        }
    }

    public String getNextId() {
        return this.nextId;
    }

    public void setNextId(String nextId) {
        this.nextId = nextId;
    }
}

