/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.repository.CmmnDeployment;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.DecisionTask;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.api.DmnDecisionTable;
import org.flowable.dmn.api.DmnDecisionTableQuery;
import org.flowable.dmn.api.DmnDeployment;
import org.flowable.dmn.api.DmnRepositoryService;

public class GetDecisionTablesForCaseDefinitionCmd
implements Command<List<DmnDecisionTable>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseDefinitionId;
    protected DmnRepositoryService dmnRepositoryService;

    public GetDecisionTablesForCaseDefinitionCmd(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    public List<DmnDecisionTable> execute(CommandContext commandContext) {
        CaseDefinition caseDefinition = CaseDefinitionUtil.getCaseDefinition(this.caseDefinitionId);
        if (caseDefinition == null) {
            throw new FlowableObjectNotFoundException("Cannot find case definition for id: " + this.caseDefinitionId, CaseDefinition.class);
        }
        Case caseModel = CaseDefinitionUtil.getCase(this.caseDefinitionId);
        if (caseModel == null) {
            throw new FlowableObjectNotFoundException("Cannot find case definition for id: " + this.caseDefinitionId, Case.class);
        }
        this.dmnRepositoryService = CommandContextUtil.getDmnEngineConfiguration(commandContext).getDmnRepositoryService();
        if (this.dmnRepositoryService == null) {
            throw new FlowableException("DMN repository service is not available");
        }
        List<DmnDecisionTable> decisionTables = this.getDecisionTablesFromModel(caseModel, caseDefinition);
        return decisionTables;
    }

    protected List<DmnDecisionTable> getDecisionTablesFromModel(Case caseModel, CaseDefinition caseDefinition) {
        HashSet<String> decisionTableKeys = new HashSet<String>();
        ArrayList<DmnDecisionTable> decisionTables = new ArrayList<DmnDecisionTable>();
        List decisionTasks = caseModel.getPlanModel().findPlanItemDefinitionsOfType(DecisionTask.class, true);
        block0: for (DecisionTask decisionTask : decisionTasks) {
            if (decisionTask.getFieldExtensions() == null || decisionTask.getFieldExtensions().size() <= 0) continue;
            for (FieldExtension fieldExtension : decisionTask.getFieldExtensions()) {
                if (!"decisionTableReferenceKey".equals(fieldExtension.getFieldName())) continue;
                String decisionTableReferenceKey = fieldExtension.getStringValue();
                if (decisionTableKeys.contains(decisionTableReferenceKey)) continue block0;
                this.addDecisionTableToCollection(decisionTables, decisionTableReferenceKey, caseDefinition);
                decisionTableKeys.add(decisionTableReferenceKey);
                continue block0;
            }
        }
        return decisionTables;
    }

    protected void addDecisionTableToCollection(List<DmnDecisionTable> decisionTables, String decisionTableKey, CaseDefinition caseDefinition) {
        DmnDecisionTableQuery decisionTableQuery = this.dmnRepositoryService.createDecisionTableQuery().decisionTableKey(decisionTableKey);
        CmmnDeployment deployment = (CmmnDeployment)CommandContextUtil.getCmmnDeploymentEntityManager().findById(caseDefinition.getDeploymentId());
        if (deployment.getParentDeploymentId() != null) {
            List dmnDeployments = this.dmnRepositoryService.createDeploymentQuery().parentDeploymentId(deployment.getParentDeploymentId()).list();
            if (dmnDeployments != null && dmnDeployments.size() > 0) {
                decisionTableQuery.deploymentId(((DmnDeployment)dmnDeployments.get(0)).getId());
            } else {
                decisionTableQuery.latestVersion();
            }
        } else {
            decisionTableQuery.latestVersion();
        }
        DmnDecisionTable decisionTable = (DmnDecisionTable)decisionTableQuery.singleResult();
        if (decisionTable != null) {
            decisionTables.add(decisionTable);
        }
    }
}

