/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.deployer;

import java.util.LinkedHashMap;
import java.util.Map;
import org.flowable.dmn.engine.impl.deployer.CachingAndArtifactsManager;
import org.flowable.dmn.engine.impl.deployer.DmnDeploymentHelper;
import org.flowable.dmn.engine.impl.deployer.ParsedDeployment;
import org.flowable.dmn.engine.impl.deployer.ParsedDeploymentBuilderFactory;
import org.flowable.dmn.engine.impl.persistence.deploy.Deployer;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntityManager;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.engine.common.impl.cfg.IdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmnDeployer
implements Deployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmnDeployer.class);
    protected IdGenerator idGenerator;
    protected ParsedDeploymentBuilderFactory parsedDeploymentBuilderFactory;
    protected DmnDeploymentHelper dmnDeploymentHelper;
    protected CachingAndArtifactsManager cachingAndArtifactsManager;

    @Override
    public void deploy(DmnDeploymentEntity deployment, Map<String, Object> deploymentSettings) {
        LOGGER.debug("Processing deployment {}", (Object)deployment.getName());
        ParsedDeployment parsedDeployment = this.parsedDeploymentBuilderFactory.getBuilderForDeploymentAndSettings(deployment, deploymentSettings).build();
        this.dmnDeploymentHelper.verifyDecisionTablesDoNotShareKeys(parsedDeployment.getAllDecisionTables());
        this.dmnDeploymentHelper.copyDeploymentValuesToDecisionTables(parsedDeployment.getDeployment(), parsedDeployment.getAllDecisionTables());
        this.dmnDeploymentHelper.setResourceNamesOnDecisionTables(parsedDeployment);
        if (deployment.isNew()) {
            Map<DecisionTableEntity, DecisionTableEntity> mapOfNewDecisionTableToPreviousVersion = this.getPreviousVersionsOfDecisionTables(parsedDeployment);
            this.setDecisionTableVersionsAndIds(parsedDeployment, mapOfNewDecisionTableToPreviousVersion);
            this.persistDecisionTables(parsedDeployment);
        } else {
            this.makeDecisionTablesConsistentWithPersistedVersions(parsedDeployment);
        }
        this.cachingAndArtifactsManager.updateCachingAndArtifacts(parsedDeployment);
    }

    protected Map<DecisionTableEntity, DecisionTableEntity> getPreviousVersionsOfDecisionTables(ParsedDeployment parsedDeployment) {
        LinkedHashMap<DecisionTableEntity, DecisionTableEntity> result = new LinkedHashMap<DecisionTableEntity, DecisionTableEntity>();
        for (DecisionTableEntity newDefinition : parsedDeployment.getAllDecisionTables()) {
            DecisionTableEntity existingDefinition = this.dmnDeploymentHelper.getMostRecentVersionOfDecisionTable(newDefinition);
            if (existingDefinition == null) continue;
            result.put(newDefinition, existingDefinition);
        }
        return result;
    }

    protected void setDecisionTableVersionsAndIds(ParsedDeployment parsedDeployment, Map<DecisionTableEntity, DecisionTableEntity> mapNewToOldDecisionTables) {
        for (DecisionTableEntity decisionTable : parsedDeployment.getAllDecisionTables()) {
            int version = 1;
            DecisionTableEntity latest = mapNewToOldDecisionTables.get(decisionTable);
            if (latest != null) {
                version = latest.getVersion() + 1;
            }
            decisionTable.setVersion(version);
            decisionTable.setId(this.idGenerator.getNextId());
        }
    }

    protected void persistDecisionTables(ParsedDeployment parsedDeployment) {
        DecisionTableEntityManager decisionTableEntityManager = CommandContextUtil.getDecisionTableEntityManager();
        for (DecisionTableEntity decisionTable : parsedDeployment.getAllDecisionTables()) {
            decisionTableEntityManager.insert(decisionTable);
        }
    }

    protected void makeDecisionTablesConsistentWithPersistedVersions(ParsedDeployment parsedDeployment) {
        for (DecisionTableEntity decisionTable : parsedDeployment.getAllDecisionTables()) {
            DecisionTableEntity persistedDecisionTable = this.dmnDeploymentHelper.getPersistedInstanceOfDecisionTable(decisionTable);
            if (persistedDecisionTable == null) continue;
            decisionTable.setId(persistedDecisionTable.getId());
            decisionTable.setVersion(persistedDecisionTable.getVersion());
        }
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public ParsedDeploymentBuilderFactory getExParsedDeploymentBuilderFactory() {
        return this.parsedDeploymentBuilderFactory;
    }

    public void setParsedDeploymentBuilderFactory(ParsedDeploymentBuilderFactory parsedDeploymentBuilderFactory) {
        this.parsedDeploymentBuilderFactory = parsedDeploymentBuilderFactory;
    }

    public DmnDeploymentHelper getDmnDeploymentHelper() {
        return this.dmnDeploymentHelper;
    }

    public void setDmnDeploymentHelper(DmnDeploymentHelper dmnDeploymentHelper) {
        this.dmnDeploymentHelper = dmnDeploymentHelper;
    }

    public CachingAndArtifactsManager getCachingAndArtifcatsManager() {
        return this.cachingAndArtifactsManager;
    }

    public void setCachingAndArtifactsManager(CachingAndArtifactsManager manager) {
        this.cachingAndArtifactsManager = manager;
    }
}

