/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.flowable.dmn.api.DmnDecisionTable;
import org.flowable.dmn.api.DmnDeployment;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.DmnDeploymentQueryImpl;
import org.flowable.dmn.engine.impl.persistence.entity.AbstractEntityManager;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntityManager;
import org.flowable.dmn.engine.impl.persistence.entity.DmnResourceEntity;
import org.flowable.dmn.engine.impl.persistence.entity.data.DmnDeploymentDataManager;
import org.flowable.engine.common.api.repository.EngineResource;
import org.flowable.engine.common.impl.persistence.entity.data.DataManager;

public class DmnDeploymentEntityManagerImpl
extends AbstractEntityManager<DmnDeploymentEntity>
implements DmnDeploymentEntityManager {
    protected DmnDeploymentDataManager deploymentDataManager;

    public DmnDeploymentEntityManagerImpl(DmnEngineConfiguration dmnEngineConfiguration, DmnDeploymentDataManager deploymentDataManager) {
        super(dmnEngineConfiguration);
        this.deploymentDataManager = deploymentDataManager;
    }

    @Override
    protected DataManager<DmnDeploymentEntity> getDataManager() {
        return this.deploymentDataManager;
    }

    @Override
    public void insert(DmnDeploymentEntity deployment) {
        super.insert(deployment, true);
        for (EngineResource resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getResourceEntityManager().insert((DmnResourceEntity)resource);
        }
    }

    @Override
    public void deleteDeployment(String deploymentId) {
        this.getHistoricDecisionExecutionEntityManager().deleteHistoricDecisionExecutionsByDeploymentId(deploymentId);
        this.getDecisionTableEntityManager().deleteDecisionTablesByDeploymentId(deploymentId);
        this.getResourceEntityManager().deleteResourcesByDeploymentId(deploymentId);
        this.delete(this.findById(deploymentId));
    }

    protected DecisionTableEntity findLatestDecisionTable(DmnDecisionTable decisionTable) {
        DecisionTableEntity latestDecisionTable = null;
        latestDecisionTable = decisionTable.getTenantId() != null && !"".equals(decisionTable.getTenantId()) ? this.getDecisionTableEntityManager().findLatestDecisionTableByKeyAndTenantId(decisionTable.getKey(), decisionTable.getTenantId()) : this.getDecisionTableEntityManager().findLatestDecisionTableByKey(decisionTable.getKey());
        return latestDecisionTable;
    }

    @Override
    public long findDeploymentCountByQueryCriteria(DmnDeploymentQueryImpl deploymentQuery) {
        return this.deploymentDataManager.findDeploymentCountByQueryCriteria(deploymentQuery);
    }

    @Override
    public List<DmnDeployment> findDeploymentsByQueryCriteria(DmnDeploymentQueryImpl deploymentQuery) {
        return this.deploymentDataManager.findDeploymentsByQueryCriteria(deploymentQuery);
    }

    @Override
    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.deploymentDataManager.getDeploymentResourceNames(deploymentId);
    }

    @Override
    public List<DmnDeployment> findDeploymentsByNativeQuery(Map<String, Object> parameterMap) {
        return this.deploymentDataManager.findDeploymentsByNativeQuery(parameterMap);
    }

    @Override
    public long findDeploymentCountByNativeQuery(Map<String, Object> parameterMap) {
        return this.deploymentDataManager.findDeploymentCountByNativeQuery(parameterMap);
    }

    public DmnDeploymentDataManager getDeploymentDataManager() {
        return this.deploymentDataManager;
    }

    public void setDeploymentDataManager(DmnDeploymentDataManager deploymentDataManager) {
        this.deploymentDataManager = deploymentDataManager;
    }
}

