/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl;

import org.flowable.dmn.api.DmnHistoryService;
import org.flowable.dmn.api.DmnManagementService;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.dmn.api.DmnRuleService;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.DmnEngines;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmnEngineImpl
implements DmnEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmnEngineImpl.class);
    protected String name;
    protected DmnManagementService dmnManagementService;
    protected DmnRepositoryService dmnRepositoryService;
    protected DmnRuleService dmnRuleService;
    protected DmnHistoryService dmnHistoryService;
    protected DmnEngineConfiguration dmnEngineConfiguration;

    public DmnEngineImpl(DmnEngineConfiguration dmnEngineConfiguration) {
        this.dmnEngineConfiguration = dmnEngineConfiguration;
        this.name = dmnEngineConfiguration.getEngineName();
        this.dmnManagementService = dmnEngineConfiguration.getDmnManagementService();
        this.dmnRepositoryService = dmnEngineConfiguration.getDmnRepositoryService();
        this.dmnRuleService = dmnEngineConfiguration.getDmnRuleService();
        this.dmnHistoryService = dmnEngineConfiguration.getDmnHistoryService();
        if (dmnEngineConfiguration.getSchemaManagementCmd() != null) {
            dmnEngineConfiguration.getCommandExecutor().execute(dmnEngineConfiguration.getSchemaCommandConfig(), dmnEngineConfiguration.getSchemaManagementCmd());
        }
        if (this.name == null) {
            LOGGER.info("default flowable DmnEngine created");
        } else {
            LOGGER.info("DmnEngine {} created", (Object)this.name);
        }
        DmnEngines.registerDmnEngine(this);
    }

    @Override
    public void close() {
        DmnEngines.unregister(this);
        this.dmnEngineConfiguration.close();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DmnManagementService getDmnManagementService() {
        return this.dmnManagementService;
    }

    @Override
    public DmnRepositoryService getDmnRepositoryService() {
        return this.dmnRepositoryService;
    }

    @Override
    public DmnRuleService getDmnRuleService() {
        return this.dmnRuleService;
    }

    @Override
    public DmnHistoryService getDmnHistoryService() {
        return this.dmnHistoryService;
    }

    @Override
    public DmnEngineConfiguration getDmnEngineConfiguration() {
        return this.dmnEngineConfiguration;
    }
}

