/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.api.DmnDeployment;
import org.flowable.dmn.api.DmnDeploymentQuery;
import org.flowable.dmn.engine.impl.DmnDeploymentQueryImpl;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnResourceEntity;
import org.flowable.dmn.engine.impl.repository.DmnDeploymentBuilderImpl;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;

public class DeployCmd<T>
implements Command<DmnDeployment>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected DmnDeploymentBuilderImpl deploymentBuilder;

    public DeployCmd(DmnDeploymentBuilderImpl deploymentBuilder) {
        this.deploymentBuilder = deploymentBuilder;
    }

    public DmnDeployment execute(CommandContext commandContext) {
        DmnDeploymentEntity deployment = this.deploymentBuilder.getDeployment();
        deployment.setDeploymentTime(CommandContextUtil.getDmnEngineConfiguration().getClock().getCurrentTime());
        if (this.deploymentBuilder.isDuplicateFilterEnabled()) {
            ArrayList existingDeployments = new ArrayList();
            if (deployment.getTenantId() == null || "".equals(deployment.getTenantId())) {
                List deploymentEntities = new DmnDeploymentQueryImpl(CommandContextUtil.getDmnEngineConfiguration().getCommandExecutor()).deploymentName(deployment.getName()).listPage(0, 1);
                if (!deploymentEntities.isEmpty()) {
                    existingDeployments.add(deploymentEntities.get(0));
                }
            } else {
                List deploymentList = ((DmnDeploymentQuery)CommandContextUtil.getDmnEngineConfiguration().getDmnRepositoryService().createDeploymentQuery().deploymentName(deployment.getName()).deploymentTenantId(deployment.getTenantId()).orderByDeploymentId().desc()).list();
                if (!deploymentList.isEmpty()) {
                    existingDeployments.addAll(deploymentList);
                }
            }
            DmnDeploymentEntity existingDeployment = null;
            if (!existingDeployments.isEmpty()) {
                existingDeployment = (DmnDeploymentEntity)existingDeployments.get(0);
                HashMap<String, EngineResource> resourceMap = new HashMap<String, EngineResource>();
                List<DmnResourceEntity> resourceList = CommandContextUtil.getResourceEntityManager().findResourcesByDeploymentId(existingDeployment.getId());
                for (DmnResourceEntity resourceEntity : resourceList) {
                    resourceMap.put(resourceEntity.getName(), resourceEntity);
                }
                existingDeployment.setResources(resourceMap);
            }
            if (existingDeployment != null && !this.deploymentsDiffer(deployment, existingDeployment)) {
                return existingDeployment;
            }
        }
        deployment.setNew(true);
        CommandContextUtil.getDeploymentEntityManager(commandContext).insert(deployment);
        HashMap<String, Object> deploymentSettings = new HashMap<String, Object>();
        deploymentSettings.put("isDmnXsdValidationEnabled", this.deploymentBuilder.isDmnXsdValidationEnabled());
        CommandContextUtil.getDmnEngineConfiguration().getDeploymentManager().deploy(deployment, deploymentSettings);
        return deployment;
    }

    protected boolean deploymentsDiffer(DmnDeploymentEntity deployment, DmnDeploymentEntity saved) {
        if (deployment.getResources() == null || saved.getResources() == null) {
            return true;
        }
        Map resources = deployment.getResources();
        Map savedResources = saved.getResources();
        for (String resourceName : resources.keySet()) {
            byte[] savedBytes;
            EngineResource savedResource = (EngineResource)savedResources.get(resourceName);
            if (savedResource == null) {
                return true;
            }
            EngineResource resource = (EngineResource)resources.get(resourceName);
            byte[] bytes = resource.getBytes();
            if (Arrays.equals(bytes, savedBytes = savedResource.getBytes())) continue;
            return true;
        }
        return false;
    }
}

