/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.el;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.dmn.api.DecisionExecutionAuditContainer;
import org.flowable.dmn.model.BuiltinAggregator;

public class ELExecutionContext {
    protected Map<Integer, Map<String, Object>> ruleResults = new LinkedHashMap<Integer, Map<String, Object>>();
    protected Map<String, Object> stackVariables;
    protected DecisionExecutionAuditContainer auditContainer;
    protected Map<String, List<Object>> outputValues = new LinkedHashMap<String, List<Object>>();
    protected BuiltinAggregator aggregator;

    public void checkExecutionContext(String variableId) {
        if (StringUtils.isEmpty((CharSequence)variableId)) {
            throw new IllegalArgumentException("Variable id cannot be empty");
        }
    }

    public void addRuleResult(int ruleNumber, String outputName, Object outputValue) {
        Map<Object, Object> ruleResult;
        if (this.ruleResults.containsKey(ruleNumber)) {
            ruleResult = this.ruleResults.get(ruleNumber);
        } else {
            ruleResult = new HashMap();
            this.ruleResults.put(ruleNumber, ruleResult);
        }
        ruleResult.put(outputName, outputValue);
    }

    public void setStackVariables(Map<String, Object> variables) {
        this.stackVariables = variables;
    }

    public Map<String, Object> getStackVariables() {
        return this.stackVariables;
    }

    public Map<String, Object> getRuleResult(int ruleNumber) {
        return this.ruleResults.get(ruleNumber);
    }

    public Map<Integer, Map<String, Object>> getRuleResults() {
        return this.ruleResults;
    }

    public DecisionExecutionAuditContainer getAuditContainer() {
        return this.auditContainer;
    }

    public void setAuditContainer(DecisionExecutionAuditContainer auditContainer) {
        this.auditContainer = auditContainer;
    }

    public Map<String, List<Object>> getOutputValues() {
        return this.outputValues;
    }

    public void addOutputValues(String outputName, List<Object> outputValues) {
        this.outputValues.put(outputName, outputValues);
    }

    public BuiltinAggregator getAggregator() {
        return this.aggregator;
    }

    public void setAggregator(BuiltinAggregator aggregator) {
        this.aggregator = aggregator;
    }
}

