/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.persistence.entity;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.RowBounds;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.management.TableMetaData;
import org.flowable.common.engine.api.management.TablePage;
import org.flowable.common.engine.impl.db.DbSqlSession;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.TablePageQueryImpl;
import org.flowable.dmn.engine.impl.persistence.AbstractManager;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnResourceEntity;
import org.flowable.dmn.engine.impl.persistence.entity.HistoricDecisionExecutionEntity;
import org.flowable.dmn.engine.impl.persistence.entity.TableDataManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDataManagerImpl
extends AbstractManager
implements TableDataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableDataManagerImpl.class);
    public static Map<Class<?>, String> apiTypeToTableNameMap = new HashMap();
    public static Map<Class<? extends Entity>, String> entityToTableNameMap = new HashMap<Class<? extends Entity>, String>();

    public TableDataManagerImpl(DmnEngineConfiguration dmnEngineConfiguration) {
        super(dmnEngineConfiguration);
    }

    protected DbSqlSession getDbSqlSession() {
        return this.getSession(DbSqlSession.class);
    }

    @Override
    public Map<String, Long> getTableCount() {
        HashMap<String, Long> tableCount = new HashMap<String, Long>();
        try {
            for (String tableName : this.getTablesPresentInDatabase()) {
                tableCount.put(tableName, this.getTableCount(tableName));
            }
            LOGGER.debug("Number of rows per flowable table: {}", tableCount);
        }
        catch (Exception e) {
            throw new FlowableException("couldn't get table counts", (Throwable)e);
        }
        return tableCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTablesPresentInDatabase() {
        ArrayList<String> tableNames = new ArrayList<String>();
        Connection connection = null;
        try {
            connection = this.getDbSqlSession().getSqlSession().getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try (ResultSet tables = null;){
                LOGGER.debug("retrieving flowable tables from jdbc metadata");
                String databaseTablePrefix = this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseTablePrefix();
                String tableNameFilter = databaseTablePrefix + "ACT_%";
                if ("postgres".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType()) || "cockroachdb".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType())) {
                    tableNameFilter = databaseTablePrefix + "act_%";
                }
                if ("oracle".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType())) {
                    tableNameFilter = databaseTablePrefix + "ACT" + databaseMetaData.getSearchStringEscape() + "_%";
                }
                String catalog = null;
                if (this.getDmnEngineConfiguration().getDatabaseCatalog() != null && this.getDmnEngineConfiguration().getDatabaseCatalog().length() > 0) {
                    catalog = this.getDmnEngineConfiguration().getDatabaseCatalog();
                }
                String schema = null;
                if (this.getDmnEngineConfiguration().getDatabaseSchema() != null && this.getDmnEngineConfiguration().getDatabaseSchema().length() > 0) {
                    schema = "oracle".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType()) ? this.getDmnEngineConfiguration().getDatabaseSchema().toUpperCase() : this.getDmnEngineConfiguration().getDatabaseSchema();
                }
                tables = databaseMetaData.getTables(catalog, schema, tableNameFilter, DbSqlSession.JDBC_METADATA_TABLE_TYPES);
                while (tables.next()) {
                    String tableName = tables.getString("TABLE_NAME");
                    tableName = tableName.toUpperCase();
                    tableNames.add(tableName);
                    LOGGER.debug("  retrieved flowable table name {}", (Object)tableName);
                }
            }
        }
        catch (Exception e) {
            throw new FlowableException("couldn't get flowable table names using metadata: " + e.getMessage(), (Throwable)e);
        }
        return tableNames;
    }

    protected long getTableCount(String tableName) {
        LOGGER.debug("selecting table count for {}", (Object)tableName);
        Long count = (Long)this.getDbSqlSession().selectOne("org.flowable.dmn.engine.impl.TablePageMap.selectTableCount", Collections.singletonMap("tableName", tableName));
        return count;
    }

    @Override
    public TablePage getTablePage(TablePageQueryImpl tablePageQuery, int firstResult, int maxResults) {
        TablePage tablePage = new TablePage();
        List tableData = this.getDbSqlSession().getSqlSession().selectList("selectTableData", (Object)tablePageQuery, new RowBounds(firstResult, maxResults));
        tablePage.setTableName(tablePageQuery.getTableName());
        tablePage.setTotal(this.getTableCount(tablePageQuery.getTableName()));
        tablePage.setRows(tableData);
        tablePage.setFirstResult((long)firstResult);
        return tablePage;
    }

    @Override
    public String getTableName(Class<?> entityClass, boolean withPrefix) {
        String databaseTablePrefix = this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseTablePrefix();
        String tableName = null;
        tableName = Entity.class.isAssignableFrom(entityClass) ? entityToTableNameMap.get(entityClass) : apiTypeToTableNameMap.get(entityClass);
        if (withPrefix) {
            return databaseTablePrefix + tableName;
        }
        return tableName;
    }

    @Override
    public TableMetaData getTableMetaData(String tableName) {
        TableMetaData result = new TableMetaData();
        try {
            result.setTableName(tableName);
            DatabaseMetaData metaData = this.getDbSqlSession().getSqlSession().getConnection().getMetaData();
            if ("postgres".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType()) || "cockroachdb".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType())) {
                tableName = tableName.toLowerCase();
            }
            String catalog = null;
            if (this.getDmnEngineConfiguration().getDatabaseCatalog() != null && this.getDmnEngineConfiguration().getDatabaseCatalog().length() > 0) {
                catalog = this.getDmnEngineConfiguration().getDatabaseCatalog();
            }
            String schema = null;
            if (this.getDmnEngineConfiguration().getDatabaseSchema() != null && this.getDmnEngineConfiguration().getDatabaseSchema().length() > 0) {
                schema = "oracle".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType()) ? this.getDmnEngineConfiguration().getDatabaseSchema().toUpperCase() : this.getDmnEngineConfiguration().getDatabaseSchema();
            }
            ResultSet resultSet = metaData.getColumns(catalog, schema, tableName, null);
            while (resultSet.next()) {
                boolean wrongSchema = false;
                if (schema != null && schema.length() > 0) {
                    for (int i = 0; i < resultSet.getMetaData().getColumnCount(); ++i) {
                        String columnName = resultSet.getMetaData().getColumnName(i + 1);
                        if (!"TABLE_SCHEM".equalsIgnoreCase(columnName) && !"TABLE_SCHEMA".equalsIgnoreCase(columnName)) continue;
                        if (schema.equalsIgnoreCase(resultSet.getString(resultSet.getMetaData().getColumnName(i + 1)))) break;
                        wrongSchema = true;
                        break;
                    }
                }
                if (wrongSchema) continue;
                String name = resultSet.getString("COLUMN_NAME").toUpperCase();
                String type = resultSet.getString("TYPE_NAME").toUpperCase();
                result.addColumnMetaData(name, type);
            }
        }
        catch (SQLException e) {
            throw new FlowableException("Could not retrieve database metadata: " + e.getMessage());
        }
        if (result.getColumnNames().isEmpty()) {
            result = null;
        }
        return result;
    }

    static {
        entityToTableNameMap.put(DmnDeploymentEntity.class, "ACT_DMN_DEPLOYMENT");
        entityToTableNameMap.put(DecisionTableEntity.class, "ACT_DMN_DECISION_TABLE");
        entityToTableNameMap.put(DmnResourceEntity.class, "ACT_DMN_DEPLOYMENT_RESOURCE");
        entityToTableNameMap.put(HistoricDecisionExecutionEntity.class, "ACT_DMN_HI_DECISION_EXECUTION");
    }
}

