/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.audit;

import org.flowable.dmn.api.DecisionExecutionAuditContainer;
import org.flowable.dmn.engine.impl.ExecuteDecisionInfo;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionExecutionAuditUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecisionExecutionAuditUtil.class);

    public static DecisionExecutionAuditContainer initializeRuleExecutionAudit(Decision decision, ExecuteDecisionInfo executeDecisionInfo) {
        if (decision == null || decision.getId() == null) {
            LOGGER.error("decision does not contain key");
            throw new IllegalArgumentException("decision does not contain decision key");
        }
        DecisionTable decisionTable = (DecisionTable)decision.getExpression();
        if (decisionTable.getHitPolicy() == null) {
            LOGGER.error("decision table does not contain a hit policy");
            throw new IllegalArgumentException("decision table does not contain a hit policy");
        }
        return new DecisionExecutionAuditContainer(decision.getId(), decision.getName(), executeDecisionInfo.getDecisionVersion(), decisionTable.getHitPolicy(), Boolean.valueOf(CommandContextUtil.getDmnEngineConfiguration().isStrictMode()), executeDecisionInfo.getVariables());
    }
}

