/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.rest.service.api.management;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.EngineInfo;
import org.flowable.dmn.engine.DmnEngines;
import org.flowable.dmn.rest.service.api.DmnRestApiInterceptor;
import org.flowable.dmn.rest.service.api.management.DmnEngineInfoResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Engine"}, description="Manage DMN Engine", authorizations={@Authorization(value="basicAuth")})
public class DmnEngineResource {
    @Autowired(required=false)
    protected DmnRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="Get DMN engine info", tags={"Engine"}, notes="Returns a read-only view of the DMN engine that is used in this REST-service.")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the engine info is returned.")})
    @GetMapping(value={"/dmn-management/engine"}, produces={"application/json"})
    public DmnEngineInfoResponse getEngineInfo() {
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessDmnManagementInfo();
        }
        DmnEngineInfoResponse response = new DmnEngineInfoResponse();
        try {
            EngineInfo dmnEngineInfo = DmnEngines.getDmnEngineInfo((String)DmnEngines.getDefaultDmnEngine().getName());
            if (dmnEngineInfo != null) {
                response.setName(dmnEngineInfo.getName());
                response.setResourceUrl(dmnEngineInfo.getResourceUrl());
                response.setException(dmnEngineInfo.getException());
            } else {
                response.setName(DmnEngines.getDefaultDmnEngine().getName());
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error retrieving DMN engine info", (Throwable)e);
        }
        response.setVersion("6.5.0.2");
        return response;
    }
}

