/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.rest.service.api.history;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.dmn.api.DmnHistoricDecisionExecutionQuery;
import org.flowable.dmn.api.DmnHistoryService;
import org.flowable.dmn.engine.impl.HistoricDecisionExecutionQueryProperty;
import org.flowable.dmn.rest.service.api.DmnRestApiInterceptor;
import org.flowable.dmn.rest.service.api.DmnRestResponseFactory;
import org.flowable.dmn.rest.service.api.history.HistoricDecisionExecutionResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Historic Decision Executions"}, description="Query Historic Decision Executions", authorizations={@Authorization(value="basicAuth")})
public class HistoryDecisionExecutionCollectionResource {
    private static final Map<String, QueryProperty> properties = new HashMap<String, QueryProperty>();
    @Autowired
    protected DmnRestResponseFactory dmnRestResponseFactory;
    @Autowired
    protected DmnHistoryService dmnHistoryService;
    @Autowired(required=false)
    protected DmnRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="List of historic decision executions", nickname="listHistoricDecisionExecutions", tags={"Historic Decision Executions"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", dataType="string", value="Only return historic decision executions with the given id.", paramType="query"), @ApiImplicitParam(name="decisionDefinitionId", dataType="string", value="Only return historic decision executions with the given definition id.", paramType="query"), @ApiImplicitParam(name="deploymentId", dataType="string", value="Only return historic decision executions with the given deployment id.", paramType="query"), @ApiImplicitParam(name="decisionKey", dataType="string", value="Only return historic decision executions with the given decision key.", paramType="query"), @ApiImplicitParam(name="activityId", dataType="string", value="Only return historic decision executions with the given activity id.", paramType="query"), @ApiImplicitParam(name="executionId", dataType="string", value="Only return historic decision executions with the given execution id.", paramType="query"), @ApiImplicitParam(name="instanceId", dataType="string", value="Only return historic decision executions with the given instance id.", paramType="query"), @ApiImplicitParam(name="scopeType", dataType="string", value="Only return historic decision executions with the given scope type.", paramType="query"), @ApiImplicitParam(name="withoutScopeType", dataType="string", value="Only return historic decision executions without a scope type.", paramType="query"), @ApiImplicitParam(name="processInstanceIdWithChildren", dataType="string", value="Return all historic decision executions with the given process instance id or its entity link children.", paramType="query"), @ApiImplicitParam(name="caseInstanceIdWithChildren", dataType="string", value="Return all historic decision executions with the given case instance id or its entity link children.", paramType="query"), @ApiImplicitParam(name="failed", dataType="string", value="Only return historic decision executions with the failed state.", paramType="query"), @ApiImplicitParam(name="tenantId", dataType="string", value="Only return historic decision executions with the given tenant id.", paramType="query"), @ApiImplicitParam(name="tenantIdLike", dataType="string", value="Only return historic decision executions like the given tenant id.", paramType="query"), @ApiImplicitParam(name="sort", dataType="string", value="Property to sort on, to be used together with the order.", allowableValues="startTime,endTime,tenantId", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the historic decision executions are returned"), @ApiResponse(code=400, message="Indicates a parameter was passed in the wrong format. The status-message contains additional information.")})
    @GetMapping(value={"/dmn-history/historic-decision-executions"}, produces={"application/json"})
    public DataResponse<HistoricDecisionExecutionResponse> getDecisionTables(@ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        DmnHistoricDecisionExecutionQuery historicDecisionExecutionQuery = this.dmnHistoryService.createHistoricDecisionExecutionQuery();
        if (allRequestParams.containsKey("id")) {
            historicDecisionExecutionQuery.id(allRequestParams.get("id"));
        }
        if (allRequestParams.containsKey("decisionDefinitionId")) {
            historicDecisionExecutionQuery.decisionDefinitionId(allRequestParams.get("decisionDefinitionId"));
        }
        if (allRequestParams.containsKey("deploymentId")) {
            historicDecisionExecutionQuery.deploymentId(allRequestParams.get("deploymentId"));
        }
        if (allRequestParams.containsKey("decisionKey")) {
            historicDecisionExecutionQuery.decisionKey(allRequestParams.get("decisionKey"));
        }
        if (allRequestParams.containsKey("activityId")) {
            historicDecisionExecutionQuery.activityId(allRequestParams.get("activityId"));
        }
        if (allRequestParams.containsKey("executionId")) {
            historicDecisionExecutionQuery.executionId(allRequestParams.get("executionId"));
        }
        if (allRequestParams.containsKey("instanceId")) {
            historicDecisionExecutionQuery.instanceId(allRequestParams.get("instanceId"));
        }
        if (allRequestParams.containsKey("scopeType")) {
            historicDecisionExecutionQuery.scopeType(allRequestParams.get("scopeType"));
        }
        if (Boolean.TRUE.equals(Boolean.valueOf(allRequestParams.get("withoutScopeType")))) {
            historicDecisionExecutionQuery.withoutScopeType();
        }
        if (allRequestParams.containsKey("processInstanceIdWithChildren")) {
            historicDecisionExecutionQuery.processInstanceIdWithChildren(allRequestParams.get("processInstanceIdWithChildren"));
        }
        if (allRequestParams.containsKey("caseInstanceIdWithChildren")) {
            historicDecisionExecutionQuery.caseInstanceIdWithChildren(allRequestParams.get("caseInstanceIdWithChildren"));
        }
        if (allRequestParams.containsKey("failed")) {
            historicDecisionExecutionQuery.failed(Boolean.valueOf(allRequestParams.get("failed")));
        }
        if (allRequestParams.containsKey("tenantId")) {
            historicDecisionExecutionQuery.tenantId(allRequestParams.get("tenantId"));
        }
        if (allRequestParams.containsKey("tenantIdLike")) {
            historicDecisionExecutionQuery.tenantIdLike(allRequestParams.get("tenantIdLike"));
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessDecisionHistoryInfoWithQuery(historicDecisionExecutionQuery);
        }
        return PaginateListUtil.paginateList(allRequestParams, (Query)historicDecisionExecutionQuery, (String)"startTime", properties, this.dmnRestResponseFactory::createHistoricDecisionExecutionResponseList);
    }

    static {
        properties.put("startTime", (QueryProperty)HistoricDecisionExecutionQueryProperty.START_TIME);
        properties.put("endTime", (QueryProperty)HistoricDecisionExecutionQueryProperty.END_TIME);
        properties.put("tenantId", (QueryProperty)HistoricDecisionExecutionQueryProperty.TENANT_ID);
    }
}

