/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.flowable.dmn.xml.converter;

import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

import org.flowable.dmn.model.DmnDefinition;
import org.flowable.dmn.model.DmnElement;
import org.flowable.dmn.model.GraphicInfo;
import org.flowable.dmn.xml.constants.DmnXMLConstants;

/**
 * @author Yvo Swillens
 */
public class DmnDiWaypointXmlConverter extends BaseDmnXMLConverter {

    @Override
    protected String getXMLElementName() {
        return ELEMENT_DI_WAYPOINT;
    }

    @Override
    protected DmnElement convertXMLToElement(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        GraphicInfo graphicInfo = new GraphicInfo();
        graphicInfo.setX(Double.valueOf(xtr.getAttributeValue(null, DmnXMLConstants.ATTRIBUTE_DI_X)));
        graphicInfo.setY(Double.valueOf(xtr.getAttributeValue(null, DmnXMLConstants.ATTRIBUTE_DI_Y)));

        // calculate width and height for output and decision service sections
        if (conversionHelper.getCurrentDiShape().getDecisionServiceDividerLine() == conversionHelper.getCurrentDiEdge()) {
            // output decisions
            if (conversionHelper.getCurrentDiShape().getDecisionServiceDividerLine().getWaypoints().isEmpty()) {
                GraphicInfo decisionServiceGraphicInfo = conversionHelper.getCurrentDiShape().getGraphicInfo();
                graphicInfo.setWidth(decisionServiceGraphicInfo.getWidth());
                graphicInfo.setHeight(graphicInfo.getY() - decisionServiceGraphicInfo.getY());
            } else {
                GraphicInfo decisionServiceGraphicInfo = conversionHelper.getCurrentDiShape().getGraphicInfo();
                graphicInfo.setWidth(decisionServiceGraphicInfo.getWidth());
                graphicInfo.setHeight(decisionServiceGraphicInfo.getHeight() - graphicInfo.getY() + decisionServiceGraphicInfo.getY());
            }
        }

        conversionHelper.getCurrentDiEdge().addWaypoint(graphicInfo);

        return graphicInfo;
    }

    @Override
    protected void writeAdditionalAttributes(DmnElement element, DmnDefinition model, XMLStreamWriter xtw) throws Exception {

    }

    @Override
    protected void writeAdditionalChildElements(DmnElement element, DmnDefinition model, XMLStreamWriter xtw) throws Exception {

    }
}