/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.el.function;

import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.el.function.FlowableShortHandExpressionFunction;

public abstract class AbstractFlowableShortHandExpressionFunction
implements FlowableShortHandExpressionFunction {
    protected String variableScopeName;
    protected String functionName;
    protected String prefix;
    protected String localName;
    protected Method method;
    protected Pattern pattern;
    protected String replacePattern;

    public AbstractFlowableShortHandExpressionFunction(String variableScopeName, List<String> functionNameOptions, String functionName) {
        this.pattern = Pattern.compile(this.buildOrWordGroup(this.getFunctionPrefixOptions()) + ":" + this.buildOrWordGroup(functionNameOptions) + "\\s*\\(\\s*'?\"?(.*?)'?\"?\\s*" + (this.isMultiParameterFunction() ? "," : "\\)"));
        this.replacePattern = this.getFinalFunctionPrefix() + ":" + functionName + (this.isNoParameterMethod() ? "(" + variableScopeName : "(" + variableScopeName + ",'$3'") + (this.isMultiParameterFunction() ? "," : ")");
        this.prefix = this.getFinalFunctionPrefix();
        this.localName = functionName;
        this.method = this.findMethod();
    }

    protected Method findMethod() {
        Method[] methods;
        for (Method method : methods = this.getClass().getMethods()) {
            if (!method.getName().equals(this.localName)) continue;
            return method;
        }
        throw new FlowableException("Programmatic error: could not find method " + this.localName + " on class " + this.getClass());
    }

    protected abstract List<String> getFunctionPrefixOptions();

    protected abstract String getFinalFunctionPrefix();

    protected abstract boolean isMultiParameterFunction();

    protected boolean isNoParameterMethod() {
        return false;
    }

    protected String buildOrWordGroup(List<String> options) {
        StringBuilder strb = new StringBuilder();
        strb.append("(");
        strb.append(String.join((CharSequence)"|", options));
        strb.append(")");
        return strb.toString();
    }

    public String enhance(String expressionText) {
        Matcher matcher = this.pattern.matcher(expressionText);
        if (matcher.find()) {
            return matcher.replaceAll(this.replacePattern);
        }
        return expressionText;
    }

    public String localName() {
        return this.localName;
    }

    public String prefix() {
        return this.prefix;
    }

    public Method functionMethod() {
        return this.method;
    }
}

