/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class ActivityUpdateHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    public List<String> getTypes() {
        return Collections.singletonList("activity-update");
    }

    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        HistoricActivityInstanceEntity historicActivityInstance;
        String activityInstanceId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"runtimeActivityInstanceId");
        return !StringUtils.isNotEmpty((CharSequence)activityInstanceId) || (historicActivityInstance = (HistoricActivityInstanceEntity)CommandContextUtil.getHistoricActivityInstanceEntityManager(commandContext).findById(activityInstanceId)) != null;
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricActivityInstanceEntityManager historicActivityInstanceEntityManager;
        HistoricActivityInstanceEntity historicActivityInstance;
        String activityInstanceId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"runtimeActivityInstanceId");
        if (StringUtils.isNotEmpty((CharSequence)activityInstanceId) && (historicActivityInstance = (HistoricActivityInstanceEntity)(historicActivityInstanceEntityManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getHistoricActivityInstanceEntityManager()).findById(activityInstanceId)) != null) {
            String taskId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"taskId");
            String assigneeId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"assignee");
            String calledProcessInstanceId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"calledProcessInstanceId");
            historicActivityInstance.setTaskId(taskId);
            historicActivityInstance.setAssignee(assigneeId);
            historicActivityInstance.setCalledProcessInstanceId(calledProcessInstanceId);
        }
    }
}

