/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.parser.handler;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.CancelEventDefinition;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.ConditionalEventDefinition;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.EscalationEventDefinition;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.bpmn.model.VariableListenerEventDefinition;
import org.flowable.engine.impl.bpmn.parser.BpmnParse;
import org.flowable.engine.impl.bpmn.parser.handler.AbstractFlowNodeBpmnParseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundaryEventParseHandler
extends AbstractFlowNodeBpmnParseHandler<BoundaryEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoundaryEventParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return BoundaryEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, BoundaryEvent boundaryEvent) {
        String eventTypeValue;
        List eventTypeExtensionElements;
        if (boundaryEvent.getAttachedToRef() == null) {
            LOGGER.warn("Invalid reference in boundary event. Make sure that the referenced activity is defined in the same scope as the boundary event {}", (Object)boundaryEvent.getId());
            return;
        }
        EventDefinition eventDefinition = null;
        if (boundaryEvent.getEventDefinitions().size() > 0) {
            eventDefinition = (EventDefinition)boundaryEvent.getEventDefinitions().get(0);
        }
        if (eventDefinition instanceof TimerEventDefinition || eventDefinition instanceof ErrorEventDefinition || eventDefinition instanceof SignalEventDefinition || eventDefinition instanceof CancelEventDefinition || eventDefinition instanceof ConditionalEventDefinition || eventDefinition instanceof MessageEventDefinition || eventDefinition instanceof EscalationEventDefinition || eventDefinition instanceof CompensateEventDefinition || eventDefinition instanceof VariableListenerEventDefinition) {
            bpmnParse.getBpmnParserHandlers().parseElement(bpmnParse, (BaseElement)eventDefinition);
            return;
        }
        if (!boundaryEvent.getExtensionElements().isEmpty() && (eventTypeExtensionElements = (List)boundaryEvent.getExtensionElements().get("eventType")) != null && !eventTypeExtensionElements.isEmpty() && StringUtils.isNotEmpty((CharSequence)(eventTypeValue = ((ExtensionElement)eventTypeExtensionElements.get(0)).getElementText()))) {
            boundaryEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createBoundaryEventRegistryEventActivityBehavior(boundaryEvent, eventTypeValue, boundaryEvent.isCancelActivity()));
            return;
        }
        LOGGER.warn("Unsupported boundary event type for boundary event {}", (Object)boundaryEvent.getId());
    }
}

