/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import org.flowable.batch.api.BatchPart;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;

public class GetBatchPartCmd
implements Command<BatchPart> {
    protected String batchPartId;

    public GetBatchPartCmd(String batchPartId) {
        this.batchPartId = batchPartId;
    }

    public BatchPart execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        BatchPart batchPart = processEngineConfiguration.getBatchServiceConfiguration().getBatchService().getBatchPart(this.batchPartId);
        if (batchPart == null) {
            throw new FlowableObjectNotFoundException("No batch part found for id " + this.batchPartId);
        }
        return batchPart;
    }
}

