/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventsubscription.service.impl.persistence.entity;

import java.text.MessageFormat;
import org.flowable.eventsubscription.service.EventSubscriptionServiceConfiguration;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntityImpl;
import org.flowable.eventsubscription.service.impl.persistence.entity.SignalEventSubscriptionEntity;

public class SignalEventSubscriptionEntityImpl
extends EventSubscriptionEntityImpl
implements SignalEventSubscriptionEntity {
    private static final long serialVersionUID = 1L;
    private static final String CONFIGURATION_TEMPLATE = "'{'\"scope\":\"{0}\"'}'";

    public SignalEventSubscriptionEntityImpl() {
    }

    public SignalEventSubscriptionEntityImpl(EventSubscriptionServiceConfiguration eventSubscriptionServiceConfiguration) {
        super(eventSubscriptionServiceConfiguration);
        this.eventType = "signal";
    }

    @Override
    public void setConfiguration(String configuration) {
        this.configuration = configuration != null && configuration.contains("{\"scope\":") ? configuration : MessageFormat.format(CONFIGURATION_TEMPLATE, configuration);
    }

    @Override
    public boolean isProcessInstanceScoped() {
        String scope = this.extractScopeFormConfiguration();
        return "processInstance".equals(scope);
    }

    @Override
    public boolean isGlobalScoped() {
        String scope = this.extractScopeFormConfiguration();
        return scope == null || "global".equals(scope);
    }

    protected String extractScopeFormConfiguration() {
        if (this.configuration == null) {
            return null;
        }
        return this.configuration.substring(10, this.configuration.length() - 2);
    }
}

