/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.rest.service.api.form;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormService;
import org.flowable.form.rest.FormRestApiInterceptor;
import org.flowable.form.rest.FormRestResponseFactory;
import org.flowable.form.rest.service.api.form.FormModelResponse;
import org.flowable.form.rest.service.api.form.FormRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Form Models"}, description="Manage Form Models", authorizations={@Authorization(value="basicAuth")})
public class FormModelWithVariablesResource {
    @Autowired
    protected FormService formService;
    @Autowired
    protected FormRestResponseFactory formRestResponseFactory;
    @Autowired(required=false)
    protected FormRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="Get a populated form model", tags={"Form Models"}, notes="Provide variables needed to pre populated form fields and to render expression based form fields")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the form model was found and returned."), @ApiResponse(code=404, message="Indicates the requested form model was not found.")})
    @PostMapping(value={"/form/model"}, produces={"application/json"})
    public FormModelResponse getFormModel(@RequestBody FormRequest formRequest, HttpServletRequest request) {
        FormInfo formModel = null;
        boolean fallbackToDefaultTenant = false;
        if (formRequest.getFallbackToDefaultTenant() != null) {
            fallbackToDefaultTenant = formRequest.getFallbackToDefaultTenant();
        }
        if (formRequest.getParentDeploymentId() != null) {
            formModel = this.formService.getFormModelWithVariablesByKeyAndParentDeploymentId(formRequest.getFormDefinitionKey(), formRequest.getParentDeploymentId(), formRequest.getTaskId(), formRequest.getVariables(), formRequest.getTenantId(), fallbackToDefaultTenant);
        } else if (formRequest.getFormDefinitionKey() != null) {
            formModel = this.formService.getFormModelWithVariablesByKey(formRequest.getFormDefinitionKey(), formRequest.getTaskId(), formRequest.getVariables(), formRequest.getTenantId(), fallbackToDefaultTenant);
        } else if (formRequest.getFormDefinitionId() != null) {
            formModel = this.formService.getFormModelWithVariablesById(formRequest.getFormDefinitionId(), formRequest.getTaskId(), formRequest.getVariables(), formRequest.getTenantId(), fallbackToDefaultTenant);
        } else {
            throw new FlowableIllegalArgumentException("Either parent deployment key, form definition key or form definition id must be provided in the request");
        }
        if (formModel == null) {
            throw new FlowableObjectNotFoundException("Could not find a form model");
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessFormInfoById(formModel, formRequest);
        }
        return this.formRestResponseFactory.createFormModelResponse(formModel);
    }
}

